/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.XSFileDeEnvelope;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.XSLog;

public class XecureSmartFileDeenvelopWithPasswd
extends Activity {
    public static final String mSessionIDKey = "session_id_key";
    public static final String mInFilePathKey = "infile_path_key";
    public static final String mOutFilePathKey = "outfile_path_key";
    public static final String m_P_assW_ordKey = "password_key";
    public static final String mResultKey = "result_key";
    private static final int mStatusStartProgress = 1;
    private static final int mStatusOnProgress = 2;
    private static final int mStatusDone = 3;
    private static final int mStatusCanceled = 4;
    private boolean mIsCanceled = false;
    private long mSessionID;
    private String mInFilePath;
    private String mOutFilePath;
    private byte[] m_P_assW_ord;
    private int mResult = -1;
    private BlockerActivityResult mBlockerParam;
    private XSFileDeEnvelope mXSFileDeEnvelope;
    private TextView mTextViewMsg;
    private ProgressBar mProgressBar;
    private TextView mTextViewFileName;
    private TextView mTextViewPercent;
    private Button mCancelButton;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Thread statusThread = new Thread(new setProgressRunnable());
                    statusThread.start();
                    break;
                }
                case 2: {
                    XecureSmartFileDeenvelopWithPasswd.this.mTextViewFileName.setText((CharSequence)XecureSmartFileDeenvelopWithPasswd.this.mXSFileDeEnvelope.getFileName());
                    int aPercent = XecureSmartFileDeenvelopWithPasswd.this.mXSFileDeEnvelope.getPercent();
                    XecureSmartFileDeenvelopWithPasswd.this.mProgressBar.setProgress(aPercent);
                    XecureSmartFileDeenvelopWithPasswd.this.mTextViewPercent.setText((CharSequence)(String.valueOf(aPercent) + "%"));
                    break;
                }
                case 3: 
                case 4: {
                    XecureSmartFileDeenvelopWithPasswd.this.mIsCanceled = true;
                    XecureSmartFileDeenvelopWithPasswd.this.finish();
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.file_progress_dialog);
        Intent receivedIntent = this.getIntent();
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        this.mSessionID = receivedIntent.getLongExtra(mSessionIDKey, -1L);
        this.mInFilePath = receivedIntent.getStringExtra(mInFilePathKey);
        this.mOutFilePath = receivedIntent.getStringExtra(mOutFilePathKey);
        this.m_P_assW_ord = receivedIntent.getByteArrayExtra(m_P_assW_ordKey);
        this.mXSFileDeEnvelope = new XSFileDeEnvelope(this.mSessionID);
        this.mTextViewMsg = (TextView)this.findViewById(R.id.file_progress_msg);
        this.mTextViewMsg.setText(R.string.file_deenvelope_progress);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.file_progress_bar);
        this.mProgressBar.setMax(100);
        this.mProgressBar.setProgress(0);
        this.mTextViewFileName = (TextView)this.findViewById(R.id.file_progress_name);
        this.mTextViewPercent = (TextView)this.findViewById(R.id.file_progress_percent);
        this.mCancelButton = (Button)this.findViewById(R.id.file_progress_cancel_btn);
        this.mCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartFileDeenvelopWithPasswd.this.onCancelButtonClick(v);
            }
        });
        this.runFileDeenvelope();
    }

    public void finish() {
        Intent aIntent = new Intent((Context)this, XecureSmartFileDeenvelopWithPasswd.class);
        aIntent.putExtra(mResultKey, this.mResult);
        if (this.mResult == 0) {
            this.mBlockerParam.setBlockerResult(-1, aIntent);
        } else {
            this.mBlockerParam.setBlockerResult(0, aIntent);
        }
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }

    private void runFileDeenvelope() {
        Thread deenvelopeThread = new Thread(new FileDeenvelopeRunnable());
        deenvelopeThread.start();
    }

    private void onCancelButtonClick(View v) {
        this.mXSFileDeEnvelope.cancel();
    }

    private class setProgressRunnable
    implements Runnable {
        private setProgressRunnable() {
        }

        @Override
        public void run() {
            while (!XecureSmartFileDeenvelopWithPasswd.this.mIsCanceled) {
                XecureSmartFileDeenvelopWithPasswd.this.mHandler.sendEmptyMessage(2);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    XSLog.e((String)"InterruptedException in progress");
                }
            }
        }
    }

    private class FileDeenvelopeRunnable
    implements Runnable {
        private FileDeenvelopeRunnable() {
        }

        @Override
        public void run() {
            XecureSmartFileDeenvelopWithPasswd.this.mHandler.sendEmptyMessage(1);
            XecureSmartFileDeenvelopWithPasswd.this.mResult = XecureSmartFileDeenvelopWithPasswd.this.mXSFileDeEnvelope.deenvelopeFileWithPasswd(XecureSmartFileDeenvelopWithPasswd.this.mInFilePath, XecureSmartFileDeenvelopWithPasswd.this.mOutFilePath, XecureSmartFileDeenvelopWithPasswd.this.m_P_assW_ord);
            if (XecureSmartFileDeenvelopWithPasswd.this.mResult == 0) {
                XecureSmartFileDeenvelopWithPasswd.this.mHandler.sendEmptyMessage(3);
            } else {
                XecureSmartFileDeenvelopWithPasswd.this.mHandler.sendEmptyMessage(4);
            }
        }
    }
}

