/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.XSFileUpload;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.XSLog;

public class XecureSmartFileUpload
extends Activity {
    public static final String mSessionIDKey = "session_id_key";
    public static final String mXaddrKey = "xaddr_key";
    public static final String mPathKey = "path_key";
    public static final String mQueryStringKey = "query_string_key";
    public static final String mHostNameKey = "host_name_key";
    public static final String mPortKey = "port_key";
    public static final String mInFilePathKey = "infile_path_key";
    public static final String mEn_cStringKey = "en_c_string_key";
    public static final String mResultKey = "result_key";
    public static final String mCookieKey = "cookie_key";
    private static final int mStatusStartProgress = 1;
    private static final int mStatusOnProgress = 2;
    private static final int mStatusDone = 3;
    private static final int mStatusCanceled = 4;
    private boolean mIsCanceled = false;
    private long mSessionID;
    private String mXaddr;
    private String mPath;
    private String mQueryString;
    private String mHostName;
    private int mPort;
    private String mInFilePath;
    private String mEncString;
    private String mCookieString = null;
    private String mResult = "";
    private BlockerActivityResult mBlockerParam;
    private XSFileUpload mXSFileUpload;
    private TextView mTextViewMsg;
    private ProgressBar mProgressBar;
    private TextView mTextViewFileName;
    private TextView mTextViewPercent;
    private Button mCancelButton;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Thread statusThread = new Thread(new setProgressRunnable());
                    statusThread.start();
                    break;
                }
                case 2: {
                    XecureSmartFileUpload.this.mTextViewFileName.setText((CharSequence)XecureSmartFileUpload.this.mXSFileUpload.getFileName());
                    int aPercent = XecureSmartFileUpload.this.mXSFileUpload.getPercent();
                    XecureSmartFileUpload.this.mProgressBar.setProgress(aPercent);
                    XecureSmartFileUpload.this.mTextViewPercent.setText((CharSequence)(String.valueOf(aPercent) + "%"));
                    break;
                }
                case 3: {
                    XecureSmartFileUpload.this.finish();
                }
                case 4: {
                    XecureSmartFileUpload.this.mIsCanceled = true;
                    XecureSmartFileUpload.this.finish();
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.file_progress_dialog);
        Intent receivedIntent = this.getIntent();
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        this.mSessionID = receivedIntent.getLongExtra(mSessionIDKey, -1L);
        this.mXaddr = receivedIntent.getStringExtra(mXaddrKey);
        this.mPath = receivedIntent.getStringExtra(mPathKey);
        this.mQueryString = receivedIntent.getStringExtra(mQueryStringKey);
        this.mHostName = receivedIntent.getStringExtra(mHostNameKey);
        this.mPort = receivedIntent.getIntExtra(mPortKey, -1);
        this.mInFilePath = receivedIntent.getStringExtra(mInFilePathKey);
        this.mEncString = receivedIntent.getStringExtra(mEn_cStringKey);
        try {
            this.mCookieString = receivedIntent.getStringExtra(mCookieKey);
        }
        catch (Exception e) {
            XSLog.i((String)"Cookie not Receive");
        }
        this.mXSFileUpload = new XSFileUpload(this.mSessionID);
        this.mTextViewMsg = (TextView)this.findViewById(R.id.file_progress_msg);
        this.mTextViewMsg.setText(R.string.file_upload_progress);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.file_progress_bar);
        this.mProgressBar.setMax(100);
        this.mProgressBar.setProgress(0);
        this.mTextViewFileName = (TextView)this.findViewById(R.id.file_progress_name);
        this.mTextViewPercent = (TextView)this.findViewById(R.id.file_progress_percent);
        this.mCancelButton = (Button)this.findViewById(R.id.file_progress_cancel_btn);
        this.mCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartFileUpload.this.onCancelButtonClick(v);
            }
        });
        this.runFileUpload();
    }

    public void finish() {
        Intent aIntent = new Intent((Context)this, XecureSmartFileUpload.class);
        aIntent.putExtra(mResultKey, this.mResult);
        if (this.mResult.contains("OK")) {
            this.mBlockerParam.setBlockerResult(-1, aIntent);
        } else {
            this.mBlockerParam.setBlockerResult(0, aIntent);
        }
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }

    private void runFileUpload() {
        Thread uploadThread = new Thread(new FileUploadRunnable());
        uploadThread.start();
    }

    private void onCancelButtonClick(View v) {
        this.mXSFileUpload.cancel();
    }

    private class setProgressRunnable
    implements Runnable {
        private setProgressRunnable() {
        }

        @Override
        public void run() {
            while (!XecureSmartFileUpload.this.mIsCanceled) {
                XecureSmartFileUpload.this.mHandler.sendEmptyMessage(2);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    XSLog.e((String)"InterruptedException in progress");
                }
            }
        }
    }

    private class FileUploadRunnable
    implements Runnable {
        private FileUploadRunnable() {
        }

        @Override
        public void run() {
            XecureSmartFileUpload.this.mHandler.sendEmptyMessage(1);
            if (XecureSmartFileUpload.this.mCookieString == null || XecureSmartFileUpload.this.mCookieString == "") {
                XecureSmartFileUpload.this.mResult = XecureSmartFileUpload.this.mXSFileUpload.uploadFile(XecureSmartFileUpload.this.mXaddr, XecureSmartFileUpload.this.mPath, XecureSmartFileUpload.this.mQueryString, XecureSmartFileUpload.this.mHostName, XecureSmartFileUpload.this.mPort, XecureSmartFileUpload.this.mInFilePath, XecureSmartFileUpload.this.mEncString, 0);
            } else {
                XecureSmartFileUpload.this.mResult = XecureSmartFileUpload.this.mXSFileUpload.uploadFile(XecureSmartFileUpload.this.mXaddr, XecureSmartFileUpload.this.mPath, XecureSmartFileUpload.this.mQueryString, XecureSmartFileUpload.this.mHostName, XecureSmartFileUpload.this.mPort, XecureSmartFileUpload.this.mInFilePath, XecureSmartFileUpload.this.mEncString, XecureSmartFileUpload.this.mCookieString, 0);
            }
            if (XecureSmartFileUpload.this.mResult.contains("OK")) {
                XecureSmartFileUpload.this.mHandler.sendEmptyMessage(3);
            } else {
                XecureSmartFileUpload.this.mHandler.sendEmptyMessage(4);
            }
        }
    }
}

