/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.menu;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import java.util.ArrayList;

public class XGridMenuView
extends GridView {
    private int mMenuItemWidth;
    private int mMenuItemHeight;
    private final int mSpacing = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private ArrayList<ImageButton> mMenuItems = null;

    private XGridMenuView(Context context) {
        super(context);
    }

    public XGridMenuView(Context context, int menuItemWidth, int menuItemHeight) {
        this(context);
        this.mMenuItemWidth = menuItemWidth;
        this.mMenuItemHeight = menuItemHeight;
    }

    public XGridMenuView(Context context, int menuItemWidth, int menuItemHeight, ArrayList<ImageButton> menuItems) {
        this(context, menuItemWidth, menuItemHeight);
        this.setMenuItems(menuItems);
    }

    public ArrayList<ImageButton> getMenuItems() {
        return this.mMenuItems;
    }

    public void setMenuItems(ArrayList<ImageButton> mMenuItems) {
        this.mMenuItems = mMenuItems;
        mMenuItems.get(0).setFocusableInTouchMode(true);
        this.initLayout();
    }

    private void initLayout() {
        this.setVerticalSpacing(this.mSpacing);
        this.setHorizontalSpacing(this.mSpacing);
        this.setStretchMode(2);
        this.setGravity(17);
        this.setAdapter((ListAdapter)new BaseAdapter(){

            public int getCount() {
                if (null == XGridMenuView.this.mMenuItems) {
                    return 0;
                }
                return XGridMenuView.this.mMenuItems.size();
            }

            public Object getItem(int position) {
                return null;
            }

            public long getItemId(int position) {
                return 0L;
            }

            public View getView(int position, View convertView, ViewGroup parent) {
                View view;
                if (convertView == null) {
                    view = (View)XGridMenuView.this.mMenuItems.get(position);
                    view.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(XGridMenuView.this.mMenuItemWidth, XGridMenuView.this.mMenuItemHeight));
                } else {
                    view = convertView;
                }
                return view;
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int aNumColumns = widthSpecSize / this.mMenuItemWidth;
        int aSpecificNumColumns = aNumColumns < this.mMenuItems.size() ? aNumColumns : this.mMenuItems.size();
        this.setNumColumns(aSpecificNumColumns);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)(this.mMenuItemWidth * aSpecificNumColumns + (aSpecificNumColumns - 1) * this.mSpacing), (int)Integer.MIN_VALUE), heightMeasureSpec);
    }
}

