/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.menu;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.softforum.sample.R;
import com.softforum.xecure.ui.menu.XGridMenuView;
import java.util.ArrayList;

public class XSlideMenuPanel
extends LinearLayout {
    private int mSlideSpeed = 300;
    private boolean mIsOpen = false;
    private XGridMenuView mGridView;
    private String mSlidingMode;
    private Context mContext;
    private int mMenuItemWidth;
    private int mMenuItemHeight;
    private final String mMODE_BOUNCE = "bounce";
    private final String mMODE_NORMAL = "normal";
    Animation.AnimationListener mStartListener = new Animation.AnimationListener(){

        public void onAnimationEnd(Animation animation) {
            XSlideMenuPanel.this.mGridView.getMenuItems().get(0).requestFocus();
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationStart(Animation animation) {
        }
    };
    Animation.AnimationListener mCollapseListener = new Animation.AnimationListener(){

        public void onAnimationEnd(Animation animation) {
            XSlideMenuPanel.this.setVisibility(8);
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationStart(Animation animation) {
        }
    };

    public XSlideMenuPanel(Context context, AttributeSet attrs) {
        super(context, attrs);
        String aItemWidth = attrs.getAttributeValue(null, "item_width");
        String aItemHeight = attrs.getAttributeValue(null, "item_height");
        if (null != aItemWidth) {
            if (aItemWidth.endsWith("dp")) {
                aItemWidth = aItemWidth.substring(0, aItemWidth.length() - 2);
            }
        } else {
            aItemWidth = "76";
        }
        if (null != aItemHeight) {
            if (aItemHeight.endsWith("dp")) {
                aItemHeight = aItemHeight.substring(0, aItemHeight.length() - 2);
            }
        } else {
            aItemHeight = "70";
        }
        LayoutInflater aLayoutInflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View aMainView = aLayoutInflater.inflate(R.layout.xslide_menu_panel, (ViewGroup)this, false);
        this.addView(aMainView);
        this.mContext = context;
        this.mSlideSpeed = attrs.getAttributeIntValue(null, "sliding_speed", 300);
        this.mSlidingMode = attrs.getAttributeValue(null, "sliding_mode");
        if (null == this.mSlidingMode) {
            this.mSlidingMode = new String("normal");
        }
        this.mMenuItemWidth = (int)TypedValue.applyDimension((int)1, (float)Integer.parseInt(aItemWidth), (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mMenuItemHeight = (int)TypedValue.applyDimension((int)1, (float)Integer.parseInt(aItemHeight), (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void toggle() {
        TranslateAnimation anim2 = null;
        boolean bl = this.mIsOpen = !this.mIsOpen;
        if (this.mIsOpen) {
            this.setVisibility(0);
            anim2 = new TranslateAnimation(0.0f, 0.0f, (float)this.getHeight(), 0.0f);
            anim2.setAnimationListener(this.mStartListener);
        } else {
            anim2 = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)this.getHeight());
            anim2.setAnimationListener(this.mCollapseListener);
        }
        anim2.setDuration((long)this.mSlideSpeed);
        if ("normal".equals(this.mSlidingMode)) {
            anim2.setInterpolator((Interpolator)new AccelerateInterpolator(1.0f));
        } else if ("bounce".equals(this.mSlidingMode)) {
            anim2.setInterpolator(AnimationUtils.loadInterpolator((Context)this.mContext, (int)0x10A000A));
        }
        this.startAnimation((Animation)anim2);
    }

    public void hide() {
        this.mIsOpen = false;
        this.setVisibility(8);
    }

    public void untoggle() {
        if (this.mIsOpen) {
            TranslateAnimation anim2 = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)this.getHeight());
            anim2.setAnimationListener(this.mCollapseListener);
            anim2.setDuration(200L);
            anim2.setInterpolator((Interpolator)new AccelerateInterpolator(1.0f));
            this.startAnimation((Animation)anim2);
            this.mIsOpen = false;
        }
    }

    public void setMenuItems(ArrayList<ImageButton> aImageButtonList) {
        this.mGridView = new XGridMenuView(this.getContext(), this.mMenuItemWidth, this.mMenuItemHeight);
        this.mGridView.setMenuItems(aImageButtonList);
        LinearLayout aMenuLayout = (LinearLayout)this.findViewById(R.id.menu_layout);
        aMenuLayout.removeAllViews();
        aMenuLayout.addView((View)this.mGridView);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.untoggle();
        return super.onTouchEvent(event);
    }

    public boolean isHide() {
        return !this.mIsOpen;
    }
}

