/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.transkey;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Spinner;
import com.softforum.sample.R;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.transkey.TransKeyResultInterface;
import com.softforum.xecure.ui.transkey.TransKeyUtil;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XUtil;
import java.security.SecureRandom;

public class RequestCertificateWithTransKey
extends Activity
implements TransKeyResultInterface {
    public static final int mRequestCertificateWindowID = 77000;
    public static final String mMediaIDKey = "request_cert_window_mediaid_key";
    public static final String m_P_assW_ordKey = "request_cert_window_password_key";
    public static final String mRandomValueKey = "request_cert_window_password_key";
    public static final String mE_ncryptedDataKey = "request_cert_window_e_ncrypted_data_key";
    private static final int MEDIA_SDCARD = 0;
    private static final int MEDIA_PKCS11 = 1;
    private int mMediaID = 1401;
    private byte[] m_P_assW_ord = null;
    private byte[] m_P_assW_ordConfirm = null;
    private Spinner mSelectStorage;
    private BlockerActivityResult mBlockerParam;
    private String mEncryptedData = null;
    private String mConfirmEncryptedData = null;
    private byte[] mRandomValue = new byte[20];
    private TransKeyUtil mTransKeyUtil = new TransKeyUtil();
    private int mTransKeyComplete = -1;
    private final int[] mTransKeyTextIds = new int[]{R.id.password_edittext, R.id.password_confirm_edittext};
    private final int[] mTransKeyTextStrings = new int[]{R.string.password, R.string.password_confirm};
    private final int[] mTransKeyMaxLength = new int[]{150, 150};
    private final int mResultForNotExistPassword = 10;
    private final int mResultForNotCorrectPassword = 11;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.request_certificate_window);
        this.setSpinner();
        Intent receivedIntent = this.getIntent();
        this.mMediaID = receivedIntent.getIntExtra(mMediaIDKey, -1);
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RequestCertificateWithTransKey.this.onOKButtonClick(v);
            }
        });
        if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            SecureRandom aSecureRandom = new SecureRandom();
            aSecureRandom.nextBytes(this.mRandomValue);
            this.mTransKeyUtil.setRandomValue(this.mRandomValue);
        }
        this.mTransKeyUtil.setMTransKey(this, this.mTransKeyTextIds, this.mTransKeyTextStrings, this.mTransKeyMaxLength, null);
    }

    private int checkInputPassword() {
        int aResult = -1;
        int aConfirmResult = 0;
        if (this.m_P_assW_ord == null || this.m_P_assW_ord.length == 0) {
            return 10;
        }
        aResult = XUtil.newCheckPasswordFormat((byte[])this.m_P_assW_ord);
        if (aResult != 0) {
            return aResult;
        }
        if (this.m_P_assW_ordConfirm == null || this.m_P_assW_ordConfirm.length == 0) {
            aConfirmResult = -1;
        } else if (this.m_P_assW_ord.length == this.m_P_assW_ordConfirm.length) {
            for (int aIndex = 0; aIndex < this.m_P_assW_ord.length; ++aIndex) {
                if (this.m_P_assW_ord[aIndex] == this.m_P_assW_ordConfirm[aIndex]) continue;
                aConfirmResult = -1;
                break;
            }
        } else {
            aConfirmResult = -1;
        }
        if (aConfirmResult != 0) {
            return 11;
        }
        return aResult;
    }

    private int checkInputPasswordWithEncryption() {
        int aResult = -1;
        int aConfirmResult = 0;
        if (this.mEncryptedData == null || this.mEncryptedData.length() == 0) {
            return 10;
        }
        aResult = XUtil.checkPassword((String)this.mEncryptedData, (byte[])this.mRandomValue, (int)2);
        if (aResult != 0) {
            return aResult;
        }
        if (this.mConfirmEncryptedData == null || this.mConfirmEncryptedData.length() == 0) {
            aConfirmResult = -1;
        } else if (!this.mEncryptedData.equals(this.mConfirmEncryptedData)) {
            aConfirmResult = -1;
        }
        if (aConfirmResult != 0) {
            return 11;
        }
        return aResult;
    }

    private void onOKButtonClick(View v) {
        int aResult = -1;
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        if (this.mMediaID == 101 || this.mMediaID == 1401) {
            aResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? this.checkInputPasswordWithEncryption() : this.checkInputPassword();
        } else {
            this.m_P_assW_ord = null;
        }
        switch (aResult) {
            case 10: {
                aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
                return;
            }
            case 11: {
                aTopView.setDescription(this.getString(R.string.incorrect_confirm_password));
                return;
            }
            case 1: {
                aTopView.setDescription(this.getString(R.string.password_length_error));
                return;
            }
            case 2: {
                aTopView.setDescription(this.getString(R.string.password_syntax_error));
                return;
            }
            case 3: {
                aTopView.setDescription(this.getString(R.string.newpassword_length_error));
                return;
            }
            case 4: {
                aTopView.setDescription(this.getString(R.string.newpassword_syntax_error));
                return;
            }
            case 5: {
                aTopView.setDescription(this.getString(R.string.newpassword_invalid_error));
                return;
            }
        }
        this.mTransKeyComplete = 0;
        Intent aIntent = new Intent();
        aIntent.putExtra(mMediaIDKey, this.mMediaID);
        if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            aIntent.putExtra("request_cert_window_password_key", this.mRandomValue);
            aIntent.putExtra(mE_ncryptedDataKey, this.mEncryptedData);
        } else {
            aIntent.putExtra("request_cert_window_password_key", this.m_P_assW_ord);
        }
        this.mBlockerParam.setBlockerResult(-1, aIntent);
        this.finish();
    }

    private void setSpinner() {
        this.mSelectStorage = (Spinner)this.findViewById(R.id.select_media);
        this.mSelectStorage.setVisibility(4);
        this.mSelectStorage.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
    }

    public void finish() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ordConfirm});
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }

    public void onBackPressed() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord, this.m_P_assW_ordConfirm, this.mRandomValue});
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mTransKeyUtil.transKeyActivityResult(this, requestCode, resultCode, data, this.mTransKeyTextIds);
    }

    @Override
    public void setTransKeyResult(int index, byte[] result) {
        switch (index) {
            case 0: {
                if (result == null) break;
                this.m_P_assW_ord = (byte[])result.clone();
                break;
            }
            case 1: {
                if (result == null) break;
                this.m_P_assW_ordConfirm = (byte[])result.clone();
            }
        }
    }

    @Override
    public void setTransKeyResult(int pIndex, String pEncryptedData) {
        switch (pIndex) {
            case 0: {
                if (pEncryptedData == null) break;
                this.mEncryptedData = pEncryptedData;
                break;
            }
            case 1: {
                if (pEncryptedData == null) break;
                this.mConfirmEncryptedData = pEncryptedData;
            }
        }
    }

    @Override
    public void doNext() {
        boolean aExistResult = false;
        aExistResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? this.mTransKeyUtil.isResultsNotEmpty(this.mEncryptedData, this.mConfirmEncryptedData) : this.mTransKeyUtil.isResultsNotEmpty(this.m_P_assW_ord, this.m_P_assW_ordConfirm);
        if (aExistResult) {
            this.onOKButtonClick(null);
        }
        if (this.mTransKeyComplete == 0) {
            XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ordConfirm});
        }
    }
}

