/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.transkey;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.crypto.PKCS11Password;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrUser;
import com.softforum.xecure.ui.transkey.TransKeyResultInterface;
import com.softforum.xecure.ui.transkey.TransKeyUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;
import java.security.SecureRandom;

public class XecureSmartVerifyVidWithTransKey
extends Activity
implements TransKeyResultInterface {
    public static final int mXecureSmartVerifyVidID = 79000;
    public static final String mMediaIDKey = "xecure_smart_verify_vid_media_id_key";
    public static final String mSelectedCertDataKey = "xecure_smart_verify_vid_data_key";
    private int mMediaID;
    private byte[] m_P_assW_ord = null;
    private byte[] mVid = null;
    private XDetailData mSelectedData;
    private String mEncryptedData = null;
    private String mVIDEncryptedData = null;
    private byte[] mRandomValue = new byte[20];
    private XCoreUtil mCoreUtil = new XCoreUtil();
    private TransKeyUtil mTransKeyUtil = new TransKeyUtil();
    private int mTransKeyComplete = -1;
    private final int[] mTransKeyTextIds = new int[]{R.id.password_edittext, R.id.vid_edittext};
    private final int[] mTransKeyTextStrings = new int[]{R.string.password, R.string.resident_registration_number};
    private final int[] mTransKeyMaxLength = new int[]{150, 13};
    private final int[] mTransKeyTextKeypadTypes = new int[]{5, 4};

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_verify_vid);
        this.mMediaID = this.getIntent().getIntExtra(mMediaIDKey, -1);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), 0);
        if (this.mMediaID == 401) {
            this.findViewById(R.id.password_input_view).setVisibility(8);
        }
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)this.mSelectedData.getValue(7));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getValue(4) + " : " + this.mSelectedData.getValue(4)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(4) + " : " + this.mSelectedData.getValue(6)));
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartVerifyVidWithTransKey.this.onOKButtonClick(v);
            }
        });
        if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            SecureRandom aSecureRandom = new SecureRandom();
            aSecureRandom.nextBytes(this.mRandomValue);
            this.mTransKeyUtil.setRandomValue(this.mRandomValue);
        }
        this.mTransKeyUtil.setMTransKey(this, this.mTransKeyTextIds, this.mTransKeyTextStrings, this.mTransKeyMaxLength, this.mTransKeyTextKeypadTypes);
    }

    private void onOKButtonClick(View v) {
        int aVerifyResult = 0;
        int aErrorCode = 0;
        boolean aIsEmpty = false;
        String aSubjectRDN = null;
        CertMgr aCertMgr = CertMgr.getInstance();
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        TextView aPasswordTextView = (TextView)this.findViewById(R.id.password_edittext);
        aSubjectRDN = this.mSelectedData.getValue(7);
        this.mCoreUtil.resetError();
        if (this.mMediaID != 401) {
            if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
                if (this.mEncryptedData == null || this.mEncryptedData.length() == 0) {
                    aIsEmpty = true;
                }
            } else if (this.m_P_assW_ord == null || this.m_P_assW_ord.length == 0) {
                aIsEmpty = true;
            }
            if (aIsEmpty) {
                aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
                return;
            }
            aVerifyResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? aCertMgr.verifyPassword(this.mMediaID, aSubjectRDN, this.mRandomValue, this.mEncryptedData) : aCertMgr.verifyPassword(this.mMediaID, 14, aSubjectRDN, this.m_P_assW_ord);
            if (aVerifyResult != 0 && (aErrorCode = this.mCoreUtil.lastErrCode()) != 22000015) {
                aTopView.setDescription(this.mCoreUtil.lastErrMsg());
                aPasswordTextView.setText((CharSequence)"");
                return;
            }
        }
        aIsEmpty = false;
        if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            if (this.mVIDEncryptedData == null || this.mVIDEncryptedData.length() == 0) {
                aIsEmpty = true;
            }
        } else if (this.mVid == null || this.mVid.length == 0) {
            aIsEmpty = true;
        }
        if (aIsEmpty) {
            aTopView.setDescription(this.getString(R.string.xecure_smart_cert_mgr_copy_wrong_vid));
            return;
        }
        if (this.mMediaID == 401) {
            this.startActivityForResult(new Intent((Context)this, PKCS11Password.class), 90000);
        } else {
            this.mTransKeyComplete = 0;
            Intent aIntent = new Intent((Context)this, XecureSmartCertMgrUser.class);
            aVerifyResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? aCertMgr.verifyCertOwner(this.mMediaID, aSubjectRDN, this.mRandomValue, this.mEncryptedData, this.mVIDEncryptedData) : aCertMgr.verifyCertOwner(this.mMediaID, 14, aSubjectRDN, this.m_P_assW_ord, this.mVid);
            if (aVerifyResult == 0) {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 0);
                this.setResult(-1, aIntent);
                this.finish();
            } else {
                this.setResult(2, aIntent);
            }
            this.finish();
        }
    }

    public void onBackPressed() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord, this.mVid, this.mRandomValue});
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mTransKeyUtil.transKeyActivityResult(this, requestCode, resultCode, data, this.mTransKeyTextIds);
    }

    @Override
    public void setTransKeyResult(int index, byte[] result) {
        switch (index) {
            case 0: {
                if (result == null) break;
                this.m_P_assW_ord = (byte[])result.clone();
                break;
            }
            case 1: {
                if (result == null) break;
                this.mVid = (byte[])result.clone();
            }
        }
    }

    @Override
    public void setTransKeyResult(int pIndex, String pEncryptedData) {
        switch (pIndex) {
            case 0: {
                if (pEncryptedData == null) break;
                this.mEncryptedData = pEncryptedData;
                break;
            }
            case 1: {
                if (pEncryptedData == null) break;
                this.mVIDEncryptedData = pEncryptedData;
            }
        }
    }

    @Override
    public void doNext() {
        boolean aExistResult = false;
        aExistResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? this.mTransKeyUtil.isResultsNotEmpty(this.mEncryptedData, this.mVIDEncryptedData) : this.mTransKeyUtil.isResultsNotEmpty(this.m_P_assW_ord, this.mVid);
        if (aExistResult) {
            this.onOKButtonClick(null);
        }
        if (this.mTransKeyComplete == 0) {
            XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord, this.mVid, this.mRandomValue});
        }
    }
}

