/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.crypto;

import android.content.Context;
import com.softforum.xecure.core.CoreWrapper;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XUtil;

public class SignEnvelopMgr {
    private XCoreUtil mCoreUtil;
    private Context mCallersContext = null;

    public void setMCallersContext(Context aContext) {
        this.mCallersContext = aContext;
    }

    public String signDataCMS(long aSessionID, String aXaddr, int aMediaID, String aSubjectDN, String aPassword, String aData, int aSearchCondition, int aOption) {
        byte[] aPlainData = null;
        String aSignedData = null;
        aPlainData = aPassword != "" ? aPassword.getBytes() : new byte[]{0};
        aSignedData = this.signDataCMS(aSessionID, aXaddr, aMediaID, aSubjectDN, aPlainData, aData, aSearchCondition, aOption);
        XUtil.resetByteArray(new byte[][]{aPlainData});
        aPassword = null;
        return aSignedData;
    }

    public String signDataCMS(long aSessionID, String aXaddr, int aMediaID, String aSubjectDN, byte[] aPassword, String aData, int aSearchCondition, int aOption) {
        int aResult = 0;
        String[] aSignedData = new String[1];
        if (aPassword == null || aPassword.length == 0) {
            aPassword = new byte[]{0};
        }
        aResult = CoreWrapper.signDataCMS(aSessionID, aXaddr, aMediaID, aSubjectDN, aPassword, aData, aSignedData, aSearchCondition, aOption);
        return aSignedData[0];
    }

    public String signDataCMS(long aSessionID, String aXaddr, int aMediaID, String aSubjectDN, byte[] aPassword, String aData, int aSearchCondition, int aOption, String aCharset) {
        int aResult = 0;
        String[] aSignedData = new String[1];
        if (aPassword == null || aPassword.length == 0) {
            aPassword = new byte[]{0};
        }
        aResult = CoreWrapper.signDataCMSWithCharset(aSessionID, aXaddr, aMediaID, aSubjectDN, aPassword, aData, aSignedData, aSearchCondition, aOption, aCharset);
        return aSignedData[0];
    }

    public String signDataCMS(long aSessionID, String aXaddr, int aMediaID, String aSubjectDN, byte[] aPasswordKey, String aEncryptedPassword, String aData, int aOption) {
        int aResult = 0;
        String[] aSignedData = new String[1];
        aResult = CoreWrapper.signDataCMSWithKDF(aSessionID, aXaddr, aMediaID, aSubjectDN, aPasswordKey, aEncryptedPassword, aData, aSignedData, aOption);
        return aSignedData[0];
    }

    public String signDataCMS(long aSessionID, String aXaddr, int aMediaID, String aSubjectDN, byte[] aPasswordKey, String aEncryptedPassword, String aData, int aOption, String aCharset) {
        int aResult = 0;
        String[] aSignedData = new String[1];
        aResult = CoreWrapper.signDataCMSWithKDFWithCharset(aSessionID, aXaddr, aMediaID, aSubjectDN, aPasswordKey, aEncryptedPassword, aData, aSignedData, aOption, aCharset);
        return aSignedData[0];
    }

    public String signDataCMS(long aSessionID, String aXaddr, int aMediaID, String aIssuerRDN, String aCertSerial, byte[] aPasswordKey, String aEncryptedPassword, String aData, int aOption) {
        int aResult = 0;
        String[] aSignedData = new String[1];
        aResult = CoreWrapper.signDataCMSWithIssuerRDNWithKDF(aSessionID, aXaddr, aMediaID, aIssuerRDN, aCertSerial, aPasswordKey, aEncryptedPassword, aData, aSignedData, aOption);
        return aSignedData[0];
    }

    public String signDataCMS(long aSessionID, String aXaddr, int aMediaID, String aIssuerRDN, String aCertSerial, byte[] aPasswordKey, String aEncryptedPassword, String aData, int aOption, String aCharset) {
        int aResult = 0;
        String[] aSignedData = new String[1];
        aResult = CoreWrapper.signDataCMSWithIssuerRDNWithKDFWithCharset(aSessionID, aXaddr, aMediaID, aIssuerRDN, aCertSerial, aPasswordKey, aEncryptedPassword, aData, aSignedData, aOption, aCharset);
        return aSignedData[0];
    }

    public String signFileInfo(long aSessionID, String aXaddr, int aMediaID, String aIssuerRDN, String aCertSerial, byte[] aPasswordKey, String aEncryptedPassword, String aData, int aOption) {
        int aResult = 0;
        String[] aSignedData = new String[1];
        aResult = CoreWrapper.signFileInfoWithKDF(aSessionID, aXaddr, aMediaID, aIssuerRDN, aCertSerial, aPasswordKey, aEncryptedPassword, aData, aSignedData, aOption);
        return aSignedData[0];
    }

    public String signFileInfo(long aSessionID, String aXaddr, int aMediaID, String aIssuerRDN, String aCertSerial, byte[] aPasswordKey, String aData, int aOption) {
        int aResult = 0;
        String[] aSignedData = new String[1];
        aResult = CoreWrapper.signFileInfo(aSessionID, aXaddr, aMediaID, aIssuerRDN, aCertSerial, aPasswordKey, aData, aSignedData, aOption);
        return aSignedData[0];
    }

    public String signDataAdd(long aSessionID, String aXaddr, int aMediaID, String aSubjectDN, String aPassword, String aData, int aSearchCondition, int aOption) {
        byte[] aPlainData = null;
        String aSignedData = null;
        aPlainData = aPassword != "" ? aPassword.getBytes() : new byte[]{0};
        aSignedData = this.signDataAdd(aSessionID, aXaddr, aMediaID, aSubjectDN, aPlainData, aData, aSearchCondition, aOption);
        XUtil.resetByteArray(new byte[][]{aPlainData});
        aPassword = null;
        return aSignedData;
    }

    public String signDataAdd(long aSessionID, String aXaddr, int aMediaID, String aSubjectDN, byte[] aPassword, String aData, int aSearchCondition, int aOption) {
        String[] aSignedData = new String[1];
        if (aPassword == null || aPassword.length == 0) {
            aPassword = new byte[]{0};
        }
        int aResult = CoreWrapper.signDataAdd(aSessionID, aXaddr, aMediaID, aSubjectDN, aPassword, aData, aSignedData, aSearchCondition, aOption);
        return aSignedData[0];
    }

    public int getPlainData(String aData, String[] aPlainData, String[] aCertList) {
        return CoreWrapper.getPlainData(aData, aPlainData, aCertList);
    }

    public String verifySignedData(String aData, int aVerifyOption, String aDirserver) {
        return CoreWrapper.verifySignedData(aData, aVerifyOption, aDirserver);
    }

    public String envelopeDataWithPEM(String aPlainData, int aEnvOption, String aPemCert) {
        return CoreWrapper.envelopeDataWithPEM(aPlainData, aEnvOption, aPemCert);
    }

    public String envelopeDataWithCert(String aPlainData, int aEnvOption, String aMediaIDList, String aSubjectDNList) {
        return CoreWrapper.envelopeDataWithCert(aPlainData, aEnvOption, aMediaIDList, aSubjectDNList);
    }

    public String envelopeDataWithPasswd(String aPlainData, int aEnvOption, String aPassword) {
        byte[] aBytePassword = null;
        String aResult = null;
        aBytePassword = aPassword.getBytes();
        aResult = this.envelopeDataWithPasswd(aPlainData, aEnvOption, aBytePassword);
        XUtil.resetByteArray(new byte[][]{aBytePassword});
        aPassword = null;
        return aResult;
    }

    public String envelopeDataWithPasswd(String aPlainData, int aEnvOption, byte[] aPassword) {
        String aResult = null;
        aResult = CoreWrapper.envelopeDataWithPasswd(aPlainData, aEnvOption, aPassword);
        return aResult;
    }

    public String envelopeDataWithPasswd(String aPlainData, int aEnvelopeOption, byte[] aPasswordKey, String aEncryptedPassword) {
        String aResult = null;
        aResult = CoreWrapper.envelopeDataWithPasswdWithKDF(aPlainData, aEnvelopeOption, aPasswordKey, aEncryptedPassword);
        return aResult;
    }

    public String deEnvelopeDataWithCert(String aEnvData, int aMediaID, String aSubjectDN, String aPassword) {
        byte[] aPlainData = null;
        String aResult = null;
        aPlainData = aPassword.getBytes();
        aResult = this.deEnvelopeDataWithCert(aEnvData, aMediaID, aSubjectDN, aPlainData);
        XUtil.resetByteArray(new byte[][]{aPlainData});
        aPassword = null;
        return aResult;
    }

    public String deEnvelopeDataWithCert(String aEnvData, int aMediaID, String aSubjectDN, byte[] aPassword) {
        String aResult = null;
        aResult = CoreWrapper.deEnvelopeDataWithCert(aEnvData, aMediaID, aSubjectDN, aPassword);
        return aResult;
    }

    public String deEnvelopeDataWithCert(String aEnvelopedData, int aMediaID, String aSubjectDN, byte[] aPasswordKey, String aEncryptedPassword) {
        String aResult = null;
        aResult = CoreWrapper.deEnvelopeDataWithCertWithKDF(aEnvelopedData, aMediaID, aSubjectDN, aPasswordKey, aEncryptedPassword);
        return aResult;
    }

    public String deEnvelopeDataWithCert(String aEnvelopedData, int aMediaID, String aIssuerRDN, String aCertSerial, byte[] aPasswordKey, String aEncryptedPassword) {
        String aResult = null;
        aResult = CoreWrapper.deEnvelopeDataWithCertWithIssuerRDNWithKDF(aEnvelopedData, aMediaID, aIssuerRDN, aCertSerial, aPasswordKey, aEncryptedPassword);
        return aResult;
    }

    public String deEnvelopeDataWithPasswd(String aEnvData, String aPassword) {
        byte[] aPlainData = null;
        String aResult = null;
        aPlainData = aPassword.getBytes();
        aResult = this.deEnvelopeDataWithPasswd(aEnvData, aPlainData);
        XUtil.resetByteArray(new byte[][]{aPlainData});
        aPassword = null;
        return aResult;
    }

    public String deEnvelopeDataWithPasswd(String aEnvData, byte[] aPassword) {
        String aResult = null;
        aResult = CoreWrapper.deEnvelopeDataWithPasswd(aEnvData, aPassword);
        return aResult;
    }

    public String deEnvelopeDataWithPasswd(String aEnvelopedData, byte[] aPasswordKey, String aEncryptedPassword) {
        String aResult = null;
        aResult = CoreWrapper.deEnvelopeDataWithPasswdWithKDF(aEnvelopedData, aPasswordKey, aEncryptedPassword);
        return aResult;
    }

    public int getEnvelopeTypeAndCertSerial(String aEnvData, int[] aEnvType, String[] aCertSerial) {
        return CoreWrapper.getEnvelopeTypeAndCertSerial(aEnvData, aEnvType, aCertSerial);
    }

    public int setIdNum(String id_num) {
        byte[] aByteIDNum = null;
        aByteIDNum = id_num != "" ? id_num.getBytes() : new byte[]{0};
        int aResult = this.setIdNum(aByteIDNum);
        XUtil.resetByteArray(new byte[][]{aByteIDNum});
        id_num = null;
        return aResult;
    }

    public int setIdNum(byte[] id_num) {
        if (id_num == null || id_num.length == 0) {
            id_num = new byte[]{0};
        }
        int aResult = CoreWrapper.setIdNum(id_num);
        return aResult;
    }

    public int setIdNum(byte[] aPasswordKey, String aEncryptedIDNumber) {
        int aResult = 0;
        aResult = CoreWrapper.setIdNumWithKDF(aPasswordKey, aEncryptedIDNumber);
        return aResult;
    }

    public int envelopIdNum(long sessionID, String xaddr, int media_id, String subject_dn, String password, int search_condition, String cert_pem) {
        byte[] aPlainData = null;
        aPlainData = password.getBytes();
        int aResult = this.envelopIdNum(sessionID, xaddr, media_id, subject_dn, aPlainData, search_condition, cert_pem);
        XUtil.resetByteArray(new byte[][]{aPlainData});
        password = null;
        return aResult;
    }

    public int envelopIdNum(long sessionID, String xaddr, int media_id, String subject_dn, byte[] password, int search_condition, String cert_pem) {
        if (password == null || password.length == 0) {
            password = new byte[]{0};
        }
        int aResult = CoreWrapper.envelopIdNum(sessionID, xaddr, media_id, subject_dn, password, search_condition, cert_pem);
        return aResult;
    }

    public int envelopIdNum(long aSessionID, String aXaddr, int aMediaID, String aSubjectDN, byte[] aPasswordKey, String aEncryptedPassword, String aCertPEM) {
        int aResult = 0;
        aResult = CoreWrapper.envelopIdNumWithKDF(aSessionID, aXaddr, aMediaID, aSubjectDN, aPasswordKey, aEncryptedPassword, aCertPEM);
        return aResult;
    }

    public int envelopIdNum(long aSessionID, String aXaddr, int aMediaID, String aIssuerRDN, String aCertSerial, byte[] aPasswordKey, String aEncryptedPassword, String aCertPEM) {
        int aResult = 0;
        aResult = CoreWrapper.envelopIdNumWithIssuerRDNWithKDF(aSessionID, aXaddr, aMediaID, aIssuerRDN, aCertSerial, aPasswordKey, aEncryptedPassword, aCertPEM);
        return aResult;
    }

    public int envelopIdNum(String certPem, byte[] vidRandom) {
        int aResult = 0;
        aResult = CoreWrapper.setEnvelopIdNum(certPem, vidRandom);
        return aResult;
    }

    public String getVidInfo() {
        return CoreWrapper.getVidInfo();
    }

    public String getCertInfoEx(String aSignedData, String aOriginalData, int aOpOption, int aInfoOption, int aVerifyOption) {
        return CoreWrapper.getCertInfoEx(aSignedData, aOriginalData, aOpOption, aInfoOption, aVerifyOption);
    }
}

