/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecurecertshare.util;

public class XCSBase64 {
    private static final char[] BASE64CHARS;
    private static final char BASE64PAD = '=';
    private static final byte[] DECODETABLE;

    private static int _decode(char[] cArray, byte[] byArray, int n) {
        int n2 = 3;
        if (cArray[3] == '=') {
            n2 = 2;
        }
        if (cArray[2] == '=') {
            n2 = 1;
        }
        byte by = DECODETABLE[cArray[0]];
        byte by2 = DECODETABLE[cArray[1]];
        byte by3 = DECODETABLE[cArray[2]];
        byte by4 = DECODETABLE[cArray[3]];
        switch (n2) {
            case 1: {
                byArray[n] = (byte)(by << 2 & 0xFC | by2 >> 4 & 3);
                return 1;
            }
            case 2: {
                byArray[n++] = (byte)(by << 2 & 0xFC | by2 >> 4 & 3);
                byArray[n] = (byte)(by2 << 4 & 0xF0 | by3 >> 2 & 0xF);
                return 2;
            }
            case 3: {
                byArray[n++] = (byte)(by << 2 & 0xFC | by2 >> 4 & 3);
                byArray[n++] = (byte)(by2 << 4 & 0xF0 | by3 >> 2 & 0xF);
                byArray[n] = (byte)(by3 << 6 & 0xC0 | by4 & 0x3F);
                return 3;
            }
        }
        throw new RuntimeException("Internal Error");
    }

    public static byte[] decode(String string) {
        char[] cArray = new char[4];
        int n = 0;
        byte[] byArray = new byte[string.length() / 4 * 3 + 3];
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '=' && (c >= DECODETABLE.length || DECODETABLE[c] == 127)) continue;
            cArray[n++] = c;
            if (n != cArray.length) continue;
            n = 0;
            n2 += XCSBase64._decode(cArray, byArray, n2);
        }
        if (n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static String encode(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length;
        if (n3 <= 0) {
            return "";
        }
        char[] cArray = new char[n3 / 3 * 4 + 4];
        int n4 = 0;
        int n5 = 0;
        for (n2 = n3; n2 >= 3; n2 -= 3) {
            n = ((byArray[n4] & 0xFF) << 16) + ((byArray[n4 + 1] & 0xFF) << 8) + (byArray[n4 + 2] & 0xFF);
            cArray[n5++] = BASE64CHARS[n >> 18];
            cArray[n5++] = BASE64CHARS[n >> 12 & 0x3F];
            cArray[n5++] = BASE64CHARS[n >> 6 & 0x3F];
            cArray[n5++] = BASE64CHARS[n & 0x3F];
            n4 += 3;
        }
        if (n2 == 1) {
            n = byArray[n4] & 0xFF;
            cArray[n5++] = BASE64CHARS[n >> 2];
            cArray[n5++] = BASE64CHARS[n << 4 & 0x3F];
            cArray[n5++] = 61;
            cArray[n5++] = 61;
        } else if (n2 == 2) {
            n = ((byArray[n4] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
            cArray[n5++] = BASE64CHARS[n >> 10];
            cArray[n5++] = BASE64CHARS[n >> 4 & 0x3F];
            cArray[n5++] = BASE64CHARS[n << 2 & 0x3F];
            cArray[n5++] = 61;
        }
        return new String(cArray, 0, n5);
    }

    public static boolean isValidBase64Encoding(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '=' || c < DECODETABLE.length && DECODETABLE[c] != 127 || c == '\r' || c == '\n') continue;
            return false;
        }
        return true;
    }

    static {
        int n;
        BASE64CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        DECODETABLE = new byte[128];
        for (n = 0; n < DECODETABLE.length; ++n) {
            XCSBase64.DECODETABLE[n] = 127;
        }
        for (n = 0; n < BASE64CHARS.length; ++n) {
            XCSBase64.DECODETABLE[XCSBase64.BASE64CHARS[n]] = (byte)n;
        }
    }
}

