/*
 * Decompiled with CFR 0.152.
 */
package com.tmonet.mobiletoken.auth;

import android.os.Bundle;
import android.util.Base64;
import android.util.Log;
import com.tmonet.mobiletoken.auth.MTKAuthException;
import com.tmonet.mobiletoken.auth.TmonetConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kr.or.kftc.mobiletoken_lib.device_control.TokenControl;
import org.json.JSONException;
import org.json.JSONObject;

public class MTKAuth {
    public static final String API_VERSION_STRING = "MTK_Auth_API_v1.3.2";
    private String TAG;
    public static final long TOKENAUTH_SUCCESS = 0L;
    public static final long TOKENAUTH_BAD_PARAMS = 0xF000001L;
    public static final long TOKENAUTH_CONNECT_FAIL = 0xF000011L;
    public static final long TOKENAUTH_TOKEN_COMM_ERROR = 251658258L;
    public static final long TOKENAUTH_CSN_ERROR = 251658260L;
    public static final long TOKENAUTH_ALREADY_INIT = 251658273L;
    public static final long TOKENAUTH_TOKEN_LOCKED = 0xF000022L;
    public static final long TOKENAUTH_SERVER_COMM_ERROR = 251658289L;
    public static final long TOKENAUTH_INTERNAL_ERROR = 0xF0000FEL;
    public static final long TOKENAUTH_UNKNOWN_ERROR = 0xF0000FFL;
    TokenControl mToken;
    TmonetConverter mConverter = new TmonetConverter();
    private String mServerIP;
    private int mAuthPort;
    protected byte[] mSessionID;
    private long mResult;
    private String mServerErr;

    public MTKAuth(TokenControl token, String serverIP, int serverPort) {
        this.mToken = token;
        this.mServerIP = serverIP;
        this.mAuthPort = serverPort;
        this.mServerErr = "\ub0b4\ubd80\uc624\ub958";
        this.TAG = null;
    }

    public MTKAuth(TokenControl token, String serverIP, int serverPort, String logTag) {
        this.mToken = token;
        this.mServerIP = serverIP;
        this.mAuthPort = serverPort;
        this.mServerErr = "\ub0b4\ubd80\uc624\ub958";
        this.TAG = logTag;
    }

    public String getVersionString() {
        return API_VERSION_STRING;
    }

    private void MTKLog(int level, String msg) {
        if (this.TAG == null) {
            return;
        }
        switch (level) {
            case 4: {
                Log.i((String)this.TAG, (String)msg);
                break;
            }
            case 3: {
                Log.d((String)this.TAG, (String)msg);
                break;
            }
            case 6: {
                Log.e((String)this.TAG, (String)msg);
                break;
            }
            case 5: {
                Log.w((String)this.TAG, (String)msg);
                break;
            }
            case 2: {
                Log.v((String)this.TAG, (String)msg);
            }
        }
    }

    public long mutualAuthenticate() {
        this.MTKLog(4, "++++ [ mutualAuthenticate ] ++++");
        if (this.mToken == null) {
            return 0xF000011L;
        }
        AuthThread authThread = new AuthThread();
        this.mResult = 0xF0000FFL;
        authThread.start();
        try {
            authThread.join(5000L);
        }
        catch (InterruptedException e) {
            this.mResult = 0xF0000FEL;
            this.mServerErr = "\ud0c0\uc784\uc544\uc6c3 \ubc1c\uc0dd";
        }
        this.MTKLog(4, "---- [ mutualAuthenticate : " + Long.toHexString(this.mResult) + " ] ----");
        return this.mResult;
    }

    public String getErrorMessage(long errorCode) {
        if (errorCode == 0xF000001L) {
            return "\ud30c\ub77c\ubbf8\ud130 \uc624\ub958";
        }
        if (errorCode == 0xF000011L) {
            return "\ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0 \uc2e4\ud328";
        }
        if (errorCode == 251658258L) {
            return "\ubcf4\uc548\ud1a0\ud070 \ud1b5\uc2e0 \uc624\ub958";
        }
        if (errorCode == 251658273L) {
            return "\ubcf4\uc548\ud1a0\ud070\uc774 \uc774\ubbf8 \ucd08\uae30\ud654 \ub418\uc5c8\uc74c";
        }
        if (errorCode == 0xF000022L) {
            return "\ubcf4\uc548\ud1a0\ud070\uc774 \uc7a0\uae40 \uc0c1\ud0dc";
        }
        if (errorCode == 251658289L) {
            return "\uc778\uc99d\uc11c\ubc84\uc640 \ud1b5\uc2e0 \uc624\ub958";
        }
        if (errorCode == 0xF0000FEL) {
            return this.mServerErr;
        }
        if (errorCode == 0xF0000FFL) {
            return "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
        }
        return "\uc815\uc0c1\ucc98\ub9ac";
    }

    public String getLastErrorMessage() {
        return this.getErrorMessage(this.mResult);
    }

    private class AuthThread
    extends Thread {
        private AuthThread() {
        }

        @Override
        public void run() {
            try {
                byte algo = this.getCryptoAlgorithm();
                byte[] csn = this.getCSN();
                byte[] null_byte = new byte[8];
                if (Arrays.equals(csn, null_byte)) {
                    MTKAuth.this.mResult = 251658260L;
                    return;
                }
                HttpsURLConnection authServer = this.setupServerConnection(MTKAuth.this.mServerIP, MTKAuth.this.mAuthPort, "/auth");
                byte[] cipheredData = this.externalAuth(authServer, algo);
                byte[] authData = this.mutualAuth(cipheredData);
                HttpsURLConnection authServer2 = this.setupServerConnection(MTKAuth.this.mServerIP, MTKAuth.this.mAuthPort, "/auth");
                this.internalAuth(authServer2, algo, authData);
            }
            catch (MTKAuthException e) {
                e.printStackTrace();
                MTKAuth.this.mResult = e.getReason();
                if (MTKAuth.this.mResult == 0xF0000FEL) {
                    MTKAuth.this.mServerErr = e.getMessage();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                MTKAuth.this.mResult = 251658289L;
                return;
            }
            catch (JSONException e) {
                e.printStackTrace();
                MTKAuth.this.mResult = 251658289L;
                return;
            }
            MTKAuth.this.mResult = 0L;
        }

        private byte getCryptoAlgorithm() throws MTKAuthException {
            Bundle request = new Bundle();
            Bundle response = new Bundle();
            MTKAuth.this.MTKLog(4, "##### GET_APPLET_CONTROL_INFO START #####");
            request.putString("REQUEST_ACTION", "GET_APPLET_CONTROL_INFO");
            MTKAuth.this.mToken.Transmit(request, response);
            if (!response.getString("RESULT_CODE").equals("0000")) {
                MTKAuth.this.MTKLog(4, ">>>>> ERROR : (" + response.getString("RESULT_CODE") + ") " + response.getString("ERROR_MESSAGE"));
                if (response.getString("RESULT_CODE").equals("0E03") || response.getString("RESULT_CODE").equals("0FC1") || response.getString("RESULT_CODE").equals("0FC2") || response.getString("RESULT_CODE").equals("0FC3")) {
                    throw new MTKAuthException("", 251658258L);
                }
                throw new MTKAuthException(response.getString("ERROR_MESSAGE"), 0xF0000FEL);
            }
            byte algo = response.getByte("CRYPTO_ALG");
            MTKAuth.this.MTKLog(4, " - CRYPTO_ALG : " + algo);
            MTKAuth.this.MTKLog(4, "##### GET_APPLET_CONTROL_INFO FINISH #####");
            return algo;
        }

        private byte[] getCSN() throws MTKAuthException {
            Bundle request = new Bundle();
            Bundle response = new Bundle();
            MTKAuth.this.MTKLog(4, "##### GET_TOKEN_INFO START #####");
            request.putString("REQUEST_ACTION", "GET_TOKEN_INFO");
            MTKAuth.this.mToken.Transmit(request, response);
            if (!response.getString("RESULT_CODE").equals("0000")) {
                MTKAuth.this.MTKLog(4, ">>>>> ERROR : (" + response.getString("RESULT_CODE") + ") " + response.getString("ERROR_MESSAGE"));
                if (response.getString("RESULT_CODE").equals("0E03") || response.getString("RESULT_CODE").equals("0FC1") || response.getString("RESULT_CODE").equals("0FC2") || response.getString("RESULT_CODE").equals("0FC3")) {
                    throw new MTKAuthException("", 251658258L);
                }
                throw new MTKAuthException(response.getString("ERROR_MESSAGE"), 0xF0000FEL);
            }
            byte[] csn = response.getByteArray("CSN");
            MTKAuth.this.MTKLog(4, " - CSN : " + MTKAuth.this.mConverter.HexToStringForDisplay(csn));
            MTKAuth.this.MTKLog(4, "##### GET_TOKEN_INFO FINISH #####");
            return csn;
        }

        private byte[] getLicenseData(byte[] TR) throws MTKAuthException {
            Bundle request = new Bundle();
            Bundle response = new Bundle();
            MTKAuth.this.MTKLog(4, "##### GET_LICENSE_DATA START #####");
            MTKAuth.this.MTKLog(4, " - TR : " + MTKAuth.this.mConverter.HexToStringForDisplay(TR));
            byte[] apduPutData = new byte[13];
            apduPutData[0] = -112;
            apduPutData[1] = 50;
            apduPutData[2] = 0;
            apduPutData[3] = 0;
            apduPutData[4] = 8;
            System.arraycopy(TR, 0, apduPutData, 5, 8);
            MTKAuth.this.MTKLog(4, " - APDU : " + MTKAuth.this.mConverter.HexToStringForDisplay(apduPutData));
            request.putString("REQUEST_ACTION", "SEND_APDU");
            request.putByteArray("APDU", apduPutData);
            request.putInt("TIMEOUT", 10000);
            MTKAuth.this.mToken.Transmit(request, response);
            if (!response.getString("RESULT_CODE").equals("0000")) {
                MTKAuth.this.MTKLog(4, ">>>>> ERROR : (" + response.getString("RESULT_CODE") + ") " + response.getString("ERROR_MESSAGE"));
                if (response.getString("RESULT_CODE").equals("0E03") || response.getString("RESULT_CODE").equals("0FC1") || response.getString("RESULT_CODE").equals("0FC2") || response.getString("RESULT_CODE").equals("0FC3")) {
                    throw new MTKAuthException("", 251658258L);
                }
                if (response.getString("RESULT_CODE").equals("0F05")) {
                    throw new MTKAuthException("", 0xF000022L);
                }
                throw new MTKAuthException(response.getString("ERROR_MESSAGE"), 0xF0000FEL);
            }
            byte[] SW12 = response.getByteArray("SW12");
            if (SW12[0] != -112 && SW12[1] != 0) {
                MTKAuth.this.MTKLog(4, ">>>>> ERROR : SW12 = " + MTKAuth.this.mConverter.HexToStringForDisplay(SW12));
                throw new MTKAuthException("SW12 : [0x" + MTKAuth.this.mConverter.HexToStringForDisplay(SW12) + "]", 0xF0000FEL);
            }
            MTKAuth.this.MTKLog(4, "##### GET_LICENSE_DATA FINISH #####");
            return response.getByteArray("RESPONSE_DATA");
        }

        private byte[] generateCardRandom(byte purpose, int length) throws MTKAuthException {
            Bundle request = new Bundle();
            Bundle response = new Bundle();
            MTKAuth.this.MTKLog(4, "##### GET_CHALLENGE START #####");
            MTKAuth.this.MTKLog(4, " - RANDOM_PURPOSE : " + purpose);
            MTKAuth.this.MTKLog(4, " - RANDOM_LENGTH : " + length);
            request.putString("REQUEST_ACTION", "GET_CHALLENGE");
            request.putByte("RANDOM_PURPOSE", purpose);
            request.putInt("RANDOM_LENGTH", length);
            MTKAuth.this.mToken.Transmit(request, response);
            if (!response.getString("RESULT_CODE").equals("0000")) {
                MTKAuth.this.MTKLog(4, ">>>>> ERROR : (" + response.getString("RESULT_CODE") + ") " + response.getString("ERROR_MESSAGE"));
                if (response.getString("RESULT_CODE").equals("0E03") || response.getString("RESULT_CODE").equals("0FC1") || response.getString("RESULT_CODE").equals("0FC2") || response.getString("RESULT_CODE").equals("0FC3")) {
                    throw new MTKAuthException("", 251658258L);
                }
                if (response.getString("RESULT_CODE").equals("0F05")) {
                    throw new MTKAuthException("", 0xF000022L);
                }
                throw new MTKAuthException(response.getString("ERROR_MESSAGE"), 0xF0000FEL);
            }
            byte[] random = response.getByteArray("RANDOM");
            MTKAuth.this.MTKLog(4, " - RANDOM : " + MTKAuth.this.mConverter.HexToStringForDisplay(random));
            MTKAuth.this.MTKLog(4, "##### GET_CHALLENGE FINISH #####");
            return random;
        }

        private HttpsURLConnection setupServerConnection(String IP, int port, String file) throws IOException {
            SSLContext sslContext;
            URL url = new URL("https", IP, port, file);
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            try {
                sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }}, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            connection.setHostnameVerifier(hostnameVerifier);
            connection.setSSLSocketFactory(sslContext.getSocketFactory());
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Cache-Control", "no-cache");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            return connection;
        }

        private byte[] externalAuth(HttpsURLConnection server, byte algorithm) throws JSONException, IOException, MTKAuthException {
            JSONObject responseJSON;
            SecureRandom sr = new SecureRandom();
            byte[] termRandom = new byte[8];
            sr.nextBytes(termRandom);
            byte[] licenseData = this.getLicenseData(termRandom);
            byte[] cardRandom = this.generateCardRandom((byte)1, 16);
            byte[] param2 = new byte[18];
            System.arraycopy(licenseData, 0, param2, 0, 8);
            System.arraycopy(licenseData, 22, param2, 8, 4);
            System.arraycopy(licenseData, 8, param2, 12, 2);
            System.arraycopy(licenseData, 10, param2, 14, 4);
            byte[] param3 = new byte[32];
            System.arraycopy(cardRandom, 0, param3, 0, cardRandom.length);
            System.arraycopy(licenseData, 14, param3, 16, 8);
            System.arraycopy(termRandom, 0, param3, 24, termRandom.length);
            MTKAuth.this.MTKLog(4, "##### EXTERNAL_AUTH (SERVER) START #####");
            MTKAuth.this.MTKLog(4, " - algorithm : " + algorithm);
            MTKAuth.this.MTKLog(4, " - csn : " + MTKAuth.this.mConverter.HexToStringForDisplay(param2));
            MTKAuth.this.MTKLog(4, " - card_random : " + MTKAuth.this.mConverter.HexToStringForDisplay(param3));
            JSONObject job = new JSONObject();
            job.put("operation", (Object)"EXTERNAL_AUTH");
            job.put("algorithm", (int)algorithm);
            job.put("csn", (Object)Base64.encodeToString((byte[])param2, (int)0));
            job.put("card_random", (Object)Base64.encodeToString((byte[])param3, (int)0));
            OutputStream os = server.getOutputStream();
            os.write(job.toString().getBytes());
            os.flush();
            int responseCode = server.getResponseCode();
            if (responseCode == 200) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] byteBuffer = new byte[1024];
                byte[] byteData = null;
                int nLength = 0;
                InputStream is = server.getInputStream();
                while ((nLength = is.read(byteBuffer, 0, byteBuffer.length)) != -1) {
                    baos.write(byteBuffer, 0, nLength);
                }
                byteData = baos.toByteArray();
                responseJSON = new JSONObject(new String(byteData));
                MTKAuth.this.MTKLog(4, "DATA response = " + responseJSON.toString());
                if (!responseJSON.getString("result_code").equals("0000")) {
                    MTKAuth.this.MTKLog(4, ">>>>> ERROR : (" + responseJSON.getString("result_code") + ") " + responseJSON.getString("result_message"));
                    throw new MTKAuthException("", 251658289L);
                }
            } else {
                MTKAuth.this.MTKLog(4, ">>>>> ERROR : (" + responseCode + ") HTTPS Connection error");
                throw new MTKAuthException("", 251658289L);
            }
            byte[] session_id = Base64.decode((String)((String)responseJSON.get("session_id")), (int)0);
            MTKAuth.this.MTKLog(4, "session_id = " + MTKAuth.this.mConverter.HexToStringForDisplay(session_id));
            byte[] ciphered_data = Base64.decode((String)((String)responseJSON.get("ciphered_data")), (int)0);
            MTKAuth.this.MTKLog(4, "ciphered_data = " + MTKAuth.this.mConverter.HexToStringForDisplay(ciphered_data));
            MTKAuth.this.mSessionID = session_id;
            MTKAuth.this.MTKLog(4, "##### EXTERNAL_AUTH (SERVER) FINISH #####");
            return ciphered_data;
        }

        private byte[] mutualAuth(byte[] cipheredData) throws JSONException, IOException, MTKAuthException {
            Bundle request = new Bundle();
            Bundle response = new Bundle();
            MTKAuth.this.MTKLog(4, "##### MUTUAL_AUTHENTICATE (TOKEN) START #####");
            MTKAuth.this.MTKLog(4, " - ISSUER_ENC_DATA : " + MTKAuth.this.mConverter.HexToStringForDisplay(cipheredData));
            request.putString("REQUEST_ACTION", "MUTUAL_AUTHENTICATE");
            request.putByteArray("ISSUER_ENC_DATA", cipheredData);
            MTKAuth.this.mToken.Transmit(request, response);
            if (!response.getString("RESULT_CODE").equals("0000")) {
                MTKAuth.this.MTKLog(4, ">>>>> ERROR : (" + response.getString("RESULT_CODE") + ") " + response.getString("ERROR_MESSAGE"));
                if (response.getString("RESULT_CODE").equals("0E03") || response.getString("RESULT_CODE").equals("0FC1") || response.getString("RESULT_CODE").equals("0FC2") || response.getString("RESULT_CODE").equals("0FC3")) {
                    throw new MTKAuthException("", 251658258L);
                }
                if (response.getString("RESULT_CODE").equals("0F05")) {
                    throw new MTKAuthException("", 0xF000022L);
                }
                throw new MTKAuthException(response.getString("ERROR_MESSAGE"), 0xF0000FEL);
            }
            byte[] authData = response.getByteArray("TOKEN_ENC_DATA");
            MTKAuth.this.MTKLog(4, " - TOKEN_ENC_DATA : " + MTKAuth.this.mConverter.HexToStringForDisplay(authData));
            MTKAuth.this.MTKLog(4, "##### MUTUAL_AUTHENTICATE (TOKEN) FINISH #####");
            return authData;
        }

        private boolean internalAuth(HttpsURLConnection server, byte algorithm, byte[] authData) throws JSONException, IOException, MTKAuthException {
            MTKAuth.this.MTKLog(4, "##### INTERNAL_AUTH (SERVER) START #####");
            MTKAuth.this.MTKLog(4, " - session_id : " + MTKAuth.this.mConverter.HexToStringForDisplay(MTKAuth.this.mSessionID));
            MTKAuth.this.MTKLog(4, " - algorithm : " + algorithm);
            MTKAuth.this.MTKLog(4, " - auth_data : " + MTKAuth.this.mConverter.HexToStringForDisplay(authData));
            JSONObject job = new JSONObject();
            job.put("operation", (Object)"INTERNAL_AUTH");
            job.put("session_id", (Object)Base64.encodeToString((byte[])MTKAuth.this.mSessionID, (int)0));
            job.put("algorithm", (int)algorithm);
            job.put("auth_data", (Object)Base64.encodeToString((byte[])authData, (int)0));
            OutputStream os = server.getOutputStream();
            os = server.getOutputStream();
            os.write(job.toString().getBytes());
            os.flush();
            int responseCode = server.getResponseCode();
            if (responseCode == 200) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] byteBuffer = new byte[1024];
                byte[] byteData = null;
                int nLength = 0;
                InputStream is = server.getInputStream();
                while ((nLength = is.read(byteBuffer, 0, byteBuffer.length)) != -1) {
                    baos.write(byteBuffer, 0, nLength);
                }
                byteData = baos.toByteArray();
                JSONObject responseJSON = new JSONObject(new String(byteData));
                MTKAuth.this.MTKLog(4, "DATA response = " + responseJSON.toString());
                if (!responseJSON.getString("result_code").equals("0000")) {
                    MTKAuth.this.MTKLog(4, ">>>>> ERROR : (" + responseJSON.getString("result_code") + ") " + responseJSON.getString("result_message"));
                    throw new MTKAuthException("", 251658289L);
                }
            } else {
                MTKAuth.this.MTKLog(4, ">>>>> ERROR : (" + responseCode + ") HTTPS Connection error");
                throw new MTKAuthException("", 251658289L);
            }
            MTKAuth.this.MTKLog(4, "##### INTERNAL_AUTH (SERVER) FINISH #####");
            return true;
        }
    }
}

