/*
 * Decompiled with CFR 0.152.
 */
package kr.co.juis.jpp.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.android.gcm.GCMRegistrar;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import kr.co.juis.jpp.android.JPPLibHttpUtil;
import kr.co.juis.jpp.android.JPPLibPushOptionData;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParserException;

public class JPPLib {
    public static final int GCM_REGIST_REQUEST = 10000;
    public static final int JPP_REGIST_REQUEST = 10001;
    public static final int GET_PUSH_OPTION_REQUEST = 10002;
    public static final int SAVE_PUSH_OPTION_REQUEST = 10003;
    public static final int READ_PUSH_REQUEST = 10004;
    public static final int JPP_UNREGIST_REQUEST = 10005;
    public static final int GCM_UNREGIST_REQUEST = 10006;
    public static final int SAVE_PUSH_OPTION_AND_REGIST_APP_REQUEST = 10007;
    private static final String logTag = "JPPLib";
    private static JPPLib m_propertyUtil = new JPPLib();
    private boolean isDebug = false;
    private Context context = null;

    private JPPLib() {
    }

    public static synchronized void initWithDebug(Context ctx, int xml_jppconfig) {
        JPPLib.m_propertyUtil.isDebug = true;
        JPPLib.init(ctx, xml_jppconfig);
        JPPLibHttpUtil.getInstance().setDebug(true);
        m_propertyUtil.setProperty("isdebug", "true");
    }

    public static synchronized void init(Context ctx, int xml_jppconfig) {
        String HOSTURL;
        String projectID;
        String APPID;
        block22: {
            m_propertyUtil.setContext(ctx);
            APPID = "";
            projectID = "";
            HOSTURL = "";
            int tag = 0;
            Resources res = ctx.getResources();
            XmlResourceParser xrp = res.getXml(xml_jppconfig);
            try {
                xrp.next();
                int eventType = xrp.getEventType();
                while (eventType != 1) {
                    if (eventType != 0) {
                        if (eventType == 2) {
                            if (xrp.getName().equals("appid")) {
                                tag = 0;
                            } else if (xrp.getName().equals("projectid")) {
                                tag = 1;
                            } else if (xrp.getName().equals("hosturl")) {
                                tag = 2;
                            }
                        } else if (eventType == 3) {
                            tag = -1;
                        } else if (eventType == 4) {
                            switch (tag) {
                                case 0: {
                                    APPID = xrp.getText();
                                    break;
                                }
                                case 1: {
                                    projectID = xrp.getText();
                                    break;
                                }
                                case 2: {
                                    HOSTURL = xrp.getText();
                                    break;
                                }
                            }
                        }
                    }
                    eventType = xrp.next();
                }
                if (JPPLib.m_propertyUtil.isDebug) {
                    Log.d((String)logTag, (String)("appid=" + APPID));
                    Log.d((String)logTag, (String)("projectID=" + projectID));
                    Log.d((String)logTag, (String)("hosturl=" + HOSTURL));
                }
            }
            catch (XmlPullParserException e) {
                if (JPPLib.m_propertyUtil.isDebug) {
                    Log.e((String)logTag, (String)"", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!JPPLib.m_propertyUtil.isDebug) break block22;
                Log.e((String)logTag, (String)"", (Throwable)e);
            }
        }
        m_propertyUtil.setJPPHostURL(HOSTURL);
        m_propertyUtil.setProperty("projectid", projectID);
        m_propertyUtil.setProperty("appid", APPID);
        m_propertyUtil.setProperty("appid", APPID);
        m_propertyUtil.setProperty("isdebug", "false");
    }

    public static synchronized JPPLib getInstance() {
        return m_propertyUtil;
    }

    protected String getProperty(String key) {
        if (this.context != null) {
            SharedPreferences prefs = this.context.getSharedPreferences("JPP_GCM_Property", 0);
            String s = prefs.getString(key, null);
            return s;
        }
        return null;
    }

    protected void setProperty(String key, String value) {
        if (this.context != null) {
            SharedPreferences prefs = this.context.getSharedPreferences("JPP_GCM_Property", 0);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(key, value);
            editor.commit();
        }
    }

    public void setUDID(String value) {
        if (this.context != null) {
            SharedPreferences prefs = this.context.getSharedPreferences("JPP_GCM_Property", 0);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString("udid", value);
            editor.commit();
        }
    }

    protected void removeProperty(String key) {
        if (this.context != null) {
            SharedPreferences prefs = this.context.getSharedPreferences("JPP_GCM_Property", 0);
            SharedPreferences.Editor editor = prefs.edit();
            editor.remove(key);
            editor.commit();
        }
    }

    public void registGcm(Handler mHandler) {
        String sRegId = this.getProperty("prefGCMRegsterID");
        if (sRegId == null || sRegId.equals("")) {
            GCMRegistrar.checkDevice((Context)this.context.getApplicationContext());
            GCMRegistrar.checkManifest((Context)this.context.getApplicationContext());
            String regId = GCMRegistrar.getRegistrationId((Context)this.context.getApplicationContext());
            if ("".equals(regId)) {
                this.removeProperty("prefGCMRegsterID");
                GCMRegistrar.register((Context)this.context.getApplicationContext(), (String[])new String[]{this.getProperty("projectid")});
                final Handler fmHandler = mHandler;
                TimerTask myTask = new TimerTask(){

                    @Override
                    public void run() {
                        String sRegId = "";
                        int cnt = 0;
                        while ((sRegId = JPPLib.this.getProperty("prefGCMRegsterID")) == null || sRegId.equals("")) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (cnt > 20) break;
                            ++cnt;
                        }
                        if (sRegId != null && !sRegId.equals("")) {
                            Message msg = fmHandler.obtainMessage();
                            msg.arg1 = 10000;
                            msg.arg2 = 0;
                            msg.obj = sRegId;
                            fmHandler.sendMessageDelayed(msg, 100L);
                        } else {
                            Message msg = fmHandler.obtainMessage();
                            msg.arg1 = 10000;
                            msg.arg2 = -1;
                            fmHandler.sendMessageDelayed(msg, 100L);
                        }
                    }
                };
                Timer timer = new Timer();
                timer.schedule(myTask, 100L);
            } else {
                this.setProperty("prefGCMRegsterID", regId);
                Message msg = mHandler.obtainMessage();
                msg.arg1 = 10000;
                msg.arg2 = 0;
                msg.obj = sRegId;
                mHandler.sendMessageDelayed(msg, 100L);
            }
        } else {
            Message msg = mHandler.obtainMessage();
            msg.arg1 = 10000;
            msg.arg2 = 0;
            msg.obj = sRegId;
            mHandler.sendMessageDelayed(msg, 100L);
        }
    }

    public void registGcm(Handler mHandler, boolean overwrite) {
        String sRegId = this.getProperty("prefGCMRegsterID");
        if (overwrite) {
            this.removeProperty("prefGCMRegsterID");
            sRegId = null;
        }
        if (sRegId == null || sRegId.equals("")) {
            GCMRegistrar.checkDevice((Context)this.context.getApplicationContext());
            GCMRegistrar.checkManifest((Context)this.context.getApplicationContext());
            String regId = GCMRegistrar.getRegistrationId((Context)this.context.getApplicationContext());
            if ("".equals(regId)) {
                this.removeProperty("prefGCMRegsterID");
                GCMRegistrar.register((Context)this.context.getApplicationContext(), (String[])new String[]{this.getProperty("projectid")});
                final Handler fmHandler = mHandler;
                TimerTask myTask = new TimerTask(){

                    @Override
                    public void run() {
                        String sRegId = "";
                        int cnt = 0;
                        while ((sRegId = JPPLib.this.getProperty("prefGCMRegsterID")) == null || sRegId.equals("")) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (cnt > 20) break;
                            ++cnt;
                        }
                        if (sRegId != null && !sRegId.equals("")) {
                            Message msg = fmHandler.obtainMessage();
                            msg.arg1 = 10000;
                            msg.arg2 = 0;
                            msg.obj = sRegId;
                            fmHandler.sendMessageDelayed(msg, 100L);
                        } else {
                            Message msg = fmHandler.obtainMessage();
                            msg.arg1 = 10000;
                            msg.arg2 = -1;
                            fmHandler.sendMessageDelayed(msg, 100L);
                        }
                    }
                };
                Timer timer = new Timer();
                timer.schedule(myTask, 100L);
            } else {
                this.setProperty("prefGCMRegsterID", regId);
                Message msg = mHandler.obtainMessage();
                msg.arg1 = 10000;
                msg.arg2 = 0;
                msg.obj = sRegId;
                mHandler.sendMessageDelayed(msg, 100L);
            }
        } else {
            Message msg = mHandler.obtainMessage();
            msg.arg1 = 10000;
            msg.arg2 = 0;
            msg.obj = sRegId;
            mHandler.sendMessageDelayed(msg, 100L);
        }
    }

    public void unregistGcm(Handler mHandler) {
        String sRegId = this.getProperty("prefGCMRegsterID");
        if (sRegId != null && !sRegId.equals("")) {
            GCMRegistrar.checkDevice((Context)this.context.getApplicationContext());
            GCMRegistrar.checkManifest((Context)this.context.getApplicationContext());
            GCMRegistrar.unregister((Context)this.context.getApplicationContext());
            final Handler fmHandler = mHandler;
            TimerTask myTask = new TimerTask(){

                @Override
                public void run() {
                    String sRegId = "";
                    while ((sRegId = JPPLib.this.getProperty("prefGCMRegsterID")) == null || sRegId.equals("")) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10006;
                    msg.arg2 = 0;
                    fmHandler.sendMessageDelayed(msg, 100L);
                }
            };
            Timer timer = new Timer();
            timer.schedule(myTask, 100L);
        } else {
            Message msg = mHandler.obtainMessage();
            msg.arg1 = 10006;
            msg.arg2 = 0;
            mHandler.sendMessageDelayed(msg, 100L);
        }
    }

    public void registApp(String userID, Handler mHandler) {
        String os = "android";
        String os_version = Build.VERSION.RELEASE;
        final String fAPP_ID = this.getProperty("appid");
        final String fuserID = userID;
        final String fudid = this.getProperty("udid");
        final String fos = os;
        final String fos_version = os_version;
        final String ftoken = this.getProperty("prefGCMRegsterID");
        final Handler fmHandler = mHandler;
        TimerTask myTask = new TimerTask(){

            @Override
            public void run() {
                boolean res = JPPLibHttpUtil.getInstance().registApp(fAPP_ID, fuserID, fudid, fos, fos_version, ftoken);
                if (res) {
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10001;
                    msg.arg2 = 0;
                    fmHandler.sendMessageDelayed(msg, 100L);
                } else {
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10001;
                    msg.arg2 = -1;
                    msg.obj = JPPLibHttpUtil.getInstance().getLastMessage();
                    fmHandler.sendMessageDelayed(msg, 100L);
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(myTask, 100L);
    }

    public void unregistApp(String userID, Handler mHandler) {
        final String fAPP_ID = m_propertyUtil.getProperty("appid");
        final String fuserID = userID;
        final String fudid = m_propertyUtil.getProperty("udid");
        final Handler fmHandler = mHandler;
        TimerTask myTask = new TimerTask(){

            @Override
            public void run() {
                boolean res = JPPLibHttpUtil.getInstance().unregistApp(fAPP_ID, fuserID, fudid);
                if (res) {
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10005;
                    msg.arg2 = 0;
                    fmHandler.sendMessageDelayed(msg, 100L);
                } else {
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10005;
                    msg.arg2 = -1;
                    msg.obj = JPPLibHttpUtil.getInstance().getLastMessage();
                    fmHandler.sendMessageDelayed(msg, 100L);
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(myTask, 100L);
    }

    public void getPushOption(String userID, Handler mHandler) {
        final String fAPP_ID = m_propertyUtil.getProperty("appid");
        final String fuserID = userID;
        final Handler fmHandler = mHandler;
        TimerTask myTask = new TimerTask(){

            @Override
            public void run() {
                JSONObject res = JPPLibHttpUtil.getInstance().getPushOption(fAPP_ID, fuserID);
                if (res != null) {
                    try {
                        String alramtype = res.getString("alramtype");
                        String option1yn = res.getString("option1yn");
                        String option2yn = res.getString("option2yn");
                        String option3yn = res.getString("option3yn");
                        String option4yn = res.getString("option4yn");
                        String option5yn = res.getString("option5yn");
                        String option6yn = res.getString("option6yn");
                        String option7yn = res.getString("option7yn");
                        String option8yn = res.getString("option8yn");
                        String option9yn = res.getString("option9yn");
                        String pushtype = res.getString("pushtype");
                        if (!res.has("userid2") || res.getString("userid2") == null || res.getString("userid2").equals("") || res.getString("userid2").equals("null")) {
                            option1yn = "N";
                            option2yn = "N";
                            option3yn = "N";
                            option4yn = "N";
                            option5yn = "N";
                            option6yn = "N";
                            option7yn = "N";
                            option8yn = "N";
                            option9yn = "N";
                        }
                        if (!res.has("token") || res.getString("token") == null || res.getString("token").equals("") || res.getString("token").equals("null") || res.getString("token").equals("-1") || res.getString("token").equals("none") || res.getString("token").equals("simulator") || res.getString("token").length() < 50) {
                            option1yn = "N";
                            option2yn = "N";
                            option3yn = "N";
                            option4yn = "N";
                            option5yn = "N";
                            option6yn = "N";
                            option7yn = "N";
                            option8yn = "N";
                            option9yn = "N";
                        }
                        JPPLibPushOptionData data = new JPPLibPushOptionData(alramtype, option1yn, option2yn, option3yn, option4yn, option5yn, option6yn, option7yn, option8yn, option9yn, pushtype);
                        Message msg = fmHandler.obtainMessage();
                        msg.arg1 = 10002;
                        msg.arg2 = 0;
                        msg.obj = data;
                        fmHandler.sendMessageDelayed(msg, 100L);
                    }
                    catch (Exception ex) {
                        Message msg = fmHandler.obtainMessage();
                        msg.arg1 = 10002;
                        msg.arg2 = -1;
                        msg.obj = ex.getMessage();
                        fmHandler.sendMessageDelayed(msg, 100L);
                    }
                } else {
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10002;
                    msg.arg2 = -1;
                    msg.obj = JPPLibHttpUtil.getInstance().getLastMessage();
                    fmHandler.sendMessageDelayed(msg, 100L);
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(myTask, 100L);
    }

    public void savePushOption(String userID, JPPLibPushOptionData option, Handler mHandler) {
        final String fAPP_ID = m_propertyUtil.getProperty("appid");
        final String fuserID = userID;
        final JPPLibPushOptionData foption = option;
        final Handler fmHandler = mHandler;
        TimerTask myTask = new TimerTask(){

            @Override
            public void run() {
                boolean res = JPPLibHttpUtil.getInstance().savePushOption(fAPP_ID, fuserID, foption.getAlramtype(), foption.getOption1yn(), foption.getOption2yn(), foption.getOption3yn(), foption.getOption4yn(), foption.getOption5yn(), foption.getOption6yn(), foption.getOption7yn(), foption.getOption8yn(), foption.getOption9yn(), foption.getPushtype());
                if (res) {
                    m_propertyUtil.setProperty("alramtype", foption.getAlramtype());
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10003;
                    msg.arg2 = 0;
                    fmHandler.sendMessageDelayed(msg, 100L);
                } else {
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10003;
                    msg.arg2 = -1;
                    msg.obj = JPPLibHttpUtil.getInstance().getLastMessage();
                    fmHandler.sendMessageDelayed(msg, 100L);
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(myTask, 100L);
    }

    public void savePushOptionAndRegistApp(String userID, JPPLibPushOptionData option, Handler mHandler) {
        String os = "android";
        String os_version = Build.VERSION.RELEASE;
        final String fAPP_ID = this.getProperty("appid");
        final String fuserID = userID;
        final String fudid = this.getProperty("udid");
        final String fos = os;
        final String fos_version = os_version;
        final String ftoken = this.getProperty("prefGCMRegsterID");
        final JPPLibPushOptionData foption = option;
        final Handler fmHandler = mHandler;
        TimerTask myTask = new TimerTask(){

            @Override
            public void run() {
                boolean res = JPPLibHttpUtil.getInstance().savePushOptionAndRegistApp(fAPP_ID, fuserID, fudid, fos, fos_version, ftoken, foption.getAlramtype(), foption.getOption1yn(), foption.getOption2yn(), foption.getOption3yn(), foption.getOption4yn(), foption.getOption5yn(), foption.getOption6yn(), foption.getOption7yn(), foption.getOption8yn(), foption.getOption9yn(), foption.getPushtype());
                if (res) {
                    m_propertyUtil.setProperty("alramtype", foption.getAlramtype());
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10007;
                    msg.arg2 = 0;
                    fmHandler.sendMessageDelayed(msg, 100L);
                } else {
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10007;
                    msg.arg2 = -1;
                    msg.obj = JPPLibHttpUtil.getInstance().getLastMessage();
                    fmHandler.sendMessageDelayed(msg, 100L);
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(myTask, 100L);
    }

    public void readPush(String pushId, Handler mHandler) {
        final String fpushId = pushId;
        final Handler fmHandler = mHandler;
        TimerTask myTask = new TimerTask(){

            @Override
            public void run() {
                boolean res = JPPLibHttpUtil.getInstance().readPush(fpushId);
                if (res) {
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10004;
                    msg.arg2 = 0;
                    fmHandler.sendMessageDelayed(msg, 100L);
                } else {
                    Message msg = fmHandler.obtainMessage();
                    msg.arg1 = 10004;
                    msg.arg2 = -1;
                    msg.obj = JPPLibHttpUtil.getInstance().getLastMessage();
                    fmHandler.sendMessageDelayed(msg, 100L);
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(myTask, 100L);
    }

    protected void setJPPHostURL(String url) {
        this.setProperty("jpp_host", url);
    }

    protected Context getContext() {
        return this.context;
    }

    protected void setContext(Context context) {
        this.context = context;
    }
}

