/*
 * Decompiled with CFR 0.152.
 */
package kr.co.juis.jpp.android;

import android.util.Log;
import java.io.BufferedInputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kr.co.juis.jpp.android.DummySSLSocketFactory;
import kr.co.juis.jpp.android.JPPLib;
import org.json.JSONObject;

class JPPLibHttpUtil {
    private static final String logTag = "JPPLib";
    private static String message = "";
    private static boolean isDebug = false;
    private static JPPLibHttpUtil _instance = new JPPLibHttpUtil();

    JPPLibHttpUtil() {
    }

    protected static JPPLibHttpUtil getInstance() {
        return _instance;
    }

    protected void setDebug(boolean debug) {
        isDebug = debug;
    }

    protected String getLastMessage() {
        return message;
    }

    protected JSONObject httpRequest(String api, String args) throws Exception {
        int len;
        if (isDebug) {
            Log.d((String)logTag, (String)("httpRequest args: " + args));
        }
        String hosturl = JPPLib.getInstance().getProperty("jpp_host");
        String urlt = "/jpp.jsp";
        String jpp_do = api.replaceAll("/api/", "");
        args = String.valueOf(args) + "&jpp_do=" + jpp_do;
        URL url = new URL(String.valueOf(hosturl) + urlt);
        HttpURLConnection conn = null;
        if (url.getProtocol().toLowerCase().equals("https")) {
            JPPLibHttpUtil.trustAllHosts();
            HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
            HttpsURLConnection.setDefaultHostnameVerifier(new FakeHostnameVerifier());
            conn = https;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-Length", Integer.toString(args.length()));
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(args);
        wr.flush();
        wr.close();
        BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
        int size = conn.getContentLength();
        if (size == -1) {
            size = 1024;
        }
        byte[] temp = new byte[size];
        boolean c = false;
        int i = 0;
        i = len = bis.read(temp, i, size);
        while (len > -1) {
            if ((i += (len = bis.read(temp, i, size - i))) != size) continue;
            byte[] temp2 = new byte[size + 1024];
            System.arraycopy(temp, 0, temp2, 0, size);
            temp = temp2;
            size += 1024;
        }
        bis.close();
        conn.disconnect();
        String jsonString = new String(temp, 0, i + 1, "UTF8");
        if (isDebug) {
            Log.d((String)logTag, (String)("httpRequest ret: " + jsonString));
        }
        JSONObject json = new JSONObject(jsonString);
        return json;
    }

    protected boolean registApp(String appID, String userID, String udid, String os, String os_version, String token) {
        String message;
        block6: {
            JPPLibHttpUtil.message = "";
            try {
                String sss = "appId=" + URLEncoder.encode(appID, "UTF8") + "&userId=" + URLEncoder.encode(userID, "UTF8") + "&udid=" + URLEncoder.encode(udid, "UTF8") + "&os=" + URLEncoder.encode(os, "UTF8") + "&osVersion=" + URLEncoder.encode(os_version, "UTF8") + "&token=" + URLEncoder.encode(token, "UTF8");
                JSONObject retJson = this.httpRequest("/api/registApp.do", sss);
                JSONObject result = retJson.getJSONObject("result");
                String code = result.getString("code");
                message = result.getString("message");
                if (!code.equals("0000")) break block6;
                if (isDebug) {
                    Log.d((String)logTag, (String)"registApp success");
                }
                return true;
            }
            catch (Exception ex) {
                if (isDebug) {
                    Log.e((String)logTag, (String)"", (Throwable)ex);
                }
                JPPLibHttpUtil.message = ex.getMessage();
                return false;
            }
        }
        if (isDebug) {
            Log.d((String)logTag, (String)("registApp fail, " + message));
        }
        JPPLibHttpUtil.message = message;
        return false;
    }

    protected boolean unregistApp(String appID, String userID, String udid) {
        String message;
        block6: {
            JPPLibHttpUtil.message = "";
            try {
                String sss = "appId=" + URLEncoder.encode(appID, "UTF8") + "&userId=" + URLEncoder.encode(userID, "UTF8") + "&udid=" + URLEncoder.encode(udid, "UTF8");
                JSONObject retJson = this.httpRequest("/api/unregistApp.do", sss);
                JSONObject result = retJson.getJSONObject("result");
                String code = result.getString("code");
                message = result.getString("message");
                if (!code.equals("0000")) break block6;
                if (isDebug) {
                    Log.d((String)logTag, (String)"unregistApp success");
                }
                return true;
            }
            catch (Exception ex) {
                if (isDebug) {
                    Log.e((String)logTag, (String)"", (Throwable)ex);
                }
                JPPLibHttpUtil.message = ex.getMessage();
                return false;
            }
        }
        if (isDebug) {
            Log.d((String)logTag, (String)("unregistApp fail, " + message));
        }
        JPPLibHttpUtil.message = message;
        return false;
    }

    protected JSONObject getPushOption(String appID, String userID) {
        message = "";
        try {
            String sss = "appId=" + URLEncoder.encode(appID, "UTF8") + "&userId=" + URLEncoder.encode(userID, "UTF8");
            JSONObject retJson = this.httpRequest("/api/getPushOption.do", sss);
            JSONObject result = retJson.getJSONObject("result");
            String code = result.getString("code");
            String message = result.getString("message");
            if (code.equals("0000")) {
                JSONObject data = retJson.getJSONObject("data");
                if (isDebug) {
                    Log.d((String)logTag, (String)"getPushOption success");
                }
                return data.getJSONObject("info");
            }
            if (isDebug) {
                Log.d((String)logTag, (String)("getPushOption fail, " + message));
            }
            JPPLibHttpUtil.message = message;
            return null;
        }
        catch (Exception ex) {
            if (isDebug) {
                Log.e((String)logTag, (String)"", (Throwable)ex);
            }
            message = ex.getMessage();
            return null;
        }
    }

    protected boolean savePushOption(String appID, String userID, String alramtype, String option1yn, String option2yn, String option3yn, String option4yn, String option5yn, String option6yn, String option7yn, String option8yn, String option9yn, String pushtype) {
        String message;
        block6: {
            JPPLibHttpUtil.message = "";
            try {
                String sss = "appId=" + URLEncoder.encode(appID, "UTF8") + "&userId=" + URLEncoder.encode(userID, "UTF8") + "&alramType=" + URLEncoder.encode(alramtype, "UTF8") + "&option1Yn=" + URLEncoder.encode(option1yn, "UTF8") + "&option2Yn=" + URLEncoder.encode(option2yn, "UTF8") + "&option3Yn=" + URLEncoder.encode(option3yn, "UTF8") + "&option4Yn=" + URLEncoder.encode(option4yn, "UTF8") + "&option5Yn=" + URLEncoder.encode(option5yn, "UTF8") + "&option6Yn=" + URLEncoder.encode(option6yn, "UTF8") + "&option7Yn=" + URLEncoder.encode(option7yn, "UTF8") + "&option8Yn=" + URLEncoder.encode(option8yn, "UTF8") + "&option9Yn=" + URLEncoder.encode(option9yn, "UTF8") + "&pushType=" + URLEncoder.encode(pushtype, "UTF8");
                JSONObject retJson = this.httpRequest("/api/savePushOption.do", sss);
                JSONObject result = retJson.getJSONObject("result");
                String code = result.getString("code");
                message = result.getString("message");
                if (!code.equals("0000")) break block6;
                if (isDebug) {
                    Log.d((String)logTag, (String)"savePushOption success");
                }
                return true;
            }
            catch (Exception ex) {
                if (isDebug) {
                    Log.e((String)logTag, (String)"", (Throwable)ex);
                }
                JPPLibHttpUtil.message = ex.getMessage();
                return false;
            }
        }
        if (isDebug) {
            Log.d((String)logTag, (String)("savePushOption fail, " + message));
        }
        JPPLibHttpUtil.message = message;
        return false;
    }

    protected boolean savePushOptionAndRegistApp(String appID, String userID, String udid, String os, String os_version, String token, String alramtype, String option1yn, String option2yn, String option3yn, String option4yn, String option5yn, String option6yn, String option7yn, String option8yn, String option9yn, String pushtype) {
        String message;
        block6: {
            JPPLibHttpUtil.message = "";
            try {
                String sss = "appId=" + URLEncoder.encode(appID, "UTF8") + "&userId=" + URLEncoder.encode(userID, "UTF8") + "&alramType=" + URLEncoder.encode(alramtype, "UTF8") + "&option1Yn=" + URLEncoder.encode(option1yn, "UTF8") + "&option2Yn=" + URLEncoder.encode(option2yn, "UTF8") + "&option3Yn=" + URLEncoder.encode(option3yn, "UTF8") + "&option4Yn=" + URLEncoder.encode(option4yn, "UTF8") + "&option5Yn=" + URLEncoder.encode(option5yn, "UTF8") + "&option6Yn=" + URLEncoder.encode(option6yn, "UTF8") + "&option7Yn=" + URLEncoder.encode(option7yn, "UTF8") + "&option8Yn=" + URLEncoder.encode(option8yn, "UTF8") + "&option9Yn=" + URLEncoder.encode(option9yn, "UTF8") + "&pushType=" + URLEncoder.encode(pushtype, "UTF8") + "&udid=" + URLEncoder.encode(udid, "UTF8") + "&os=" + URLEncoder.encode(os, "UTF8") + "&osVersion=" + URLEncoder.encode(os_version, "UTF8") + "&token=" + URLEncoder.encode(token, "UTF8");
                JSONObject retJson = this.httpRequest("/api/savePushOptionAndRegistApp.do", sss);
                JSONObject result = retJson.getJSONObject("result");
                String code = result.getString("code");
                message = result.getString("message");
                if (!code.equals("0000")) break block6;
                if (isDebug) {
                    Log.d((String)logTag, (String)"savePushOption success");
                }
                return true;
            }
            catch (Exception ex) {
                if (isDebug) {
                    Log.e((String)logTag, (String)"", (Throwable)ex);
                }
                JPPLibHttpUtil.message = ex.getMessage();
                return false;
            }
        }
        if (isDebug) {
            Log.d((String)logTag, (String)("savePushOption fail, " + message));
        }
        JPPLibHttpUtil.message = message;
        return false;
    }

    protected boolean readPush(String pushid) {
        String message;
        block6: {
            JPPLibHttpUtil.message = "";
            try {
                String sss = "pushid=" + URLEncoder.encode(pushid, "UTF8");
                JSONObject retJson = this.httpRequest("/api/readPush.do", sss);
                JSONObject result = retJson.getJSONObject("result");
                String code = result.getString("code");
                message = result.getString("message");
                if (!code.equals("0000")) break block6;
                if (isDebug) {
                    Log.d((String)logTag, (String)"readPush success");
                }
                return true;
            }
            catch (Exception ex) {
                if (isDebug) {
                    Log.e((String)logTag, (String)"", (Throwable)ex);
                }
                JPPLibHttpUtil.message = ex.getMessage();
                return false;
            }
        }
        if (isDebug) {
            Log.d((String)logTag, (String)("readPush fail, " + message));
        }
        JPPLibHttpUtil.message = message;
        return false;
    }

    private static void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            DummySSLSocketFactory dsslf = new DummySSLSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(dsslf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class FakeHostnameVerifier
    implements HostnameVerifier {
        private FakeHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

