/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.keypad;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrUser;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecurekeypad.XKConstants;
import com.softforum.xecurekeypad.XKEditText;
import java.security.SecureRandom;

public class XecureSmartChangePasswordWithXK
extends Activity {
    public static final int mXecureSmartChangePasswordID = 78000;
    public static final String mMediaIDKey = "xecure_smart_changepw_media_id_key";
    public static final String mSelectedCertDataKey = "xecure_smart_changepw_data_key";
    public static final String mNewPasswordKey = "sign_cert_password_password_key";
    public static final String mOldPasswordKey = "old_cert_password_password_key";
    public static final String mRandomValueKey = "sign_cert_password_random_value_key";
    public static final String mE_ncryptedDataKey = "sign_cert_password_e_ncrypted_data_key";
    public static final String mNewE_ncryptedDataKey = "sign_cert_password_new_e_ncrypted_data_key";
    public static final int RESULT_PASSWD_FAIL = 2;
    private int mMediaID;
    private int m_P_assW_ordTryCount = 0;
    private XDetailData mSelectedData;
    private XCoreUtil mCoreUtil = new XCoreUtil();
    private byte[] mOldPassword = null;
    private byte[] mNewPassword = null;
    private byte[] mNewPasswordConfirm = null;
    private String mEncryptedData = null;
    private String mNewEncryptedData = null;
    private String mConfirmEncryptedData = null;
    private byte[] mRandomValue = new byte[20];
    private String mCallMode;
    private int mDetailDataType = 0;
    private int mDetailDataCertSubjectKey = 7;
    private int mDetailDataCertIssuerKey = 4;
    private int mDetailDataCertToKey = 6;
    private XKEditText mOldPasswordTextView = null;
    private XKEditText mNewPasswordTextView = null;
    private XKEditText mNewPasswordConfirmTextView = null;
    private final int mResultForNotExistPassword = 10;
    private final int mResultForVerifyPasswordFail = 11;
    private final int mResultForNotCorrectPassword = 12;
    private final int mResultForEqualPassword = 13;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_change_password_xk);
        this.mMediaID = this.getIntent().getIntExtra(mMediaIDKey, -1);
        this.mCallMode = this.getIntent().getStringExtra("call_mode_key");
        if (this.mCallMode != null && this.mCallMode.equals("call_mode_renew")) {
            XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
            aTopView.setSubject(this.getString(R.string.renew_certificate_window_title));
            aTopView.setDescription(this.getString(R.string.renew_certificate_window_desc));
            this.mDetailDataType = 3;
            this.mDetailDataCertSubjectKey = 2;
            this.mDetailDataCertIssuerKey = 3;
            this.mDetailDataCertToKey = 4;
            TextView aAlertTextView = (TextView)this.findViewById(R.id.new_password_check_alert_textview);
            aAlertTextView.setVisibility(0);
        }
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), this.mDetailDataType);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)this.mSelectedData.getValue(this.mDetailDataCertSubjectKey));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertIssuerKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertIssuerKey)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertToKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertToKey)));
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(this.mRandomValue);
        }
        this.setKeyPad();
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartChangePasswordWithXK.this.onOKButtonClick(v);
            }
        });
    }

    private void setKeyPad() {
        int aKeypadType = 0;
        int aKeypadViewType = 0;
        this.mOldPasswordTextView = (XKEditText)this.findViewById(R.id.password_edittext);
        this.mNewPasswordTextView = (XKEditText)this.findViewById(R.id.new_password_edittext);
        this.mNewPasswordConfirmTextView = (XKEditText)this.findViewById(R.id.new_password_confirm_edittext);
        if (EnvironmentConfig.mXecureKeypadFullViewUsage) {
            aKeypadViewType = 1;
            this.mOldPasswordTextView.setSubTitle("\ube44\ubc00\ubc88\ud638");
            this.mNewPasswordTextView.setSubTitle("\uc0c8 \ube44\ubc00\ubc88\ud638");
            this.mNewPasswordConfirmTextView.setSubTitle("\uc0c8 \ube44\ubc00\ubc88\ud638 \ud655\uc778");
        } else if (EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aKeypadViewType = 0;
            this.mOldPasswordTextView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
            this.mNewPasswordTextView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
            this.mNewPasswordConfirmTextView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
        }
        if (aKeypadViewType == 1) {
            this.mOldPasswordTextView.setUseInputButton(true);
            this.mNewPasswordTextView.setUseInputButton(true);
            this.mNewPasswordConfirmTextView.setUseInputButton(true);
            this.mOldPasswordTextView.setSubTitle(this.getString(R.string.password));
            this.mNewPasswordTextView.setSubTitle(this.getString(R.string.new_password));
            this.mNewPasswordConfirmTextView.setSubTitle(this.getString(R.string.new_password_confirm));
        }
        aKeypadType = 1;
        this.mOldPasswordTextView.setXKViewType(aKeypadViewType);
        this.mOldPasswordTextView.setXKKeypadType(aKeypadType);
        this.mNewPasswordTextView.setXKViewType(aKeypadViewType);
        this.mNewPasswordTextView.setXKKeypadType(aKeypadType);
        this.mNewPasswordConfirmTextView.setXKViewType(aKeypadViewType);
        this.mNewPasswordConfirmTextView.setXKKeypadType(aKeypadType);
    }

    private int checkInputPasswordWithEncryption() {
        int aResult = -1;
        int aErrorCode = 0;
        int aConfirmResult = 0;
        String aSubjectDN = null;
        CertMgr aCertMgr = CertMgr.getInstance();
        if (this.mEncryptedData == null || this.mEncryptedData.length() == 0) {
            return 10;
        }
        aSubjectDN = this.mSelectedData.getValue(this.mDetailDataCertSubjectKey);
        aResult = aCertMgr.verifyPassword(this.mMediaID, aSubjectDN, this.mRandomValue, this.mEncryptedData);
        if (aResult != 0 && (aErrorCode = this.mCoreUtil.lastErrCode()) != 22000015) {
            return 11;
        }
        if (this.mNewEncryptedData == null || this.mNewEncryptedData.length() == 0) {
            return 10;
        }
        aResult = this.mCallMode != null && this.mCallMode.equals("call_mode_renew") ? XUtil.checkPassword((String)this.mNewEncryptedData, (byte[])this.mRandomValue, (int)2) : XUtil.checkPassword((String)this.mNewEncryptedData, (byte[])this.mRandomValue, (int)0);
        if (aResult != 0) {
            return aResult;
        }
        if (this.mConfirmEncryptedData == null || this.mConfirmEncryptedData.length() == 0) {
            aConfirmResult = -1;
        } else if (!this.mNewEncryptedData.equals(this.mConfirmEncryptedData)) {
            aConfirmResult = -1;
        }
        if (aConfirmResult != 0) {
            return 12;
        }
        if (this.mEncryptedData.equals(this.mConfirmEncryptedData)) {
            return 13;
        }
        return aResult;
    }

    private int checkInputPassword() {
        int aResult = -1;
        int aErrorCode = 0;
        int aConfirmResult = 0;
        int aEqualResult = 0;
        int aIndex = 0;
        CertMgr aCertMgr = null;
        aCertMgr = CertMgr.getInstance();
        if (this.mOldPassword == null || this.mOldPassword.length == 0) {
            return 10;
        }
        aResult = aCertMgr.verifyPassword(this.mMediaID, 14, this.mSelectedData.getValue(this.mDetailDataCertSubjectKey), this.mOldPassword);
        if (aResult != 0 && (aErrorCode = this.mCoreUtil.lastErrCode()) != 22000015) {
            return 11;
        }
        if (this.mNewPassword == null || this.mNewPassword.length == 0) {
            return 10;
        }
        aResult = this.mCallMode != null && this.mCallMode.equals("call_mode_renew") ? XUtil.newCheckPasswordFormat((byte[])this.mNewPassword) : XUtil.checkPasswordFormat((byte[])this.mNewPassword);
        if (aResult != 0) {
            return aResult;
        }
        if (this.mNewPasswordConfirm == null || this.mNewPasswordConfirm.length == 0) {
            aConfirmResult = -1;
        } else if (this.mNewPassword.length == this.mNewPasswordConfirm.length) {
            for (aIndex = 0; aIndex < this.mNewPassword.length; ++aIndex) {
                if (this.mNewPassword[aIndex] == this.mNewPasswordConfirm[aIndex]) continue;
                aConfirmResult = -1;
                break;
            }
        } else {
            aConfirmResult = -1;
        }
        if (aConfirmResult != 0) {
            return 12;
        }
        if (this.mOldPassword.length == this.mNewPasswordConfirm.length) {
            for (aIndex = 0; aIndex < this.mNewPasswordConfirm.length; ++aIndex) {
                if (this.mOldPassword[aIndex] == this.mNewPasswordConfirm[aIndex]) continue;
                aEqualResult = -1;
                break;
            }
        }
        if (aEqualResult == 0) {
            return 13;
        }
        return aResult;
    }

    private void onOKButtonClick(View v) {
        int aResult = 0;
        String aSubjectDN = null;
        Intent aIntent = null;
        XTopView aTopView = null;
        CertMgr aCertMgr = CertMgr.getInstance();
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        aSubjectDN = this.mSelectedData.getValue(this.mDetailDataCertSubjectKey);
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            this.mEncryptedData = this.mOldPasswordTextView.getEncryptedData(this.mRandomValue);
            this.mNewEncryptedData = this.mNewPasswordTextView.getEncryptedData(this.mRandomValue);
            this.mConfirmEncryptedData = this.mNewPasswordConfirmTextView.getEncryptedData(this.mRandomValue);
        } else {
            this.mOldPassword = this.mOldPasswordTextView.getData().getBytes();
            this.mNewPassword = this.mNewPasswordTextView.getData().getBytes();
            this.mNewPasswordConfirm = this.mNewPasswordConfirmTextView.getData().getBytes();
        }
        this.mCoreUtil.resetError();
        aResult = EnvironmentConfig.mXecureKeypadEncryptionUsage ? this.checkInputPasswordWithEncryption() : this.checkInputPassword();
        switch (aResult) {
            case 10: {
                aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
                return;
            }
            case 11: {
                aTopView.setDescription(this.mCoreUtil.lastErrMsg());
                if (++this.m_P_assW_ordTryCount >= 3) {
                    this.setResult(2);
                    this.finish();
                }
                return;
            }
            case 12: {
                aTopView.setDescription(this.getString(R.string.incorrect_confirm_password));
                return;
            }
            case 13: {
                aTopView.setDescription(this.getString(R.string.password_renew_syntax_error));
                return;
            }
            case 1: {
                aTopView.setDescription(this.getString(R.string.password_length_error));
                return;
            }
            case 2: {
                aTopView.setDescription(this.getString(R.string.password_syntax_error));
                return;
            }
            case 3: {
                aTopView.setDescription(this.getString(R.string.newpassword_length_error));
                return;
            }
            case 4: {
                aTopView.setDescription(this.getString(R.string.newpassword_syntax_error));
                return;
            }
            case 5: {
                aTopView.setDescription(this.getString(R.string.newpassword_invalid_error));
                return;
            }
        }
        if (this.mCallMode != null && this.mCallMode.equals("call_mode_renew")) {
            aIntent = new Intent();
            if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                aIntent.putExtra(mRandomValueKey, this.mRandomValue);
                aIntent.putExtra(mE_ncryptedDataKey, this.mEncryptedData);
                aIntent.putExtra(mNewE_ncryptedDataKey, this.mNewEncryptedData);
            } else {
                aIntent.putExtra(mOldPasswordKey, this.mOldPassword);
                aIntent.putExtra(mNewPasswordKey, this.mNewPassword);
            }
            this.setResult(-1, aIntent);
            this.finish();
        } else {
            aIntent = new Intent((Context)this, XecureSmartCertMgrUser.class);
            aResult = EnvironmentConfig.mXecureKeypadEncryptionUsage ? aCertMgr.changePassword(this.mMediaID, aSubjectDN, this.mRandomValue, this.mEncryptedData, this.mNewEncryptedData) : aCertMgr.changePassword(this.mMediaID, aSubjectDN, this.mOldPassword, this.mNewPassword);
            if (aResult == 0) {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 1);
                aIntent.putExtra(mNewPasswordKey, this.mNewPassword);
                this.setResult(-1, aIntent);
                this.finish();
            } else {
                this.setResult(2, aIntent);
            }
        }
        this.finish();
    }

    public void finish() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mNewPasswordConfirm});
        super.finish();
    }

    public void onBackPressed() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mOldPassword, this.mNewPassword, this.mNewPasswordConfirm, this.mRandomValue});
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if ((requestCode != XKConstants.XKKeypadRequestCode || resultCode != 0) && requestCode == XKConstants.XKKeypadRequestCode && resultCode == 200000) {
            Toast.makeText((Context)this, (CharSequence)"\uc778\ub371\uc2a4 \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.", (int)0).show();
        }
    }
}

