/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.certshare.ExportCertWithCertShare;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecure.yessign.ConnectToYessignApp;
import com.softforum.xecure.yessign.ExportCertificateToYessign;

public class SignCertPasswordWindow
extends Activity {
    public static final int mSignCertPasswordWindowID = 70510;
    public static final String mMediaIDKey = "sign_cert_password_media_id_key";
    public static final String mSelectedCertDataKey = "sign_cert_password_selected_cert_data_key";
    public static final String m_P_assW_ordKey = "sign_cert_password_password_key";
    public static final String mOldP_assw_ordKey = "old_cert_password_password_key";
    public static final String mRandomValueKey = "sign_cert_password_random_value_key";
    public static final String mE_ncryptedDataKey = "sign_cert_password_e_ncrypted_data_key";
    public static final String mNewE_ncryptedDataKey = "sign_cert_password_new_e_ncrypted_data_key";
    public static final String mCallModeKey = "call_mode_key";
    public static final String mCallModeSign = "call_mode_sign";
    public static final String mCallModeExportCertificate = "call_mode_export_certificate";
    public static final String mCallModeExportCertificateEX = "call_mode_export_certificate_ex";
    public static final String mCallModeExportCertificateByCertShare = "call_mode_export_certificate_certshare";
    public static final int RESULT_PASSWD_FAIL = 2;
    public static final int RESULT_VERIFY_PASSWORD_OK = 3;
    public static final int RESULT_EXPORT_CERTIFICATE_OK = 4;
    private int mMediaID;
    private XDetailData mSelectedData;
    private String m_P_assW_ord = null;
    private int m_P_assW_ordTryCount;
    private String mCallMode = null;
    private XCoreUtil mCoreUtil = new XCoreUtil();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_sign_cert_password_window);
        this.m_P_assW_ordTryCount = 0;
        this.mMediaID = this.getIntent().getIntExtra(mMediaIDKey, -1);
        this.mCallMode = this.getIntent().getStringExtra(mCallModeKey);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), 3);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)XUtil.getCNFromRDN((String)this.mSelectedData.getValue(2)));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(3) + " : " + this.mSelectedData.getValue(3)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(4) + " : " + this.mSelectedData.getValue(4)));
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SignCertPasswordWindow.this.onOKButtonClick(v);
            }
        });
    }

    private void onOKButtonClick(View v) {
        EditText aPasswordEditText = (EditText)this.findViewById(R.id.password_edittext);
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        this.mCoreUtil.resetError();
        this.m_P_assW_ord = aPasswordEditText.getText().toString();
        if (this.m_P_assW_ord.length() == 0) {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        CertMgr aCertMgr = CertMgr.getInstance();
        int aErrorCode = 0;
        if (aCertMgr.verifyPassword(this.mMediaID, 14, this.mSelectedData.getValue(2), this.m_P_assW_ord) != 0 && (aErrorCode = this.mCoreUtil.lastErrCode()) != 22000015) {
            aTopView.setDescription(this.mCoreUtil.lastErrMsg());
            this.m_P_assW_ord = "";
            aPasswordEditText.setText((CharSequence)"");
            if (++this.m_P_assW_ordTryCount >= 3) {
                this.setResult(2);
                this.finish();
            }
            return;
        }
        if (this.mCallMode.equals(mCallModeExportCertificate)) {
            Intent aIntent = null;
            aIntent = new Intent((Context)this, ConnectToYessignApp.class);
            if (this.mCallMode.equals(mCallModeExportCertificate)) {
                aIntent.putExtra("ChoiceAction", 0);
            }
            if (this.mCallMode.equals(mCallModeExportCertificateEX)) {
                aIntent.putExtra("ChoiceAction", 2);
            }
            aIntent.putExtra("export_cert_media_id_key", this.mMediaID);
            aIntent.putExtra("export_cert_selected_cert_data_key", this.mSelectedData.getValueArray());
            this.startActivityForResult(aIntent, 72900);
        } else if (this.mCallMode.equals(mCallModeExportCertificateEX)) {
            ExportCertificateToYessign.setCertificate(this.mSelectedData, this.mMediaID);
            this.setResult(3);
            this.finish();
        } else if (this.mCallMode.equals(mCallModeExportCertificateByCertShare)) {
            Intent aIntent = null;
            aIntent = new Intent((Context)this, ExportCertWithCertShare.class);
            aIntent.putExtra("export_cert_media_id_key", this.mMediaID);
            aIntent.putExtra("export_cert_selected_cert_data_key", this.mSelectedData.getValueArray());
            aIntent.putExtra("export_cert_selected_cert_password_key", this.m_P_assW_ord.getBytes());
            aIntent.addFlags(0x2000000);
            this.startActivity(aIntent);
            this.finish();
            this.m_P_assW_ord = null;
        } else {
            Intent aIntent = new Intent();
            aIntent.putExtra(m_P_assW_ordKey, this.m_P_assW_ord.getBytes());
            this.setResult(-1, aIntent);
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Intent aIntent = this.getIntent();
        if (resultCode == 4) {
            this.setResult(-1, aIntent);
        } else if (resultCode == 6) {
            this.setResult(6);
        } else if (resultCode == 0) {
            this.setResult(0, aIntent);
        }
        this.finish();
    }
}

