/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;

public class XecureSmartCertExport
extends Activity {
    public static final int mXecureSmartCertExportID = 76000;
    public static final String mMediaIDKey = "xecure_smart_export_media_id_key";
    public static final String mSelectedCertDataKey = "xecure_smart_export_cert_data_key";
    private int mMediaID;
    private XDetailData mSelectedData;
    private XCoreUtil mCoreUtil = new XCoreUtil();
    private String mPKCS8Password;
    private String mPKCS12Password;
    private String mPKCS12Confirm_P_assW_ord;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_cert_export);
        this.mMediaID = this.getIntent().getIntExtra(mMediaIDKey, -1);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), 0);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)XUtil.getCNFromRDN((String)this.mSelectedData.getValue(7)));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(4) + " : " + XUtil.getCNFromRDN((String)this.mSelectedData.getValue(4))));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(6) + " : " + this.mSelectedData.getValue(6)));
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartCertExport.this.onOKButtonClick(v);
            }
        });
    }

    private void onOKButtonClick(View v) {
        CertMgr aCertMgr = CertMgr.getInstance();
        String aSubjectDN = this.mSelectedData.getValue(7);
        String aStorePath = "/sdcard/" + XUtil.getCNFromRDN((String)this.mSelectedData.getValue(7)) + ".pfx";
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        TextView aPKCS8PasswdTextView = (TextView)this.findViewById(R.id.password_edittext);
        this.mPKCS8Password = aPKCS8PasswdTextView.getText().toString();
        this.mCoreUtil.resetError();
        if (this.mPKCS8Password != null || this.mPKCS8Password.length() > 0) {
            if (aCertMgr.verifyPassword(this.mMediaID, 14, this.mSelectedData.getValue(7), this.mPKCS8Password) != 0) {
                aTopView.setDescription(this.mCoreUtil.lastErrMsg());
                aPKCS8PasswdTextView.setText((CharSequence)"");
                this.mPKCS8Password = "";
            }
        } else {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        TextView aPKCS12PasswdTextView = (TextView)this.findViewById(R.id.new_password_edittext);
        TextView aPKCS12ConfirmPasswdTextView = (TextView)this.findViewById(R.id.new_password_confirm_edittext);
        this.mPKCS12Password = aPKCS12PasswdTextView.getText().toString();
        this.mPKCS12Confirm_P_assW_ord = aPKCS12ConfirmPasswdTextView.getText().toString();
        if (this.mPKCS12Password.length() == 0) {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        if (!this.mPKCS12Password.equals(this.mPKCS12Confirm_P_assW_ord)) {
            aTopView.setDescription(this.getString(R.string.incorrect_confirm_password));
            return;
        }
        int error = aCertMgr.exportCert(this.mMediaID, aSubjectDN, this.mPKCS8Password, this.mPKCS12Password, aStorePath);
        if (error == 0) {
            this.setResult(-1);
            this.finish();
        } else {
            this.setResult(2);
        }
        this.finish();
    }
}

