/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.core.CoreWrapper;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XSLog;

public class XecureSmartMoveCertificateToAppData
extends Activity {
    public static final int mXecureSmartMoveCertofocateToAppDataID = 120000;
    public static final String mMediaIDKey = "sign_cert_password_media_id_key";
    public static final String mSelectedCertDataKey = "sign_cert_password_selected_cert_data_key";
    public static final String m_P_assW_ordKey = "sign_cert_password_password_key";
    public static final String mOldPasswordKey = "old_cert_password_password_key";
    public static final int RESULT_PASSWD_FAIL = 2;
    private int mSrcMediaID;
    private int mDstMediaID;
    private XDetailData mSelectedData;
    private String m_P_assW_ord = null;
    private int m_P_assW_ordTryCount;
    private int mDetailDataType = 0;
    private int mDetailDataCertSubjectKey = 7;
    private int mDetailDataCertIssuerKey = 4;
    private int mDetailDataCertToKey = 6;
    private XCoreUtil mCoreUtil = new XCoreUtil();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_sign_cert_password_window);
        this.m_P_assW_ordTryCount = 0;
        this.mSrcMediaID = this.getIntent().getIntExtra("mSrcMediaID", 1);
        this.mDstMediaID = this.getIntent().getIntExtra("mDstMediaID", 1);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), this.mDetailDataType);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)this.mSelectedData.getValue(this.mDetailDataCertSubjectKey));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertIssuerKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertIssuerKey)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertToKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertToKey)));
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartMoveCertificateToAppData.this.onOKButtonClick(v);
            }
        });
    }

    private void onOKButtonClick(View v) {
        EditText aPasswordEditText = (EditText)this.findViewById(R.id.password_edittext);
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        this.mCoreUtil.resetError();
        this.m_P_assW_ord = aPasswordEditText.getText().toString();
        if (this.m_P_assW_ord.length() == 0) {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        CertMgr aCertMgr = CertMgr.getInstance();
        if (aCertMgr.verifyPassword(this.mSrcMediaID, 14, this.mSelectedData.getValue(this.mDetailDataCertSubjectKey), this.m_P_assW_ord) != 0) {
            aTopView.setDescription(this.mCoreUtil.lastErrMsg());
            this.m_P_assW_ord = "";
            aPasswordEditText.setText((CharSequence)"");
            if (++this.m_P_assW_ordTryCount >= 3) {
                this.setResult(2);
                this.finish();
            }
        } else {
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)"\uc8fc\uc758").setMessage((CharSequence)"APPDATA\ub85c \uc778\uc99d\uc11c\ub97c \uc774\ub3d9\uc2dc \uae30\uc874SDCARD\uc758 \uc778\uc99d\uc11c\ub294 \uc0ad\uc81c\ub429\ub2c8\ub2e4. \uacc4\uc18d\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?").setPositiveButton((CharSequence)"YES", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    XTopView aTopView = (XTopView)XecureSmartMoveCertificateToAppData.this.findViewById(R.id.top_view);
                    Intent aIntent = new Intent();
                    int aResult = CoreWrapper.saveCert((String)XecureSmartMoveCertificateToAppData.this.mSelectedData.getValue(XecureSmartMoveCertificateToAppData.this.mDetailDataCertSubjectKey), (byte[])XecureSmartMoveCertificateToAppData.this.m_P_assW_ord.getBytes(), (int)XecureSmartMoveCertificateToAppData.this.mSrcMediaID, (int)3, (int)14, (int)XecureSmartMoveCertificateToAppData.this.mDstMediaID);
                    XSLog.d((String)(this.getClass().getName() + "::Save to APPDATA Cert result : " + aResult));
                    if (aResult != 0) {
                        aTopView.setDescription("APPDATA\ub85c \uc778\uc99d\uc11c \uc774\ub3d9\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                        XecureSmartMoveCertificateToAppData.this.setResult(2, aIntent);
                    } else {
                        aResult = CertMgr.getInstance().deleteCertificateWithSubjectDN(XecureSmartMoveCertificateToAppData.this.mSrcMediaID, 3, XecureSmartMoveCertificateToAppData.this.mSelectedData.getValue(XecureSmartMoveCertificateToAppData.this.mDetailDataCertSubjectKey));
                        XSLog.d((String)(this.getClass().getName() + "::DeleteCert result : " + aResult));
                        if (aResult != 0) {
                            aTopView.setDescription("\uc778\uc99d\uc11c \uc0ad\uc81c\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                            XecureSmartMoveCertificateToAppData.this.setResult(2, aIntent);
                        } else {
                            aIntent.putExtra("xecure_smart_cert_mgr_result_key", 3);
                            XecureSmartMoveCertificateToAppData.this.setResult(-1, aIntent);
                            XecureSmartMoveCertificateToAppData.this.finish();
                        }
                    }
                }
            }).setNegativeButton((CharSequence)"NO", null).show();
        }
    }
}

