/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor a;

    public CollectionTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.a = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        if (!Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type elementType = $Gson$Types.getCollectionElementType(type, rawType);
        TypeAdapter<?> elementTypeAdapter = gson.getAdapter(TypeToken.get(elementType));
        ObjectConstructor<T> constructor = this.a.getConstructor(typeToken);
        a result = new a(gson, elementType, elementTypeAdapter, constructor);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class a<E>
    extends TypeAdapter<Collection<E>> {
        private final TypeAdapter<E> b;
        private final ObjectConstructor<? extends Collection<E>> c;

        public a(Gson context, Type elementType, TypeAdapter<E> elementTypeAdapter, ObjectConstructor<? extends Collection<E>> constructor) {
            this.b = new com.google.gson.internal.bind.a<E>(context, elementTypeAdapter, elementType);
            this.c = constructor;
        }

        public Collection<E> a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Collection<E> collection = this.c.construct();
            in.beginArray();
            while (in.hasNext()) {
                E instance = this.b.read(in);
                collection.add(instance);
            }
            in.endArray();
            return collection;
        }

        public void a(JsonWriter out, Collection<E> collection) throws IOException {
            if (collection == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (E element : collection) {
                this.b.write(out, element);
            }
            out.endArray();
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Collection)x1);
        }
    }
}

