/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeAdapters {
    public static final TypeAdapter<Class> CLASS = new TypeAdapter<Class>(){

        public void a(JsonWriter out, Class value) throws IOException {
            throw new UnsupportedOperationException("Attempted to serialize java.lang.Class: " + value.getName() + ". Forgot to register a type adapter?");
        }

        public Class a(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("Attempted to deserialize a java.lang.Class. Forgot to register a type adapter?");
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Class)x1);
        }
    };
    public static final TypeAdapterFactory CLASS_FACTORY = TypeAdapters.newFactory(Class.class, CLASS);
    public static final TypeAdapter<BitSet> BIT_SET = new TypeAdapter<BitSet>(){

        public BitSet a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            BitSet bitset = new BitSet();
            in.beginArray();
            int i = 0;
            JsonToken tokenType = in.peek();
            while (tokenType != JsonToken.END_ARRAY) {
                boolean set;
                switch (tokenType) {
                    case NUMBER: {
                        set = in.nextInt() != 0;
                        break;
                    }
                    case BOOLEAN: {
                        set = in.nextBoolean();
                        break;
                    }
                    case STRING: {
                        String stringValue = in.nextString();
                        try {
                            set = Integer.parseInt(stringValue) != 0;
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new JsonSyntaxException("Error: Expecting: bitset number value (1, 0), Found: " + stringValue);
                        }
                    }
                    default: {
                        throw new JsonSyntaxException("Invalid bitset value type: " + (Object)((Object)tokenType));
                    }
                }
                if (set) {
                    bitset.set(i);
                }
                ++i;
                tokenType = in.peek();
            }
            in.endArray();
            return bitset;
        }

        public void a(JsonWriter out, BitSet src) throws IOException {
            if (src == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (int i = 0; i < src.length(); ++i) {
                int value = src.get(i) ? 1 : 0;
                out.value(value);
            }
            out.endArray();
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (BitSet)x1);
        }
    };
    public static final TypeAdapterFactory BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, BIT_SET);
    public static final TypeAdapter<Boolean> BOOLEAN = new TypeAdapter<Boolean>(){

        public Boolean a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (in.peek() == JsonToken.STRING) {
                return Boolean.parseBoolean(in.nextString());
            }
            return in.nextBoolean();
        }

        public void a(JsonWriter out, Boolean value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.value(value);
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Boolean)x1);
        }
    };
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){

        public Boolean a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return Boolean.valueOf(in.nextString());
        }

        public void a(JsonWriter out, Boolean value) throws IOException {
            out.value(value == null ? "null" : value.toString());
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Boolean)x1);
        }
    };
    public static final TypeAdapterFactory BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, BOOLEAN);
    public static final TypeAdapter<Number> BYTE = new TypeAdapter<Number>(){

        public Number a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                int intValue = in.nextInt();
                return (byte)intValue;
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException(e);
            }
        }

        public void a(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Number)x1);
        }
    };
    public static final TypeAdapterFactory BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, BYTE);
    public static final TypeAdapter<Number> SHORT = new TypeAdapter<Number>(){

        public Number a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return (short)in.nextInt();
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException(e);
            }
        }

        public void a(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Number)x1);
        }
    };
    public static final TypeAdapterFactory SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, SHORT);
    public static final TypeAdapter<Number> INTEGER = new TypeAdapter<Number>(){

        public Number a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return in.nextInt();
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException(e);
            }
        }

        public void a(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Number)x1);
        }
    };
    public static final TypeAdapterFactory INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, INTEGER);
    public static final TypeAdapter<Number> LONG = new TypeAdapter<Number>(){

        public Number a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return in.nextLong();
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException(e);
            }
        }

        public void a(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Number)x1);
        }
    };
    public static final TypeAdapter<Number> FLOAT = new TypeAdapter<Number>(){

        public Number a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return Float.valueOf((float)in.nextDouble());
        }

        public void a(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Number)x1);
        }
    };
    public static final TypeAdapter<Number> DOUBLE = new TypeAdapter<Number>(){

        public Number a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return in.nextDouble();
        }

        public void a(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Number)x1);
        }
    };
    public static final TypeAdapter<Number> NUMBER = new TypeAdapter<Number>(){

        public Number a(JsonReader in) throws IOException {
            JsonToken jsonToken = in.peek();
            switch (jsonToken) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
                case NUMBER: {
                    return new LazilyParsedNumber(in.nextString());
                }
            }
            throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken));
        }

        public void a(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Number)x1);
        }
    };
    public static final TypeAdapterFactory NUMBER_FACTORY = TypeAdapters.newFactory(Number.class, NUMBER);
    public static final TypeAdapter<Character> CHARACTER = new TypeAdapter<Character>(){

        public Character a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String str = in.nextString();
            if (str.length() != 1) {
                throw new JsonSyntaxException("Expecting character, got: " + str);
            }
            return Character.valueOf(str.charAt(0));
        }

        public void a(JsonWriter out, Character value) throws IOException {
            out.value(value == null ? null : String.valueOf(value));
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Character)x1);
        }
    };
    public static final TypeAdapterFactory CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, CHARACTER);
    public static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        public String a(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (peek == JsonToken.BOOLEAN) {
                return Boolean.toString(in.nextBoolean());
            }
            return in.nextString();
        }

        public void a(JsonWriter out, String value) throws IOException {
            out.value(value);
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (String)x1);
        }
    };
    public static final TypeAdapterFactory STRING_FACTORY = TypeAdapters.newFactory(String.class, STRING);
    public static final TypeAdapter<StringBuilder> STRING_BUILDER = new TypeAdapter<StringBuilder>(){

        public StringBuilder a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return new StringBuilder(in.nextString());
        }

        public void a(JsonWriter out, StringBuilder value) throws IOException {
            out.value(value == null ? null : value.toString());
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (StringBuilder)x1);
        }
    };
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, STRING_BUILDER);
    public static final TypeAdapter<StringBuffer> STRING_BUFFER = new TypeAdapter<StringBuffer>(){

        public StringBuffer a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return new StringBuffer(in.nextString());
        }

        public void a(JsonWriter out, StringBuffer value) throws IOException {
            out.value(value == null ? null : value.toString());
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (StringBuffer)x1);
        }
    };
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, STRING_BUFFER);
    public static final TypeAdapter<URL> URL = new TypeAdapter<URL>(){

        public URL a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String nextString = in.nextString();
            return "null".equals(nextString) ? null : new URL(nextString);
        }

        public void a(JsonWriter out, URL value) throws IOException {
            out.value(value == null ? null : value.toExternalForm());
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (URL)x1);
        }
    };
    public static final TypeAdapterFactory URL_FACTORY = TypeAdapters.newFactory(URL.class, URL);
    public static final TypeAdapter<URI> URI = new TypeAdapter<URI>(){

        public URI a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                String nextString = in.nextString();
                return "null".equals(nextString) ? null : new URI(nextString);
            }
            catch (URISyntaxException e) {
                throw new JsonIOException(e);
            }
        }

        public void a(JsonWriter out, URI value) throws IOException {
            out.value(value == null ? null : value.toASCIIString());
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (URI)x1);
        }
    };
    public static final TypeAdapterFactory URI_FACTORY = TypeAdapters.newFactory(URI.class, URI);
    public static final TypeAdapter<InetAddress> INET_ADDRESS = new TypeAdapter<InetAddress>(){

        public InetAddress a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return InetAddress.getByName(in.nextString());
        }

        public void a(JsonWriter out, InetAddress value) throws IOException {
            out.value(value == null ? null : value.getHostAddress());
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (InetAddress)x1);
        }
    };
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, INET_ADDRESS);
    public static final TypeAdapter<UUID> UUID = new TypeAdapter<UUID>(){

        public UUID a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return java.util.UUID.fromString(in.nextString());
        }

        public void a(JsonWriter out, UUID value) throws IOException {
            out.value(value == null ? null : value.toString());
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (UUID)x1);
        }
    };
    public static final TypeAdapterFactory UUID_FACTORY = TypeAdapters.newFactory(UUID.class, UUID);
    public static final TypeAdapterFactory TIMESTAMP_FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (typeToken.getRawType() != Timestamp.class) {
                return null;
            }
            final TypeAdapter<Date> dateTypeAdapter = gson.getAdapter(Date.class);
            return new TypeAdapter<Timestamp>(){

                public Timestamp a(JsonReader in) throws IOException {
                    Date date = (Date)dateTypeAdapter.read(in);
                    return date != null ? new Timestamp(date.getTime()) : null;
                }

                public void a(JsonWriter out, Timestamp value) throws IOException {
                    dateTypeAdapter.write(out, value);
                }

                @Override
                public /* synthetic */ Object read(JsonReader x0) throws IOException {
                    return this.a(x0);
                }

                @Override
                public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
                    this.a(x0, (Timestamp)x1);
                }
            };
        }
    };
    public static final TypeAdapter<Calendar> CALENDAR = new TypeAdapter<Calendar>(){
        private static final String a = "year";
        private static final String b = "month";
        private static final String c = "dayOfMonth";
        private static final String d = "hourOfDay";
        private static final String e = "minute";
        private static final String f = "second";

        public Calendar a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            int year = 0;
            int month = 0;
            int dayOfMonth = 0;
            int hourOfDay = 0;
            int minute = 0;
            int second = 0;
            while (in.peek() != JsonToken.END_OBJECT) {
                String name = in.nextName();
                int value = in.nextInt();
                if (a.equals(name)) {
                    year = value;
                    continue;
                }
                if (b.equals(name)) {
                    month = value;
                    continue;
                }
                if (c.equals(name)) {
                    dayOfMonth = value;
                    continue;
                }
                if (d.equals(name)) {
                    hourOfDay = value;
                    continue;
                }
                if (e.equals(name)) {
                    minute = value;
                    continue;
                }
                if (!f.equals(name)) continue;
                second = value;
            }
            in.endObject();
            return new GregorianCalendar(year, month, dayOfMonth, hourOfDay, minute, second);
        }

        public void a(JsonWriter out, Calendar value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name(a);
            out.value(value.get(1));
            out.name(b);
            out.value(value.get(2));
            out.name(c);
            out.value(value.get(5));
            out.name(d);
            out.value(value.get(11));
            out.name(e);
            out.value(value.get(12));
            out.name(f);
            out.value(value.get(13));
            out.endObject();
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Calendar)x1);
        }
    };
    public static final TypeAdapterFactory CALENDAR_FACTORY = TypeAdapters.newFactoryForMultipleTypes(Calendar.class, GregorianCalendar.class, CALENDAR);
    public static final TypeAdapter<Locale> LOCALE = new TypeAdapter<Locale>(){

        public Locale a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String locale = in.nextString();
            StringTokenizer tokenizer = new StringTokenizer(locale, "_");
            String language = null;
            String country = null;
            String variant = null;
            if (tokenizer.hasMoreElements()) {
                language = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                country = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                variant = tokenizer.nextToken();
            }
            if (country == null && variant == null) {
                return new Locale(language);
            }
            if (variant == null) {
                return new Locale(language, country);
            }
            return new Locale(language, country, variant);
        }

        public void a(JsonWriter out, Locale value) throws IOException {
            out.value(value == null ? null : value.toString());
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Locale)x1);
        }
    };
    public static final TypeAdapterFactory LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, LOCALE);
    public static final TypeAdapter<JsonElement> JSON_ELEMENT = new TypeAdapter<JsonElement>(){

        public JsonElement a(JsonReader in) throws IOException {
            switch (in.peek()) {
                case STRING: {
                    return new JsonPrimitive(in.nextString());
                }
                case NUMBER: {
                    String number = in.nextString();
                    return new JsonPrimitive(new LazilyParsedNumber(number));
                }
                case BOOLEAN: {
                    return new JsonPrimitive(in.nextBoolean());
                }
                case NULL: {
                    in.nextNull();
                    return JsonNull.INSTANCE;
                }
                case BEGIN_ARRAY: {
                    JsonArray array = new JsonArray();
                    in.beginArray();
                    while (in.hasNext()) {
                        array.add(this.a(in));
                    }
                    in.endArray();
                    return array;
                }
                case BEGIN_OBJECT: {
                    JsonObject object = new JsonObject();
                    in.beginObject();
                    while (in.hasNext()) {
                        object.add(in.nextName(), this.a(in));
                    }
                    in.endObject();
                    return object;
                }
            }
            throw new IllegalArgumentException();
        }

        public void a(JsonWriter out, JsonElement value) throws IOException {
            if (value == null || value.isJsonNull()) {
                out.nullValue();
            } else if (value.isJsonPrimitive()) {
                JsonPrimitive primitive = value.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    out.value(primitive.getAsNumber());
                } else if (primitive.isBoolean()) {
                    out.value(primitive.getAsBoolean());
                } else {
                    out.value(primitive.getAsString());
                }
            } else if (value.isJsonArray()) {
                out.beginArray();
                for (JsonElement e : value.getAsJsonArray()) {
                    this.a(out, e);
                }
                out.endArray();
            } else if (value.isJsonObject()) {
                out.beginObject();
                for (Map.Entry<String, JsonElement> e : value.getAsJsonObject().entrySet()) {
                    out.name(e.getKey());
                    this.a(out, e.getValue());
                }
                out.endObject();
            } else {
                throw new IllegalArgumentException("Couldn't write " + value.getClass());
            }
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (JsonElement)x1);
        }
    };
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY = TypeAdapters.newFactory(JsonElement.class, JSON_ELEMENT);
    public static final TypeAdapterFactory ENUM_FACTORY = TypeAdapters.newEnumTypeHierarchyFactory();

    private TypeAdapters() {
    }

    public static <TT> TypeAdapterFactory newEnumTypeHierarchyFactory() {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                Class<T> rawType = typeToken.getRawType();
                if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                    return null;
                }
                if (!rawType.isEnum()) {
                    rawType = rawType.getSuperclass();
                }
                return new a<T>(rawType);
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final TypeToken<TT> type, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                return typeToken.equals(type) ? typeAdapter : null;
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> type, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                return typeToken.getRawType() == type ? typeAdapter : null;
            }

            public String toString() {
                return "Factory[type=" + type.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> unboxed, final Class<TT> boxed, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                Class<T> rawType = typeToken.getRawType();
                return rawType == unboxed || rawType == boxed ? typeAdapter : null;
            }

            public String toString() {
                return "Factory[type=" + boxed.getName() + "+" + unboxed.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactoryForMultipleTypes(final Class<TT> base, final Class<? extends TT> sub, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                Class<T> rawType = typeToken.getRawType();
                return rawType == base || rawType == sub ? typeAdapter : null;
            }

            public String toString() {
                return "Factory[type=" + base.getName() + "+" + sub.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    public static <TT> TypeAdapterFactory newTypeHierarchyFactory(final Class<TT> clazz, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                return clazz.isAssignableFrom(typeToken.getRawType()) ? typeAdapter : null;
            }

            public String toString() {
                return "Factory[typeHierarchy=" + clazz.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class a<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<String, T> a = new HashMap<String, T>();
        private final Map<T, String> b = new HashMap<T, String>();

        public a(Class<T> classOfT) {
            try {
                for (Enum constant : (Enum[])classOfT.getEnumConstants()) {
                    String name = constant.name();
                    SerializedName annotation = classOfT.getField(name).getAnnotation(SerializedName.class);
                    if (annotation != null) {
                        name = annotation.value();
                    }
                    this.a.put(name, constant);
                    this.b.put(constant, name);
                }
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError();
            }
        }

        public T a(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return (T)((Enum)this.a.get(in.nextString()));
        }

        public void a(JsonWriter out, T value) throws IOException {
            out.value(value == null ? null : this.b.get(value));
        }

        @Override
        public /* synthetic */ Object read(JsonReader x0) throws IOException {
            return this.a(x0);
        }

        @Override
        public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
            this.a(x0, (Enum)x1);
        }
    }
}

