/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.tools.dao.mtouch;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kr.co.skplanet.utils.BinaryUtil;
import kr.co.skplanet.utils.LOG;
import kr.co.skplanet.utils.Util;

public class MobileTouchTicket
implements Parcelable {
    protected byte m_byPartnerID;
    protected byte m_byAffiliateID;
    protected byte[] m_baFranchiseID = new byte[10];
    protected String m_strTicketNumber;
    protected String m_strTicketName;
    protected String m_strPlace;
    protected Date m_oTicketDate;
    protected byte m_byTicketValue;
    protected byte[] m_baSeatNumber = new byte[8];
    protected String m_strTicketID;
    protected byte[] m_baAuthCode = new byte[8];
    protected byte m_byStatus;
    public static final Parcelable.Creator<MobileTouchTicket> CREATOR = new Parcelable.Creator<MobileTouchTicket>(){

        public MobileTouchTicket a(Parcel in) {
            return new MobileTouchTicket(in);
        }

        public MobileTouchTicket[] a(int size) {
            return new MobileTouchTicket[size];
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.a(n);
        }
    };

    public MobileTouchTicket() {
    }

    public MobileTouchTicket(Parcel in) {
        this.a(in);
    }

    public static MobileTouchTicket getParsingTicketObject(byte[] baTicketData) {
        LOG.info(">> getParsingTicketObject()");
        LOG.info("++ baMembershipData : [%s]", Util.byteArrayToHexString(baTicketData));
        MobileTouchTicket ticket = new MobileTouchTicket();
        int nParsingIndex = 0;
        try {
            if (baTicketData == null || baTicketData.length == 0 || baTicketData[0] == -1) {
                throw new Exception("##### invaild baTicketData #####");
            }
            ticket.setPartnerID(baTicketData[nParsingIndex]);
            LOG.info("PartnerID : " + ticket.getPartnerID());
            ticket.setAffiliateID(baTicketData[++nParsingIndex]);
            LOG.info("AffiliateID : " + ticket.getAffiliateID());
            byte[] franchiseID = new byte[10];
            System.arraycopy(baTicketData, ++nParsingIndex, franchiseID, 0, 10);
            ticket.setFranchiseID(franchiseID);
            Util.DumpPacket("franchiseID", ticket.getFranchiseID(), ticket.getFranchiseID().length);
            byte[] ticketNumber = new byte[6];
            System.arraycopy(baTicketData, nParsingIndex += 10, ticketNumber, 0, 6);
            if (Util.STRLEN(ticketNumber) == 0) {
                ticket.setTicketNumber("000000");
            } else {
                int len = Util.TrimRight(ticketNumber, 0, '\u0000', 6);
                ticket.setTicketNumber(new String(ticketNumber, 0, len));
            }
            Util.DumpPacket("ticketNumber", ticketNumber, 6);
            LOG.info("Ticket Number : " + ticket.getTicketNumber());
            byte[] ticketTitle = new byte[40];
            System.arraycopy(baTicketData, nParsingIndex += 6, ticketTitle, 0, 40);
            if (Util.STRLEN(ticketTitle) == 0) {
                ticket.setTicketName("Mobile Touch Ticket");
            } else {
                try {
                    int len = Util.TrimRight(ticketTitle, 0, '\u0000', 40);
                    ticket.setTicketName(new String(ticketTitle, 0, len, "KSC5601"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            Util.DumpPacket("ticketTitle", ticketTitle, 40);
            LOG.info("Ticket Title : " + ticket.getTicketName());
            byte[] ticketPlace = new byte[4];
            System.arraycopy(baTicketData, nParsingIndex += 40, ticketPlace, 0, 4);
            if (Util.STRLEN(ticketPlace) == 0) {
                ticket.setPlace("Ticket Place");
            } else {
                try {
                    int len = Util.TrimRight(ticketPlace, 0, '\u0000', 4);
                    ticket.setPlace(new String(ticketPlace, 0, len, "KSC5601"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            nParsingIndex += 4;
            Util.DumpPacket("ticketPlace", ticketPlace, 4);
            LOG.info("Ticket Place : " + ticket.getPlace());
            byte[] ticketDateBCD = new byte[5];
            byte[] ticketDateData = new byte[10];
            SimpleDateFormat format = new SimpleDateFormat("yyMMDDhhmm");
            System.arraycopy(baTicketData, nParsingIndex, ticketDateBCD, 0, 5);
            Util.UnPackData(ticketDateData, 0, ticketDateBCD, 0, 5);
            String ticketDateStr = new String(ticketDateData);
            try {
                ticket.setTicketDate(format.parse(ticketDateStr));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Util.DumpPacket("expireDate(BCD)", ticketDateBCD, 5);
            Util.DumpPacket("startDateData(Unpack)", ticketDateData, 5);
            LOG.info("startDate : " + ticket.getTicketDate().toLocaleString());
            ticket.setTicketValue(baTicketData[nParsingIndex += 5]);
            LOG.info("ticket Value : " + ticket.getTicketValue());
            byte[] seatNumber = new byte[8];
            System.arraycopy(baTicketData, ++nParsingIndex, seatNumber, 0, 8);
            ticket.setSeatNumber(seatNumber);
            Util.DumpPacket("seat Number", ticket.getSeatNumber(), ticket.getSeatNumber().length);
            byte[] ticketBCD = new byte[8];
            byte[] ticketID = new byte[16];
            System.arraycopy(baTicketData, nParsingIndex += 8, ticketBCD, 0, 8);
            Util.UnPackData(ticketID, 0, ticketBCD, 0, 8);
            ticket.setTicketID(new String(ticketID));
            Util.DumpPacket("ticketID(BCD)", ticketBCD, 8);
            Util.DumpPacket("ticketID(Unpack)", ticketID, 8);
            LOG.info("ticketID : " + ticket.getTicketID());
            byte[] authNumber = new byte[8];
            System.arraycopy(baTicketData, nParsingIndex += 8, authNumber, 0, 8);
            ticket.setAuthCode(authNumber);
            Util.DumpPacket("auth Number", ticket.getAuthCode(), ticket.getAuthCode().length);
            ticket.setStatus(baTicketData[nParsingIndex += 8]);
            ++nParsingIndex;
            LOG.info("ticket Status : " + ticket.getStatus());
            ++nParsingIndex;
        }
        catch (Exception e) {
            LOG.error(e);
            ticket = null;
        }
        return ticket;
    }

    public void dumpToLogcat() {
        LOG.info("===========================================");
        LOG.info(" MobileTouchTicket (" + this.m_strTicketID + ")");
        LOG.info("===========================================");
        LOG.info(" m_byPartnerID(HEX) : 0x" + Util.getHexChar(this.m_byPartnerID));
        LOG.info(" m_byAffiliateID(HEX) : 0x" + Util.getHexChar(this.m_byAffiliateID));
        LOG.info(" m_baFranchiseID(HEX) : " + Util.getHexString(this.m_baFranchiseID));
        LOG.info(" m_strTicketNumber : " + this.m_strTicketNumber);
        LOG.info(" m_strTicketName : " + this.m_strTicketName);
        LOG.info(" m_strPlace : " + this.m_strPlace);
        LOG.info(" m_oTicketDate : " + this.m_oTicketDate.toLocaleString());
        LOG.info(" m_byTicketValue : 0x" + BinaryUtil.toHexString(this.m_byTicketValue));
        LOG.info(" m_baSeatNumber : " + BinaryUtil.toHexString(this.m_baSeatNumber));
        LOG.info(" m_strTicketID : " + this.m_strTicketID);
        LOG.info(" m_baAuthCode : " + BinaryUtil.toHexString(this.m_baAuthCode));
        LOG.info(" m_byStatus : 0x" + BinaryUtil.toHexString(this.m_byStatus));
        LOG.info("===========================================");
    }

    public int describeContents() {
        LOG.info(">> describeContents()");
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.m_byPartnerID);
        dest.writeByte(this.m_byAffiliateID);
        dest.writeByteArray(this.m_baFranchiseID);
        dest.writeString(this.m_strTicketNumber);
        dest.writeString(this.m_strTicketName);
        dest.writeString(this.m_strPlace);
        dest.writeLong(this.m_oTicketDate.getTime());
        dest.writeByte(this.m_byTicketValue);
        dest.writeByteArray(this.m_baSeatNumber);
        dest.writeString(this.m_strTicketID);
        dest.writeByteArray(this.m_baAuthCode);
        dest.writeByte(this.m_byStatus);
    }

    private void a(Parcel in) {
        this.m_byPartnerID = in.readByte();
        this.m_byAffiliateID = in.readByte();
        in.readByteArray(this.m_baFranchiseID);
        this.m_strTicketNumber = in.readString();
        this.m_strTicketName = in.readString();
        this.m_strPlace = in.readString();
        this.m_oTicketDate = new Date(in.readLong());
        this.m_byTicketValue = in.readByte();
        in.readByteArray(this.m_baSeatNumber);
        this.m_strTicketID = in.readString();
        in.readByteArray(this.m_baAuthCode);
        this.m_byStatus = in.readByte();
    }

    public byte getPartnerID() {
        return this.m_byPartnerID;
    }

    public void setPartnerID(byte mtPartnerID) {
        this.m_byPartnerID = mtPartnerID;
    }

    public byte getAffiliateID() {
        return this.m_byAffiliateID;
    }

    public void setAffiliateID(byte mtAffiliateID) {
        this.m_byAffiliateID = mtAffiliateID;
    }

    public byte[] getFranchiseID() {
        return this.m_baFranchiseID;
    }

    public void setFranchiseID(byte[] mtFranchiseID) {
        System.arraycopy(mtFranchiseID, 0, this.m_baFranchiseID, 0, 10);
    }

    public String getTicketNumber() {
        return this.m_strTicketNumber;
    }

    public void setTicketNumber(String mtTicketNumber) {
        this.m_strTicketNumber = mtTicketNumber;
    }

    public String getTicketName() {
        return this.m_strTicketName;
    }

    public void setTicketName(String mtTicketName) {
        this.m_strTicketName = mtTicketName;
    }

    public String getPlace() {
        return this.m_strPlace;
    }

    public void setPlace(String mtPlace) {
        this.m_strPlace = mtPlace;
    }

    public Date getTicketDate() {
        return this.m_oTicketDate;
    }

    public void setTicketDate(Date mtTicketDate) {
        this.m_oTicketDate = mtTicketDate;
    }

    public byte getTicketValue() {
        return this.m_byTicketValue;
    }

    public void setTicketValue(byte mtTicketValue) {
        this.m_byTicketValue = mtTicketValue;
    }

    public byte[] getSeatNumber() {
        return this.m_baSeatNumber;
    }

    public void setSeatNumber(byte[] mtSeatNumber) {
        System.arraycopy(mtSeatNumber, 0, this.m_baSeatNumber, 0, 8);
    }

    public String getTicketID() {
        return this.m_strTicketID;
    }

    public void setTicketID(String mtTicketID) {
        this.m_strTicketID = mtTicketID;
    }

    public byte[] getAuthCode() {
        return this.m_baAuthCode;
    }

    public void setAuthCode(byte[] mtAuthCode) {
        System.arraycopy(mtAuthCode, 0, this.m_baAuthCode, 0, 8);
    }

    public byte getStatus() {
        return this.m_byStatus;
    }

    public void setStatus(byte mtStatus) {
        this.m_byStatus = mtStatus;
    }
}

