/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.tools.network.ota;

import android.content.Context;
import com.google.gson.Gson;
import com.skp.smarttouch.sem.tools.common.APITypeCode;
import com.skp.smarttouch.sem.tools.common.OpCodeEnum;
import com.skp.smarttouch.sem.tools.common.STIllegarSmartCardException;
import com.skp.smarttouch.sem.tools.common.STOtaProcException;
import com.skp.smarttouch.sem.tools.dao.ConfigDFParamData;
import com.skp.smarttouch.sem.tools.dao.CouponIssueData;
import com.skp.smarttouch.sem.tools.dao.MembershipIssueData;
import com.skp.smarttouch.sem.tools.dao.TicketIssueData;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.BodyOfOta;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.DispData;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.HeaderOfOta;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.IOTAProtocol;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.IssueData;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.OTAWorkerData;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.OtaBody;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.OtaHeader;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.ParamData;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.Rpdu;
import com.skp.smarttouch.sem.tools.network.AbstractWorker;
import com.skp.smarttouch.sem.tools.network.Network;
import com.skp.smarttouch.sem.tools.network.ota.RequestBuilder;
import com.skp.smarttouch.sem.tools.smartcard.AbstractSmartcard;
import java.util.ArrayList;
import java.util.List;
import kr.co.skplanet.utils.BinaryUtil;
import kr.co.skplanet.utils.LOG;

public class OTAManager {
    private final String a = "000";
    private final String b = "000";
    private final String c = "999";
    private final String d = "1";
    private final String e = "2";
    private final String f = "3";
    private final String g = "1";
    private final String h = "2";
    private static OTAManager i = null;
    private static Context j = null;
    private AbstractWorker.OnWorkerListener k = null;
    private APITypeCode l = null;
    private String m = "N";

    private OTAManager() {
        LOG.info(">> OTAManager()");
    }

    public static OTAManager getInstance(Context context) {
        LOG.info(">> getInstance()");
        LOG.info("++ context : [%s]", context);
        j = context;
        if (i == null) {
            i = new OTAManager();
        }
        return i;
    }

    public void release() {
        LOG.info(">> release()");
        i = null;
    }

    public void setStagingYn(String yn) {
        LOG.info(">> setStagingYn()");
        LOG.info("++ yn : [%s]", yn);
        this.m = yn;
    }

    public String getStagingYn() {
        return this.m;
    }

    public void setOnWorkerListener(APITypeCode api, AbstractWorker.OnWorkerListener listener) {
        this.l = api;
        this.k = listener;
    }

    public boolean requestIssueApplet(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String tid, String aid, String version) {
        LOG.info(">> requestIssueApplet()");
        LOG.info("++ smartCard : [%s]", smartCard);
        LOG.info("++ nopId : [%s]", nopId);
        LOG.info("++ compId : [%s]", compId);
        LOG.info("++ tid : [%s]", tid);
        LOG.info("++ aid : [%s]", aid);
        LOG.info("++ version : [%s]", version);
        boolean bRet = true;
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.INSTALL);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid(tid);
        workerData.setIccid(iccid);
        bRet = this.a(smartCard, workerData);
        return bRet;
    }

    public boolean requestDeleteApplet(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String tid, String aid, String version) {
        LOG.info(">> requestDeleteApplet()");
        LOG.info("++ smartCard : [%s]", smartCard);
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.DELETE);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid(tid);
        workerData.setIccid(iccid);
        return this.a(smartCard, workerData);
    }

    public boolean lockApplet(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String tid, String aid, String version) {
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.LOCK);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid(tid);
        workerData.setIccid(iccid);
        return this.a(smartCard, workerData);
    }

    public boolean unLockApplet(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String tid, String aid, String version) {
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.UNLOCK);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid(tid);
        workerData.setIccid(iccid);
        return this.a(smartCard, workerData);
    }

    public boolean enableApplet(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String tid, String aid, String version) {
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.ENABLE);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid(tid);
        workerData.setIccid(iccid);
        return this.a(smartCard, workerData);
    }

    public boolean blockingApplet(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String tid, String aid, String version) {
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.BLOCKING);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid(tid);
        workerData.setIccid(iccid);
        return this.a(smartCard, workerData);
    }

    public boolean requestSetPpse(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String tid, String aid, String version) {
        LOG.info(">> requestSetPpse()");
        LOG.info("++ smartCard : [%s]", smartCard);
        LOG.info("++ nopId : [%s]", nopId);
        LOG.info("++ compId : [%s]", compId);
        LOG.info("++ tid : [%s]", tid);
        LOG.info("++ aid : [%s]", aid);
        LOG.info("++ version : [%s]", version);
        boolean bRet = true;
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.SETPPSE);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid(tid);
        workerData.setIccid(iccid);
        bRet = this.a(smartCard, workerData);
        return bRet;
    }

    public boolean requestSetConfigDF(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String tid, String aid, String version, ConfigDFParamData configDF) {
        LOG.info(">> requestSetConfigDF()");
        LOG.info("++ smartCard : [%s]", smartCard);
        LOG.info("++ nopId : [%s]", nopId);
        LOG.info("++ compId : [%s]", compId);
        LOG.info("++ tid : [%s]", tid);
        LOG.info("++ aid : [%s]", aid);
        LOG.info("++ version : [%s]", version);
        boolean bRet = true;
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.SETCONFIGDF);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid(tid);
        workerData.setIccid(iccid);
        ParamData paramData = new ParamData();
        paramData.setCardSpec(configDF.getCardSpec());
        paramData.setSItem(configDF.getSItem());
        paramData.setIDCenter(configDF.getIDCenter());
        paramData.setCommand(configDF.getCommand());
        paramData.setADFAID(configDF.getADFAID());
        paramData.setExtraInfo(configDF.getExtraInfo());
        paramData.setCardType(configDF.getCardType());
        paramData.setExpireDate(configDF.getExpireDate());
        paramData.setCardSerial(configDF.getCardSerial());
        paramData.setManageNumber(configDF.getManageNumber());
        paramData.setPartnerInfo(configDF.getPartnerInfo());
        workerData.setParamData(paramData);
        bRet = this.a(smartCard, workerData);
        return bRet;
    }

    public boolean lockTrans(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String tid, String aid, String version) {
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.LOCKTRANS);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid(tid);
        workerData.setIccid(iccid);
        return this.a(smartCard, workerData);
    }

    public boolean requestIsuueCoupon(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String aid, String version, CouponIssueData coupon) {
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.COUPON_ISSUE);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid("");
        workerData.setIccid(iccid);
        IssueData issueData = new IssueData();
        issueData.setPtcode(coupon.getPtcode());
        issueData.setFsercode(coupon.getFsercode());
        issueData.setFseecode(coupon.getFseecode());
        issueData.setCpid(coupon.getCpid());
        issueData.setProperty(coupon.getProperty());
        issueData.setValiddate(coupon.getValiddate());
        issueData.setCpname(coupon.getCpname());
        issueData.setDcamount(coupon.getDcamount());
        issueData.setAid(coupon.getAid());
        issueData.setGuideamount(coupon.getGuideamount());
        issueData.setAvailablecnt(coupon.getAvailablecnt());
        issueData.setVerifycode(coupon.getVerifycode());
        issueData.setExprno(coupon.getExprno());
        issueData.setStatus(coupon.getStatus());
        issueData.setExpinfo(coupon.getExpinfo());
        workerData.setIssueData(issueData);
        workerData.setIssueType("1");
        workerData.setIssueDel("1");
        return this.a(smartCard, workerData);
    }

    public boolean requestDeleteCoupon(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String aid, String version, byte recordNo) {
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.COUPON_DELETE);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid("");
        workerData.setIccid(iccid);
        IssueData issueData = new IssueData();
        issueData.setDelrno(BinaryUtil.toHexString(recordNo));
        workerData.setIssueData(issueData);
        workerData.setIssueType("1");
        workerData.setIssueDel("2");
        return this.a(smartCard, workerData);
    }

    public boolean requestIsuueMembership(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String aid, String version, MembershipIssueData membership) {
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.MEMBERSHIP_ISSUE);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid("");
        workerData.setIccid(iccid);
        IssueData issueData = new IssueData();
        issueData.setPtcode(membership.getPtcode());
        issueData.setFsercode(membership.getFsercode());
        issueData.setTrackinfo(membership.getTrackinfo());
        issueData.setStatus(membership.getStatus());
        issueData.setMsname(membership.getMsname());
        issueData.setExpinfo(membership.getExpinfo());
        workerData.setIssueData(issueData);
        workerData.setIssueType("2");
        workerData.setIssueDel("1");
        return this.a(smartCard, workerData);
    }

    public boolean requestDeleteMembership(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String aid, String version, byte recordNo) {
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.MEMBERSHIP_DELETE);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid("");
        workerData.setIccid(iccid);
        IssueData issueData = new IssueData();
        issueData.setDelrno(BinaryUtil.toHexString(recordNo));
        workerData.setIssueData(issueData);
        workerData.setIssueType("2");
        workerData.setIssueDel("2");
        return this.a(smartCard, workerData);
    }

    public boolean requestIsuueTicket(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String aid, String version, TicketIssueData ticket) {
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.TICKET_ISSUE);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid("");
        workerData.setIccid(iccid);
        IssueData issueData = new IssueData();
        issueData.setPtcode(ticket.getPtcode());
        issueData.setFsercode(ticket.getFsercode());
        issueData.setFseecode(ticket.getFseecode());
        issueData.setBookingno(ticket.getBookingno());
        issueData.setTitle(ticket.getTitle());
        issueData.setPavilion(ticket.getPavilion());
        issueData.setRunningtime(ticket.getRunningtime());
        issueData.setType(ticket.getType());
        issueData.setSeatno(ticket.getSeatno());
        issueData.setTicketid(ticket.getTicketid());
        issueData.setAuthcode(ticket.getAuthcode());
        issueData.setStatus(ticket.getStatus());
        issueData.setExpinfo(ticket.getExpinfo());
        workerData.setIssueData(issueData);
        workerData.setIssueType("3");
        workerData.setIssueDel("1");
        return this.a(smartCard, workerData);
    }

    public boolean requestDeleteTicket(AbstractSmartcard smartCard, String iccid, String nopId, String compId, String aid, String version, byte recordNo) {
        OTAWorkerData workerData = new OTAWorkerData();
        workerData.setOpCode(OpCodeEnum.TICKET_DELETE);
        workerData.setNopId(nopId);
        workerData.setCompId(compId);
        workerData.setInstanceAid(aid);
        workerData.setAppletVersion(version);
        workerData.setTid("");
        workerData.setIccid(iccid);
        IssueData issueData = new IssueData();
        issueData.setDelrno(BinaryUtil.toHexString(recordNo));
        workerData.setIssueData(issueData);
        workerData.setIssueType("3");
        workerData.setIssueDel("2");
        return this.a(smartCard, workerData);
    }

    private boolean a(AbstractSmartcard smartCard, OTAWorkerData workerData) {
        LOG.debug(">> process()");
        boolean bRet = true;
        if (smartCard == null) {
            throw new IllegalArgumentException("***** invaild smartcard");
        }
        RequestBuilder requestBuilder = new RequestBuilder(j);
        Gson gson = new Gson();
        IOTAProtocol.Request request = null;
        IOTAProtocol.Response response = null;
        BodyOfOta body = null;
        OtaHeader otaHeader = null;
        OtaBody otaBody = null;
        List<String> listApdu = null;
        ArrayList<Rpdu> listRpdu = null;
        String jsonOfRequest = null;
        String jsonOfResponse = null;
        int seq = 0;
        String nextUrl = null;
        String msgType = null;
        try {
            try {
                int nRet = smartCard.connect();
                if (nRet < 0) {
                    throw new STIllegarSmartCardException("***** smartcard connected fail!!");
                }
                LOG.info("##############################################################################");
                LOG.info("## Initialize[%s]", seq);
                LOG.info("##############################################################################");
                request = requestBuilder.buildInitiate(Integer.toString(seq), workerData);
                jsonOfRequest = gson.toJson(request);
                LOG.info("++ jsonOfRequest : [%s]", jsonOfRequest);
                jsonOfResponse = Network.getServerMessage(this.a(workerData.getOpCode()), null, jsonOfRequest);
                LOG.info("++ jsonOfResponse : [%s]", jsonOfResponse);
                response = gson.fromJson(jsonOfResponse, IOTAProtocol.Response.class);
                while (true) {
                    IssueData issueData;
                    this.b(response);
                    this.a(response);
                    body = response.getBody();
                    otaHeader = body.getOtaHeader();
                    otaBody = body.getOtaBody();
                    nextUrl = otaHeader.getNextUrl();
                    msgType = otaHeader.getMsgType();
                    if (nextUrl == null || nextUrl.length() < 1) {
                        LOG.info("##############################################################################");
                        LOG.info("## \uc644\ub8cc ==> next_url is empty [%s]", seq);
                        LOG.info("##############################################################################");
                        break;
                    }
                    if ("4".equals(msgType)) {
                        LOG.info("##############################################################################");
                        LOG.info("## \uc644\ub8cc ==> MSG_TYPE_END [%s]", seq);
                        LOG.info("##############################################################################");
                        break;
                    }
                    seq = (int)Float.parseFloat(otaHeader.getSeqNum());
                    listApdu = otaBody.getApduList();
                    listRpdu = null;
                    if (listApdu != null && listApdu.size() > 0) {
                        listRpdu = new ArrayList<Rpdu>();
                        for (String apdu : listApdu) {
                            if (apdu == null) continue;
                            byte[] baRpdu = smartCard.transmit(BinaryUtil.parseHexString(apdu));
                            Rpdu rpdu = new Rpdu();
                            if (baRpdu != null) {
                                rpdu.setRespCode("000");
                            } else {
                                rpdu.setRespCode("999");
                            }
                            rpdu.setRpduString(BinaryUtil.toHexString(baRpdu));
                            listRpdu.add(rpdu);
                        }
                    }
                    if ((issueData = otaBody.getIssueData()) != null) {
                        IssueData orgIssueData = workerData.getIssueData();
                        orgIssueData.setCsn(issueData.getCsn());
                        orgIssueData.setHrn(issueData.getHrn());
                        workerData.setIssueData(orgIssueData);
                    }
                    LOG.info("##############################################################################");
                    LOG.info("## \ubc18\ubcf5 \uc218\ud589[%s]", seq);
                    LOG.info("##############################################################################");
                    request = requestBuilder.buildResponse(Integer.toString(seq), "000", "", listRpdu, workerData);
                    jsonOfRequest = gson.toJson(request);
                    LOG.info("++ jsonOfRequest : [%s]", jsonOfRequest);
                    jsonOfResponse = Network.getServerMessage(nextUrl, null, jsonOfRequest);
                    LOG.info("++ jsonOfResponse : [%s]", jsonOfResponse);
                    response = gson.fromJson(jsonOfResponse, IOTAProtocol.Response.class);
                }
                this.a(response);
            }
            catch (STOtaProcException e) {
                LOG.error(e);
                bRet = false;
                smartCard.disconnect();
            }
            catch (Exception e) {
                LOG.error(e);
                bRet = false;
                request = requestBuilder.buildEnd(Integer.toString(seq), "999", "unknown", null, workerData);
                jsonOfRequest = gson.toJson(request);
                if (nextUrl != null) {
                    Network.getServerMessage(nextUrl, null, jsonOfRequest, "POST");
                }
                smartCard.disconnect();
            }
        }
        finally {
            smartCard.disconnect();
        }
        return bRet;
    }

    private String a(OpCodeEnum opcode) {
        LOG.info(">> generateInitiateUrl()");
        LOG.info(new Object[]{"++ opcode : [%s]", opcode});
        String url = null;
        url = OpCodeEnum.INSTALL.equals((Object)opcode) ? String.format("%s/api/install?staging=%s", "https://sems.sksmarttouch.com", this.m) : (OpCodeEnum.DELETE.equals((Object)opcode) ? String.format("%s/api/delete?staging=%s", "https://sems.sksmarttouch.com", this.m) : (OpCodeEnum.LOCK.equals((Object)opcode) ? String.format("%s/api/lock?staging=%s", "https://sems.sksmarttouch.com", this.m) : (OpCodeEnum.UNLOCK.equals((Object)opcode) ? String.format("%s/api/unlock?staging=%s", "https://sems.sksmarttouch.com", this.m) : (OpCodeEnum.ENABLE.equals((Object)opcode) ? String.format("%s/api/enable?staging=%s", "https://sems.sksmarttouch.com", this.m) : (OpCodeEnum.BLOCKING.equals((Object)opcode) ? String.format("%s/api/blocking?staging=%s", "https://sems.sksmarttouch.com", this.m) : (OpCodeEnum.SETPPSE.equals((Object)opcode) ? String.format("%s/api/setPpse?staging=%s", "https://sems.sksmarttouch.com", this.m) : (OpCodeEnum.LOCKTRANS.equals((Object)opcode) ? String.format("%s/api/lockTrans?staging=%s", "https://sems.sksmarttouch.com", this.m) : (OpCodeEnum.SETCONFIGDF.equals((Object)opcode) ? String.format("%s/api/setConfigDF?staging=%s", "https://sems.sksmarttouch.com", this.m) : String.format("%s/seman/issue", "http://coupon.sksmarttouch.com:8080")))))))));
        LOG.info("-- returned : [%s]", url);
        return url;
    }

    private void a(IOTAProtocol.Response response) throws STOtaProcException {
        HeaderOfOta header = null;
        BodyOfOta body = null;
        OtaHeader otaHeader = null;
        OtaBody otaBody = null;
        if (response == null) {
            throw new STOtaProcException("***** response is empty");
        }
        header = response.getHeader();
        body = response.getBody();
        if (header == null) {
            throw new STOtaProcException("***** response.header is empty");
        }
        if (!"000".equals(header.getResultCode())) {
            throw new STOtaProcException("***** response.header is not '000'");
        }
        if (body == null) {
            throw new STOtaProcException("***** response.body is empty");
        }
        otaHeader = body.getOtaHeader();
        otaBody = body.getOtaBody();
        if (otaHeader == null) {
            throw new STOtaProcException("***** response.body.ota_header is empty");
        }
        if (otaBody == null) {
            throw new STOtaProcException("***** response.body.ota_body is empty");
        }
    }

    private void b(IOTAProtocol.Response response) {
        LOG.info(">> sendOnDispatchWorker()");
        LOG.info("++ response : [%s]", response);
        if (this.k == null) {
            LOG.info("-- returned : listener is null");
            return;
        }
        if (response == null) {
            LOG.info("-- returned : response is null");
            return;
        }
        HeaderOfOta header = response.getHeader();
        BodyOfOta body = response.getBody();
        OtaBody otaBody = null;
        DispData dispData = null;
        try {
            if (header == null) {
                LOG.error("***** header is null : dispatch data skip...!!");
                return;
            }
            if (body == null) {
                throw new Exception("***** body is null");
            }
            otaBody = body.getOtaBody();
            if (otaBody == null) {
                throw new Exception("***** ota_body is null");
            }
            dispData = otaBody.getDispData();
            if (dispData == null) {
                throw new Exception("***** disp_data is null");
            }
            String msg = dispData.getDispErr() != null && dispData.getDispErr().trim().length() > 0 ? dispData.getDispErr() : dispData.getDispMsg();
            this.k.onDispatchFromWorker(this.l, otaBody.getDispData().getDispStat(), msg);
        }
        catch (Exception e) {
            this.k.onDispatchFromWorker(this.l, header.getResultCode(), header.getResultMsg());
        }
    }
}

