/*
 * Decompiled with CFR 0.152.
 */
package kr.co.skplanet.utils;

import java.io.UnsupportedEncodingException;
import kr.co.skplanet.utils.StringUtil;

public class BinaryUtil {
    public static byte[] parseBinary(Object value) {
        byte[] ret = null;
        if (value instanceof String) {
            ret = BinaryUtil.parseBinary((String)value);
        } else if (value instanceof Byte) {
            ret = new byte[]{(Byte)value};
        } else if (value instanceof Integer) {
            ret = BinaryUtil.parseBinary((Integer)value);
        } else if (value instanceof Short) {
            ret = BinaryUtil.parseBinary((Short)value);
        } else if (value instanceof byte[]) {
            int len = ((byte[])value).length;
            ret = new byte[len];
            System.arraycopy(value, 0, ret, 0, len);
        }
        return ret;
    }

    public static byte[] parseBinary(Object value, int order) {
        byte[] ret = null;
        if (value instanceof String) {
            ret = BinaryUtil.parseBinary((String)value);
        } else if (value instanceof Byte) {
            ret = new byte[]{(Byte)value};
        } else if (value instanceof Integer) {
            ret = BinaryUtil.parseBinary((int)((Integer)value), order);
        } else if (value instanceof Short) {
            ret = BinaryUtil.parseBinary((short)((Short)value), order);
        } else if (value instanceof byte[]) {
            int len = ((byte[])value).length;
            ret = new byte[len];
            System.arraycopy(value, 0, ret, 0, len);
        }
        return ret;
    }

    public static byte[] parseBinary(int value) {
        int SIZE = 4;
        byte[] b2 = new byte[SIZE];
        int i = 0;
        while (i < SIZE) {
            b2[i] = (byte)(value >>> 8 * (SIZE - 1 - i));
            ++i;
        }
        return b2;
    }

    public static byte[] parseBinary(short value) {
        int SIZE = 2;
        byte[] b2 = new byte[SIZE];
        int i = 0;
        while (i < SIZE) {
            b2[i] = (byte)(value >>> 8 * (SIZE - 1 - i));
            ++i;
        }
        return b2;
    }

    public static byte[] parseBinary(String value) {
        return value.getBytes();
    }

    public static byte[] parseBinary(String value, String charset) {
        byte[] ret = null;
        try {
            ret = value.getBytes(charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static String toHexString(byte value) {
        byte[] in = new byte[]{value};
        return BinaryUtil.toHexString(in);
    }

    public static String toHexString(byte[] value) {
        if (value == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            int j = value[i] >> 4 & 0xF;
            if (j <= 9) {
                sb.append(j);
            } else {
                sb.append((char)(j + 65 - 10));
            }
            j = value[i] & 0xF;
            if (j <= 9) {
                sb.append(j);
            } else {
                sb.append((char)(j + 65 - 10));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toHexString(byte[] value, int start, int len) {
        if (len <= 0) {
            return null;
        }
        if (value == null) {
            return null;
        }
        int max = start + len;
        StringBuffer sb = new StringBuffer();
        int i = start;
        while (i < max) {
            int j = value[i] >> 4 & 0xF;
            if (j <= 9) {
                sb.append(j);
            } else {
                sb.append((char)(j + 65 - 10));
            }
            j = value[i] & 0xF;
            if (j <= 9) {
                sb.append(j);
            } else {
                sb.append((char)(j + 65 - 10));
            }
            ++i;
        }
        return sb.toString();
    }

    public static byte[] parseHexString(String value) {
        if (value == null) {
            return null;
        }
        value = value.toUpperCase();
        int len = value.length();
        byte[] out = new byte[len / 2];
        int i = 0;
        while (i < len / 2) {
            int j = i * 2;
            int high = 0;
            int low = 0;
            if (value.charAt(j) >= '0' && value.charAt(j) <= '9') {
                high = value.charAt(j) - 48;
            } else if (value.charAt(j) >= 'A' && value.charAt(j) <= 'F') {
                high = 10 + (value.charAt(j) - 65);
            }
            if (value.charAt(j) >= '0' && value.charAt(j + 1) <= '9') {
                low = value.charAt(j + 1) - 48;
            } else if (value.charAt(j + 1) >= 'A' && value.charAt(j + 1) <= 'F') {
                low = 10 + (value.charAt(j + 1) - 65);
            }
            out[i] = (byte)(high * 16 + low);
            ++i;
        }
        return out;
    }

    public static String toBinaryString(byte value) {
        int in = value & 0xFF;
        String str = Integer.toBinaryString(in);
        str = StringUtil.format(str, 8, '0', false);
        return str;
    }

    public static String toBinaryString(byte[] value) {
        if (value == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            String str = BinaryUtil.toBinaryString(value[i]);
            sb.append(str);
            ++i;
        }
        return sb.toString();
    }

    public static String toBinaryString(byte[] value, int start, int len) {
        if (value == null) {
            return null;
        }
        int max = start + len;
        StringBuffer sb = new StringBuffer();
        int i = start;
        while (i < max) {
            String str = BinaryUtil.toBinaryString(value[i]);
            sb.append(str);
            ++i;
        }
        return sb.toString();
    }

    public static int parseBinaryString(String value) {
        int result = 0;
        try {
            result = Integer.parseInt(value, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static int parseBinaryString(String value, int start, int end) {
        int result = 0;
        try {
            String str = value.substring(start, end);
            result = BinaryUtil.parseBinaryString(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

