/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecurekeypad;

import com.softforum.xecurekeypad.XKCoreWrapperToJni;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class XKCoreWrapper {
    private String mSessionID = null;
    private String mE2ESessionID = null;
    private String mE2EToken = null;
    private int mE2ESessionTime = 0;
    private ArrayList<String> mInputIndexArray = null;
    private boolean mUseSessionTimeRefresh = false;
    private boolean mUseSessionRefresh = false;
    private boolean mUseRefresh = false;
    private XKCoreWrapperToJni mCoreWrapperToJni = null;

    public XKCoreWrapper(String pSessionID) {
        this.mSessionID = pSessionID;
        this.mInputIndexArray = new ArrayList();
        this.mCoreWrapperToJni = new XKCoreWrapperToJni();
    }

    public void putIndex(String aIndex) {
        this.mInputIndexArray.add(aIndex);
    }

    public void deleteIndex() {
        int aIndex = 0;
        aIndex = this.getIndexCount();
        if (aIndex > 0) {
            this.mInputIndexArray.remove(aIndex - 1);
        }
    }

    public void clearIndex() {
        this.mInputIndexArray.clear();
    }

    public int getIndexCount() {
        return this.mInputIndexArray.size();
    }

    public String makeIndex(int aIndexType) {
        String aReturnIndex = "";
        aReturnIndex = this.mCoreWrapperToJni.makeIndex(this.mSessionID, this.getKeypadType(aIndexType));
        return aReturnIndex;
    }

    public String makeIndexE2E(int aIndexType, String aURL) {
        int aIndex = 0;
        int aAddCount = 0;
        String aAddString = "";
        String aReturnIndex = "";
        String aE2EResponse = "";
        StringTokenizer aResponseTokenizer = null;
        aE2EResponse = this.mCoreWrapperToJni.makeIndexE2E(this.getKeypadType(aIndexType), aURL);
        try {
            aResponseTokenizer = new StringTokenizer(aE2EResponse, "|");
            this.mE2ESessionID = aResponseTokenizer.nextToken();
            aAddCount = 8 - this.mE2ESessionID.length();
            aIndex = 0;
            while (aIndex < aAddCount) {
                aAddString = String.valueOf(aAddString) + "0";
                ++aIndex;
            }
            if (this.mE2ESessionID.length() != 8) {
                this.mE2ESessionID = String.valueOf(aAddString) + this.mE2ESessionID;
            }
            aReturnIndex = aResponseTokenizer.nextToken();
            this.mE2EToken = aResponseTokenizer.nextToken();
            this.mE2ESessionTime = Integer.parseInt(aResponseTokenizer.nextToken());
        }
        catch (NullPointerException aException) {
            aReturnIndex = "";
        }
        return aReturnIndex;
    }

    public String getIndex() {
        String aReturnIndex = "";
        aReturnIndex = this.mCoreWrapperToJni.getIndex(this.mSessionID);
        return aReturnIndex;
    }

    public String getIndexText(int aIndexType) {
        String aReturnIndexText = "";
        aReturnIndexText = this.mCoreWrapperToJni.getIndexText(this.getKeypadType(aIndexType));
        return aReturnIndexText;
    }

    public String getIndexE2E() {
        String aReturnIndex = "";
        aReturnIndex = this.mCoreWrapperToJni.getIndexE2E(this.mE2ESessionID);
        return aReturnIndex;
    }

    public String getE2ESessionID() {
        return this.mE2ESessionID;
    }

    public String getE2EToken() {
        return this.mE2EToken;
    }

    public int getE2ESessionTime() {
        return this.mE2ESessionTime;
    }

    public String getEncryptedData(byte[] pRandomValue) {
        String aEncryptedData = null;
        int aIndexArrayLength = 0;
        int aIndexCount = 0;
        StringBuffer aTempString = null;
        aTempString = new StringBuffer();
        aIndexArrayLength = this.mInputIndexArray.size();
        aIndexCount = 0;
        while (aIndexCount < aIndexArrayLength) {
            String aIndexString = this.mInputIndexArray.get(aIndexCount);
            aTempString.append(aIndexString);
            if (aIndexCount + 1 < aIndexArrayLength) {
                aTempString.append(",");
            }
            ++aIndexCount;
        }
        aEncryptedData = this.mCoreWrapperToJni.getEncryptedData(this.mSessionID, aTempString.toString(), pRandomValue);
        if (aEncryptedData == null) {
            aEncryptedData = "";
        }
        return aEncryptedData;
    }

    public String getUnpackedData() {
        int aIndexArrayLength = 0;
        int aIndexCount = 0;
        String aUnpackedString = null;
        StringBuffer aTempString = null;
        aTempString = new StringBuffer();
        aIndexArrayLength = this.mInputIndexArray.size();
        aIndexCount = 0;
        while (aIndexCount < aIndexArrayLength) {
            String aIndexString = this.mInputIndexArray.get(aIndexCount);
            aTempString.append(aIndexString);
            if (aIndexCount + 1 < aIndexArrayLength) {
                aTempString.append(",");
            }
            ++aIndexCount;
        }
        aUnpackedString = this.mCoreWrapperToJni.getUnpackedData(this.mSessionID, aTempString.toString());
        if (aUnpackedString == null) {
            aUnpackedString = "";
        }
        return aUnpackedString;
    }

    public String getpackedData() {
        int aIndexArrayLength = 0;
        int aIndexCount = 0;
        StringBuffer aTempString = null;
        aTempString = new StringBuffer();
        aIndexArrayLength = this.mInputIndexArray.size();
        aIndexCount = 0;
        while (aIndexCount < aIndexArrayLength) {
            String aIndexString = this.mInputIndexArray.get(aIndexCount);
            aTempString.append(aIndexString);
            if (aIndexCount + 1 < aIndexArrayLength) {
                aTempString.append(",");
            }
            ++aIndexCount;
        }
        return aTempString.toString();
    }

    public boolean isExistSessionID() {
        boolean aIsExist = false;
        if (!this.mUseSessionRefresh && !this.mUseRefresh) {
            aIsExist = true;
            this.mUseSessionTimeRefresh = false;
        } else {
            aIsExist = false;
            this.mUseSessionTimeRefresh = true;
        }
        this.mUseRefresh = false;
        return aIsExist;
    }

    public boolean useSessionTimeRefresh() {
        return this.mUseSessionTimeRefresh;
    }

    public void setUseSessionRefresh(boolean aUseSessionRefresh) {
        this.mUseSessionRefresh = aUseSessionRefresh;
    }

    public void setUseRefresh(boolean aUseRefresh) {
        this.mUseRefresh = aUseRefresh;
    }

    private String getKeypadType(int aKeypadType) {
        String aType = null;
        switch (aKeypadType) {
            case 0: {
                aType = "number";
                break;
            }
            default: {
                aType = "qwertysmart";
            }
        }
        return aType;
    }
}

