/*
 * Decompiled with CFR 0.152.
 */
package com.raonsecure.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import com.raon.common.KSBase64;
import com.raon.common.KSHex;
import com.raon.ks.KSSha1;
import com.raonsecure.api.RaonException;
import com.raonsecure.api.RaonLogger;
import com.raonsecure.api.Raon_Http;
import com.raonsecure.service.GetCertList;
import com.raonsecure.service.IRemoteInterface;
import com.skp.smarttouch.sem.telco.SEUtility;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class Raon_Usim_Api {
    public static final int SU_RESULT_OK = 0;
    public static final int SU_RESULT_FAIL = 1;
    public static final int RESULT_IS_MEMBER = 1001;
    public static final int RESULT_BIND_FAIL = 1002;
    public static final int RESULT_JOIN_FAIL = 1003;
    public static final int RESULT_IMPOSSIBLE_SERVICE = 1004;
    public static final int RESULT_USER_NO_MEMBER = 2001;
    public static final int RESULT_USER_USIM_MEMBER = 2002;
    public static final int RESULT_USER_SIMILAR_MEMBER = 2003;
    public static final int RESULT_USER_IMPOSSIBLE_MEMBER = 2004;
    public static final int RESULT_USER_NOT_TELECOM_MEMBER = 2005;
    public static final int RESULT_USER_SERVICE_STATUS_STOP = 2006;
    public static final int RESULT_USER_NOT_SUPPORTED_MEMBER = 2007;
    public static final int RESULT_USER_NOT_OPEN_USIM = 2008;
    public static final int RESULT_USER_NOT_SUPPORTED_DEVICE = 2009;
    public static final int RESULT_USER_NOT_SUPPORTED_USIM = 2010;
    public static final int RESULT_APP_NOT_SUPPORT = 3001;
    public static final int RESULT_APP_REQUIED_UPDATE = 3002;
    public static final int RESULT_NETWORK_CONNECT = 4001;
    public static final int RESULT_NETWORK_ERROR = 4002;
    public static final int RESULT_PW_PIN_INCORRECT = 5001;
    public static final int RESULT_PW_PIN_LOCK = 5002;
    public static final int RESULT_PW_PIN_INIT_STATE = 5003;
    public static final int RESULT_PW_PIN_INVALID_LENGTH = 5004;
    public static final int RESULT_PW_CERT_INCORRECT = 5005;
    public static final int RESULT_NOT_EXIST_VID_RANDOM = 6001;
    public static final int RESULT_NOT_EXIST_FILTER_CERT = 6002;
    public static final int RESULT_NOT_ENOUGH_CERT_STORAGE = 6003;
    public static final int RESULT_NOT_SUPPORTED_ROOTING = 6004;
    public static final int RESULT_ISPOSSIBLESERVICE_FAIL = 7001;
    public static final int RESULT_JOINSERVICE_FAIL = 7002;
    public static final int RESULT_GETTOKENINFO_FAIL = 7003;
    public static final int RESULT_SETFILTER_FAIL = 7004;
    public static final int RESULT_GET_CERT_COUNT_FAIL = 7005;
    public static final int RESULT_GETCERTIFICATE_FAIL = 7006;
    public static final int RESULT_GET_ATTRIBUTES_FAIL = 7007;
    public static final int RESULT_SIGN_FAIL = 7008;
    public static final int RESULT_ADD_UNSIGNED_ATTRIBUTE_SIGNEDDDATA_FAIL = 7009;
    public static final int RESULT_GET_VID_RANDOM_FAIL = 7010;
    public static final int RESULT_VERIFY_VID_FAIL = 7011;
    public static final int RESULT_WRITE_CERT_USIM_FAIL = 7012;
    public static final int RESULT_DELETE_CERT_USIM_FAIL = 7013;
    public static final int RESULT_LOGIN_FAIL = 7014;
    public static final int RESULT_LOGOUT_FAIL = 7015;
    public static final int RESULT_CHANGEPIN_FAIL = 7016;
    public static final int RESULT_INITPIN_FAIL = 7017;
    public static final int RESULT_INVALID_PARAM = 9001;
    public static final int RESULT_CODE_INSTALL_APP_FAIL = 9002;
    public static final int RESULT_REMOTE_EXCEPTION = 9003;
    public static final int RESULT_CORE_INIT_FAIL = 9004;
    public static final int RESULT_OK = 1;
    public static final int RESULT_FAIL = 0;
    public static final int RESULT_ERROR_NOT_INSTALLED_PACKAGE = -100;
    public static final int RESULT_ERROR_NOT_ALLOWED_APP_ACCESS = -101;
    public static final int RESULT_ERROR_NOT_MEMBER_ACCESS = -102;
    public static final int RESULT_ERROR_MEMBER_CHECK = -103;
    public static final int RESULT_ERROR_USIM_CONNECT = -201;
    public static final int RESULT_ERROR_USIM_DISCONNECT = -202;
    public static final int RESULT_ERROR_USIM_GET_CERTLIST_COUNT = -203;
    public static final int RESULT_ERROR_USIM_GET_CERT = -204;
    public static final int RESULT_ERROR_USIM_GET_EMPTYROOM_COUNT = -205;
    public static final int RESULT_ERROR_USIM_VERIFY_PIN = -206;
    public static final int RESULT_ERROR_USIM_VERIFY_PIN_DIGIT = -2060;
    public static final int RESULT_ERROR_USIM_ISSUE_CERT = -207;
    public static final int RESULT_ERROR_USIM_PKCS1_SIGNEX = -208;
    public static final int RESULT_ERROR_USIM_LOGOUT = -209;
    public static final int RESULT_ERROR_USIM_DELETE_CERT_AND_KEY = -210;
    public static final int RESULT_ERROR_USIM_GET_VID_RANDOM = -211;
    public static final int RESULT_ERROR_USIM_PUT_CERT = -212;
    public static final int RESULT_ERROR_USIM_GET_CERTLIST = -213;
    public static final int RESULT_ERROR_USIM_GET_CERTLIST_IN_USIM = -214;
    public static final int RESULT_ERROR_USIM_DELETE_CERT = -215;
    public static final int RESULT_ERROR_USIM_PKCS7_SIGN = -216;
    public static final int RESULT_ERROR_USIM_PKCS7_SIGN_TIME = -217;
    public static final int RESULT_ERROR_USIM_ADD_UNAUTH_ATTRIBUTE = -218;
    public static final int RESULT_ERROR_USIM_ADD_UNAUTH_ATTRIBUTES_WITH_SIGNED_DATABASE64 = -219;
    public static final int RESULT_ERROR_USIM_GET_KS_CERTIFICATE = -220;
    public static final int RESULT_ERROR_USIM_VERIFY_VID = -221;
    public static final int RESULT_ERROR_RAON_SIGN_P7_KOSCOM = -222;
    public static final int RESULT_ERROR_RAON_SIGN_P7_KOSCOM_SIMPLE = -223;
    public static final int RESULT_ERROR_USIM_SIGN_P1_MAP = -224;
    public static final int RESULT_ERROR_CHECK_VERSION_ERROR = -225;
    public static final int RESULT_ERROR_SERVER_CONNECTION_ERROR_WHILE_CHECK_MEMBER = -226;
    public static final int RESULT_ERROR_SERVER_RESPONSE_ERROR_WHILE_CHECK_MEMBER = -227;
    public static final int RESULT_ERROR_NOT_INSTALLED_SEIO_AGENT = -228;
    public static final int RESULT_ERROR_RECEIVED_DEVICE_SERIAL_ERROR = -229;
    public static final int RESULT_ERROR_INITIALZED_NEED_RESET_PASSWORD = -230;
    public static final int RESULT_ERROR_INVALID_PARAM = -231;
    public static final int RESULT_ERROR_USIM_NOT_EXIST = -301;
    public static final int RESULT_ERROR_GET_USIMINFO_FAILED = -302;
    public static final int RESULT_ERROR_NOT_SUPPORT_AGENCY = -303;
    public static final int RESULT_ERROR_NOT_MATCH_AIDL = -998;
    public static final int RESULT_ERROR_SERVICE_BIND_FAILED = -999;
    public static final int RESULT_ERROR_WRONG_PASSWORD_REQ_COUNT_1 = 1001;
    public static final int RESULT_ERROR_WRONG_PASSWORD_REQ_COUNT_2 = 1002;
    public static final int RESULT_ERROR_WRONG_PASSWORD_REQ_COUNT_3 = 1003;
    public static final int RESULT_ERROR_WRONG_PASSWORD_REQ_COUNT_4 = 1004;
    public static final int RESULT_ERROR_WRONG_PASSWORD_REQ_COUNT_5 = 1005;
    public static final int RESULT_ERROR_WRONG_PASSWORD_REQ_COUNT_6 = 1006;
    public static final int RESULT_ERROR_WRONG_PASSWORD_REQ_COUNT_7 = 1007;
    public static final int RESULT_ERROR_WRONG_PASSWORD_REQ_COUNT_8 = 1008;
    public static final int RESULT_ERROR_WRONG_PASSWORD_REQ_COUNT_9 = 1009;
    public static final int RESULT_ERROR_WRONG_PASSWORD_REQ_COUNT_10_ANN_INIT_PASSWORD = 1010;
    public static final int RESULT_ERROR_USIM_PUTCERT_CERT_DATA_ERROR = -2121;
    public static final int RESULT_ERROR_USIM_PUTCERT_PRVKEY_DATA_ERROR = -2122;
    public static final int RESULT_ERROR_USIM_PUTCERT_PASSWORD_IS_NULL = -2123;
    public static final int RESULT_ERROR_USIM_CHECK_CERT_PASSWORD = -2124;
    public static final int RESULT_ERROR_USIM_PUTCERT_VERIFY_PASSWORD_FAILED = -2125;
    private Context mContext = null;
    IRemoteInterface mRemoteInterface = null;
    Boolean flag_mBound = false;
    ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder binder) {
            RaonLogger.trace("Raon_Usim_Api onServiceConnected Start");
            Raon_Usim_Api.this.mRemoteInterface = IRemoteInterface.Stub.asInterface((IBinder)binder);
            if (Raon_Usim_Api.this.mRemoteInterface == null) {
                RaonLogger.trace("Raon_Usim_Api onServiceConnected mRemoteInterface null");
                Raon_Usim_Api.this.flag_mBound = false;
            } else {
                RaonLogger.trace("Raon_Usim_Api onServiceConnected mRemoteInterface not null");
                Raon_Usim_Api.this.flag_mBound = true;
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            RaonLogger.trace("Raon_Usim_Api onServiceDisconnected");
            Raon_Usim_Api.this.flag_mBound = false;
        }
    };

    private Raon_Usim_Api(Context context) {
        this.mContext = context;
    }

    public void doBindService() {
        RaonLogger.trace("Raon_Usim_Api doBindService Start");
        this.mContext.bindService(new Intent("com.raonsecure.Usim_Mobile.SERVICE"), this.mConnection, 1);
    }

    public void doUnBindService() {
        RaonLogger.trace("Raon_Usim_Api doUnBindService Start");
        this.mContext.unbindService(this.mConnection);
    }

    public static int CheckPackage(Context ctx) {
        RaonLogger.trace("Raon_Usim_Api CheckPackage");
        int ret = -1;
        int com = -1;
        String CHECK_PACKAGE_NAME = null;
        com = Raon_Usim_Api.ChecPhoneState(ctx);
        if (com == 1) {
            CHECK_PACKAGE_NAME = "com.raonsecure.mobiletoken";
        } else if (com == 2) {
            CHECK_PACKAGE_NAME = "com.lguplus.mobiletoken";
        } else if (com == 3) {
            CHECK_PACKAGE_NAME = "com.raonsecure.ktmobiletoken";
        } else {
            if (com == 100) {
                return -301;
            }
            if (com == 101) {
                return -302;
            }
            if (com == 102) {
                return -303;
            }
            return -304;
        }
        if (CHECK_PACKAGE_NAME == null) {
            CHECK_PACKAGE_NAME = "com.raonsecure.mobiletoken";
        }
        RaonLogger.trace("CheckPackage bindService");
        try {
            PackageManager pm = ctx.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(CHECK_PACKAGE_NAME.trim(), 128);
            ApplicationInfo appInfo = pi.applicationInfo;
            RaonLogger.trace("\ud328\ud0a4\uc9c0\uac00 \uc124\uce58 \ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4.");
            RaonLogger.trace("Enabled value = " + appInfo.enabled);
            ret = 1;
        }
        catch (PackageManager.NameNotFoundException e) {
            RaonLogger.trace("\ud328\ud0a4\uc9c0\uac00 \uc124\uce58 \ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            ret = -100;
        }
        catch (Exception e) {
            RaonLogger.trace("\uc54c \uc218 \uc5c6\ub294 \uc624\ub958");
            ret = -997;
        }
        return ret;
    }

    private static int ChecPhoneState(Context ctx) {
        boolean ret = false;
        String src = null;
        String com = null;
        TelephonyManager tm = (TelephonyManager)ctx.getSystemService("phone");
        src = tm.getLine1Number();
        com = tm.getSimOperator();
        RaonLogger.trace("\ud1b5\uc2e0\uc0ac \ud655\uc778 = " + com);
        if (tm.getSimState() == 1) {
            RaonLogger.trace("ChecPhoneState ChecPhoneState SIM_STATE_ABSENT");
            return 100;
        }
        if (com == null && com.length() <= 0) {
            RaonLogger.trace("ChecPhoneState ChecPhoneState \ud1b5\uc2e0\uc0ac \uc870\ud68c\uc911 \uc624\ub958");
            return 101;
        }
        if (com.equals("45006")) {
            RaonLogger.trace("ChecPhoneState ChecPhoneState LGU+");
            return 2;
        }
        if (com.equals("45005") || com.equals("45002")) {
            RaonLogger.trace("ChecPhoneState ChecPhoneState SKT");
            return 1;
        }
        if (com.equals("45008")) {
            RaonLogger.trace("ChecPhoneState ChecPhoneState KT");
            return 3;
        }
        return 102;
    }

    public static int Raon_Check_Package(Context ctx) throws RaonException {
        RaonLogger.trace("Start Raon_Check_Package");
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Check_Package CheckPackage Fail");
            throw new RaonException(ret_check_package, "Check Packag Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_Check_Package CheckPackage Success");
        return ret_check_package;
    }

    public static boolean Raon_Check_User_NoneApp(Context ctx, String pkg) throws RaonException {
        Map<Object, Object> resHttp = new HashMap();
        HashMap<String, Object> httpdata = new HashMap<String, Object>();
        int com = -1;
        String tel = null;
        String phonenum = null;
        com = Raon_Usim_Api.ChecPhoneState(ctx);
        if (com == 1) {
            tel = "2";
        } else if (com == 2) {
            tel = "1";
        } else if (com == 3) {
            tel = "3";
        } else {
            if (com == 100) {
                throw new RaonException(-301, "Not Exist USIM");
            }
            if (com == 101) {
                throw new RaonException(-302, "Not Exist Com");
            }
            if (com == 102) {
                throw new RaonException(-303, "Unknown Com");
            }
        }
        phonenum = Raon_Usim_Api.ReadPhoneNumber(ctx);
        try {
            httpdata.clear();
            httpdata.put("ctn", phonenum);
            httpdata.put("com", tel);
            httpdata.put("call_app_pkg", pkg);
            resHttp = Raon_Http.Send_Data("1003", httpdata);
        }
        catch (Exception e) {
            throw new RaonException(-226, "Error Server Connect");
        }
        if (resHttp.get("retcode") != null && resHttp.get("retcode").toString().length() >= 1) {
            return resHttp.get("svc_auth") != null && resHttp.get("svc_auth").toString().equals("1");
        }
        throw new RaonException(-227, "Error Server Response");
    }

    public static boolean Raon_Check_SeioAgent(Context ctx) throws RaonException {
        RaonLogger.trace("Start Raon_Check_Package");
        if (!SEUtility.isInstalledSeioAgent((Context)ctx.getApplicationContext())) {
            RaonLogger.trace("SeioAgent Check isInstalled false");
            return false;
        }
        RaonLogger.trace("SeioAgent Check isInstalled true");
        if (SEUtility.isNeedUpgradeSEIOAgent((Context)ctx.getApplicationContext(), (int)1, (int)0)) {
            RaonLogger.trace("SeioAgent Check isupdate true");
            return false;
        }
        RaonLogger.trace("SeioAgent Check isupdate false");
        return true;
    }

    public static int Raon_Install_SeioAgent(Context ctx) throws RaonException {
        RaonLogger.trace("Start Raon_Install_Package");
        int ret_check_package = 1;
        int com = Raon_Usim_Api.ChecPhoneState(ctx);
        if (com != 1) {
            if (com == 2) {
                throw new RaonException(com, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud1b5\uc2e0\uc0ac");
            }
            if (com == 3) {
                throw new RaonException(com, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud1b5\uc2e0\uc0ac");
            }
            throw new RaonException(com, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud1b5\uc2e0\uc0ac");
        }
        Intent intent = new Intent();
        intent.addFlags(0x30000000);
        intent.setClassName("com.skt.skaf.A000Z00040", "com.skt.skaf.A000Z00040.A000Z00040");
        intent.setAction("COLLAB_ACTION");
        intent.putExtra("com.skt.skaf.COL.URI", "PRODUCT_VIEW/0000397902/0/PAYMENT".getBytes());
        intent.putExtra("com.skt.skaf.COL.REQUESTER", "A000Z00040");
        ctx.startActivity(intent);
        return ret_check_package;
    }

    public static int Raon_Install_Package(Context ctx) throws RaonException {
        RaonLogger.trace("Start Raon_Install_Package");
        int ret_check_package = 1;
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        int com = Raon_Usim_Api.ChecPhoneState(ctx);
        if (com == 1) {
            intent.setData(Uri.parse((String)"https://play.google.com/store/apps/details?id=com.raonsecure.mobiletoken&hl=ko"));
        } else if (com == 2) {
            intent.setData(Uri.parse((String)"https://play.google.com/store/apps/details?id=com.lguplus.mobiletoken"));
        } else if (com == 3) {
            intent.setData(Uri.parse((String)"https://play.google.com/store/apps/details?id=com.raonsecure.ktmobiletoken&hl=ko"));
        } else {
            throw new RaonException(com, "Check com fail");
        }
        ctx.startActivity(intent);
        return ret_check_package;
    }

    public static boolean Raon_Check_User(Context ctx, IRemoteInterface mRemoteInterface) throws RaonException {
        Map retmap = new HashMap();
        int ret_check_package = -1;
        int ret_code = 0;
        String ret_msg = "";
        boolean user_yn = false;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Check_User CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_Check_User CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.Check_User();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (retmap == null) {
            throw new RaonException(-998, "Not Match aidl");
        }
        ret_code = (Integer)retmap.get("code");
        ret_msg = (String)retmap.get("ret_msg");
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        user_yn = (Boolean)retmap.get("user_yn");
        return user_yn;
    }

    public static int Raon_Check_Version(Context ctx, IRemoteInterface mRemoteInterface) throws RaonException {
        Map retmap = new HashMap();
        int ret_check_package = -1;
        int ret_code = 0;
        String ret_msg = "";
        int version_info = 0;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Check_User CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_Check_User CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            RaonLogger.trace("Raon_Usim_Api Raon_Check_Version Start Check_App_Version");
            retmap = mRemoteInterface.Check_App_Version();
            RaonLogger.trace("Raon_Usim_Api Raon_Check_Version End Check_App_Version");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (retmap == null) {
            throw new RaonException(-998, "Not Match aidl");
        }
        ret_code = (Integer)retmap.get("code");
        ret_msg = (String)retmap.get("ret_msg");
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        version_info = (Integer)retmap.get("check_version");
        RaonLogger.trace("check_version " + version_info);
        return version_info;
    }

    public static void Raon_Service_Join(Context ctx, String pkg_name) throws RaonException {
        int ret_check_package = -1;
        String pkg = "com.android.intentsender.sendintent";
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Check_User CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        Intent intent = new Intent();
        intent.setAction(pkg);
        intent.putExtra("type", "1001");
        intent.putExtra("join_code", pkg_name);
        ctx.startActivity(intent);
    }

    public static void Raon_Edit_PinNum(Context ctx) throws RaonException {
        int ret_check_package = -1;
        String pkg = "com.android.intentsender.sendintent";
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Edit_PinNum CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        Intent intent = new Intent();
        intent.setAction(pkg);
        intent.putExtra("type", "1002");
        ctx.startActivity(intent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String Raon_GetToken(Context ctx) throws RaonException {
        String simSerialNumber;
        TelephonyManager telephonyManager;
        int ret_check_package = -1;
        String token = null;
        String get_token = null;
        int com = -1;
        String phonenum = null;
        Map<Object, Object> resHttp = new HashMap();
        HashMap<String, Object> httpdata = new HashMap<String, Object>();
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetToken CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetToken CheckPackage Success");
        com = Raon_Usim_Api.ChecPhoneState(ctx);
        phonenum = Raon_Usim_Api.ReadPhoneNumber(ctx);
        if (com == 1) {
            try {
                httpdata.clear();
                httpdata.put("ctn", phonenum);
                httpdata.put("com", "2");
                httpdata.put("call_app_pkg", "");
                resHttp = Raon_Http.Send_Data("1003", httpdata);
            }
            catch (Exception e) {
                throw new RaonException(-226, "Error Server Connect");
            }
            if (resHttp.get("retcode") == null) throw new RaonException(-227, "Error Server Response");
            if (resHttp.get("retcode").toString().length() < 1) throw new RaonException(-227, "Error Server Response");
            if (resHttp.get("svc_auth") != null) {
                resHttp.get("svc_auth").toString().equals("1");
            }
            if (resHttp.get("usim_serial") == null) throw new RaonException(-227, "Error Server Response");
            if (resHttp.get("usim_serial").toString().length() <= 0) throw new RaonException(-227, "Error Server Response");
            get_token = resHttp.get("usim_serial").toString();
            RaonLogger.trace("Raon_Usim_Api simSerialNumber SKT : " + get_token);
        } else if (com == 2) {
            telephonyManager = (TelephonyManager)ctx.getSystemService("phone");
            simSerialNumber = telephonyManager.getSimSerialNumber();
            if (simSerialNumber != null) {
                get_token = simSerialNumber;
                RaonLogger.trace("Raon_Usim_Api simSerialNumber" + simSerialNumber);
                RaonLogger.trace("Raon_Usim_Api imsi" + telephonyManager.getSubscriberId());
            } else {
                String imsi = telephonyManager.getSubscriberId();
                if (imsi != null) {
                    get_token = imsi;
                }
            }
        } else if (com == 3) {
            telephonyManager = (TelephonyManager)ctx.getSystemService("phone");
            simSerialNumber = telephonyManager.getSimSerialNumber();
            if (simSerialNumber != null) {
                get_token = simSerialNumber;
                RaonLogger.trace("Raon_Usim_Api simSerialNumber" + simSerialNumber);
                RaonLogger.trace("Raon_Usim_Api imsi" + telephonyManager.getSubscriberId());
            } else {
                String imsi = telephonyManager.getSubscriberId();
                if (imsi != null) {
                    get_token = imsi;
                }
            }
        } else {
            if (com == 100) {
                throw new RaonException(-301, "Not Exist USIM");
            }
            if (com == 101) {
                throw new RaonException(-302, "Not Exist Com");
            }
            if (com == 102) {
                throw new RaonException(-303, "Unknown Com");
            }
        }
        if (get_token == null) throw new RaonException(-229, "Error Server Response");
        if (get_token.length() < 1) {
            throw new RaonException(-229, "Error Server Response");
        }
        KSSha1 d = new KSSha1();
        byte[] byte_token = d.digest(get_token.getBytes());
        get_token = new String(KSBase64.encode((byte[])byte_token));
        return get_token.substring(0, 16);
    }

    public static boolean Raon_CheckPackage(Context ctx) throws RaonException {
        int ret_check_package = -1;
        boolean ret = false;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package == 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Success");
            ret = true;
        } else {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Fail");
            ret = false;
        }
        return ret;
    }

    public static boolean Raon_CheckPin(Context ctx, IRemoteInterface mRemoteInterface, String pin) throws RaonException {
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        boolean ret = true;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Success");
        if (pin.length() != 8) {
            throw new RaonException(-2060, "Pin length is wrong.");
        }
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.check_pin_map(pin);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        RaonLogger.trace("Raon_CheckPin ret_code = " + ret_code);
        if (ret_code != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_CheckPin ret_code != 1 : " + (String)retmap.get("err_msg"));
            if (ret_code == -206) {
                ret_code = (Integer)retmap.get("pwd_cnt");
                RaonLogger.trace("Raon_CheckPin ret_code2 = " + ret_code);
                throw new RaonException(ret_code, ret_msg);
            }
            throw new RaonException(ret_code, ret_msg);
        }
        return true;
    }

    public static int Raon_GetCertcount(Context ctx, IRemoteInterface mRemoteInterface) throws RaonException {
        Map retmap = new HashMap();
        int cert_count = 0;
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertcount CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertcount CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.getCertCount_map();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        cert_count = (Integer)retmap.get("cert_count");
        return cert_count;
    }

    public static GetCertList Raon_GetCertlist(Context ctx, IRemoteInterface mRemoteInterface) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist Start");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        GetCertList certlist = new GetCertList();
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist mRemoteInterface.getCertList_map Start");
            retmap = mRemoteInterface.getCertList_map();
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist mRemoteInterface.getCertList_map End");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap == null) {
            RaonLogger.trace("GetCertList Raon_GetCertlist retmap == null");
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        certlist = (GetCertList)retmap.get("ret");
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist End");
        return certlist;
    }

    public static GetCertList Raon_GetCertlist_Opt(Context ctx, IRemoteInterface mRemoteInterface, String SerialNumber, String cert_issuerDn, String subjectDn) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        GetCertList certlist = new GetCertList();
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt CheckPackage Success");
        String serial_int = String.valueOf(Integer.parseInt(SerialNumber.trim(), 16));
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.getCertList_Filter_map(serial_int, cert_issuerDn, subjectDn);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        certlist = (GetCertList)retmap.get("ret");
        return certlist;
    }

    public static GetCertList Raon_GetCertlist_Opt(Context ctx, IRemoteInterface mRemoteInterface, String subjectDn) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        GetCertList certlist = new GetCertList();
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.getCertList_Filter_SubjectDn(subjectDn);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        certlist = (GetCertList)retmap.get("ret");
        return certlist;
    }

    public static GetCertList Raon_GetCertlist_Filter_SubjectDN(Context ctx, IRemoteInterface mRemoteInterface, String subjectDn) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        GetCertList certlist = new GetCertList();
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.getCertList_Filter_SubjectDn(subjectDn);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        certlist = (GetCertList)retmap.get("ret");
        return certlist;
    }

    public static GetCertList Raon_GetCertlist_Filter_Serial(Context ctx, IRemoteInterface mRemoteInterface, String serial) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Filter_Serial");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        GetCertList certlist = new GetCertList();
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.getCertList_Filter_Serial(serial);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        certlist = (GetCertList)retmap.get("ret");
        return certlist;
    }

    public static GetCertList Raon_GetCertlist_Filter_OID(Context ctx, IRemoteInterface mRemoteInterface, String OID) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        GetCertList certlist = new GetCertList();
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.getCertList_Filter_Oid(OID);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        certlist = (GetCertList)retmap.get("ret");
        return certlist;
    }

    public static GetCertList Raon_GetCertlist_SD(Context ctx, IRemoteInterface mRemoteInterface) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_Opt");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        GetCertList certlist = new GetCertList();
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_SD CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist_SD CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.getCertList_SD_map();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap == null) {
            RaonLogger.trace("GetCertList Raon_GetCertlist retmap == null");
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        certlist = (GetCertList)retmap.get("ret");
        return certlist;
    }

    public static int Raon_GetEmptyRoom(Context ctx, IRemoteInterface mRemoteInterface) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int room_count = 0;
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.getEmptyRoom_map();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        room_count = (Integer)retmap.get("empty_room_count");
        return room_count;
    }

    public static int Raon_IssueCert(Context ctx, IRemoteInterface mRemoteInterface, int ca, String ip, int port, String ref, String authcode, String pin) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int roomnum = 0;
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.Usim_Issue_Cert_map(ca, ip, port, ref, authcode, pin);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        roomnum = (Integer)retmap.get("roomnum");
        return roomnum;
    }

    public static boolean Raon_PutCert(Context ctx, IRemoteInterface mRemoteInterface, String cert, String prvKey, String cert_pwd, String pinnum) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_PutCert");
        Map retmap = new HashMap();
        int ret_check_package = -1;
        int ret_code = 0;
        String ret_msg = "";
        boolean roomnum = false;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_PutCert CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_PutCert CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.putcert_map(cert, prvKey, cert_pwd, pinnum);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        return true;
    }

    public static boolean Raon_PutCert_Filepath(Context ctx, IRemoteInterface mRemoteInterface, String certpath, String cert_pwd, String pinnum) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_PutCert_Filepath");
        Map retmap = new HashMap();
        int ret_check_package = -1;
        int ret_code = 0;
        String ret_msg = "";
        boolean roomnum = false;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_PutCert_Filepath CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_PutCert_Filepath CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.putcert_filepath_map(certpath, cert_pwd, pinnum);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        return true;
    }

    public static GetCertList Raon_GetCert(Context ctx, IRemoteInterface mRemoteInterface, int roomnum) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCert Start");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist mRemoteInterface.getCert_map Start");
            retmap = mRemoteInterface.getCert_map(roomnum);
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist mRemoteInterface.getCert_map End");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        GetCertList cert = (GetCertList)retmap.get("cert");
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist End");
        return cert;
    }

    public static byte[] Raon_GetVidRandom(Context ctx, IRemoteInterface mRemoteInterface, int roomnum) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetVidRandom");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.getVidRandom_map(roomnum);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        String str_vidrandom = (String)retmap.get("vidrandom");
        byte[] byte_vidrandom = KSBase64.decode((String)str_vidrandom);
        return byte_vidrandom;
    }

    public static String Raon_Sign(Context ctx, IRemoteInterface mRemoteInterface, String plain, int roomnum, String pin) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.Usim_Sign_map(plain, roomnum, pin);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        String signed = (String)retmap.get("signed");
        return signed;
    }

    public static String Raon_Sign_P1(Context ctx, IRemoteInterface mRemoteInterface, byte[] plain, int roomnum, String pin) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        String str_plain = null;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_GetCertlist CheckPackage Success");
        str_plain = KSHex.encodeUpper((byte[])plain);
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.Usim_Sign_P1_map(str_plain, roomnum, pin);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            throw new RaonException(ret_code, ret_msg);
        }
        String signed = (String)retmap.get("signed");
        return signed;
    }

    public static String Raon_Sign_P7(Context ctx, IRemoteInterface mRemoteInterface, byte[] plain, int roomnum, String pin) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        String str_plain = null;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7 CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7 CheckPackage Success");
        str_plain = KSHex.encodeUpper((byte[])plain);
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.Usim_Sign_P7_map(str_plain, roomnum, pin);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7 ret_code != 1 : " + (String)retmap.get("err_msg"));
            if (ret_code == -206) {
                ret_code = (Integer)retmap.get("pwd_cnt");
                throw new RaonException(ret_code, ret_msg);
            }
            throw new RaonException(ret_code, ret_msg);
        }
        String signed = (String)retmap.get("signed");
        return signed;
    }

    public static String Raon_Sign_P7_Koscom(Context ctx, IRemoteInterface mRemoteInterface, byte[] plain, int roomnum, String pin) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_Koscom");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        String str_plain = null;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_Koscom CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_Koscom CheckPackage Success");
        str_plain = KSHex.encodeUpper((byte[])plain);
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.Usim_Sign_P7_Koscom(str_plain, roomnum, pin);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7 ret_code != 1 : " + (String)retmap.get("err_msg"));
            if (ret_code == -206) {
                ret_code = (Integer)retmap.get("pwd_cnt");
                throw new RaonException(ret_code, ret_msg);
            }
            throw new RaonException(ret_code, ret_msg);
        }
        String signed = (String)retmap.get("signed");
        return signed;
    }

    public static String Raon_Sign_P1_Koscom_Simple(Context ctx, IRemoteInterface mRemoteInterface, byte[] plain, int roomnum, String pin) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_Koscom");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        String str_plain = null;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P1_Koscom_Simple CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P1_Koscom_Simple CheckPackage Success");
        str_plain = KSHex.encodeUpper((byte[])plain);
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.Usim_Sign_P1_Koscom_Simple(str_plain, roomnum, pin);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7 ret_code != 1 : " + (String)retmap.get("err_msg"));
            if (ret_code == -206) {
                ret_code = (Integer)retmap.get("pwd_cnt");
                throw new RaonException(ret_code, ret_msg);
            }
            throw new RaonException(ret_code, ret_msg);
        }
        String signed = (String)retmap.get("signed");
        return signed;
    }

    public static String Raon_Sign_P7_AddTime(Context ctx, IRemoteInterface mRemoteInterface, byte[] plain, int roomnum, String pin, String time) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddTime");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        String str_plain = null;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddTime CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddTime CheckPackage Success");
        str_plain = KSHex.encodeUpper((byte[])plain);
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.Usim_Sign_P7_addTime_map(str_plain, roomnum, pin, time);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddTime ret_code != 1 : " + (String)retmap.get("err_msg"));
            if (ret_code == -206) {
                ret_code = (Integer)retmap.get("pwd_cnt");
                throw new RaonException(ret_code, ret_msg);
            }
            throw new RaonException(ret_code, ret_msg);
        }
        String signed = (String)retmap.get("signed");
        return signed;
    }

    public static String Raon_Sign_P7_AddTime(Context ctx, IRemoteInterface mRemoteInterface, byte[] plain, int roomnum, String pin, String time, int type_time) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddTime");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        String str_plain = null;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddTime CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddTime CheckPackage Success");
        str_plain = KSHex.encodeUpper((byte[])plain);
        byte[] byte_dec_Origin_Time = KSBase64.decode((String)time);
        String str_Origin_Time = new String(byte_dec_Origin_Time);
        long long_Origin_Time = Long.parseLong(str_Origin_Time);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(long_Origin_Time);
        switch (type_time) {
            case 0: {
                cal.add(10, 0);
                break;
            }
            case 1: {
                cal.add(10, 9);
                break;
            }
            case 2: {
                cal.add(10, 18);
                break;
            }
            default: {
                cal.add(10, 0);
            }
        }
        long long_after_time = cal.getTimeInMillis();
        String str_after_Time = String.valueOf(long_after_time);
        byte[] byte_end_after_Time = KSBase64.encode((byte[])str_after_Time.getBytes());
        String str_end_after_Time = new String(byte_end_after_Time);
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.Usim_Sign_P7_addTime_map(str_plain, roomnum, pin, str_end_after_Time);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddTime ret_code != 1 : " + (String)retmap.get("err_msg"));
            if (ret_code == -206) {
                ret_code = (Integer)retmap.get("pwd_cnt");
                throw new RaonException(ret_code, ret_msg);
            }
            throw new RaonException(ret_code, ret_msg);
        }
        String signed = (String)retmap.get("signed");
        return signed;
    }

    public static String Raon_Sign_P7_AddUnAuthAttr(Context ctx, IRemoteInterface mRemoteInterface, String signedmsg, String oid, byte[] value) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddUnAuthAttr");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddUnAuthAttr CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddUnAuthAttr CheckPackage Success");
        String str_value = new String(KSBase64.encode((byte[])value));
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.addUnAuthAttributesWithSignedDataBase64(signedmsg, oid, str_value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Sign_P7_AddUnAuthAttr ret_code != 1 : " + (String)retmap.get("err_msg"));
            if (ret_code == -206) {
                ret_code = (Integer)retmap.get("pwd_cnt");
                throw new RaonException(ret_code, ret_msg);
            }
            throw new RaonException(ret_code, ret_msg);
        }
        String signed = (String)retmap.get("signed");
        return signed;
    }

    public static boolean Raon_Delete_Cert(Context ctx, IRemoteInterface mRemoteInterface, int roomnum, String pin) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_Delete_Cert");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        Object str_plain = null;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Delete_Cert CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_Delete_Cert CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.Delete_Cert_map(roomnum, pin);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Delete_Cert ret_code != 1 : " + (String)retmap.get("err_msg"));
            if (ret_code == -206) {
                ret_code = (Integer)retmap.get("pwd_cnt");
                throw new RaonException(ret_code, ret_msg);
            }
            throw new RaonException(ret_code, ret_msg);
        }
        return true;
    }

    public static boolean Raon_VerifyVID(Context ctx, IRemoteInterface mRemoteInterface, int roomnum, String pin, String idn) throws RaonException {
        RaonLogger.trace("Raon_Usim_Api Raon_Check_Vid");
        Map retmap = new HashMap();
        int ret_code = 0;
        String ret_msg = "";
        int ret_check_package = -1;
        Object str_plain = null;
        boolean ret_verifyvid = false;
        ret_check_package = Raon_Usim_Api.CheckPackage(ctx);
        if (ret_check_package != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Check_Vid CheckPackage Fail");
            throw new RaonException(ret_check_package, "CheckPackage Fail");
        }
        RaonLogger.trace("Raon_Usim_Api Raon_Check_Vid CheckPackage Success");
        try {
            if (mRemoteInterface == null) {
                throw new RaonException(-999, "mRemoteInterface is null");
            }
            retmap = mRemoteInterface.Verify_VID(roomnum, pin, idn);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (retmap != null) {
            ret_code = (Integer)retmap.get("code");
            ret_msg = (String)retmap.get("ret_msg");
            if (ret_msg == null) {
                ret_msg = "Error";
            }
        } else {
            throw new RaonException(-998, "Not Match aidl");
        }
        if (ret_code != 1) {
            RaonLogger.trace("Raon_Usim_Api Raon_Check_Vid ret_code != 1 : " + (String)retmap.get("err_msg"));
            if (ret_code == -206) {
                ret_code = (Integer)retmap.get("pwd_cnt");
                throw new RaonException(ret_code, ret_msg);
            }
            throw new RaonException(ret_code, ret_msg);
        }
        ret_verifyvid = (Boolean)retmap.get("ret_verifyvid");
        return ret_verifyvid;
    }

    private static String ReadPhoneNumber(Context ctx) {
        String src = null;
        TelephonyManager tm = (TelephonyManager)ctx.getSystemService("phone");
        src = tm.getLine1Number();
        RaonLogger.trace("Raon_Http ReadPhoneNumber Start");
        if (src.length() != 0 && src.charAt(0) == '+') {
            src = src.replace("+82", "0");
        }
        RaonLogger.trace("Raon_Http ReadPhoneNumber Phone Number " + src);
        return src;
    }

    public static int RaonHandleResultCode(int raon_resultcode) {
        int commonResultCode = 0;
        switch (raon_resultcode) {
            case 1: {
                commonResultCode = 0;
                break;
            }
            case -100: {
                commonResultCode = 1;
                break;
            }
            case -101: {
                commonResultCode = 3001;
                break;
            }
            case -102: {
                commonResultCode = 2001;
                break;
            }
            case -103: {
                commonResultCode = 1;
                break;
            }
            case -201: {
                commonResultCode = 1;
                break;
            }
            case -202: {
                commonResultCode = 1;
                break;
            }
            case -203: {
                commonResultCode = 1;
                break;
            }
            case -204: {
                commonResultCode = 7006;
                break;
            }
            case -205: {
                commonResultCode = 1;
                break;
            }
            case -206: {
                commonResultCode = 5001;
                break;
            }
            case -2060: {
                commonResultCode = 5001;
                break;
            }
            case -207: {
                commonResultCode = 1;
                break;
            }
            case -208: {
                commonResultCode = 1;
                break;
            }
            case -209: {
                commonResultCode = 1;
                break;
            }
            case -210: {
                commonResultCode = 1;
                break;
            }
            case -211: {
                commonResultCode = 7010;
                break;
            }
            case -212: {
                commonResultCode = 1;
                break;
            }
            case -213: {
                commonResultCode = 1;
                break;
            }
            case -214: {
                commonResultCode = 1;
                break;
            }
            case -215: {
                commonResultCode = 7013;
                break;
            }
            case -216: {
                commonResultCode = 1;
                break;
            }
            case -217: {
                commonResultCode = 1;
                break;
            }
            case -218: {
                commonResultCode = 1;
                break;
            }
            case -219: {
                commonResultCode = 1;
                break;
            }
            case -220: {
                commonResultCode = 1;
                break;
            }
            case -221: {
                commonResultCode = 1;
                break;
            }
            case -222: {
                commonResultCode = 1;
                break;
            }
            case -223: {
                commonResultCode = 1;
                break;
            }
            case -224: {
                commonResultCode = 1;
                break;
            }
            case -225: {
                commonResultCode = 1;
                break;
            }
            case -226: {
                commonResultCode = 1;
                break;
            }
            case -227: {
                commonResultCode = 1;
                break;
            }
            case -228: {
                commonResultCode = 1;
                break;
            }
            case -229: {
                commonResultCode = 1;
                break;
            }
            case -230: {
                commonResultCode = 1;
                break;
            }
            case -301: {
                commonResultCode = 1;
                break;
            }
            case -302: {
                commonResultCode = 1;
                break;
            }
            case -303: {
                commonResultCode = 1;
                break;
            }
            case -998: {
                commonResultCode = 1;
                break;
            }
            case -999: {
                commonResultCode = 1;
                break;
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: {
                commonResultCode = 5001;
                break;
            }
            case 1010: {
                commonResultCode = 5002;
                break;
            }
            case -2121: {
                commonResultCode = 1;
                break;
            }
            case -2122: {
                commonResultCode = 1;
                break;
            }
            case -2123: {
                commonResultCode = 1;
                break;
            }
            case -2124: {
                commonResultCode = 1;
                break;
            }
            case -2125: {
                commonResultCode = 1;
                break;
            }
            default: {
                commonResultCode = 1;
            }
        }
        return commonResultCode;
    }

    public static byte[] marshall(Parcelable parceable) {
        Parcel parcel = Parcel.obtain();
        parceable.writeToParcel(parcel, 0);
        byte[] bytes = parcel.marshall();
        parcel.recycle();
        return bytes;
    }

    public static Map<String, Object> checkService(int telecom, String phoneno) throws RaonException {
        Map<Object, Object> resHttp = new HashMap();
        HashMap<String, Object> httpdata = new HashMap<String, Object>();
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        httpdata.clear();
        int service_vender = 0;
        int usim_member = 11;
        int service_tp = 201;
        try {
            httpdata.put("service_tp", service_tp);
            httpdata.put("teletype", telecom);
            httpdata.put("ctn", phoneno);
            httpdata.put("sitecode", "607020012");
            httpdata.put("sms_yn", "N");
            resHttp = Raon_Http.Send_Data(String.valueOf(service_tp), httpdata);
        }
        catch (Exception e) {
            throw new RaonException(-226, "Error Server Connect");
        }
        if (resHttp.get("retcode") != null && resHttp.get("retcode").toString().length() >= 1) {
            if (resHttp.get("retcode").equals("000")) {
                int cp_cd = 0;
                if (resHttp.get("join_cp_cd") != null && resHttp.get("join_cp_cd").toString().length() > 0) {
                    cp_cd = Integer.parseInt((String)resHttp.get("join_cp_cd"));
                }
                service_vender = cp_cd;
                usim_member = resHttp.get("join_yn").equals("Y") ? 12 : (resHttp.get("join_yn").equals("N") ? 13 : (resHttp.get("join_yn").equals("U") ? 15 : (resHttp.get("join_yn").equals("P") ? 14 : 14)));
            } else {
                usim_member = 11;
                service_vender = 0;
            }
        } else {
            throw new RaonException(-227, "Error Server Response");
        }
        retValue.put("service_vender", service_vender);
        retValue.put("usim_member", usim_member);
        return retValue;
    }
}

