/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.stream.a;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class JsonWriter
implements Closeable {
    private final Writer a;
    private final List<a> b = new ArrayList<a>();
    private String c;
    private String d;
    private boolean e;
    private boolean f;
    private String g;
    private boolean h;

    public JsonWriter(Writer out) {
        this.b.add(com.google.gson.stream.a.f);
        this.d = ":";
        this.h = true;
        if (out == null) {
            throw new NullPointerException("out == null");
        }
        this.a = out;
    }

    public final void setIndent(String indent) {
        if (indent.length() == 0) {
            this.c = null;
            this.d = ":";
        } else {
            this.c = indent;
            this.d = ": ";
        }
    }

    public final void setLenient(boolean lenient) {
        this.e = lenient;
    }

    public boolean isLenient() {
        return this.e;
    }

    public final void setHtmlSafe(boolean htmlSafe) {
        this.f = htmlSafe;
    }

    public final boolean isHtmlSafe() {
        return this.f;
    }

    public final void setSerializeNulls(boolean serializeNulls) {
        this.h = serializeNulls;
    }

    public final boolean getSerializeNulls() {
        return this.h;
    }

    public JsonWriter beginArray() throws IOException {
        this.b();
        return this.a(com.google.gson.stream.a.a, "[");
    }

    public JsonWriter endArray() throws IOException {
        return this.a(com.google.gson.stream.a.a, com.google.gson.stream.a.b, "]");
    }

    public JsonWriter beginObject() throws IOException {
        this.b();
        return this.a(com.google.gson.stream.a.c, "{");
    }

    public JsonWriter endObject() throws IOException {
        return this.a(com.google.gson.stream.a.c, com.google.gson.stream.a.e, "}");
    }

    private JsonWriter a(a empty, String openBracket) throws IOException {
        this.a(true);
        this.b.add(empty);
        this.a.write(openBracket);
        return this;
    }

    private JsonWriter a(a empty, a nonempty, String closeBracket) throws IOException {
        a context = this.a();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem: " + this.b);
        }
        if (this.g != null) {
            throw new IllegalStateException("Dangling name: " + this.g);
        }
        this.b.remove(this.b.size() - 1);
        if (context == nonempty) {
            this.c();
        }
        this.a.write(closeBracket);
        return this;
    }

    private a a() {
        return this.b.get(this.b.size() - 1);
    }

    private void a(a topOfStack) {
        this.b.set(this.b.size() - 1, topOfStack);
    }

    public JsonWriter name(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.g != null) {
            throw new IllegalStateException();
        }
        this.g = name;
        return this;
    }

    private void b() throws IOException {
        if (this.g != null) {
            this.d();
            this.a(this.g);
            this.g = null;
        }
    }

    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.b();
        this.a(false);
        this.a(value);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        if (this.g != null) {
            if (this.h) {
                this.b();
            } else {
                this.g = null;
                return this;
            }
        }
        this.a(false);
        this.a.write("null");
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.b();
        this.a(false);
        this.a.write(value ? "true" : "false");
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.b();
        this.a(false);
        this.a.append(Double.toString(value));
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.b();
        this.a(false);
        this.a.write(Long.toString(value));
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.b();
        String string = value.toString();
        if (!this.e && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.a(false);
        this.a.append(string);
        return this;
    }

    public void flush() throws IOException {
        this.a.flush();
    }

    public void close() throws IOException {
        this.a.close();
        if (this.a() != com.google.gson.stream.a.g) {
            throw new IOException("Incomplete document");
        }
    }

    private void a(String value) throws IOException {
        this.a.write("\"");
        int length = value.length();
        block10: for (int i = 0; i < length; ++i) {
            char c2 = value.charAt(i);
            switch (c2) {
                case '\"': 
                case '\\': {
                    this.a.write(92);
                    this.a.write(c2);
                    continue block10;
                }
                case '\t': {
                    this.a.write("\\t");
                    continue block10;
                }
                case '\b': {
                    this.a.write("\\b");
                    continue block10;
                }
                case '\n': {
                    this.a.write("\\n");
                    continue block10;
                }
                case '\r': {
                    this.a.write("\\r");
                    continue block10;
                }
                case '\f': {
                    this.a.write("\\f");
                    continue block10;
                }
                case '&': 
                case '\'': 
                case '<': 
                case '=': 
                case '>': {
                    if (this.f) {
                        this.a.write(String.format("\\u%04x", c2));
                        continue block10;
                    }
                    this.a.write(c2);
                    continue block10;
                }
                case '\u2028': 
                case '\u2029': {
                    this.a.write(String.format("\\u%04x", c2));
                    continue block10;
                }
                default: {
                    if (c2 <= '\u001f') {
                        this.a.write(String.format("\\u%04x", c2));
                        continue block10;
                    }
                    this.a.write(c2);
                }
            }
        }
        this.a.write("\"");
    }

    private void c() throws IOException {
        if (this.c == null) {
            return;
        }
        this.a.write("\n");
        for (int i = 1; i < this.b.size(); ++i) {
            this.a.write(this.c);
        }
    }

    private void d() throws IOException {
        a context = this.a();
        if (context == com.google.gson.stream.a.e) {
            this.a.write(44);
        } else if (context != com.google.gson.stream.a.c) {
            throw new IllegalStateException("Nesting problem: " + this.b);
        }
        this.c();
        this.a(com.google.gson.stream.a.d);
    }

    private void a(boolean root) throws IOException {
        switch (this.a()) {
            case f: {
                if (!this.e && !root) {
                    throw new IllegalStateException("JSON must start with an array or an object.");
                }
                this.a(com.google.gson.stream.a.g);
                break;
            }
            case a: {
                this.a(com.google.gson.stream.a.b);
                this.c();
                break;
            }
            case b: {
                this.a.append(',');
                this.c();
                break;
            }
            case d: {
                this.a.append(this.d);
                this.a(com.google.gson.stream.a.e);
                break;
            }
            case g: {
                throw new IllegalStateException("JSON must have only one top-level value.");
            }
            default: {
                throw new IllegalStateException("Nesting problem: " + this.b);
            }
        }
    }
}

