/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecurekeypad;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.softforum.xecurekeypad.XKConstants;
import com.softforum.xecurekeypad.XKCoreWrapper;
import com.softforum.xecurekeypad.XKKeypadCustomInterface;
import com.softforum.xecurekeypad.XKKeypadFullView;
import com.softforum.xecurekeypad.XKKeypadView;
import com.softforum.xecurekeypad.XKParcelableParams;
import java.util.HashMap;
import java.util.Map;

public class XKEditText
extends EditText {
    private static Map<String, XKCoreWrapper> mCoreMap = new HashMap<String, XKCoreWrapper>();
    private Activity mActivity = null;
    private Activity mXKKeypadViewActivity = null;
    private int mXKType = 0;
    private int mXKViewType = 0;
    private int mXKInputMaxLength = 0;
    private int mXKBackgroundID = 0;
    private int mXKBackgroundAlpha = -1;
    private XKCoreWrapper mXKCoreWrapper = null;
    private String mSessionID = null;
    private String mE2EURL = null;
    private String mSubTitle = null;
    private Drawable mXKBlankLogoImage = null;
    private int mLayoutIdentifier = -1;
    private View mViewIncludeEditText = null;
    private boolean mUseFocus = true;
    private boolean mUseFocusableInTouchMode = true;
    private boolean mUseInputButton = false;
    private XKKeypadCustomInterface mXKKeypadCustomInterface = null;

    public XKEditText(Context pContext) {
        super(pContext);
        this.initialize(pContext);
    }

    public XKEditText(Context pContext, AttributeSet pAttributeSet) {
        super(pContext, pAttributeSet);
        this.initialize(pContext);
    }

    public XKEditText(Context pContext, AttributeSet pAttributeSet, int pDefStyle) {
        super(pContext, pAttributeSet, pDefStyle);
        this.initialize(pContext);
    }

    private void initialize(Context pContext) {
        this.mSessionID = String.valueOf(((Object)((Object)this)).hashCode());
        this.mActivity = (Activity)pContext;
        this.mXKType = 1;
        this.mXKInputMaxLength = XKConstants.XKKeypadDefaultMaxLength;
        this.mXKCoreWrapper = mCoreMap.get(String.valueOf(this.mSessionID));
        if (this.mXKCoreWrapper == null) {
            this.mXKCoreWrapper = new XKCoreWrapper(this.mSessionID);
        }
        if (mCoreMap.containsKey(String.valueOf(this.mSessionID))) {
            mCoreMap.remove(String.valueOf(this.mSessionID));
        }
        mCoreMap.put(String.valueOf(this.mSessionID), this.mXKCoreWrapper);
        this.mXKCoreWrapper.setUseSessionRefresh(true);
        this.setEvent();
    }

    public void setFocus() {
        this.setFocusableInTouchMode(this.mUseFocusableInTouchMode);
        this.setFocusable(this.mUseFocus);
    }

    private void setEvent() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XKEditText.this.mUseFocus = XKEditText.this.isFocusable();
                XKEditText.this.mUseFocusableInTouchMode = XKEditText.this.isFocusableInTouchMode();
                if (XKEditText.this.mUseFocus || XKEditText.this.mUseFocusableInTouchMode) {
                    XKEditText.this.hideSoftKeyboard(v);
                    XKEditText.this.startKeypad();
                } else {
                    XKEditText.this.setFocusableInTouchMode(true);
                    XKEditText.this.setFocusable(true);
                    XKEditText.this.requestFocus();
                }
            }
        });
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int aInputType = XKEditText.this.getInputType();
                XKEditText.this.setInputType(0);
                XKEditText.this.onTouchEvent(event);
                XKEditText.this.setInputType(aInputType);
                return true;
            }
        });
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    XKEditText.this.hideSoftKeyboard(v);
                    XKEditText.this.startKeypad();
                }
            }
        });
    }

    public void setXKKeypadCustomInterface(XKKeypadCustomInterface pXKKeypadCustomInterface) {
        this.mXKKeypadCustomInterface = pXKKeypadCustomInterface;
    }

    public XKKeypadCustomInterface getXKKeypadCustomInterface() {
        return this.mXKKeypadCustomInterface;
    }

    public void setXKKeypadViewActivity(Activity pXKKeypadViewActivity) {
        this.mXKKeypadViewActivity = pXKKeypadViewActivity;
    }

    public void inputComplete() {
        this.mXKKeypadViewActivity.finish();
    }

    public void inputCancel() {
        this.mXKKeypadViewActivity.onBackPressed();
    }

    public String getKeypadID() {
        return this.mSessionID;
    }

    public void setUseInputButton(boolean pUseInputButton) {
        this.mUseInputButton = pUseInputButton;
    }

    public boolean getUseInputButton() {
        return this.mUseInputButton;
    }

    public void setXKKeypadType(int pXKKeypadType) {
        this.mXKType = pXKKeypadType;
    }

    public int getKeypadType() {
        return this.mXKType;
    }

    public void setXKViewType(int pXKViewType) {
        this.mXKViewType = pXKViewType;
    }

    public int getKeypadViewType() {
        return this.mXKViewType;
    }

    public void setXKKeypadMaxLength(int pXKKeypadMaxLength) {
        this.mXKInputMaxLength = pXKKeypadMaxLength;
    }

    public int getKeypadMaxLength() {
        return this.mXKInputMaxLength;
    }

    public void setE2EURL(String pE2EURL) {
        this.mE2EURL = pE2EURL;
    }

    public String getE2EURL() {
        return this.mE2EURL;
    }

    public void setLayoutIdentifier(int pLayoutIdentifier) {
        this.mLayoutIdentifier = pLayoutIdentifier;
    }

    public int getLayoutIdentifier() {
        return this.mLayoutIdentifier;
    }

    public void setViewIncludeEditText(View pViewIncludeEditText) {
        this.mViewIncludeEditText = pViewIncludeEditText;
    }

    public View getViewIncludeEditText() {
        return this.mViewIncludeEditText;
    }

    public void setSubTitle(String pSubTitle) {
        this.mSubTitle = pSubTitle;
    }

    public String getSubTitle() {
        return this.mSubTitle;
    }

    public void setBackground(int pBackgroundID, int pAlpha) {
        this.mXKBackgroundID = pBackgroundID;
        this.mXKBackgroundAlpha = pAlpha;
    }

    public int getBackgroundID() {
        return this.mXKBackgroundID;
    }

    public int getBackgroundAlpha() {
        return this.mXKBackgroundAlpha;
    }

    public void setBlankLogoImage(Drawable pBlankLogoImage) {
        this.mXKBlankLogoImage = pBlankLogoImage;
    }

    public void setXKCoreWrapper(XKCoreWrapper pXKCoreWrapper) {
        this.mXKCoreWrapper = pXKCoreWrapper;
    }

    public String getData() {
        String aUnpackedData = null;
        aUnpackedData = this.mXKCoreWrapper != null ? this.mXKCoreWrapper.getUnpackedData() : "";
        return aUnpackedData;
    }

    public String getEncryptedData(byte[] pRandomValue) {
        String aEncryptedData = null;
        aEncryptedData = this.mXKCoreWrapper != null ? this.mXKCoreWrapper.getEncryptedData(pRandomValue) : "";
        return aEncryptedData;
    }

    public String getDataE2E() {
        String aPackedData = null;
        aPackedData = this.mXKCoreWrapper != null ? this.mXKCoreWrapper.getpackedData() : "";
        return aPackedData;
    }

    public String getE2ESessionID() {
        String aE2ESessionID = null;
        aE2ESessionID = this.mXKCoreWrapper.getE2ESessionID();
        return aE2ESessionID;
    }

    public String getE2EToken() {
        String aE2EToken = null;
        aE2EToken = this.mXKCoreWrapper.getE2EToken();
        return aE2EToken;
    }

    private void hideSoftKeyboard(View v) {
        this.mActivity.getWindow().setSoftInputMode(3);
        ((InputMethodManager)super.getContext().getSystemService("input_method")).hideSoftInputFromWindow(v.getWindowToken(), 0);
    }

    public void startKeypad() {
        DoProgress aDoProgress = null;
        aDoProgress = new DoProgress(this);
        if (Build.VERSION.SDK_INT >= 11) {
            aDoProgress.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            aDoProgress.execute(new Void[0]);
        }
    }

    private class DoProgress
    extends AsyncTask<Void, Void, Void> {
        private XKEditText mXKEditText = null;
        private Intent mIntent = null;
        private ProgressDialog mProgressDialog = null;

        public DoProgress(XKEditText pXKEditText) {
            this.mXKEditText = pXKEditText;
        }

        protected void onPreExecute() {
            this.mProgressDialog = new ProgressDialog((Context)XKEditText.this.mActivity);
            this.mProgressDialog.setMessage((CharSequence)"\ubcf4\uc548\ud0a4\ud328\ub4dc\ub97c \ud638\ucd9c\ud569\ub2c8\ub2e4");
            this.mProgressDialog.setIndeterminate(true);
            this.mProgressDialog.setCanceledOnTouchOutside(false);
            this.mProgressDialog.setCancelable(true);
            this.mProgressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    dialog.dismiss();
                    DoProgress.this.cancel(true);
                }
            });
            this.mProgressDialog.show();
            super.onPreExecute();
        }

        protected Void doInBackground(Void ... params) {
            XKParcelableParams aXKParcelableParams = null;
            aXKParcelableParams = new XKParcelableParams(XKEditText.this.mXKCoreWrapper, this.mXKEditText, XKEditText.this.mActivity, XKEditText.this.mXKBlankLogoImage);
            this.mIntent = XKEditText.this.mXKViewType == 1 ? new Intent((Context)XKEditText.this.mActivity, XKKeypadFullView.class) : new Intent((Context)XKEditText.this.mActivity, XKKeypadView.class);
            this.mIntent.putExtra(XKConstants.XKKeypadParcelableParams, (Parcelable)aXKParcelableParams);
            return null;
        }

        protected void onPostExecute(Void aResult) {
            XKEditText.this.mActivity.startActivityForResult(this.mIntent, XKConstants.XKKeypadRequestCode);
            this.mProgressDialog.dismiss();
            this.cancel(true);
            super.onPostExecute((Object)aResult);
        }

        protected void onCancelled() {
            this.mProgressDialog.dismiss();
            this.cancel(true);
            super.onCancelled();
        }
    }
}

