/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.util;

public class XDetailData {
    public static final int TYPE_CERT = 0;
    public static final int TYPE_SESSION = 1;
    public static final int TYPE_SESSION_DETAIL = 2;
    public static final int TYPE_CERT_SIMPLE = 3;
    public static final int TYPE_USIM_CERT = 4;
    private int mMediaID;
    private int mDataType;
    private String[] mKeyTextArray;
    private String[] mValueArray;

    public XDetailData(String source, int dataType) {
        this.mValueArray = source.split("\\$");
        this.mDataType = dataType;
        this.setKeyTexts(dataType);
    }

    public XDetailData(String source, int dataType, int mediaID) {
        this.mValueArray = source.split("\\$");
        this.mDataType = dataType;
        this.mMediaID = mediaID;
        this.setKeyTexts(dataType);
    }

    public XDetailData(String[] source, int dataType) {
        int aIndexCount = 0;
        int aArrayLength = 0;
        aArrayLength = source.length;
        this.mValueArray = new String[aArrayLength];
        for (aIndexCount = 0; aIndexCount < aArrayLength; ++aIndexCount) {
            this.mValueArray[aIndexCount] = source[aIndexCount];
        }
        this.mDataType = dataType;
        this.setKeyTexts(dataType);
    }

    private void setKeyTexts(int dataType) {
        switch (dataType) {
            case 0: {
                this.mKeyTextArray = new String[]{"\uc0c1\ud0dc", "\ubc84\uc804", "\uc77c\ub828\ubc88\ud638", "\uc11c\uba85 \uc54c\uace0\ub9ac\uc998", "\ubc1c\uae09\uc790", "\ubc1c\uae09\uc77c", "\ub9cc\ub8cc\uc77c", "\uc8fc\uccb4", "\uacf5\uac1c\ud0a4 \uc54c\uace0\ub9ac\uc998", "\uacf5\uac1c\ud0a4", "\uc11c\uba85", "\uc8fc\uccb4 \ud0a4 \uc2dd\ubcc4\uc790", "\uc778\uc99d\uc11c \uc815\ucc45", "\ud0a4\uc0ac\uc6a9", "\uae30\ubcf8 \uaddc\uc81c", "\uc8fc\uccb4 \ub300\uccb4 \uc774\ub984", "CRL \ubd84\ubc30\uc810", "\uc0ac\uc6a9\uc790 \uc54c\ub9bc", "CPS", "\uae30\uad00\uc815\ubcf4 \uc561\uc138\uc2a4"};
                break;
            }
            case 3: {
                this.mKeyTextArray = new String[]{"\uc0c1\ud0dc", "\uc778\uc99d\uc11c \uc815\ucc45", "\ubc1c\uae09\uc790", "\uc8fc\uccb4", "\ub9cc\ub8cc\uc77c", "\ubc1c\uae09\uc790 \uc804\uccb4\uc774\ub984", "\uc77c\ub828\ubc88\ud638"};
                break;
            }
            case 4: {
                this.mKeyTextArray = new String[]{"\uc0c1\ud0dc", "\uc778\uc99d\uc11c \uc815\ucc45", "\uc8fc\uccb4", "\ubc1c\uae09\uae30\uad00", "\ubc1c\uae09\uc77c", "\ub9cc\ub8cc\uc77c", "\ubc1c\uae09\uc790", "\uc77c\ub828\ubc88\ud638"};
                break;
            }
            case 1: {
                this.mKeyTextArray = new String[]{"\uc0c1\ud0dc", "DN", "CN"};
                break;
            }
            case 2: {
                this.mKeyTextArray = new String[]{"\uc138\uc158 \uc0c1\ud0dc", "\uc5f0\uacb0 \uc2dc\uac04", "\uc11c\ubc84 \uc778\uc99d\uc11c", "\uc0ac\uc6a9\uc790 \uc778\uc99d\uc11c"};
                break;
            }
        }
    }

    public String getKeyText(int key) {
        String ret = null;
        try {
            ret = this.mKeyTextArray[key];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ret = "";
        }
        return ret;
    }

    public String getValue(int key) {
        String ret = null;
        try {
            ret = this.mValueArray[key];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ret = "";
        }
        return ret;
    }

    public int getLength() {
        return this.mValueArray.length;
    }

    public String[] getValueArray() {
        int aIndexCount = 0;
        int aArrayLength = 0;
        String[] aValueArray = null;
        aArrayLength = this.mValueArray.length;
        aValueArray = new String[aArrayLength];
        for (aIndexCount = 0; aIndexCount < aArrayLength; ++aIndexCount) {
            aValueArray[aIndexCount] = this.mValueArray[aIndexCount];
        }
        return aValueArray;
    }

    public int getDataType() {
        return this.mDataType;
    }

    public int getMediaID() {
        return this.mMediaID;
    }

    public static class SESSION_DETAIL_KEY {
        public static final int SESSION_DETAIL_STATE = 0;
        public static final int SESSION_DETAIL_START_TIME = 1;
        public static final int SESSION_DETAIL_SERVER_CERT = 2;
        public static final int SESSION_DETAIL_USER_CERT = 3;
    }

    public static class SESSION_KEY {
        public static final int XGATE_ADDR = 0;
        public static final int DN = 1;
        public static final int CN = 2;
    }

    public static class CERT_KEY_USIM {
        public static final int STATE = 0;
        public static final int POLICY_ID = 1;
        public static final int SUBJECT_RDN = 2;
        public static final int ISSUER_NAME = 3;
        public static final int FROM = 4;
        public static final int TO = 5;
        public static final int ISSUER_RDN = 6;
        public static final int SERIAL = 7;
    }

    public static class CERT_KEY_SIMPLE {
        public static final int STATE = 0;
        public static final int POLICY_ID = 1;
        public static final int SUBJECT_RDN = 2;
        public static final int ISSUER_RDN = 3;
        public static final int TO = 4;
        public static final int ISSUER_RDN_FULL = 5;
        public static final int SERIAL = 6;
    }

    public static class CERT_KEY {
        public static final int STATE = 0;
        public static final int VERSION = 1;
        public static final int SERIAL = 2;
        public static final int SIGNATURE_ALG_DESC = 3;
        public static final int ISSUER_RDN = 4;
        public static final int FROM = 5;
        public static final int TO = 6;
        public static final int SUBJECT_RDN = 7;
        public static final int SUBJECT_KEY_ALG_DESC = 8;
        public static final int SUBJECT_PUBLIC_KEY = 9;
        public static final int SIGNATURE = 10;
        public static final int AUTHORITY_KEY_ID = 11;
        public static final int POLICY_ID = 12;
        public static final int SUBJECT_ALT_NAME = 13;
        public static final int KEY_USAGE_DESC = 14;
        public static final int BASIC_CONSTRAINTS = 15;
        public static final int CRL_DISTRIBUTION_POINTS = 16;
        public static final int USER_NOTICE = 17;
        public static final int CPS_URI = 18;
        public static final int AIAS = 19;
    }
}

