/*
 * Decompiled with CFR 0.152.
 */
package kr.or.kftc.crypto;

import kr.or.kftc.crypto.HSMCryptException;
import kr.or.kftc.mobiletoken_lib.util.LibLog;

public class RSAPublicKey {
    static final String TAG = RSAPublicKey.class.getSimpleName();
    private int keyLength = 0;
    private byte[] n = null;
    private byte[] e = null;

    public RSAPublicKey(byte[] pubKeyData) throws HSMCryptException {
        try {
            if (pubKeyData == null) {
                throw new HSMCryptException("'pubKeyData' can't be null", 4049);
            }
            if (pubKeyData[0] != 1) {
                throw new HSMCryptException("Invalid key type field", 4049);
            }
            switch (pubKeyData[1]) {
                case 32: 
                case 64: {
                    this.keyLength = pubKeyData[1] * 4;
                    break;
                }
                default: {
                    throw new HSMCryptException("Invalid key length field", 4049);
                }
            }
            if (pubKeyData.length < 2 + this.keyLength + 4) {
                throw new HSMCryptException("Invalid key length", 4049);
            }
            this.n = new byte[this.keyLength];
            System.arraycopy(pubKeyData, 2, this.n, 0, this.keyLength);
            this.e = new byte[4];
            System.arraycopy(pubKeyData, 2 + this.keyLength, this.e, 0, 4);
        }
        catch (HSMCryptException e) {
            LibLog.e(TAG, "!! RSAPublicKey Constructor Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public byte[] getModulus() {
        return this.n;
    }

    public byte[] getExponent() {
        return this.e;
    }
}

