package com.dreamsecurity.usim.smartcert3rd;

import com.dreamsecurity.usim.smartcert3rd.SmartCertSignType;
import com.dreamsecurity.usim.smartcert3rd.SmartCertSignOption;
import com.dreamsecurity.usim.smartcert3rd.SmartCertKeyPairAlg;
import com.dreamsecurity.usim.smartcert3rd.SmartCertResult;
import com.dreamsecurity.usim.smartcert3rd.SmartCertSignAlg;
import com.dreamsecurity.usim.smartcert3rd.SmartCertInfoType;
import com.dreamsecurity.usim.smartcert3rd.SmartCertBag;
import com.dreamsecurity.usim.smartcert3rd.SmartCertFilterType;

interface SmartCertAidlService {

    //서비스 가능한 상태 확인
    SmartCertResult isServiceValid(in boolean isUseVaccine, in String packageName, in String ip, in int port);
    
    //결과
    SmartCertResult getResultCode();
    
    //버전정보
    //String getVersionInfo();
    
    //마지막 예외 메시지
    String getLastExceptions();
    
    //인증서 리스트
    void setOIDPolicy(in String oidPolicy, in String packageName); 

    //인증서 갯수 확인
    int getMaxCertCount();
    int getCertCount(in String packageName);
    int getMaxPinLen();
    int getMinPinLen();
    int getRetryPinCount();
    boolean isPinLocked();

    //인증서 리스트 
    byte[] getCertificate(in int index, in String packageName);
    
    String getDNAttributeValue(in String dn, in String dnAttribute);
    String[] getDNAttributeValues(in String dn, in String dnAttribute);
    
    String getIssuerDN(in int index, in String packageName);
    String getSubjectDN(in int index, in String packageName);
    String getExpiredDate(in int index, in String packageName);
    String getValidStartDate(in int index, in String packageName);
    String getCertificatePolicy(in int index, in boolean valueType, in String packageName);

    //전자서명
    SmartCertResult login(in byte[] pin);
    void logout();
    byte[] getVIDRandom(in int index, in String packageName);
    String getVIDRandomBase64(in int index, in String packageName);
    boolean verifyID(in int index, in byte[] idNumber, in String packageName);
    
    byte[] getSignedData(in int index, in SmartCertSignType signType, in SmartCertSignOption signOption, in byte[] tobeSignData, in String strTime, in String packageName);
    String getSignedDataBase64(in int index, in SmartCertSignType signType, in SmartCertSignOption signOption, in byte[] tobeSignData, in String strTime, in String packageName);
    SmartCertResult writeCertAndPriKey (in byte[] certificate, in byte[] prikeyPassword, in byte[] priKey, in String packageName);
    boolean possibleKeyGen();
    byte[] genKeyPair(in SmartCertKeyPairAlg algType);
    byte[] getPublicKey(in byte[] keyId);
    byte[] getSignature(in byte[] keyId, in SmartCertSignAlg signAlg,in byte[] tobeSignData);
    SmartCertResult writeCertificate(in byte[] keyId, in byte[] certificate, in String packageName);
    SmartCertResult deleteCertAndPriKey(in int index, in String packageName);
    
    int getRegisterSessionTimout();
    String getRegisterURL();
    String getUpdateURL();
    SmartCertResult getIsServiceValidState();
    int getUpdateState();
    
    void addUnSignedAttribute(in String oid, in byte[] oidValue);
    
    byte[] addUnSignedAttributeWithSignedData(in byte[] signedData);
    String addUnSignedAttributeWithSignedDataBase64(in String signedDataBase64);
    
    String getSubjectAltName(in int index, in String packageName);
    
    String getSerialNumber(in int index, in String packageName);
    
    int findCertIndex(in String issuerDN, in String subjectDN, in String serialNum, in String packageName);
    
    boolean isInitPin();
    
    String getTokenInfo(in SmartCertInfoType tokenInfoType);
    
    SmartCertBag readCertFromSD(in String path);
    
    SmartCertResult deleteSDMemoryCert(in String path);
    
    void setFilter(in SmartCertFilterType filterType, in String values, in String packageName);
}