/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.XSFileDownload;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.XSLog;

public class XecureSmartFileDownload
extends Activity {
    public static final String mSessionIDKey = "session_id_key";
    public static final String mXaddrKey = "xaddr_key";
    public static final String mPathKey = "path_key";
    public static final String mQueryStringKey = "query_string_key";
    public static final String mHostNameKey = "host_name_key";
    public static final String mPortKey = "port_key";
    public static final String mTargetFilePathKey = "target_file_path_key";
    public static final String mDownloadPathKey = "download_file_path_key";
    public static final String mEn_cStringKey = "en_c_string_key";
    public static final String mResultKey = "result_key";
    public static final String mCookie = "cookie_key";
    private static final int mStatusStartProgress = 1;
    private static final int mStatusOnProgress = 2;
    private static final int mStatusDone = 3;
    private static final int mStatusCanceled = 4;
    private boolean mIsCanceled = false;
    private long mSessionID;
    private String mXaddr;
    private String mPath;
    private String mQueryString;
    private String mHostName;
    private int mPort;
    private String mTargetFilePath;
    private String mDownloadPath;
    private String mEncString;
    private String mResult = "";
    private String mCookieString = null;
    private BlockerActivityResult mBlockerParam;
    private XSFileDownload mXSFileDownload;
    private TextView mTextViewMsg;
    private ProgressBar mProgressBar;
    private TextView mTextViewFileName;
    private TextView mTextViewPercent;
    private Button mCancelButton;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Thread statusThread = new Thread(new setProgressRunnable());
                    statusThread.start();
                    break;
                }
                case 2: {
                    XecureSmartFileDownload.this.mTextViewFileName.setText((CharSequence)XecureSmartFileDownload.this.mXSFileDownload.getFileName());
                    int aPercent = XecureSmartFileDownload.this.mXSFileDownload.getPercent();
                    XecureSmartFileDownload.this.mProgressBar.setProgress(aPercent);
                    XecureSmartFileDownload.this.mTextViewPercent.setText((CharSequence)(String.valueOf(aPercent) + "%"));
                    break;
                }
                case 3: {
                    XecureSmartFileDownload.this.finish();
                }
                case 4: {
                    XecureSmartFileDownload.this.mIsCanceled = true;
                    XecureSmartFileDownload.this.finish();
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.file_progress_dialog);
        Intent receivedIntent = this.getIntent();
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        this.mSessionID = receivedIntent.getLongExtra(mSessionIDKey, -1L);
        this.mXaddr = receivedIntent.getStringExtra(mXaddrKey);
        this.mPath = receivedIntent.getStringExtra(mPathKey);
        this.mQueryString = receivedIntent.getStringExtra(mQueryStringKey);
        this.mHostName = receivedIntent.getStringExtra(mHostNameKey);
        this.mPort = receivedIntent.getIntExtra(mPortKey, -1);
        this.mTargetFilePath = receivedIntent.getStringExtra(mTargetFilePathKey);
        this.mDownloadPath = receivedIntent.getStringExtra(mDownloadPathKey);
        this.mEncString = receivedIntent.getStringExtra(mEn_cStringKey);
        try {
            this.mCookieString = receivedIntent.getStringExtra(mCookie);
        }
        catch (Exception e) {
            XSLog.i((String)"Cookie not Receive");
        }
        this.mXSFileDownload = new XSFileDownload(this.mSessionID);
        this.mTextViewMsg = (TextView)this.findViewById(R.id.file_progress_msg);
        this.mTextViewMsg.setText(R.string.file_download_progress);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.file_progress_bar);
        this.mProgressBar.setMax(100);
        this.mProgressBar.setProgress(0);
        this.mTextViewFileName = (TextView)this.findViewById(R.id.file_progress_name);
        this.mTextViewPercent = (TextView)this.findViewById(R.id.file_progress_percent);
        this.mCancelButton = (Button)this.findViewById(R.id.file_progress_cancel_btn);
        this.mCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartFileDownload.this.onCancelButtonClick(v);
            }
        });
        this.runFileDownload();
    }

    private void onCancelButtonClick(View v) {
        this.mXSFileDownload.cancel();
    }

    private void runFileDownload() {
        Thread uploadThread = new Thread(new FileDownloadRunnable());
        uploadThread.start();
    }

    public void finish() {
        Intent aIntent = new Intent((Context)this, XecureSmartFileDownload.class);
        aIntent.putExtra(mResultKey, this.mResult);
        if (this.mResult != null && this.mResult.length() > 0) {
            this.mBlockerParam.setBlockerResult(-1, aIntent);
        } else {
            this.mBlockerParam.setBlockerResult(0, aIntent);
        }
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }

    private class setProgressRunnable
    implements Runnable {
        private setProgressRunnable() {
        }

        @Override
        public void run() {
            while (!XecureSmartFileDownload.this.mIsCanceled) {
                XecureSmartFileDownload.this.mHandler.sendEmptyMessage(2);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    XSLog.e((String)"InterruptedException in progress");
                }
            }
        }
    }

    private class FileDownloadRunnable
    implements Runnable {
        private FileDownloadRunnable() {
        }

        @Override
        public void run() {
            XecureSmartFileDownload.this.mHandler.sendEmptyMessage(1);
            if (XecureSmartFileDownload.this.mCookieString == null || XecureSmartFileDownload.this.mCookieString == "") {
                XecureSmartFileDownload.this.mResult = XecureSmartFileDownload.this.mXSFileDownload.downloadFile(XecureSmartFileDownload.this.mXaddr, XecureSmartFileDownload.this.mPath, XecureSmartFileDownload.this.mQueryString, XecureSmartFileDownload.this.mHostName, XecureSmartFileDownload.this.mPort, XecureSmartFileDownload.this.mTargetFilePath, XecureSmartFileDownload.this.mDownloadPath, XecureSmartFileDownload.this.mEncString, 0);
            } else {
                XecureSmartFileDownload.this.mResult = XecureSmartFileDownload.this.mXSFileDownload.downloadFile(XecureSmartFileDownload.this.mXaddr, XecureSmartFileDownload.this.mPath, XecureSmartFileDownload.this.mQueryString, XecureSmartFileDownload.this.mHostName, XecureSmartFileDownload.this.mPort, XecureSmartFileDownload.this.mTargetFilePath, XecureSmartFileDownload.this.mDownloadPath, XecureSmartFileDownload.this.mEncString, XecureSmartFileDownload.this.mCookieString, 0);
            }
            if (XecureSmartFileDownload.this.mResult != null && XecureSmartFileDownload.this.mResult.length() > 0) {
                XecureSmartFileDownload.this.mHandler.sendEmptyMessage(3);
            } else {
                XecureSmartFileDownload.this.mHandler.sendEmptyMessage(4);
            }
        }
    }
}

