/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.XSFileEnvelope;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.XSLog;

public class XecureSmartFileEnvelopWithPEM
extends Activity {
    public static final String mSessionIDKey = "session_id_key";
    public static final String mInFilePathKey = "infile_path_key";
    public static final String mOutFilePathKey = "outfile_path_key";
    public static final String mPEMDataKey = "pem_data_key";
    public static final String mPEMFileKey = "pem_file_key";
    public static final String mResultKey = "result_key";
    private static final int mStatusStartProgress = 1;
    private static final int mStatusOnProgress = 2;
    private static final int mStatusDone = 3;
    private static final int mStatusCanceled = 4;
    private boolean mIsCanceled = false;
    private long mSessionID;
    private String mInFilePath;
    private String mOutFilePath;
    private String mPEMData;
    private String mPEMFile;
    private int mResult = -1;
    private BlockerActivityResult mBlockerParam;
    private XSFileEnvelope mXSFileEnvelope;
    private TextView mTextViewMsg;
    private ProgressBar mProgressBar;
    private TextView mTextViewFileName;
    private TextView mTextViewPercent;
    private Button mCancelButton;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Thread statusThread = new Thread(new setProgressRunnable());
                    statusThread.start();
                    break;
                }
                case 2: {
                    XecureSmartFileEnvelopWithPEM.this.mTextViewFileName.setText((CharSequence)XecureSmartFileEnvelopWithPEM.this.mXSFileEnvelope.getFileName());
                    int aPercent = XecureSmartFileEnvelopWithPEM.this.mXSFileEnvelope.getPercent();
                    XecureSmartFileEnvelopWithPEM.this.mProgressBar.setProgress(aPercent);
                    XecureSmartFileEnvelopWithPEM.this.mTextViewPercent.setText((CharSequence)(String.valueOf(aPercent) + "%"));
                    break;
                }
                case 3: 
                case 4: {
                    XecureSmartFileEnvelopWithPEM.this.mIsCanceled = true;
                    XecureSmartFileEnvelopWithPEM.this.finish();
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.file_progress_dialog);
        Intent receivedIntent = this.getIntent();
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        this.mSessionID = receivedIntent.getLongExtra(mSessionIDKey, -1L);
        this.mInFilePath = receivedIntent.getStringExtra(mInFilePathKey);
        this.mOutFilePath = receivedIntent.getStringExtra(mOutFilePathKey);
        this.mPEMData = receivedIntent.getStringExtra(mPEMDataKey);
        this.mPEMFile = receivedIntent.getStringExtra(mPEMFileKey);
        this.mXSFileEnvelope = new XSFileEnvelope(this.mSessionID);
        this.mTextViewMsg = (TextView)this.findViewById(R.id.file_progress_msg);
        this.mTextViewMsg.setText(R.string.file_envelope_progress);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.file_progress_bar);
        this.mProgressBar.setMax(100);
        this.mProgressBar.setProgress(0);
        this.mTextViewFileName = (TextView)this.findViewById(R.id.file_progress_name);
        this.mTextViewPercent = (TextView)this.findViewById(R.id.file_progress_percent);
        this.mCancelButton = (Button)this.findViewById(R.id.file_progress_cancel_btn);
        this.mCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartFileEnvelopWithPEM.this.onCancelButtonClick(v);
            }
        });
        this.runFileEnvelope();
    }

    public void finish() {
        Intent aIntent = new Intent((Context)this, XecureSmartFileEnvelopWithPEM.class);
        aIntent.putExtra(mResultKey, this.mResult);
        if (this.mResult == 0) {
            this.mBlockerParam.setBlockerResult(-1, aIntent);
        } else {
            this.mBlockerParam.setBlockerResult(0, aIntent);
        }
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }

    private void runFileEnvelope() {
        Thread envelopeThread = new Thread(new FileEnvelopeRunnable());
        envelopeThread.start();
    }

    private void onCancelButtonClick(View v) {
        this.mXSFileEnvelope.cancel();
    }

    private class setProgressRunnable
    implements Runnable {
        private setProgressRunnable() {
        }

        @Override
        public void run() {
            while (!XecureSmartFileEnvelopWithPEM.this.mIsCanceled) {
                XecureSmartFileEnvelopWithPEM.this.mHandler.sendEmptyMessage(2);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    XSLog.e((String)"InterruptedException in progress");
                }
            }
        }
    }

    private class FileEnvelopeRunnable
    implements Runnable {
        private FileEnvelopeRunnable() {
        }

        @Override
        public void run() {
            XecureSmartFileEnvelopWithPEM.this.mHandler.sendEmptyMessage(1);
            XecureSmartFileEnvelopWithPEM.this.mResult = XecureSmartFileEnvelopWithPEM.this.mXSFileEnvelope.envelopeFileWithPEM(XecureSmartFileEnvelopWithPEM.this.mInFilePath, XecureSmartFileEnvelopWithPEM.this.mOutFilePath, XecureSmartFileEnvelopWithPEM.this.mPEMData, XecureSmartFileEnvelopWithPEM.this.mPEMFile);
            if (XecureSmartFileEnvelopWithPEM.this.mResult == 0) {
                XecureSmartFileEnvelopWithPEM.this.mHandler.sendEmptyMessage(3);
            } else if (XecureSmartFileEnvelopWithPEM.this.mResult != 0) {
                XecureSmartFileEnvelopWithPEM.this.mHandler.sendEmptyMessage(4);
            }
        }
    }
}

