/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.transkey;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.View;
import android.webkit.WebView;
import android.widget.EditText;
import com.softforum.xecure.ui.transkey.TransKeyResultInterface;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XSLog;
import com.softsecurity.transkey.TransKeyActivity;
import com.softsecurity.transkey.TransKeyCipher;
import java.security.SecureRandom;

public class TransKeyUtil {
    private final int mTransKeyID = 9000000;
    private InputFilter[] mInputFilter = new InputFilter[]{new InputFilter(){

        public CharSequence filter(CharSequence src, int start, int end, Spanned dst, int dstart, int dend) {
            return null;
        }
    }};
    private InputFilter[] mNullInputFilter = new InputFilter[]{new InputFilter(){

        public CharSequence filter(CharSequence src, int start, int end, Spanned dst, int dstart, int dend) {
            return src.length() < 1 ? dst.subSequence(dstart, dend) : "";
        }
    }};
    private byte[] m_P_assW_ord = null;
    private String mCipherData = null;
    private String mDummyData = null;
    private byte[] mSecureKey = null;
    private byte[] mRandomValue = null;
    private int mRealDataLength = 0;

    public void setRandomValue(byte[] aRandomValue) {
        this.mRandomValue = new byte[aRandomValue.length];
        for (int i = 0; i < aRandomValue.length; ++i) {
            this.mRandomValue[i] = aRandomValue[i];
        }
    }

    public void setMTransKey(Activity context, int[] id2, int[] label) {
        this.setMTransKey(context, id2, label, null, null);
    }

    public void setMTransKey(Activity context, int[] id2, int[] label, int[] maxLen, int[] keypadType) {
        for (int i = 0; i < id2.length; ++i) {
            EditText aEditText = (EditText)context.findViewById(id2[i]);
            final Activity aContext = context;
            final int aIndex = i;
            final String aLabel = context.getString(label[i]);
            final int aMaxLen = null != maxLen ? maxLen[aIndex] : -1;
            final int aKeypadType = null != keypadType ? keypadType[aIndex] : 5;
            aEditText.setInputType(0);
            aEditText.setFilters(this.mNullInputFilter);
            aEditText.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
            aEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    if (hasFocus) {
                        TransKeyUtil.this.startTransKeyActivity(aContext, aLabel, aIndex, aMaxLen, -1, aKeypadType, null);
                    }
                }
            });
            aEditText.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TransKeyUtil.this.startTransKeyActivity(aContext, aLabel, aIndex, aMaxLen, -1, aKeypadType, null);
                }
            });
        }
    }

    public void startTransKeyActivity(Activity context, String label, int index, int maxLen, int inputType, int keypadType, String key) {
        Intent aIntent = new Intent((Context)context, TransKeyActivity.class);
        aIntent.putExtra("mTK_keypadType", keypadType);
        switch (inputType) {
            case 0: {
                aIntent.putExtra("mTK_inputType", 0);
                break;
            }
            case 1: {
                aIntent.putExtra("mTK_inputType", 1);
                break;
            }
            case 2: {
                aIntent.putExtra("mTK_inputType", 2);
                break;
            }
            case 3: {
                aIntent.putExtra("mTK_inputType", 3);
                break;
            }
            default: {
                aIntent.putExtra("mTK_inputType", 2);
            }
        }
        aIntent.putExtra("mTK_label", label);
        aIntent.putExtra("mTK_cryptType", 0);
        if (maxLen > 0) {
            aIntent.putExtra("mTK_maxLength", maxLen);
        }
        if (null != key) {
            aIntent.putExtra("mTK_cryptType", 1);
            aIntent.putExtra("mTK_secureKey", key.getBytes());
            if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
                aIntent.putExtra("mTK_Pbkdf_randkey", this.mRandomValue);
            }
        } else if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            byte[] aSecureKey = new byte[16];
            SecureRandom aSecureRandom = new SecureRandom();
            aSecureRandom.nextBytes(aSecureKey);
            aIntent.putExtra("mTK_cryptType", 1);
            aIntent.putExtra("mTK_secureKey", aSecureKey);
            aIntent.putExtra("mTK_Pbkdf_randkey", this.mRandomValue);
        }
        context.startActivityForResult(aIntent, 9000000 + index);
    }

    public void transKeyActivityResult(Activity context, int requestCode, int resultCode, Intent data, int[] editTextId) {
        if (requestCode < 9000000) {
            return;
        }
        int aIndex = requestCode - 9000000;
        String aPBKDF2CipherData = null;
        if (resultCode == 0) {
            if (null != data) {
                String errMsg = data.getStringExtra("mTK_errorMessage");
                if (errMsg == null) {
                    errMsg = "";
                }
                XSLog.e((String)"Error", (String)errMsg);
            }
        } else {
            this.mCipherData = data.getStringExtra("mTK_cipherData");
            this.mDummyData = data.getStringExtra("mTK_dummyData");
            this.mSecureKey = data.getByteArrayExtra("mTK_secureKey");
            this.mRealDataLength = data.getIntExtra("mTK_dataLength", 0);
            if (this.mRealDataLength == 0) {
                return;
            }
            try {
                TransKeyCipher tkc = new TransKeyCipher("SEED");
                tkc.setSecureKey(this.mSecureKey);
                if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
                    aPBKDF2CipherData = tkc.getPBKDF2DataEncryptCipherData(this.mCipherData);
                } else {
                    this.m_P_assW_ord = new byte[this.mRealDataLength];
                    if (!tkc.getDecryptCipherData(this.mCipherData, this.m_P_assW_ord)) {
                        this.m_P_assW_ord = null;
                    }
                }
                if (editTextId[aIndex] != -1) {
                    EditText aPassEditText = (EditText)context.findViewById(editTextId[aIndex]);
                    aPassEditText.setFilters(this.mInputFilter);
                    aPassEditText.setText((CharSequence)this.mDummyData);
                    aPassEditText.setFilters(this.mNullInputFilter);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                XSLog.e((String)"Array is out of Bounds");
            }
            catch (RuntimeException e) {
                XSLog.e((String)"RuntimeException Exception");
            }
            catch (Exception e) {
                XSLog.e((String)"Unknown Exception");
            }
        }
        if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            ((TransKeyResultInterface)context).setTransKeyResult(aIndex, aPBKDF2CipherData);
        } else {
            ((TransKeyResultInterface)context).setTransKeyResult(aIndex, this.m_P_assW_ord);
        }
        ((TransKeyResultInterface)context).doNext();
        this.resetPlainData();
    }

    public byte[] getDecryptCipherData() {
        byte[] aDecryptCipherData = null;
        TransKeyCipher aTransKeyCipher = null;
        aTransKeyCipher = new TransKeyCipher("SEED");
        aTransKeyCipher.setSecureKey(this.mSecureKey);
        aDecryptCipherData = new byte[this.mRealDataLength];
        if (!aTransKeyCipher.getDecryptCipherData(this.mCipherData, aDecryptCipherData)) {
            aDecryptCipherData = null;
        }
        return aDecryptCipherData;
    }

    public void resetPlainData() {
        if (this.m_P_assW_ord != null) {
            for (int i = 0; i < this.m_P_assW_ord.length; ++i) {
                this.m_P_assW_ord[i] = 0;
            }
        }
        this.m_P_assW_ord = null;
    }

    public boolean isResultsNotEmpty(byte[] ... arg) {
        for (int i = 0; i < arg.length; ++i) {
            byte[] aByte = arg[i];
            if (null != aByte && !"".equals(aByte)) continue;
            return false;
        }
        return true;
    }

    public boolean isResultsNotEmpty(String ... aArg) {
        for (int i = 0; i < aArg.length; ++i) {
            String aString = aArg[i];
            if (null != aString && !"".equals(aString)) continue;
            return false;
        }
        return true;
    }

    public void startTransKeyActivityForWeb(Activity context, String label, int keypadType, int inputType, int maxLength, String key) {
        this.startTransKeyActivity(context, label, 0, maxLength, inputType, keypadType, key);
    }

    public void transKeyActivityResultForWeb(WebView webView, int resultCode, Intent data) {
        if (resultCode == 0) {
            String errMsg;
            if (null != data && (errMsg = data.getStringExtra("mTK_errorMessage")) == null) {
                errMsg = "";
            }
        } else {
            String aCipherData = data.getStringExtra("mTK_cipherData");
            String aDummyData = data.getStringExtra("mTK_dummyData");
            String aJavaCall = "javascript:setTransKeyResult('" + aCipherData + "','" + aDummyData + "')";
            webView.loadUrl(aJavaCall);
        }
    }
}

