/*
 * Decompiled with CFR 0.152.
 */
package kr.co.skplanet.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import kr.co.skplanet.utils.LOG;

public final class Util {
    public static final int SEED_OPERATION_NUM = 5;
    public static final int DATE_LENGTH = 9;
    public static final byte PADDING = 32;

    public static int BytesToInt(byte[] b2, int off, int size) {
        int n = 0;
        int i = 0;
        while (i < size) {
            n |= (b2[off + i] & 0xFF) << 8 * i;
            ++i;
        }
        return n;
    }

    public static int BytesToIntByBidEndian(byte[] b2, int off, int size) {
        int n = 0;
        int i = 0;
        while (i < size) {
            n |= (b2[off + i] & 0xFF) << 8 * (size - i - 1);
            ++i;
        }
        return n;
    }

    public static int IntFromBytes(byte[] b2, int off, int size) {
        byte[] bytesValue = new byte[size + 1];
        int nLen = Util.STRNCPYWithIgnoreZeroChar(bytesValue, 0, b2, off, size, false);
        String strValue = new String(bytesValue, 0, nLen);
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long LongFromBytes(byte[] b2, int off, int size) {
        byte[] bytesValue = new byte[size + 1];
        int nLen = Util.STRNCPYWithIgnoreZeroChar(bytesValue, 0, b2, off, size, false);
        String strValue = new String(bytesValue, 0, nLen);
        try {
            return Long.parseLong(strValue);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static long BytesToLong(byte[] b2, int off, int size) {
        long n = 0L;
        int i = 0;
        while (i < size) {
            n |= ((long)b2[off + i] & 0xFFL) << 8 * i;
            ++i;
        }
        return n;
    }

    public static void IntToBytes(byte[] bytesValue, int nOffset, int nSize, int nValue) {
        int i = 0;
        while (i < nSize) {
            bytesValue[nOffset + i] = (byte)(nValue >>> 8 * i);
            ++i;
        }
    }

    public static byte[] IntToBytes(int nSize, int nValue) {
        byte[] bytesValue = new byte[nSize];
        int i = 0;
        while (i < nSize) {
            bytesValue[i] = (byte)(nValue >>> 8 * i);
            ++i;
        }
        return bytesValue;
    }

    public static byte[] IntToBytesByBidEndian(byte[] bytesValue, int nOffset, int nSize, int nValue) {
        int i = 0;
        while (i < nSize) {
            bytesValue[nOffset + i] = (byte)(nValue >>> 8 * (nSize - i - 1));
            ++i;
        }
        return bytesValue;
    }

    public static byte[] NumToBytes(int nValue) {
        String strValue = String.valueOf(nValue);
        return strValue.getBytes();
    }

    public static void NumToBytes(byte[] bytesDest, int nDestLoc, int nValue) {
        String strValue = String.valueOf(nValue);
        Util.STRCPY(bytesDest, nDestLoc, strValue);
    }

    public static int ATOI(String str) {
        return Util.ATOI(str.getBytes());
    }

    public static int ATOI(byte[] bytesValue) {
        return Util.ATOI(bytesValue, 0, bytesValue.length);
    }

    public static int ATOI(byte[] bytesValue, int nOffset, int nSize) {
        int nValue;
        int nLen = nSize == -1 ? Util.STRLEN(bytesValue, nOffset) : nSize;
        byte[] byteTemp = new byte[nLen + 1];
        Util.IgnoreRightSpace(byteTemp, 0, bytesValue, nOffset, nLen);
        byteTemp = Util.RemoveChar(byteTemp, ',');
        byteTemp = Util.ReplaceChar(byteTemp, 0, Util.STRLEN(byteTemp), (byte)46, (byte)0, null);
        if (Util.STRLEN(byteTemp) == 0) {
            return 0;
        }
        try {
            nValue = Integer.parseInt(Util.MakeString(byteTemp, 0));
        }
        catch (NumberFormatException e) {
            nValue = 0;
        }
        return nValue;
    }

    public static long ATOL(String strValue) {
        return Util.ATOL(strValue.getBytes());
    }

    public static long ATOL(byte[] bytesValue) {
        return Util.ATOL(bytesValue, 0, bytesValue.length);
    }

    public static long ATOL(byte[] bytesValue, int nOffset, int nSize) {
        long lValue;
        if (nSize == -1) {
            nSize = Util.STRLEN(bytesValue, nOffset);
        }
        try {
            lValue = Long.parseLong(new String(bytesValue, nOffset, nSize));
        }
        catch (NumberFormatException e) {
            lValue = 0L;
        }
        return lValue;
    }

    public static int BYTENCPY(byte[] bytesDest, int nDestLoc, byte[] bytesSrc, int nSrcLoc, int nLen) {
        if (bytesSrc == null) {
            return 0;
        }
        nLen = Math.min(bytesSrc.length, nLen);
        System.arraycopy(bytesSrc, nSrcLoc, bytesDest, nDestLoc, nLen);
        return nLen;
    }

    public static int SHORTNCPY(short[] bytesDest, int nDestLoc, short[] bytesSrc, int nSrcLoc, int nLen) {
        nLen = Math.min(bytesSrc.length, nLen);
        int i = 0;
        while (i < nLen) {
            bytesDest[i] = 0;
            ++i;
        }
        return nLen;
    }

    public static int STRCPY(byte[] bytesDest, int nDestLoc, byte[] bytesSrc, int nSrcLoc) {
        int nLen = Util.STRLEN(bytesSrc, nSrcLoc);
        if ((nLen = Math.min(bytesDest.length - 1, nLen)) != 0) {
            System.arraycopy(bytesSrc, nSrcLoc, bytesDest, nDestLoc, nLen);
        }
        bytesDest[nDestLoc + nLen] = 0;
        return nLen;
    }

    public static int STRCPY(byte[] bytesDest, int nDestLoc, String strSrc) {
        return Util.STRCPY(bytesDest, nDestLoc, strSrc.getBytes(), 0);
    }

    public static int STRCPY(byte[] bytesDest, String strSrc) {
        return Util.STRCPY(bytesDest, 0, strSrc.getBytes(), 0);
    }

    public static int STRCPY(byte[] bytesDest, byte[] bytesSrc) {
        return Util.STRCPY(bytesDest, 0, bytesSrc, 0);
    }

    public static int STRNCPY(byte[] bytesDest, int nDestLoc, byte[] bytesSrc, int nSrcLoc, int nLen) {
        nLen = Math.min(Util.STRLEN(bytesSrc, nSrcLoc), nLen);
        if (nLen == 0) {
            return nLen;
        }
        System.arraycopy(bytesSrc, nSrcLoc, bytesDest, nDestLoc, nLen);
        return nLen;
    }

    public static int STRCAT(byte[] bytesDest, byte[] bytesSrc, int nSrcLoc) {
        int nLen = Util.STRLEN(bytesDest);
        nLen += Util.STRCPY(bytesDest, nLen, bytesSrc, nSrcLoc);
        return nLen;
    }

    public static int STRCAT(byte[] bytesDest, int nDestLoc, byte[] bytesSrc, int nSrcLoc) {
        int nLen = Util.STRLEN(bytesDest, nDestLoc);
        nLen += Util.STRCPY(bytesDest, nDestLoc + nLen, bytesSrc, nSrcLoc);
        return nLen;
    }

    public static int STRCAT(byte[] bytesDest, int nDestLoc, String strSrc) {
        return Util.STRCPY(bytesDest, nDestLoc + Util.STRLEN(bytesDest, nDestLoc), Util.AsciiGetBytes(strSrc), 0);
    }

    public static int STRCAT(byte[] bytesDest, String strSrc) {
        return Util.STRCPY(bytesDest, Util.STRLEN(bytesDest, 0), strSrc.getBytes(), 0);
    }

    public static int STRNCPYToSpace(byte[] bytesDest, int nDestLoc, byte[] bytesSrc, int nSrcLoc, int nLen) {
        int nMinLen = Math.min(Util.STRLEN(bytesSrc, nSrcLoc), nLen);
        nMinLen = Math.min(nLen, nMinLen);
        System.arraycopy(bytesSrc, nSrcLoc, bytesDest, nDestLoc, nMinLen);
        if (nMinLen == bytesDest.length - nDestLoc) {
            return nMinLen;
        }
        int i = nMinLen;
        while (i < nLen) {
            bytesDest[nDestLoc + i] = 32;
            ++i;
        }
        return nLen;
    }

    public static void STRNCPYToZero(byte[] szDest, int nDestLoc, byte[] szSrc, int nSrcLoc, int nLen) {
        int nSrcLen = Util.STRLEN(szSrc, nSrcLoc);
        int nZeroCnt = nLen - nSrcLen;
        Util.MEMSET(szDest, nDestLoc, (byte)48, nZeroCnt);
        System.arraycopy(szSrc, nSrcLoc, szDest, nDestLoc + nZeroCnt, nSrcLen);
    }

    public static void RightAlignedNumericString(byte[] szDest, int nDestLoc, int nNum, int nLen) {
        Util.STRNCPYToZero(szDest, nDestLoc, Util.AsciiGetBytes(Integer.toString(nNum)), 0, nLen);
    }

    public static void MEMSET(byte[] szDest, int nDestLoc, byte byteValue, int nLen) {
        int nCnt = nDestLoc + nLen;
        int nI = nDestLoc;
        while (nI < nCnt) {
            szDest[nI] = byteValue;
            ++nI;
        }
    }

    public static int MEMCMP(byte[] bytesMem1, int nMemLoc1, byte[] bytesMem2, int nMemLoc2, int nLen) {
        int nI = 0;
        while (nI < nLen) {
            if (bytesMem1[nMemLoc1] != bytesMem2[nMemLoc2]) {
                if (bytesMem1[nMemLoc1] > bytesMem2[nMemLoc2]) {
                    return -1;
                }
                return 1;
            }
            ++nI;
            ++nMemLoc1;
            ++nMemLoc2;
        }
        return 0;
    }

    public static int MEMCPY(byte[] bytesDest, int nDestLoc, byte[] bytesSrc, int nSrcLoc, int nLen) {
        System.arraycopy(bytesSrc, nSrcLoc, bytesDest, nDestLoc, nLen);
        return nLen;
    }

    public static int STRCMP(byte[] szSrc1, byte[] szSrc2) {
        int nLen1 = Util.STRLEN(szSrc1);
        int nLen2 = Util.STRLEN(szSrc2);
        int nLen = Math.min(nLen1, nLen2);
        int nI = 0;
        while (nI < nLen) {
            if (szSrc1[nI] != szSrc2[nI]) {
                if (szSrc1[nI] > szSrc2[nI]) {
                    return -1;
                }
                return 1;
            }
            ++nI;
        }
        if (nLen1 > nLen2) {
            return -1;
        }
        if (nLen1 < nLen2) {
            return 1;
        }
        return 0;
    }

    public static int STRCMP(byte[] szSrc1, int nLoc1, byte[] szSrc2, int nLoc2) {
        int nLen1 = Util.STRLEN(szSrc1, nLoc1);
        int nLen2 = Util.STRLEN(szSrc2, nLoc2);
        int nLen = Math.min(nLen1, nLen2);
        int nI = 0;
        while (nI < nLen) {
            if (szSrc1[nLoc1] != szSrc2[nLoc2]) {
                if (szSrc1[nLoc1] > szSrc2[nLoc2]) {
                    return -1;
                }
                return 1;
            }
            ++nI;
            ++nLoc1;
            ++nLoc2;
        }
        if (nLen1 > nLen2) {
            return -1;
        }
        if (nLen1 < nLen2) {
            return 1;
        }
        return 0;
    }

    public static boolean STRCMP(String strSrc1, String strSrc2) {
        int ret = strSrc1.compareTo(strSrc2);
        return ret != 0;
    }

    public static int STRNCMP(byte[] szSrc1, int nLoc1, byte[] szSrc2, int nLoc2, int nLen) {
        int nLenKeep = nLen;
        int nLen1 = Util.STRLEN(szSrc1, nLoc1);
        int nLen2 = Util.STRLEN(szSrc2, nLoc2);
        nLen = Math.min(Math.min(nLen1, nLen2), nLen);
        int nI = 0;
        while (nI < nLen) {
            if (szSrc1[nLoc1] != szSrc2[nLoc2]) {
                if (szSrc1[nLoc1] < szSrc2[nLoc2]) {
                    return -1;
                }
                return 1;
            }
            ++nI;
            ++nLoc1;
            ++nLoc2;
        }
        if (nLenKeep > nLen) {
            if (nLen1 < nLen2) {
                return -1;
            }
            if (nLen1 > nLen2) {
                return 1;
            }
        }
        return 0;
    }

    public static int STRLEN(byte[] szText, int nLoc) {
        if (szText == null) {
            return 0;
        }
        int nLen = szText.length - nLoc;
        int nI = 0;
        while (nI < nLen) {
            if (szText[nLoc + nI] == 0) break;
            ++nI;
        }
        return nI;
    }

    public static int STRLEN(byte[] szText) {
        return Util.STRLEN(szText, 0);
    }

    public static int STRLEN(String strText) {
        return Util.STRLEN(strText.getBytes(), 0);
    }

    public static byte[] AsciiGetBytes(String buf) {
        int size = buf.length();
        byte[] bytebuf = new byte[size];
        int i = 0;
        while (i < size) {
            bytebuf[i] = (byte)buf.charAt(i);
            ++i;
        }
        return bytebuf;
    }

    public static int IgnoreSpace(byte[] szDest, int nDestLoc, byte[] szSrc, int nSrcLoc, int nLen) {
        byte[] pszBuff = new byte[nLen + 1];
        nLen = Util.IgnoreRightSpace(pszBuff, 0, szSrc, nSrcLoc, nLen);
        nLen = Util.IgnoreLeftSpace(szDest, nDestLoc, pszBuff, 0, nLen);
        pszBuff = null;
        return nLen;
    }

    public static int IgnoreRightSpace(byte[] szDest, int nDestLoc, byte[] szSrc, int nSrcLoc, int nLen) {
        nLen = Util.STRNCPYWithIgnoreSpace(szDest, nDestLoc, szSrc, nSrcLoc, nLen);
        szDest[nDestLoc + nLen] = 0;
        return nLen;
    }

    public static int IgnoreLeftSpace(byte[] szDest, int nDestLoc, byte[] szSrc, int nSrcLoc, int nLen) {
        while (szSrc[nSrcLoc] == 32 && nLen > 0) {
            ++nSrcLoc;
            --nLen;
        }
        Util.STRNCPY(szDest, nDestLoc, szSrc, nSrcLoc, nLen);
        szDest[nDestLoc + nLen] = 0;
        return nLen;
    }

    public static int STRNCPYWithIgnoreSpace(byte[] szDest, int nDestLoc, byte[] szSrc, int nSrcLoc, int nLen) {
        byte[] szBuff = new byte[nLen + 1];
        nLen = Util.STRNCPY(szBuff, 0, szSrc, nSrcLoc, nLen);
        nLen = Util.TrimRight(szBuff, 0, ' ', nLen);
        Util.STRNCPY(szDest, nDestLoc, szBuff, 0, nLen);
        szBuff = null;
        return nLen;
    }

    public static int TrimRight(byte[] szText, int nStartLoc, char cDelimiter, int nLen) {
        if (nLen == 0) {
            return 0;
        }
        if (nLen == -1) {
            nLen = Util.STRLEN(szText, nStartLoc);
            if (nLen == 0) {
                return 0;
            }
            --nLen;
        } else {
            --nLen;
        }
        int nI = nLen;
        while (nI >= 0) {
            int nIdx = nStartLoc + nI;
            if (szText[nIdx] != cDelimiter && szText[nIdx] != 0) break;
            szText[nIdx] = 0;
            --nI;
        }
        if (szText[nStartLoc + nLen] != 0) {
            return nLen + 1;
        }
        return Util.STRLEN(szText, nStartLoc);
    }

    public static int STRNCPYWithIgnoreZeroChar(byte[] szDest, int nDestLoc, byte[] szSrc, int nSrcLoc, int nLen, boolean bCommaValue) {
        if (nLen < 0) {
            nLen = Util.STRLEN(szSrc, nSrcLoc);
        }
        int nDotLoc = -1;
        int nLenDot = 0;
        int nLimitLoc = nSrcLoc + nLen;
        while (nLen > 0 && szSrc[nSrcLoc] == 48) {
            ++nSrcLoc;
            --nLen;
        }
        if (bCommaValue && nSrcLoc < nLimitLoc) {
            if (szSrc[nSrcLoc] == 46) {
                nDotLoc = nSrcLoc;
                nLenDot = nLimitLoc - nDotLoc;
            } else {
                int nI = nSrcLoc;
                while (nI < nLimitLoc) {
                    if (szSrc[nI] == 46) {
                        nDotLoc = nI;
                        nLenDot = nLimitLoc - nDotLoc;
                        break;
                    }
                    ++nI;
                }
            }
        }
        if (nLen == 0 || szSrc[nSrcLoc] == 46) {
            --nSrcLoc;
            ++nLen;
        }
        if (bCommaValue) {
            byte[] szBuff = new byte[nLen + 1];
            if (nDotLoc != -1) {
                nLen -= nLenDot;
            }
            System.arraycopy(szSrc, nSrcLoc, szBuff, 0, nLen);
            szBuff[nLen] = 0;
            String strCommaValue = Util.MakeCommaValueFromBytes(szBuff, 0);
            if (nDotLoc != -1) {
                strCommaValue = String.valueOf(strCommaValue) + new String(szSrc, nDotLoc, nLenDot);
            }
            nLen = Util.BYTENCPY(szDest, 0, Util.AsciiGetBytes(strCommaValue), 0, strCommaValue.length());
        } else {
            System.arraycopy(szSrc, nSrcLoc, szDest, nDestLoc, nLen);
        }
        return nLen;
    }

    public static String MakeString(byte[] szSrc) {
        if (szSrc == null) {
            return null;
        }
        return Util.MakeKSC5601String(szSrc, 0, Util.STRLEN(szSrc, 0));
    }

    public static String MakeString(byte[] szSrc, int nLoc) {
        if (szSrc == null) {
            return null;
        }
        return Util.MakeKSC5601String(szSrc, nLoc, Util.STRLEN(szSrc, nLoc));
    }

    public static String MakeKSC5601String(byte[] szSrc, int nLoc, int nLen) {
        int nLimit = nLoc + nLen;
        int nI = nLoc;
        while (nI < nLimit) {
            if ((szSrc[nI] & 0xFF) < 128) {
                ++nI;
                continue;
            }
            nI += 2;
        }
        if (nI > nLimit) {
            --nLen;
        }
        return new String(szSrc, nLoc, nLen);
    }

    public static byte[] RemoveChar(byte[] szInValue, char cRemove) {
        return Util.RemoveChar(szInValue, 0, cRemove);
    }

    public static byte[] RemoveChar(byte[] szInValue, int nLoc, char cRemove) {
        int nLen = Util.STRLEN(szInValue, nLoc);
        byte[] szOutValue = new byte[nLen + 1];
        int nCurrPos = 0;
        int i = 0;
        while (i < nLen) {
            if (szInValue[i] != (byte)cRemove) {
                szOutValue[nCurrPos++] = szInValue[i];
            }
            ++i;
        }
        szOutValue[nCurrPos] = 0;
        return szOutValue;
    }

    public static byte[] ReplaceChar(byte[] pszSrc, int nOffset, int nSize, byte cOrg, byte cRep, short[] pCnt) {
        short nItemCnt = 0;
        byte[] pszNew = Util.CloneBytes(pszSrc, nOffset, nSize);
        int i = 0;
        while (i < nSize) {
            if (pszNew[i] == cOrg) {
                pszNew[i] = cRep;
                nItemCnt = (short)(nItemCnt + 1);
            }
            ++i;
        }
        if (pCnt != null) {
            pCnt[0] = nItemCnt;
        }
        return pszNew;
    }

    public static String MakeCommaValueFromBytes(byte[] szInValue, int nInLoc) {
        int nInValueLoc = nInLoc;
        byte cTemp = szInValue[nInValueLoc];
        if (szInValue[nInValueLoc] == 45 || szInValue[nInValueLoc] == 43) {
            ++nInValueLoc;
        }
        int nLen = Util.STRLEN(szInValue, nInValueLoc);
        int nComma = nLen / 3;
        if (nLen % 3 == 0 && nComma > 0) {
            --nComma;
        }
        int nCnt = nLen + nComma;
        if (szInValue[nInValueLoc] != szInValue[nInLoc]) {
            ++nCnt;
        }
        byte[] szOutValue = new byte[nCnt];
        int i = 0;
        while (i < nComma) {
            int nLoc = nCnt - (i + 1) * 3 - i;
            System.arraycopy(szInValue, nInValueLoc + nLen - (i + 1) * 3, szOutValue, nLoc, 3);
            szOutValue[nLoc - 1] = 44;
            ++i;
        }
        System.arraycopy(szInValue, nInValueLoc, szOutValue, nCnt - (nLen + nComma), nLen - nComma * 3);
        if (nInValueLoc != nInLoc) {
            szOutValue[0] = cTemp;
        }
        return new String(szOutValue);
    }

    public static String MakeCommaValueFromStr(String str) {
        return Util.MakeCommaValueFromBytes(Util.AsciiGetBytes(str), 0);
    }

    public static String MakeCommaValueFromNum(int nValue) {
        return Util.MakeCommaValueFromBytes(Util.AsciiGetBytes(String.valueOf(nValue)), 0);
    }

    public static String MakeCommaValueFromlong(long nValue) {
        return Util.MakeCommaValueFromBytes(Util.AsciiGetBytes(String.valueOf(nValue)), 0);
    }

    public static final byte[] CloneBytesArray(byte[] bytesSrc) {
        int nLen = bytesSrc.length;
        if (nLen == 0) {
            return null;
        }
        byte[] bytesNew = new byte[nLen];
        System.arraycopy(bytesSrc, 0, bytesNew, 0, nLen);
        return bytesNew;
    }

    public static final byte[] CloneBytes(byte[] bytesSrc, int nLoc, int nSize) {
        byte[] bytesNew = new byte[nSize];
        System.arraycopy(bytesSrc, nLoc, bytesNew, 0, nSize);
        return bytesNew;
    }

    public static final byte[] ReallocBytes(byte[] bytesSrc, int nLoc, int nSize, int nNewSize) {
        byte[] bytesNew = new byte[nNewSize];
        if (bytesSrc != null) {
            nSize = Math.min(nSize, nNewSize);
            System.arraycopy(bytesSrc, nLoc, bytesNew, 0, nSize);
        }
        return bytesNew;
    }

    public static final int[] ReallocIntArray(int[] arrSrc, int nLoc, int nSize, int nNewSize) {
        int[] arrNew = new int[nNewSize];
        if (arrSrc != null) {
            nSize = Math.min(nSize, nNewSize);
            System.arraycopy(arrSrc, nLoc, arrNew, 0, nSize);
        }
        return arrNew;
    }

    public static final Object[] ReallocObjects(Object[] objectsSrc, int nLoc, int nSize, int nNewSize) {
        Object[] objectsNew = new Object[nNewSize];
        if (objectsSrc != null) {
            nSize = Math.min(nSize, nNewSize);
            System.arraycopy(objectsSrc, nLoc, objectsNew, 0, nSize);
        }
        return objectsNew;
    }

    public static byte[] STRDUP(byte[] pszSrc) {
        if (pszSrc == null) {
            return null;
        }
        int nLen = Util.STRLEN(pszSrc, 0);
        byte[] pszTar = new byte[nLen + 1];
        System.arraycopy(pszSrc, 0, pszTar, 0, nLen);
        pszTar[nLen] = 0;
        return pszTar;
    }

    public static boolean PackData(byte[] pDest, int nDestOffset, byte[] pSrc, int nSrcOffset, int nPackedSize) {
        int nLast = nDestOffset + nPackedSize;
        int i = nSrcOffset;
        int j = nDestOffset;
        while (j < nLast) {
            int cHigh = Util.BytesToInt(pSrc, i, 1);
            cHigh = cHigh >= 65 && cHigh <= 90 ? cHigh - 65 + 10 : (cHigh >= 97 && cHigh <= 122 ? cHigh - 97 + 10 : (cHigh -= 48));
            int cLow = Util.BytesToInt(pSrc, i + 1, 1);
            cLow = cLow >= 65 && cLow <= 90 ? cLow - 65 + 10 : (cLow >= 97 && cLow <= 122 ? cLow - 97 + 10 : (cLow -= 48));
            pDest[j] = (byte)(cHigh << 4 | cLow);
            i += 2;
            ++j;
        }
        return true;
    }

    public static void UnPackData(byte[] pDest, int nDestLoc, byte[] pSrc, int nOffset, int nPackedSize) {
        int nLast = nOffset + nPackedSize;
        while (nOffset < nLast) {
            byte c1 = (byte)(pSrc[nOffset] >>> 4 & 0xF);
            byte c2 = (byte)(pSrc[nOffset] & 0xF);
            c1 = (byte)(c1 > 9 ? 97 + (c1 - 10) : 48 + c1);
            c2 = (byte)(c2 > 9 ? 97 + (c2 - 10) : 48 + c2);
            pDest[nDestLoc] = c1;
            pDest[nDestLoc + 1] = c2;
            nDestLoc += 2;
            ++nOffset;
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static byte[] HexToBytes(String hex) {
        if (hex == null || hex.length() == 0) {
            return null;
        }
        byte[] ba = new byte[hex.length() / 2];
        int i = 0;
        while (i < ba.length) {
            ba[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return ba;
    }

    public static final void DumpPacket(String strWhere, byte[] byteBuf, int nSize) {
        Util.DumpPacket(strWhere, byteBuf, 0, nSize);
    }

    public static final void DumpPacket(String strWhere, byte[] byteBuf, int nLoc, int nSize) {
        String strHexaBuf = "";
        byte[] szAsciBuf = new byte[17];
        LOG.info(String.valueOf(strWhere) + "()================================= ,size={ [" + (nSize += nLoc) + "]");
        int i = nLoc;
        while (i < nSize) {
            String strTemp;
            int j = i;
            while (j < i + 16) {
                if (j < nSize) {
                    strTemp = Integer.toHexString(0xFF & byteBuf[j]);
                    if (strTemp.length() < 2) {
                        strTemp = "0" + strTemp;
                    }
                } else {
                    strTemp = "  ";
                }
                strHexaBuf = String.valueOf(strHexaBuf) + strTemp;
                int nTmp = j % 2;
                if (nTmp != 0) {
                    strHexaBuf = String.valueOf(strHexaBuf) + ' ';
                }
                ++j;
            }
            strHexaBuf = String.valueOf(strHexaBuf) + "   |";
            Util.MEMSET(szAsciBuf, 0, (byte)32, szAsciBuf.length);
            if (i + 16 < nSize) {
                Util.STRNCPY(szAsciBuf, 0, byteBuf, i, 16);
            } else {
                Util.STRNCPY(szAsciBuf, 0, byteBuf, i, nSize - i);
            }
            j = 0;
            while (j < 16) {
                if (Util.a(Util.BytesToInt(szAsciBuf, j, 1)) == 0) {
                    szAsciBuf[j] = 46;
                }
                ++j;
            }
            StringBuffer strIndex = new StringBuffer("00000000");
            strTemp = Integer.toHexString(i - nLoc);
            int nLenIndex = strIndex.length();
            int nLenOffset = strTemp.length();
            j = 1;
            while (j <= nLenOffset) {
                strIndex.setCharAt(nLenIndex - j, strTemp.charAt(nLenOffset - j));
                ++j;
            }
            String strBuf = strIndex.toString();
            strBuf = String.valueOf(strBuf) + "  ";
            strBuf = String.valueOf(strBuf) + strHexaBuf;
            strBuf = String.valueOf(strBuf) + new String(szAsciBuf);
            LOG.info(strBuf);
            strHexaBuf = "";
            i += 16;
        }
        LOG.info(" ================================= }" + strWhere + "() end!");
    }

    private static int a(int n) {
        if (n < 32) {
            return 0;
        }
        if (n == 37) {
            return 0;
        }
        return n;
    }

    public static boolean IsPINSuitable(byte[] pPIN) {
        short nLen = (short)Util.STRLEN(pPIN);
        char cSeedChar = (char)pPIN[0];
        boolean bIsFlag = false;
        short i = 1;
        while (i < nLen) {
            if (cSeedChar != (char)pPIN[i]) {
                bIsFlag = true;
                break;
            }
            i = (short)(i + 1);
        }
        if (!bIsFlag) {
            return false;
        }
        bIsFlag = false;
        i = 0;
        while (i < nLen - 1) {
            short nDist = (short)(pPIN[0] - pPIN[i + 1]);
            if (nDist != i + 1 && nDist != -(i + 1)) {
                bIsFlag = true;
                break;
            }
            i = (short)(i + 1);
        }
        return bIsFlag;
    }

    public static byte[] intToByteArray(int integer) {
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.putInt(integer);
        buff.order(ByteOrder.BIG_ENDIAN);
        return buff.array();
    }

    public static int byteArrayToInt(byte[] bytes) {
        int size = 4;
        ByteBuffer buff = ByteBuffer.allocate(4);
        byte[] newBytes = new byte[4];
        int i = 0;
        while (i < 4) {
            newBytes[i] = i + bytes.length < 4 ? (byte)0 : bytes[i + bytes.length - 4];
            ++i;
        }
        buff = ByteBuffer.wrap(newBytes);
        buff.order(ByteOrder.BIG_ENDIAN);
        return buff.getInt();
    }

    public static int getTime() {
        Calendar calendar = Calendar.getInstance();
        int y4 = calendar.get(1);
        int m2 = calendar.get(2) + 1;
        int d2 = calendar.get(5);
        int hh = calendar.get(11);
        int mm = calendar.get(12);
        int ss = calendar.get(13);
        return (y4 - 2000) * 31536000 + (m2 - 1) * 2592000 + (d2 - 1) * 86400 + hh * 3600 + mm * 60 + ss;
    }

    public static void getCurrentDate(byte[] pszDate) {
        Util.getCurrentDate(pszDate, 0);
    }

    public static void getCurrentDate(byte[] pszDate, int nLoc) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        Util.a(cal, pszDate, nLoc);
    }

    private static void a(Calendar cal, byte[] pszDate, int nLoc) {
        StringBuffer sb = new StringBuffer(14);
        int nTemp = cal.get(1);
        sb.append(nTemp);
        nTemp = cal.get(2) + 1;
        if (nTemp < 10) {
            sb.append('0');
        }
        sb.append(nTemp);
        nTemp = cal.get(5);
        if (nTemp < 10) {
            sb.append('0');
        }
        sb.append(nTemp);
        Util.BYTENCPY(pszDate, nLoc, sb.toString().getBytes(), 0, 8);
        pszDate[nLoc + 9 - 1] = 0;
    }

    public static void getDate(long nTime, byte[] pszDate) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        Date date = new Date(nTime);
        cal.setTime(date);
        Util.a(cal, pszDate, 0);
    }

    public static long GET_SECONDS() {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        Date date = cal.getTime();
        return date.getTime();
    }

    public static long TIME_DAY(int day) {
        return (long)day * 24L * 60L * 60L * 1000L;
    }

    public static long TIME_HOUR(int hour) {
        return (long)hour * 60L * 60L * 1000L;
    }

    public static final String newStringUTF8(byte[] src, int srart, int length) {
        String str;
        try {
            str = new String(new String(src, srart, length, "euc-kr").getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return str.trim();
    }

    public static final int encodingUTF8andInteger(byte[] src, int srart, int length) throws Exception {
        String str = new String(src, srart, length).trim();
        int num = 0;
        if (Util.isDigit(str)) {
            num = Integer.parseInt(str);
        }
        return num;
    }

    public static final int byteArrayToEuckrWithSpace(String src, byte[] dst, int offset, int length) throws UnsupportedEncodingException {
        if (length != 0 && src != null) {
            byte[] temp = src.getBytes("euc-kr");
            Util.STRNCPYToSpace(dst, offset, temp, 0, length);
            return length;
        }
        return 0;
    }

    public static boolean isDigit(String str) {
        char[] c2 = str.toCharArray();
        if (str.equals("")) {
            return false;
        }
        int i = 0;
        while (i < c2.length) {
            if (!Character.isDigit(c2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getYearMonthDay(int _subtraction) {
        int nYear = Util.ATOI(Util.getYearMonthDay("yyyy"));
        int nMonth = Util.getDateType(1);
        int nRun = 0;
        boolean isRun = true;
        while (isRun) {
            if (nRun >= _subtraction) {
                isRun = false;
                break;
            }
            if (nMonth > 1) {
                --nMonth;
            } else {
                nMonth = 12;
                --nYear;
            }
            ++nRun;
        }
        String strCheckDate = null;
        strCheckDate = Integer.toString(nYear);
        if (nMonth < 10) {
            strCheckDate = String.valueOf(strCheckDate) + "0";
        }
        strCheckDate = String.valueOf(strCheckDate) + Integer.toString(nMonth);
        return strCheckDate;
    }

    public static String getYearMonthDay(String _strType) {
        String strCheckDate = null;
        SimpleDateFormat formatter = new SimpleDateFormat(_strType);
        Date currentTime = new Date();
        strCheckDate = formatter.format(currentTime);
        return strCheckDate;
    }

    public static int getDateType(int nType) {
        int nData = 0;
        String strCheckDate = null;
        strCheckDate = Util.getYearMonthDay("yyyyMMdd");
        if (strCheckDate != null) {
            byte[] pData = new byte[2];
            Util.MEMSET(pData, 0, (byte)32, 2);
            System.arraycopy(strCheckDate.getBytes(), nType * 2 + 2, pData, 0, 2);
            nData = Util.ATOI(pData);
        }
        return nData;
    }

    public static String getMoneyString(int mMoney) {
        return Util.getMoneyString(mMoney, "\uac70\ub798\uae08\uc561 ");
    }

    public static String getMoneyString(int mMoney, String strHeaderData) {
        return Util.getMoneyString(mMoney, strHeaderData, " \uc6d0");
    }

    public static String getMoneyString(int mMoney, String strHeaderData, String strFooterData) {
        StringBuffer sb = new StringBuffer();
        double num = mMoney;
        DecimalFormat df = new DecimalFormat("#,##0");
        sb.append(strHeaderData);
        sb.append(df.format(num));
        sb.append(strFooterData);
        return sb.toString();
    }

    public static byte[] getByteString(String szData, int nSize) throws IOException {
        int nLen;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = null;
        if (nSize <= 0) {
            return buff;
        }
        int n = nLen = szData == null ? 0 : szData.length();
        if (nLen > nSize) {
            nLen = nSize;
            szData = szData.substring(0, nLen);
        }
        if (szData != null) {
            baos.write(szData.getBytes());
        }
        while (nLen < nSize) {
            baos.write(0);
            ++nLen;
        }
        buff = baos.toByteArray();
        baos.close();
        return buff;
    }

    public static int getByteStringLen(byte[] strData) {
        return Util.getByteStringLen(new String(strData));
    }

    public static int getByteStringLen(String strData) {
        int strLen = 0;
        int i = 0;
        while (i < strData.length()) {
            char c2 = strData.charAt(i);
            strLen = c2 < '\uac00' || '\ud7a3' < c2 ? ++strLen : (strLen += 2);
            ++i;
        }
        return strLen;
    }

    public static final int getByteSizeToComplex(String str) {
        int en = 0;
        int ko = 0;
        int etc = 0;
        char[] string = str.toCharArray();
        int i = 0;
        while (i < string.length) {
            if (string[i] >= 'A' && string[i] <= 'z') {
                ++en;
            } else if (string[i] >= '\uac00' && string[i] <= '\ud7a3') {
                ko += 2;
            } else {
                ++etc;
            }
            ++i;
        }
        return en + ko + etc;
    }

    public static String getHexString(byte[] b2) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < b2.length) {
            result.append(Integer.toString((b2[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return result.toString();
    }

    public static String getHexChar(byte b2) {
        return Integer.toString((b2 & 0xFF) + 256, 16).substring(1);
    }

    public static String getRandom() {
        int addNum;
        Random r = new Random();
        String randomNum = "" + r.nextInt(100000000);
        if (randomNum.length() != 8 && (addNum = 8 - randomNum.length()) > 0) {
            int i = 0;
            while (i < addNum) {
                randomNum = "0" + randomNum;
                ++i;
            }
        }
        return randomNum;
    }

    public static byte[] makeHashMD5(String input) {
        byte[] md5encrypt = null;
        if (input == null || input.length() == 0) {
            return null;
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(input.getBytes());
            md5encrypt = md5.digest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5encrypt;
    }

    public static byte[] makeHashMD5(byte[] input) {
        byte[] md5encrypt = null;
        if (input == null || input.length == 0) {
            return null;
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(input);
            md5encrypt = md5.digest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5encrypt;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static String byteArrayToHexString(byte[] b2) {
        String result = "";
        int i = 0;
        while (i < b2.length) {
            result = String.valueOf(result) + Integer.toString((b2[i] & 0xFF) + 256, 16).substring(1);
            ++i;
        }
        return result;
    }
}

