/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.tools.smartcard;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.skp.smarttouch.sem.tools.dao.NRMSApplets;
import com.skp.smarttouch.sem.tools.dao.NRMSCredits;
import com.skp.smarttouch.sem.tools.dao.NRMSTcses;
import com.sktelecom.smartcard.ISmartcard;
import java.util.List;
import kr.co.skplanet.utils.BinaryUtil;
import kr.co.skplanet.utils.LOG;

public abstract class AbstractSmartcard {
    public static final int SMARTCARD_IO_SUCCESS = 0;
    public static final int SMARTCARD_IO_ERROR_OPEN_CHANNEL = -1;
    public static final int SMARTCARD_IO_ALREADY_CONNECTED = -2;
    public static final int SMARTCARD_IO_ERROR_NOT_CONNECT = -3;
    public static final int SMARTCARD_IO_ERROR_TRANSMIT_BUFFER = -4;
    public static final int SMARTCARD_IO_ERROR_RESPONSE_BUFFER = -5;
    public static final int SMARTCARD_IO_ERROR_ATR_BUFFER = -6;
    public static final int SMARTCARD_IO_CARD_NOT_EXIST = -7;
    public static final int SMARTCARD_IO_ERROR_UNKNOWN = -8;
    public static final byte BYTE_READ_MORE = 97;
    public static final byte BYTE_RESPONSE_LENGTH = 108;
    public static final byte[] RESULT_SUCCESS;
    public static final byte[] ERROR_LENGTH;
    public static final byte[] ERROR_P1P2;
    public static final byte[] ERROR_NOT_FOUND_AID;
    public static final int RES_BUFF = 258;
    private List<NRMSApplets> a = null;
    private List<NRMSCredits> b = null;
    private List<NRMSTcses> c = null;
    private Context d = null;
    protected ISmartcard mCard = null;
    private static final byte[] e;
    private static final byte[] f;
    private static final byte[] g;
    private static final byte[] h;
    private static final byte[] i;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = -112;
        RESULT_SUCCESS = byArray;
        byte[] byArray2 = new byte[2];
        byArray2[0] = 103;
        ERROR_LENGTH = byArray2;
        ERROR_P1P2 = new byte[]{106, -122};
        ERROR_NOT_FOUND_AID = new byte[]{106, -120};
        byte[] byArray3 = new byte[5];
        byArray3[0] = -96;
        byArray3[4] = 3;
        e = byArray3;
        byte[] byArray4 = new byte[5];
        byArray4[0] = -96;
        byArray4[4] = 4;
        f = byArray4;
        byte[] byArray5 = new byte[5];
        byArray5[0] = -96;
        byArray5[4] = 119;
        g = byArray5;
        byte[] byArray6 = new byte[5];
        byArray6[0] = -96;
        byArray6[4] = 37;
        h = byArray6;
        byte[] byArray7 = new byte[5];
        byArray7[0] = -44;
        byArray7[1] = 16;
        byArray7[4] = 48;
        i = byArray7;
    }

    public abstract int getChannel();

    public abstract byte[] getATR();

    public abstract int connect();

    public abstract int disconnect();

    public abstract byte[] transmit(byte[] var1);

    public abstract byte[] transmit(String var1, byte[] var2);

    public abstract boolean isResponseSuccess(byte[] var1);

    public abstract byte[] cmdSELECT(byte[] var1);

    public abstract byte[] cmdSELECT(String var1, byte[] var2);

    public AbstractSmartcard(Context context, ISmartcard cardService) {
        this.d = context;
        this.mCard = cardService;
    }

    public void setSmartcard(ISmartcard cardService) {
        this.mCard = cardService;
    }

    public void setApplets(List<NRMSApplets> applets) {
        this.a = applets;
    }

    public void setCredits(List<NRMSCredits> credits) {
        this.b = credits;
    }

    public void setTcses(List<NRMSTcses> tcses) {
        this.c = tcses;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean hasPermissionForSelect(byte[] command) {
        LOG.info(">> hasPermissionForSelect()");
        LOG.info("++ command : [%s]", BinaryUtil.toHexString(command));
        if (this.getPackageName().equalsIgnoreCase("com.skp.nop.tc") || this.getPackageName().equalsIgnoreCase("com.skplanet.nfc.smarttouch")) {
            LOG.info("-- returned");
            return true;
        }
        boolean hasPermission = false;
        if (command[1] == -92 && command[2] == 4) {
            byte[] baInstanceAid = new byte[command[4]];
            String strInputInstanceAid = null;
            try {
                System.arraycopy(command, 5, baInstanceAid, 0, baInstanceAid.length);
                strInputInstanceAid = BinaryUtil.toHexString(baInstanceAid);
                if (strInputInstanceAid == null || strInputInstanceAid.length() < 2) {
                    throw new Exception("***** this is not aid");
                }
                if (this.a == null || this.a.size() < 1) {
                    throw new Exception("***** applets is null");
                }
                LOG.warning("this is select aid [%s]", strInputInstanceAid);
                for (NRMSApplets a2 : this.a) {
                    String fCd;
                    a2.dump(a2);
                    String instanceAID = a2.getInstAid();
                    String sdAID = a2.getSdAid();
                    if (strInputInstanceAid.equalsIgnoreCase(instanceAID)) {
                        LOG.warning("has permission instanceAID");
                        return true;
                    }
                    if (strInputInstanceAid.contains(BinaryUtil.toHexString(e)) && strInputInstanceAid.startsWith(BinaryUtil.toHexString(e))) {
                        LOG.warning("this is visa rid");
                        fCd = this.a(baInstanceAid);
                        if (fCd == null || fCd.length() != 2) continue;
                        for (NRMSCredits credit : this.b) {
                            if (!credit.getFinanceCd().equalsIgnoreCase(fCd)) continue;
                            LOG.warning("has permission for finance cd for visa");
                            return true;
                        }
                        continue;
                    }
                    if (strInputInstanceAid.contains(BinaryUtil.toHexString(f)) && strInputInstanceAid.startsWith(BinaryUtil.toHexString(f))) {
                        LOG.warning("this is visa master");
                        fCd = this.a(baInstanceAid);
                        if (fCd == null || fCd.length() != 2) continue;
                        for (NRMSCredits credit : this.b) {
                            if (!credit.getFinanceCd().equalsIgnoreCase(fCd)) continue;
                            LOG.warning("has permission for finance cd for master");
                            return true;
                        }
                        continue;
                    }
                    if (strInputInstanceAid.contains(BinaryUtil.toHexString(g)) && strInputInstanceAid.startsWith(BinaryUtil.toHexString(g))) {
                        LOG.warning("this is visa amex01");
                        fCd = this.a(baInstanceAid);
                        if (fCd == null || fCd.length() != 2) continue;
                        for (NRMSCredits credit : this.b) {
                            if (!credit.getFinanceCd().equalsIgnoreCase(fCd)) continue;
                            LOG.warning("has permission for finance cd for amex01");
                            return true;
                        }
                        continue;
                    }
                    if (strInputInstanceAid.contains(BinaryUtil.toHexString(h)) && strInputInstanceAid.startsWith(BinaryUtil.toHexString(h))) {
                        LOG.warning("this is visa amex02");
                        fCd = this.a(baInstanceAid);
                        if (fCd == null || fCd.length() != 2) continue;
                        for (NRMSCredits credit : this.b) {
                            if (!credit.getFinanceCd().equalsIgnoreCase(fCd)) continue;
                            LOG.warning("has permission for finance cd for amex02");
                            return true;
                        }
                        continue;
                    }
                    if (strInputInstanceAid.contains(BinaryUtil.toHexString(i)) && strInputInstanceAid.startsWith(BinaryUtil.toHexString(i))) {
                        LOG.warning("this is mobia");
                        fCd = this.b(baInstanceAid);
                        LOG.info("++ fCd : [%s]", fCd);
                        if (fCd != null && fCd.length() == 4) {
                            for (NRMSTcses tcs : this.c) {
                                LOG.info("++ tcs.getFinanceCd() : [%s]", tcs.getFinanceCd());
                                if (!tcs.getFinanceCd().equalsIgnoreCase(fCd)) continue;
                                LOG.warning("has permission for finance cd for mobia");
                                return true;
                            }
                        }
                        LOG.warning("has permission for finance cd for mobia always");
                        return true;
                    }
                    if (strInputInstanceAid.contains(instanceAID) && strInputInstanceAid.startsWith(instanceAID)) {
                        LOG.warning("has permission pattern");
                        return true;
                    }
                    if (strInputInstanceAid.contains(instanceAID.toUpperCase()) && strInputInstanceAid.startsWith(instanceAID.toUpperCase())) {
                        LOG.warning("has permission pattern");
                        return true;
                    }
                    if (strInputInstanceAid.equalsIgnoreCase(sdAID)) {
                        LOG.warning("has permission sd aid");
                        return true;
                    }
                    if (this.b == null || this.b.size() <= 0) continue;
                    for (NRMSCredits credit : this.b) {
                        String sdAidForCredit = credit.getSdAid();
                        if (!strInputInstanceAid.equalsIgnoreCase(sdAidForCredit)) continue;
                        LOG.warning("has permission finance's sd aid");
                        return true;
                    }
                }
            }
            catch (Exception e) {
                LOG.error(e);
            }
        } else {
            hasPermission = true;
        }
        return hasPermission;
    }

    public String getICCID() throws Exception {
        int j;
        String iccid = null;
        byte[] baRPDU = null;
        byte[] baICCID = null;
        baRPDU = this.transmit(BinaryUtil.parseHexString("00A4000C022FE2"));
        LOG.info("++ baRPDU : [%s]", BinaryUtil.toHexString(baRPDU));
        if (!this.isResponseSuccess(baRPDU)) {
            throw new Exception("***** File select failed");
        }
        baRPDU = this.transmit(BinaryUtil.parseHexString("00B000000A"));
        LOG.info("++ baRPDU : [%s]", BinaryUtil.toHexString(baRPDU));
        if (!this.isResponseSuccess(baRPDU)) {
            throw new Exception("***** ICCID read faild");
        }
        baICCID = new byte[baRPDU.length - 2];
        System.arraycopy(baRPDU, 0, baICCID, 0, baICCID.length);
        String tmpIccid = BinaryUtil.toHexString(baICCID);
        int nByteCount = tmpIccid.length() / 2;
        String[][] tempHexString = new String[nByteCount][2];
        int nCount = 0;
        int i = 0;
        while (i < nByteCount) {
            j = 0;
            while (j < 2) {
                tempHexString[i][j] = String.format("%c", Character.valueOf(tmpIccid.charAt(nCount)));
                ++nCount;
                ++j;
            }
            ++i;
        }
        iccid = "";
        i = 0;
        while (i < nByteCount) {
            j = 1;
            while (j >= 0) {
                iccid = String.valueOf(iccid) + tempHexString[i][j];
                --j;
            }
            ++i;
        }
        LOG.info("++ tmpIccid : [%s]", tmpIccid);
        LOG.info("++ iccid : [%s]", iccid);
        return iccid;
    }

    protected String getPackageName() {
        LOG.info(">> getPackageName()");
        PackageManager pm = null;
        PackageInfo info = null;
        try {
            pm = this.d.getPackageManager();
            info = pm.getPackageInfo(this.d.getPackageName(), 0);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return info.packageName;
    }

    private String a(byte[] baInstanceAid) {
        String financeCode;
        block7: {
            LOG.info(">> parseFinanceCode()");
            financeCode = null;
            try {
                try {
                    if (baInstanceAid == null || baInstanceAid.length < 15) {
                        throw new IllegalArgumentException("***** invalid credit card aid !!");
                    }
                    byte[] baRid = new byte[5];
                    byte[] baPix = new byte[2];
                    byte[] baBin = new byte[3];
                    byte[] baExt = new byte[5];
                    if (baInstanceAid.length >= 15) {
                        System.arraycopy(baInstanceAid, 0, baRid, 0, 5);
                        System.arraycopy(baInstanceAid, 5, baPix, 0, 2);
                        System.arraycopy(baInstanceAid, 7, baBin, 0, 3);
                        System.arraycopy(baInstanceAid, 10, baExt, 0, 5);
                        LOG.error("++ baInstanceAid : [%s]", BinaryUtil.toHexString(baInstanceAid));
                        LOG.error("++ baRid : [%s]", BinaryUtil.toHexString(baRid));
                        LOG.error("++ baPix : [%s]", BinaryUtil.toHexString(baPix));
                        LOG.error("++ baBin : [%s]", BinaryUtil.toHexString(baBin));
                        LOG.error("++ baExt : [%s]", BinaryUtil.toHexString(baExt));
                    }
                    String strExt = BinaryUtil.toHexString(baExt);
                    financeCode = strExt.substring(0, 2);
                }
                catch (Exception e) {
                    LOG.error(e);
                    LOG.info("++ returned : [%s]", financeCode);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                LOG.info("++ returned : [%s]", financeCode);
                throw throwable;
            }
            LOG.info("++ returned : [%s]", financeCode);
        }
        return financeCode;
    }

    private String b(byte[] baInstanceAid) {
        String financeCode;
        block6: {
            LOG.info(">> parseFinanceCode()");
            LOG.info("++ baInstanceAid : [%s]", BinaryUtil.toHexString(baInstanceAid));
            financeCode = null;
            try {
                try {
                    if (baInstanceAid == null || baInstanceAid.length < 16) {
                        throw new IllegalArgumentException("***** invalid credit card aid !!");
                    }
                    byte[] baRid = new byte[5];
                    byte[] baSvs = new byte[2];
                    byte[] baRfu = new byte[1];
                    byte[] baFcd = new byte[2];
                    byte[] baPcd = new byte[5];
                    byte[] baNum = new byte[1];
                    System.arraycopy(baInstanceAid, 0, baRid, 0, 5);
                    System.arraycopy(baInstanceAid, 5, baSvs, 0, 2);
                    System.arraycopy(baInstanceAid, 7, baRfu, 0, 1);
                    System.arraycopy(baInstanceAid, 8, baFcd, 0, 2);
                    System.arraycopy(baInstanceAid, 10, baPcd, 0, 5);
                    System.arraycopy(baInstanceAid, 15, baNum, 0, 1);
                    LOG.error("++ baInstanceAid : [%s]", BinaryUtil.toHexString(baInstanceAid));
                    LOG.error("++ baRid : [%s]", BinaryUtil.toHexString(baRid));
                    LOG.error("++ baSvs : [%s]", BinaryUtil.toHexString(baSvs));
                    LOG.error("++ baRfu : [%s]", BinaryUtil.toHexString(baRfu));
                    LOG.error("++ baFcd : [%s]", BinaryUtil.toHexString(baFcd));
                    LOG.error("++ baPcd : [%s]", BinaryUtil.toHexString(baPcd));
                    LOG.error("++ baNum : [%s]", BinaryUtil.toHexString(baNum));
                    financeCode = BinaryUtil.toHexString(baFcd);
                }
                catch (Exception e) {
                    LOG.error(e);
                    LOG.info("++parseFinanceCode returned : [%s]", financeCode);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                LOG.info("++parseFinanceCode returned : [%s]", financeCode);
                throw throwable;
            }
            LOG.info("++parseFinanceCode returned : [%s]", financeCode);
        }
        return financeCode;
    }
}

