/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.tools.smartcard;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.skp.smarttouch.sem.tools.smartcard.AbstractSmartcard;
import com.sktelecom.smartcard.ISmartcard;
import java.util.concurrent.Semaphore;
import kr.co.skplanet.utils.LOG;
import kr.co.skplanet.utils.Util;

public class SmartcardEmul
extends AbstractSmartcard {
    private final Semaphore a = new Semaphore(1);

    public SmartcardEmul(Context context, ISmartcard cardService) {
        super(context, cardService);
    }

    @Override
    public void setSmartcard(ISmartcard cardService) {
        super.setSmartcard(cardService);
    }

    public ISmartcard getSmartcard() {
        return this.mCard;
    }

    protected void alog(String msg) {
        Log.w((String)this.getClass().getName(), (String)msg);
    }

    public boolean isEnable() {
        boolean bRet = false;
        this.alog("Smartcard::isEnable");
        this.alog("Smartcard::isEnable::mCard = " + this.mCard);
        if (this.mCard != null) {
            bRet = true;
        }
        return bRet;
    }

    @Override
    public int getChannel() {
        int channel = -1;
        if (this.mCard != null) {
            try {
                channel = this.mCard.getChannel();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return channel;
    }

    @Override
    public byte[] getATR() {
        byte[] atr = null;
        if (this.mCard != null) {
            byte[] buf = new byte[256];
            try {
                int ret = this.mCard.getATR(buf);
                if (ret > 0) {
                    atr = new byte[ret];
                    System.arraycopy(buf, 0, atr, 0, ret);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return atr;
    }

    @Override
    public int connect() {
        int rCode = 0;
        if (this.mCard == null) {
            this.alog("connect() fail! : mCard is null!");
            return -3;
        }
        try {
            rCode = this.mCard.connect();
            this.alog("connect() return  " + rCode);
        }
        catch (RemoteException e) {
            this.alog("connect() Error : " + e.toString());
        }
        if (rCode > 0) {
            try {
                this.a.acquire();
                this.alog("connect() =============> semaphore acquire");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return rCode;
    }

    @Override
    public int disconnect() {
        int rCode = 0;
        if (this.mCard == null) {
            this.alog("disconnect() fail! : mCard is null");
            return -3;
        }
        try {
            rCode = this.mCard.disconnect();
            this.alog("disconnect() : return " + rCode);
        }
        catch (RemoteException e) {
            this.alog("disconnect() Error : " + e.toString());
        }
        this.a.release();
        this.alog("disconnect() =============> semaphore release");
        return rCode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] transmit(byte[] command) {
        int rCode = -8;
        byte[] tempRes = new byte[258];
        byte[] response = null;
        if (this.mCard == null) {
            this.alog("transmit() is fail!! : mCard is null!");
            return null;
        }
        if (command == null) {
            this.alog("transmit() is fail!! : command is null");
            return null;
        }
        if (!this.hasPermissionForSelect(command)) {
            LOG.error("***** do not have permission to select command !!");
            return null;
        }
        Util.DumpPacket("Smartcard::transmit", command, command.length);
        try {
            rCode = this.mCard.transmit(command, tempRes);
            if (rCode <= 0) {
                this.alog("transmit() error!!! return " + rCode);
                return response;
            }
            if (rCode == 2 && tempRes[0] == 97) {
                byte[] byArray = new byte[5];
                byArray[1] = -64;
                byte[] cmdReadMore = byArray;
                cmdReadMore[4] = tempRes[1];
                Util.MEMSET(tempRes, 0, (byte)0, 258);
                rCode = this.mCard.transmit(cmdReadMore, tempRes);
                if (rCode < 0) {
                    this.alog("transmit() error!! Fail to read more....(61 xx)");
                    return null;
                }
            }
            response = new byte[rCode];
            System.arraycopy(tempRes, 0, response, 0, rCode);
            Util.DumpPacket("transmit() response", response, response.length);
            return response;
        }
        catch (RemoteException e) {
            this.alog("trasmit() Error : " + e.toString());
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] transmit(String compId, byte[] command) {
        LOG.warning(">> transmit()");
        LOG.warning("++ compId : [%s]", compId);
        int rCode = -8;
        byte[] tempRes = new byte[258];
        byte[] response = null;
        if (this.mCard == null) {
            this.alog("transmit() is fail!! : mCard is null!");
            return null;
        }
        if (command == null) {
            this.alog("transmit() is fail!! : command is null");
            return null;
        }
        if (!("STD_TRP".equalsIgnoreCase(compId) || "STD_TWR".equalsIgnoreCase(compId) || this.hasPermissionForSelect(command))) {
            LOG.error("***** do not have permission to select command !!");
            return null;
        }
        Util.DumpPacket("Smartcard::transmit", command, command.length);
        try {
            rCode = this.mCard.transmit(command, tempRes);
            if (rCode <= 0) {
                this.alog("transmit() error!!! return " + rCode);
                return response;
            }
            if (rCode == 2 && tempRes[0] == 97) {
                byte[] byArray = new byte[5];
                byArray[1] = -64;
                byte[] cmdReadMore = byArray;
                cmdReadMore[4] = tempRes[1];
                Util.MEMSET(tempRes, 0, (byte)0, 258);
                rCode = this.mCard.transmit(cmdReadMore, tempRes);
                if (rCode < 0) {
                    this.alog("transmit() error!! Fail to read more....(61 xx)");
                    return null;
                }
            }
            response = new byte[rCode];
            System.arraycopy(tempRes, 0, response, 0, rCode);
            Util.DumpPacket("transmit() response", response, response.length);
            return response;
        }
        catch (RemoteException e) {
            this.alog("trasmit() Error : " + e.toString());
        }
        return response;
    }

    @Override
    public boolean isResponseSuccess(byte[] res) {
        if (res == null) {
            this.alog("isResponseSuccess() fail!! : response is null");
            return false;
        }
        int len = res.length;
        byte[] SW = new byte[]{res[len - 2], res[len - 1]};
        return SW[0] == RESULT_SUCCESS[0] && SW[1] == RESULT_SUCCESS[1];
    }

    @Override
    public byte[] cmdSELECT(byte[] aid) {
        int aidLen = aid.length;
        byte[] cmdSelect = new byte[5 + aidLen];
        cmdSelect[0] = 0;
        cmdSelect[1] = -92;
        cmdSelect[2] = 4;
        cmdSelect[3] = 0;
        cmdSelect[4] = (byte)aidLen;
        int i = 0;
        while (i < aidLen) {
            cmdSelect[5 + i] = aid[i];
            ++i;
        }
        return this.transmit(cmdSelect);
    }

    @Override
    public byte[] cmdSELECT(String compId, byte[] aid) {
        int aidLen = aid.length;
        byte[] cmdSelect = new byte[5 + aidLen];
        cmdSelect[0] = 0;
        cmdSelect[1] = -92;
        cmdSelect[2] = 4;
        cmdSelect[3] = 0;
        cmdSelect[4] = (byte)aidLen;
        int i = 0;
        while (i < aidLen) {
            cmdSelect[5 + i] = aid[i];
            ++i;
        }
        return this.transmit(compId, cmdSelect);
    }
}

