/*
 * Decompiled with CFR 0.152.
 */
package kr.or.kftc.smartcard;

import android.nfc.tech.IsoDep;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import kr.or.kftc.crypto.HSMCrypt;
import kr.or.kftc.crypto.HSMCryptException;
import kr.or.kftc.crypto.RSAPublicKey;
import kr.or.kftc.mobiletoken_lib.util.DataConverter;
import kr.or.kftc.mobiletoken_lib.util.LibLog;

public class SecurityToken {
    static final String TAG = SecurityToken.class.getSimpleName();
    private HSMCrypt mCryptoKFTC;
    public KFTCTokenInfo tokenInfo = new KFTCTokenInfo();
    private DataConverter mConverter = new DataConverter();
    public static final int ISODEP_TIMEOUT = 5000;
    public static final byte LENGTH_TOKENINFO = 94;
    public static final byte LENGTH_FCI = 27;
    public static final byte LENGTH_CERTIFICATE_R = 20;
    public static final byte INIT_RSA_DECRYPT = 8;
    public static final byte INIT_TDES_CBC_DECRYPT = 25;
    public static final byte INIT_SEED_CBC_DECRYPT = 41;
    public static final byte INIT_AES128_CBC_DECRYPT = 73;
    public static final short TOKEN_S_SUCCESS = 0;
    public static final short TOKEN_E_UNKNOWN = 3840;
    public static final short TOKEN_E_UNSUPPORTED_TOKEN = 3841;
    public static final short TOKEN_E_INVALID_PARAMETER = 3842;
    public static final short TOKEN_E_VERIFY_PIN_FAIL = 3843;
    public static final short TOKEN_E_INVALID_CERTKEY_IDX = 3844;
    public static final short TOKEN_E_PIN_BLOCK = 3845;
    public static final short TOKEN_E_SECURITY_NOT_SATISFY = 3846;
    public static final short TOKEN_E_EXCEED_MAXCOUNT = 3847;
    public static final short TOKEN_E_NO_TOKEN_AVAILABLE = 4033;
    public static final short TOKEN_E_TOKEN_LOST = 4034;
    public static final short TOKEN_E_SCARD_COMM_ERROR = 4035;
    public static final short TOKEN_E_SCARD_CMD_FAIL = 4036;
    public static final short TOKEN_E_NO_CERT = 4037;
    static final byte[] CAPDU_SELECT_APPLET;
    static final byte[] CAPDU_GET_CERTIFICATE_LIST;
    static final byte[] CAPDU_GET_PUBLICKEY_FOR_ENC;
    static final byte[] CAPDU_GET_KEY_PIN_STATUS;
    static final byte[] CAPDU_CHECK_PIN_VERIFICATION;
    static final byte[] CAPDU_GET_TOKEN_INFO;
    static final byte[] CAPDU_GET_CHALLENGE_FOR_INTERNAL;
    static final byte[] CAPDU_PUT_DATA;
    static final byte[] CAPDU_MUTUAL_AUTH;
    private byte[] capduGetChallenge;
    static final byte[] CAPDU_UPDATE_BINARY;
    private byte[] capduGetCertificateSize;
    private byte[] capduSelectFile;
    private byte[] capduReadBinary;
    private byte[] capduClear;
    private byte[] capudGetCertificateR;
    private byte[] capudVerifyPIN;
    private byte[] capduPutPIN;
    private byte[] capudInitializeCrypto;
    private byte[] capudPerformCrypto;
    private byte[] capduGenerateKeyPair;
    private byte[] capduStorePrivateKey;
    static final short APDU_P1 = 2;
    static final short APDU_P2 = 3;
    static final short APDU_Lc = 4;
    static final short APDU_Le = 4;
    static final short APDU_DATA = 5;
    public byte[] RAPDU_DATA;
    public byte[] RAPDU_SW12;
    private TokenDeviceType tokenDeviceType;
    private IsoDep cardNFC;

    static {
        byte[] byArray = new byte[12];
        byArray[1] = -92;
        byArray[2] = 4;
        byArray[4] = 7;
        byArray[5] = -44;
        byArray[6] = 16;
        byArray[7] = 101;
        byArray[8] = 9;
        byArray[9] = -112;
        byArray[11] = -128;
        CAPDU_SELECT_APPLET = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[1] = -54;
        byArray2[2] = 1;
        byArray2[3] = -111;
        byArray2[4] = 8;
        CAPDU_GET_CERTIFICATE_LIST = byArray2;
        byte[] byArray3 = new byte[5];
        byArray3[1] = -54;
        byArray3[2] = 1;
        byArray3[3] = -16;
        byArray3[4] = -122;
        CAPDU_GET_PUBLICKEY_FOR_ENC = byArray3;
        byte[] byArray4 = new byte[5];
        byArray4[1] = -54;
        byArray4[2] = 1;
        byArray4[3] = -110;
        byArray4[4] = 1;
        CAPDU_GET_KEY_PIN_STATUS = byArray4;
        byte[] byArray5 = new byte[5];
        byArray5[1] = 32;
        byArray5[3] = 1;
        CAPDU_CHECK_PIN_VERIFICATION = byArray5;
        byte[] byArray6 = new byte[5];
        byArray6[1] = -54;
        byArray6[2] = 1;
        byArray6[3] = 17;
        byArray6[4] = 94;
        CAPDU_GET_TOKEN_INFO = byArray6;
        byte[] byArray7 = new byte[5];
        byArray7[1] = -124;
        byArray7[2] = 1;
        byArray7[4] = 16;
        CAPDU_GET_CHALLENGE_FOR_INTERNAL = byArray7;
        byte[] byArray8 = new byte[5];
        byArray8[1] = -38;
        byArray8[2] = 1;
        CAPDU_PUT_DATA = byArray8;
        byte[] byArray9 = new byte[5];
        byArray9[1] = -126;
        byArray9[4] = 32;
        CAPDU_MUTUAL_AUTH = byArray9;
        byte[] byArray10 = new byte[5];
        byArray10[1] = -42;
        byArray10[4] = -56;
        CAPDU_UPDATE_BINARY = byArray10;
    }

    public SecurityToken(TokenDeviceType targetDevice) {
        byte[] byArray = new byte[5];
        byArray[1] = -124;
        byArray[2] = -1;
        this.capduGetChallenge = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[1] = -54;
        byArray2[2] = 1;
        byArray2[4] = 2;
        this.capduGetCertificateSize = byArray2;
        byte[] byArray3 = new byte[7];
        byArray3[1] = -92;
        byArray3[4] = 2;
        this.capduSelectFile = byArray3;
        byte[] byArray4 = new byte[5];
        byArray4[1] = -80;
        this.capduReadBinary = byArray4;
        byte[] byArray5 = new byte[5];
        byArray5[0] = -112;
        byArray5[1] = 12;
        this.capduClear = byArray5;
        byte[] byArray6 = new byte[5];
        byArray6[1] = -54;
        byArray6[2] = 1;
        byArray6[4] = 20;
        this.capudGetCertificateR = byArray6;
        byte[] byArray7 = new byte[5];
        byArray7[1] = 32;
        byArray7[3] = 1;
        this.capudVerifyPIN = byArray7;
        byte[] byArray8 = new byte[5];
        byArray8[0] = -112;
        byArray8[1] = 36;
        byArray8[3] = 1;
        this.capduPutPIN = byArray8;
        byte[] byArray9 = new byte[5];
        byArray9[0] = -112;
        byArray9[1] = 42;
        this.capudInitializeCrypto = byArray9;
        byte[] byArray10 = new byte[5];
        byArray10[0] = -112;
        byArray10[1] = 46;
        this.capudPerformCrypto = byArray10;
        byte[] byArray11 = new byte[5];
        byArray11[0] = -112;
        byArray11[1] = 70;
        this.capduGenerateKeyPair = byArray11;
        byte[] byArray12 = new byte[5];
        byArray12[0] = -112;
        byArray12[1] = 60;
        this.capduStorePrivateKey = byArray12;
        this.RAPDU_SW12 = new byte[2];
        try {
            this.tokenDeviceType = targetDevice;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! SecurityToken Constructor Exception.");
            e.printStackTrace();
        }
    }

    public void SetCard(IsoDep isoDep) {
        try {
            this.cardNFC = isoDep;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! SecurityToken.SetCard Exception.");
            e.printStackTrace();
        }
    }

    public boolean isConnectedCard() {
        boolean bIsConn = false;
        try {
            bIsConn = this.cardNFC.isConnected();
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! SecurityToken.isConnectedCard Exception.");
            e.printStackTrace();
        }
        return bIsConn;
    }

    public boolean ConnectCard() {
        if (this.tokenDeviceType == TokenDeviceType.NFC) {
            block4: {
                try {
                    if (!this.cardNFC.isConnected()) break block4;
                    return true;
                }
                catch (Exception e) {
                    LibLog.e(TAG, "!!!! NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0\uc911 IOException \uc624\ub958 \ubc1c\uc0dd");
                    e.printStackTrace();
                    return false;
                }
            }
            this.cardNFC.connect();
            this.cardNFC.setTimeout(5000);
        }
        return true;
    }

    public void DisconnectCard() {
        if (this.tokenDeviceType == TokenDeviceType.NFC) {
            try {
                if (this.cardNFC.isConnected()) {
                    this.cardNFC.close();
                }
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0\ud574\uc81c\uc911 IOException \uc624\ub958 \ubc1c\uc0dd");
                e.printStackTrace();
                return;
            }
        }
    }

    public short SelectApplet() {
        block14: {
            block15: {
                block13: {
                    short iRet = 3840;
                    LibLog.i(TAG, "## TOKEN CONTROL: Select Applet");
                    iRet = this.tokenTransmit(CAPDU_SELECT_APPLET);
                    if (iRet != 0) {
                        return iRet;
                    }
                    if (this.RAPDU_SW12[0] == -112) break block13;
                    return 4033;
                }
                System.arraycopy(this.RAPDU_DATA, 16, this.tokenInfo.issuerCode, 0, 3);
                this.tokenInfo.tokenSpecVersion = this.RAPDU_DATA[19];
                this.tokenInfo.maxCertificates = this.RAPDU_DATA[20];
                this.tokenInfo.tokenKeyFeature = this.RAPDU_DATA[21];
                this.tokenInfo.authType = this.RAPDU_DATA[22];
                this.tokenInfo.cryptoAlgorithm = this.RAPDU_DATA[23];
                LibLog.d(TAG, "## \ud1a0\ud070 \ud45c\uc900\ud654 \ubc84\uc804 : " + String.format("%02x", this.tokenInfo.tokenSpecVersion));
                LibLog.d(TAG, "## \uc0ac\uc6a9\uc790 \uc778\uc99d \uc54c\uace0\ub9ac\uc998 : " + String.format("%02x", (byte)(this.tokenInfo.authType & 0xF0)));
                if ((byte)(this.tokenInfo.authType & 0xF0) == 32) {
                    LibLog.d(TAG, "## \uc0ac\uc6a9\uc790 \uc778\uc99d \uc54c\uace0\ub9ac\uc998 : RSA");
                    this.mCryptoKFTC = LibLog.isDebugMode() ? new HSMCrypt(-128, "MTKCrypto") : new HSMCrypt(-128);
                    break block14;
                }
                if ((byte)(this.tokenInfo.authType & 0xF0) != -128) break block15;
                if (this.tokenInfo.cryptoAlgorithm == 16) {
                    LibLog.d(TAG, "## \uc0ac\uc6a9\uc790 \uc778\uc99d \uc54c\uace0\ub9ac\uc998 : 3DES");
                    this.mCryptoKFTC = LibLog.isDebugMode() ? new HSMCrypt(16, "MTKCrypto") : new HSMCrypt(16);
                    break block14;
                }
                if (this.tokenInfo.cryptoAlgorithm == 32) {
                    LibLog.d(TAG, "## \uc0ac\uc6a9\uc790 \uc778\uc99d \uc54c\uace0\ub9ac\uc998 : SEED");
                    this.mCryptoKFTC = LibLog.isDebugMode() ? new HSMCrypt(32, "MTKCrypto") : new HSMCrypt(32);
                    break block14;
                }
                if (this.tokenInfo.cryptoAlgorithm == 64) {
                    LibLog.d(TAG, "## \uc0ac\uc6a9\uc790 \uc778\uc99d \uc54c\uace0\ub9ac\uc998 : AES128");
                    this.mCryptoKFTC = LibLog.isDebugMode() ? new HSMCrypt(64, "MTKCrypto") : new HSMCrypt(64);
                    break block14;
                }
                LibLog.e(TAG, "!!!! \uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc0ac\uc6a9\uc790 \uc778\uc99d \uc54c\uace0\ub9ac\uc998 \uc0ac\uc6a9: " + String.format("%02x", this.tokenInfo.cryptoAlgorithm));
                return 3841;
            }
            LibLog.e(TAG, "!!!! \uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc0ac\uc6a9\uc790 \uc778\uc99d \ubc29\ubc95 \uc0ac\uc6a9");
            return 3841;
        }
        try {
            if (this.tokenInfo.tokenSpecVersion < 3) {
                return 3841;
            }
            return 0;
        }
        catch (HSMCryptException he) {
            String emsg = he.getMessage();
            if (emsg == null) {
                emsg = "";
            }
            LibLog.e(TAG, "!!!! SelectApplet Exception: " + emsg);
            return 3840;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! SelectApplet Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    public short GetTokenInfo() {
        block4: {
            short iRet = 3840;
            try {
                LibLog.i(TAG, "## TOKEN CONTROL: Get Token Info");
                iRet = this.tokenTransmit(CAPDU_GET_TOKEN_INFO);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] == -112) break block4;
                return 4036;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! GetTokenInfo Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        byte[] tmpArr = null;
        tmpArr = Arrays.copyOfRange(this.RAPDU_DATA, 0, 32);
        this.tokenInfo.tokenLabel = tmpArr;
        tmpArr = Arrays.copyOfRange(this.RAPDU_DATA, 32, 64);
        this.tokenInfo.manufacturerID = tmpArr;
        tmpArr = Arrays.copyOfRange(this.RAPDU_DATA, 64, 80);
        this.tokenInfo.tokenModel = tmpArr;
        tmpArr = Arrays.copyOfRange(this.RAPDU_DATA, 80, 88);
        this.tokenInfo.tokenSerialNumber = tmpArr;
        this.tokenInfo.maxPinLen = this.RAPDU_DATA[88];
        this.tokenInfo.minPinLen = this.RAPDU_DATA[89];
        tmpArr = Arrays.copyOfRange(this.RAPDU_DATA, 90, 92);
        this.tokenInfo.hwVersion = tmpArr;
        tmpArr = Arrays.copyOfRange(this.RAPDU_DATA, 92, 94);
        this.tokenInfo.fwVersion = tmpArr;
        return 0;
    }

    public short GetFCI(byte[] outFCI) {
        block7: {
            short iRet;
            block6: {
                iRet = 3840;
                try {
                    LibLog.i(TAG, "## TOKEN CONTROL: Get FCI");
                    this.capduSelectFile[5] = -8;
                    this.capduSelectFile[6] = 30;
                    iRet = this.tokenTransmit(this.capduSelectFile);
                    if (iRet != 0) {
                        return iRet;
                    }
                    if (this.RAPDU_SW12[0] == -112) break block6;
                    return 4036;
                }
                catch (Exception e) {
                    LibLog.e(TAG, "!!!! GetFCI Exception");
                    e.printStackTrace();
                    return 3840;
                }
            }
            this.capduReadBinary[2] = 0;
            this.capduReadBinary[3] = 0;
            this.capduReadBinary[4] = 27;
            iRet = this.tokenTransmit(this.capduReadBinary);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] == -112) break block7;
            return 4036;
        }
        System.arraycopy(this.RAPDU_DATA, 0, outFCI, 0, this.RAPDU_DATA.length);
        return 0;
    }

    public short MutualAuthenticate(byte[] issuerEncData, byte[] tokenEncData) {
        block5: {
            short iRet = 3840;
            try {
                byte[] capduMutualAuth = new byte[37];
                System.arraycopy(CAPDU_MUTUAL_AUTH, 0, capduMutualAuth, 0, CAPDU_MUTUAL_AUTH.length);
                System.arraycopy(issuerEncData, 0, capduMutualAuth, CAPDU_MUTUAL_AUTH.length, issuerEncData.length);
                iRet = this.tokenTransmit(capduMutualAuth);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] != -112) break block5;
                System.arraycopy(this.RAPDU_DATA, 0, tokenEncData, 0, this.RAPDU_DATA.length);
                return 0;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! MutualAuthenticate Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        if (this.RAPDU_SW12[0] == 105) {
            return 3846;
        }
        return 4036;
    }

    public short GetIssueKeyAndPinStatus(byte[] outKeyPinStatus) {
        block4: {
            short iRet = 3840;
            try {
                iRet = this.tokenTransmit(CAPDU_GET_KEY_PIN_STATUS);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] == -112) break block4;
                return 4036;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! GetIssueKeyAndPinStatus Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        outKeyPinStatus[0] = this.RAPDU_DATA[0];
        return 0;
    }

    public short GetCertificateList(byte[] outCertificateList) {
        block4: {
            short iRet = 3840;
            try {
                LibLog.i(TAG, "## TOKEN CONTROL: Get Certificate List");
                iRet = this.tokenTransmit(CAPDU_GET_CERTIFICATE_LIST);
                if (iRet != 0) {
                    return iRet;
                }
                LibLog.d(TAG, "#Get Certificate List:" + this.mConverter.HexToStringForDisplay(this.RAPDU_DATA, 0, this.RAPDU_DATA.length) + ":" + this.mConverter.HexToStringForDisplay(this.RAPDU_SW12, 0, this.RAPDU_SW12.length));
                if (this.RAPDU_SW12[0] == -112) break block4;
                return 4036;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! GetCertificateList Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        System.arraycopy(this.RAPDU_DATA, 0, outCertificateList, 0, this.RAPDU_DATA.length);
        return 0;
    }

    public short GetCertificateSize(int certificateIndex, int[] outCertificateSize) {
        block6: {
            block5: {
                short iRet = 3840;
                try {
                    LibLog.i(TAG, "## TOKEN CONTROL: Get Certificate Size");
                    outCertificateSize[0] = 0;
                    this.capduGetCertificateSize[3] = (byte)(80 + (certificateIndex + 1));
                    iRet = this.tokenTransmit(this.capduGetCertificateSize);
                    if (iRet != 0) {
                        return iRet;
                    }
                    if (this.RAPDU_SW12[0] == -112) break block5;
                    return 4036;
                }
                catch (Exception e) {
                    LibLog.e(TAG, "!!!! GetCertificateSize Exception");
                    e.printStackTrace();
                    return 3840;
                }
            }
            if (this.RAPDU_DATA != null) break block6;
            return 3840;
        }
        outCertificateSize[0] = this.mConverter.BytesToInt(this.RAPDU_DATA, 0, this.RAPDU_DATA.length);
        return 0;
    }

    public short SelectCertificateFile(int certificateIndex) {
        short iRet = 3840;
        try {
            LibLog.i(TAG, "## TOKEN CONTROL: Select Certificate File");
            this.capduSelectFile[5] = -8;
            this.capduSelectFile[6] = (byte)(3 + 4 * certificateIndex);
            iRet = this.tokenTransmit(this.capduSelectFile);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] != -112) {
                return 4036;
            }
            return 0;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! SelectCertificateFile Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    public short SelectKeyFile(int certificateIndex) {
        short iRet = 3840;
        try {
            LibLog.i(TAG, "## TOKEN CONTROL: Select Key File");
            this.capduSelectFile[5] = -8;
            this.capduSelectFile[6] = (byte)(1 + 4 * certificateIndex);
            iRet = this.tokenTransmit(this.capduSelectFile);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] != -112) {
                return 4036;
            }
            return 0;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! SelectKeyFile Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    public short GetPublicKeyLength(int certificateIndex, byte[] outKeyLength) {
        short iRet;
        block9: {
            block8: {
                iRet = 3840;
                try {
                    LibLog.i(TAG, "## TOKEN CONTROL: Get PublicKey Length");
                    this.capduSelectFile[5] = -8;
                    this.capduSelectFile[6] = (byte)(4 + 4 * certificateIndex);
                    iRet = this.tokenTransmit(this.capduSelectFile);
                    if (iRet != 0) {
                        return iRet;
                    }
                    if (this.RAPDU_SW12[0] == -112) break block8;
                    return 4036;
                }
                catch (Exception e) {
                    LibLog.e(TAG, "!!!! SelectPublicKeyFile Exception");
                    e.printStackTrace();
                    return 3840;
                }
            }
            this.capduReadBinary[2] = 0;
            this.capduReadBinary[3] = 0;
            this.capduReadBinary[4] = 2;
            iRet = this.tokenTransmit(this.capduReadBinary);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] == -112) break block9;
            return 4036;
        }
        outKeyLength[0] = this.RAPDU_DATA[1];
        if (outKeyLength[0] == 0) {
            String tmpModel = "";
            tmpModel = this.tokenInfo.tokenModel[0] != 0 ? this.mConverter.HexToString(this.tokenInfo.tokenModel, 0, this.tokenInfo.tokenModel.length).toUpperCase() : "00";
            boolean bTargetModel = tmpModel.equals("544D4E34303732202020202020202020");
            if (bTargetModel && this.tokenInfo.fwVersion[0] == 1 && this.tokenInfo.fwVersion[1] == 0 || bTargetModel && this.tokenInfo.fwVersion[0] == 0 && this.tokenInfo.fwVersion[1] == 1) {
                LibLog.i(TAG, "** 0100");
                iRet = this.GetKeyLengthFromKeyInfoFile(certificateIndex, outKeyLength);
            }
        }
        return iRet;
    }

    public short GetCertificateData(int certificateLength, byte[] outCertificate) {
        short iRet = 0;
        int offset = 0;
        try {
            LibLog.i(TAG, "## TOKEN CONTROL: Get Certificate Data (len:" + certificateLength + ")");
            Arrays.fill(outCertificate, (byte)0);
            this.capduReadBinary[4] = certificateLength > 200 ? -56 : (byte)certificateLength;
            do {
                this.capduReadBinary[2] = (byte)(offset / 256);
                this.capduReadBinary[3] = (byte)(offset % 256);
                iRet = this.tokenTransmit(this.capduReadBinary);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] != -112) {
                    iRet = 4036;
                    break;
                }
                System.arraycopy(this.RAPDU_DATA, 0, outCertificate, offset, this.RAPDU_DATA.length);
                offset += this.RAPDU_DATA.length;
                if (certificateLength - this.RAPDU_DATA.length > 0) {
                    if ((certificateLength -= this.RAPDU_DATA.length) > 200) {
                        this.capduReadBinary[4] = -56;
                        continue;
                    }
                    this.capduReadBinary[4] = (byte)certificateLength;
                    continue;
                }
                certificateLength = 0;
            } while (certificateLength > 0);
            return iRet;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! GetCertificate Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    public short GetCertificateR(int certificateIndex, byte[] outCertificateR) {
        block5: {
            short iRet = 3840;
            try {
                LibLog.i(TAG, "## TOKEN CONTROL: Get Certificate R");
                this.capudGetCertificateR[3] = (byte)(64 + (certificateIndex + 1));
                iRet = this.tokenTransmit(this.capudGetCertificateR);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] != -112) break block5;
                System.arraycopy(this.RAPDU_DATA, 0, outCertificateR, 0, this.RAPDU_DATA.length);
                return 0;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! GetCertificateR Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        if (this.RAPDU_SW12[0] == 105) {
            return 3846;
        }
        return 4036;
    }

    public short GenerateSignature(byte[] dataToBeSigned, byte[] outSignature, int keyLength) {
        short iRet = 3840;
        try {
            LibLog.i(TAG, "## TOKEN CONTROL: Generate Signature");
            iRet = this.PerformCrypto(dataToBeSigned, outSignature, keyLength);
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! GenerateSignature Exception");
            e.printStackTrace();
        }
        return iRet;
    }

    public short Decrypt(byte[] dataToBeDecrypted, byte[] outDecryptedData, int keyLength) {
        short iRet = 3840;
        try {
            LibLog.i(TAG, "## TOKEN CONTROL: Decrypt");
            iRet = this.PerformCrypto(dataToBeDecrypted, outDecryptedData, keyLength);
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! Decrypt Exception");
            e.printStackTrace();
        }
        return iRet;
    }

    public short InitializeCrypto(byte P1, byte P2) {
        block5: {
            short iRet = 3840;
            try {
                LibLog.i(TAG, "## TOKEN CONTROL: Initialize Crypto");
                this.capudInitializeCrypto[2] = P1;
                this.capudInitializeCrypto[3] = P2;
                iRet = this.tokenTransmit(this.capudInitializeCrypto, 10000);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] != -112) break block5;
                return 0;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! InitializeCrypto Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        if (this.RAPDU_SW12[0] == 105) {
            return 3846;
        }
        return 4036;
    }

    public short InitializeCrypto(byte P1, byte P2, byte Lc) {
        block5: {
            short iRet = 3840;
            try {
                LibLog.i(TAG, "## TOKEN CONTROL: Initialize Crypto");
                byte[] capudInitializeCryptoSymm = new byte[5 + Lc];
                Arrays.fill(capudInitializeCryptoSymm, (byte)0);
                System.arraycopy(this.capudInitializeCrypto, 0, capudInitializeCryptoSymm, 0, this.capudInitializeCrypto.length);
                capudInitializeCryptoSymm[2] = P1;
                capudInitializeCryptoSymm[3] = P2;
                capudInitializeCryptoSymm[4] = Lc;
                iRet = this.tokenTransmit(capudInitializeCryptoSymm, 10000);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] != -112) break block5;
                return 0;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! InitializeCrypto Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        if (this.RAPDU_SW12[0] == 105) {
            return 3846;
        }
        return 4036;
    }

    public short PerformCrypto(byte[] inData, byte[] outData, int keyLength) {
        block8: {
            short iRet = 3840;
            try {
                byte[] genApduPerformCrypto;
                LibLog.i(TAG, "## TOKEN CONTROL: Perform Crypto");
                if (keyLength < 256) {
                    this.capudPerformCrypto[2] = 0;
                    this.capudPerformCrypto[3] = 0;
                    this.capudPerformCrypto[4] = (byte)keyLength;
                    genApduPerformCrypto = new byte[keyLength + 5];
                    System.arraycopy(this.capudPerformCrypto, 0, genApduPerformCrypto, 0, this.capudPerformCrypto.length);
                    System.arraycopy(inData, 0, genApduPerformCrypto, this.capudPerformCrypto.length, keyLength);
                } else {
                    this.capudPerformCrypto[2] = 1;
                    this.capudPerformCrypto[3] = inData[0];
                    this.capudPerformCrypto[4] = -1;
                    genApduPerformCrypto = new byte[260];
                    System.arraycopy(this.capudPerformCrypto, 0, genApduPerformCrypto, 0, this.capudPerformCrypto.length);
                    System.arraycopy(inData, 1, genApduPerformCrypto, this.capudPerformCrypto.length, 255);
                }
                iRet = this.tokenTransmit(genApduPerformCrypto, 120000);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] != -112) break block8;
                if (outData != null) {
                    System.arraycopy(this.RAPDU_DATA, 0, outData, 0, this.RAPDU_DATA.length);
                }
                return 0;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! PerformCrypto Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        if (this.RAPDU_SW12[0] == 105) {
            return 3846;
        }
        return 4036;
    }

    public short GenerateKeyPair(int keyIndex, byte keyTypeLength, byte[] outModulus, byte[] outExponent) {
        block6: {
            short iRet = 3840;
            LibLog.i(TAG, "## TOKEN CONTROL: Generate Key Pair");
            this.capduGenerateKeyPair[2] = (byte)keyIndex;
            this.capduGenerateKeyPair[3] = keyTypeLength;
            iRet = this.tokenTransmit(this.capduGenerateKeyPair, 180000);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] != -112) break block6;
            RSAPublicKey publicKey = new RSAPublicKey(this.RAPDU_DATA);
            System.arraycopy(publicKey.getModulus(), 0, outModulus, 0, publicKey.getKeyLength());
            System.arraycopy(publicKey.getExponent(), 0, outExponent, 0, 4);
            return 0;
        }
        try {
            if (this.RAPDU_SW12[0] == 105) {
                return 3846;
            }
            return 4036;
        }
        catch (HSMCryptException e) {
            LibLog.e(TAG, "!!!! \uacf5\uac1c\ud0a4 \ucc98\ub9ac \uc624\ub958(new RSAPublicKey)");
            return 3840;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! GenerateKeyPair Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    public short StorePrivateKey(int offset, byte[] privateKey, int privateKeyLength) {
        block5: {
            short iRet = 3840;
            try {
                LibLog.i(TAG, "## TOKEN CONTROL: Store Private Key");
                byte[] tmpCapduStorePrivateKey = new byte[5 + privateKeyLength];
                System.arraycopy(this.capduStorePrivateKey, 0, tmpCapduStorePrivateKey, 0, this.capduStorePrivateKey.length);
                tmpCapduStorePrivateKey[2] = (byte)(offset / 256);
                tmpCapduStorePrivateKey[3] = (byte)(offset % 256);
                tmpCapduStorePrivateKey[4] = (byte)privateKeyLength;
                System.arraycopy(privateKey, 0, tmpCapduStorePrivateKey, 5, privateKeyLength);
                iRet = this.tokenTransmit(tmpCapduStorePrivateKey, 10000);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] != -112) break block5;
                return 0;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! StorePrivateKey Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        if (this.RAPDU_SW12[0] == 105) {
            return 3846;
        }
        return 4036;
    }

    public short PutPublicKey(int keyIndex, byte[] publicKey) {
        int offset;
        int iRet;
        block8: {
            iRet = 3840;
            offset = 0;
            LibLog.i(TAG, "## TOKEN CONTROL: Select PublicKey File");
            this.capduSelectFile[5] = -8;
            this.capduSelectFile[6] = (byte)(4 + 4 * keyIndex);
            iRet = this.tokenTransmit(this.capduSelectFile);
            if (iRet != 0) {
                return (short)iRet;
            }
            if (this.RAPDU_SW12[0] == -112) break block8;
            return 4036;
        }
        try {
            byte[] capduUpdateBinary = null;
            int publicKeyLength = publicKey.length;
            capduUpdateBinary = publicKeyLength < 200 ? new byte[publicKeyLength + 5] : new byte[205];
            System.arraycopy(CAPDU_UPDATE_BINARY, 0, capduUpdateBinary, 0, CAPDU_UPDATE_BINARY.length);
            do {
                if (offset + 200 > publicKeyLength) {
                    capduUpdateBinary = new byte[publicKeyLength - offset + 5];
                    System.arraycopy(CAPDU_UPDATE_BINARY, 0, capduUpdateBinary, 0, CAPDU_UPDATE_BINARY.length);
                    capduUpdateBinary[4] = (byte)(publicKeyLength - offset);
                    System.arraycopy(publicKey, offset, capduUpdateBinary, 5, capduUpdateBinary[4] & 0xFF);
                } else {
                    capduUpdateBinary[4] = -56;
                    System.arraycopy(publicKey, offset, capduUpdateBinary, 5, 200);
                }
                capduUpdateBinary[2] = (byte)(offset / 256);
                capduUpdateBinary[3] = (byte)(offset % 256);
                iRet = this.tokenTransmit(capduUpdateBinary);
                if (iRet != 0) break;
                if (this.RAPDU_SW12[0] == -112 && this.RAPDU_SW12[1] == 0) continue;
                if (this.RAPDU_SW12[0] == 105) {
                    iRet = 3846;
                    break;
                }
                iRet = 4036;
                break;
            } while ((offset += 200) <= publicKeyLength);
            return (short)iRet;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! PutPublicKey Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    public short PutCertificate(int certificateIndex, byte[] certificate, int certificateLength) {
        int iRet = 3840;
        int offset = 0;
        try {
            LibLog.i(TAG, "## TOKEN CONTROL: Put Certificate");
            iRet = this.SelectCertificateFile(certificateIndex);
            if (iRet != 0) {
                return (short)iRet;
            }
            byte[] capduUpdateBinary = null;
            capduUpdateBinary = certificateLength < 200 ? new byte[certificateLength + 5] : new byte[205];
            System.arraycopy(CAPDU_UPDATE_BINARY, 0, capduUpdateBinary, 0, CAPDU_UPDATE_BINARY.length);
            do {
                if (offset + 200 > certificateLength) {
                    capduUpdateBinary = new byte[certificateLength - offset + 5];
                    System.arraycopy(CAPDU_UPDATE_BINARY, 0, capduUpdateBinary, 0, CAPDU_UPDATE_BINARY.length);
                    capduUpdateBinary[4] = (byte)(certificateLength - offset);
                    System.arraycopy(certificate, offset, capduUpdateBinary, 5, capduUpdateBinary[4] & 0xFF);
                } else {
                    capduUpdateBinary[4] = -56;
                    System.arraycopy(certificate, offset, capduUpdateBinary, 5, 200);
                }
                capduUpdateBinary[2] = (byte)(offset / 256);
                capduUpdateBinary[3] = (byte)(offset % 256);
                iRet = this.tokenTransmit(capduUpdateBinary);
                if (iRet != 0) break;
                if (this.RAPDU_SW12[0] == -112 && this.RAPDU_SW12[1] == 0) continue;
                if (this.RAPDU_SW12[0] == 105) {
                    iRet = 3846;
                    break;
                }
                iRet = 4036;
                break;
            } while ((offset += 200) <= certificateLength);
            return (short)iRet;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! PutCertificate Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    public short PutCertificateR(int certificateIndex, byte[] certificateR) {
        block5: {
            short iRet = 3840;
            try {
                LibLog.i(TAG, "## TOKEN CONTROL: Put Certificate R");
                byte[] capduPutData = new byte[25];
                System.arraycopy(CAPDU_PUT_DATA, 0, capduPutData, 0, 5);
                capduPutData[3] = (byte)(64 + (certificateIndex + 1));
                capduPutData[4] = 20;
                System.arraycopy(certificateR, 0, capduPutData, 5, 20);
                iRet = this.tokenTransmit(capduPutData);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] != -112) break block5;
                return 0;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! PutCertificateR Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        if (this.RAPDU_SW12[0] == 105) {
            return 3846;
        }
        return 4036;
    }

    public short PutCertificateSize(int certificateIndex, int certificateLength) {
        block5: {
            short iRet = 3840;
            try {
                LibLog.i(TAG, "## TOKEN CONTROL: Put Certificate Size");
                byte[] capduPutData = new byte[7];
                System.arraycopy(CAPDU_PUT_DATA, 0, capduPutData, 0, 5);
                capduPutData[3] = (byte)(80 + (certificateIndex + 1));
                capduPutData[4] = 2;
                capduPutData[5] = (byte)(certificateLength / 256);
                capduPutData[6] = (byte)(certificateLength % 256);
                iRet = this.tokenTransmit(capduPutData);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] != -112) break block5;
                return 0;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! PutCertificateSize Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        if (this.RAPDU_SW12[0] == 105) {
            return 3846;
        }
        return 4036;
    }

    public short UpdateCertificateList(byte[] certificateList) {
        block5: {
            short iRet = 3840;
            try {
                LibLog.i(TAG, "## TOKEN CONTROL: Update Certificate List");
                byte[] capduPutData = new byte[5 + certificateList.length];
                System.arraycopy(CAPDU_PUT_DATA, 0, capduPutData, 0, 5);
                capduPutData[3] = -111;
                capduPutData[4] = (byte)certificateList.length;
                System.arraycopy(certificateList, 0, capduPutData, 5, certificateList.length);
                iRet = this.tokenTransmit(capduPutData);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] != -112) break block5;
                return 0;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! PutCertificateList Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        if (this.RAPDU_SW12[0] == 105) {
            return 3846;
        }
        return 4036;
    }

    public short ClearKeyAndCertificate(int certificateIndex) {
        int iRet = 3840;
        try {
            LibLog.i(TAG, "## TOKEN CONTROL: Clear Key and Certificate File");
            int fileidx = 2;
            while (fileidx < 5) {
                this.capduClear[2] = (byte)(certificateIndex * 4 + fileidx);
                iRet = this.tokenTransmit(this.capduClear);
                if (iRet != 0) break;
                if (this.RAPDU_SW12[0] != -112) {
                    if (this.RAPDU_SW12[0] == 105) {
                        iRet = 3846;
                        break;
                    }
                    iRet = 4036;
                    break;
                }
                ++fileidx;
            }
            return (short)iRet;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! ClearKeyAndCertificate Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    public short ClearKeyInfo(int certificateIndex) {
        int iRet = 3840;
        int offset = 0;
        int keyinfoLength = 365;
        byte[] nulldata = new byte[200];
        try {
            LibLog.i(TAG, "## TOKEN CONTROL: Clear Key Info File");
            iRet = this.SelectKeyFile(certificateIndex);
            if (iRet != 0) {
                return (short)iRet;
            }
            Arrays.fill(nulldata, (byte)0);
            byte[] capduUpdateBinary = new byte[205];
            System.arraycopy(CAPDU_UPDATE_BINARY, 0, capduUpdateBinary, 0, CAPDU_UPDATE_BINARY.length);
            do {
                if (offset + 200 > keyinfoLength) {
                    capduUpdateBinary = new byte[keyinfoLength - offset + 5];
                    System.arraycopy(CAPDU_UPDATE_BINARY, 0, capduUpdateBinary, 0, CAPDU_UPDATE_BINARY.length);
                    capduUpdateBinary[4] = (byte)(keyinfoLength - offset);
                    System.arraycopy(nulldata, 0, capduUpdateBinary, 5, capduUpdateBinary[4] & 0xFF);
                } else {
                    capduUpdateBinary[4] = -56;
                    System.arraycopy(nulldata, 0, capduUpdateBinary, 5, 200);
                }
                capduUpdateBinary[2] = (byte)(offset / 256);
                capduUpdateBinary[3] = (byte)(offset % 256);
                iRet = this.tokenTransmit(capduUpdateBinary);
                if (iRet != 0) break;
                if (this.RAPDU_SW12[0] == -112 && this.RAPDU_SW12[1] == 0) continue;
                if (this.RAPDU_SW12[0] == 105) {
                    iRet = 3846;
                    break;
                }
                iRet = 4036;
                break;
            } while ((offset += 200) <= keyinfoLength);
            return (short)iRet;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! ClearKeyInfo Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short VerifyPIN(byte[] Pin, byte[] outRetryCount) {
        short iRet = 3840;
        try {
            LibLog.i(TAG, "## TOKEN CONTROL: Verify PIN");
            outRetryCount[0] = 0;
            byte[] outEncPin = new byte[16];
            int outEncPinLength = 0;
            byte[] cardRand = new byte[16];
            iRet = this.tokenTransmit(CAPDU_GET_CHALLENGE_FOR_INTERNAL);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] != -112) {
                return 4036;
            }
            System.arraycopy(this.RAPDU_DATA, 0, cardRand, 0, this.RAPDU_DATA.length);
            if ((byte)(this.tokenInfo.authType & 0xF0) == 32) {
                iRet = this.GetPublicKeyForEncrypt();
                if (iRet != 0) {
                    return iRet;
                }
                try {
                    outEncPin = this.mCryptoKFTC.EncryptPINVerify(cardRand, Pin, this.tokenInfo.pubKeyForEnc);
                }
                catch (HSMCryptException e) {
                    String emsg = e.getMessage();
                    if (emsg == null) {
                        emsg = "";
                    }
                    LibLog.e(TAG, "!!!! EncryptPINVerify Exception: " + emsg);
                    return 3840;
                }
                this.capudVerifyPIN[2] = -126;
            } else if ((byte)(this.tokenInfo.authType & 0xF0) == -128) {
                byte[] appRand = new byte[16];
                Random rnd = new Random();
                rnd.setSeed(System.currentTimeMillis());
                int idx = 0;
                while (true) {
                    if (idx >= 16) {
                        try {
                            outEncPin = this.mCryptoKFTC.EncryptPINVerify(cardRand, appRand, Pin);
                            break;
                        }
                        catch (HSMCryptException e) {
                            String emsg = e.getMessage();
                            if (emsg == null) {
                                emsg = "";
                            }
                            LibLog.e(TAG, "!!!! EncryptPINVerify Exception: " + emsg);
                            return 3840;
                        }
                    }
                    appRand[idx] = (byte)rnd.nextInt(254);
                    ++idx;
                }
                this.capudVerifyPIN[2] = -120;
            }
            outEncPinLength = outEncPin.length;
            if (outEncPinLength < Pin.length) {
                return 3840;
            }
            byte[] capduVerifyEncPIN = new byte[this.capudVerifyPIN.length + outEncPinLength];
            this.capudVerifyPIN[4] = (byte)outEncPinLength;
            System.arraycopy(this.capudVerifyPIN, 0, capduVerifyEncPIN, 0, this.capudVerifyPIN.length);
            System.arraycopy(outEncPin, 0, capduVerifyEncPIN, this.capudVerifyPIN.length, outEncPinLength);
            iRet = this.tokenTransmit(capduVerifyEncPIN, 10000);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] == -112) {
                return 0;
            }
            if (this.RAPDU_SW12[0] == 99) {
                outRetryCount[0] = (byte)(this.RAPDU_SW12[1] & 0xF);
                return 3843;
            }
            if (this.RAPDU_SW12[0] == 105 && this.RAPDU_SW12[1] == -124) {
                return 3845;
            }
            return 4036;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! VerifyPIN Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    public byte[] getSessionKey() {
        byte[] sessionKey = null;
        try {
            sessionKey = this.mCryptoKFTC.getSessionKey();
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! getSessionKey Exception");
            e.printStackTrace();
        }
        return sessionKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short PutPIN(byte[] Pin) {
        short iRet = 3840;
        try {
            LibLog.i(TAG, "## TOKEN CONTROL: Put PIN");
            byte[] outEncPin = new byte[16];
            int outEncPinLength = 0;
            byte[] cardRand = new byte[16];
            iRet = this.tokenTransmit(CAPDU_GET_CHALLENGE_FOR_INTERNAL);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] != -112) {
                return 4036;
            }
            System.arraycopy(this.RAPDU_DATA, 0, cardRand, 0, this.RAPDU_DATA.length);
            if ((byte)(this.tokenInfo.authType & 0xF0) == 32) {
                iRet = this.GetPublicKeyForEncrypt();
                if (iRet != 0) {
                    return iRet;
                }
                try {
                    outEncPin = this.mCryptoKFTC.EncryptPINPutpin(cardRand, Pin, this.tokenInfo.pubKeyForEnc);
                }
                catch (HSMCryptException e) {
                    String emsg = e.getMessage();
                    if (emsg == null) {
                        emsg = "";
                    }
                    LibLog.e(TAG, "!!!! EncryptPINPutpin Exception: " + emsg);
                    return 3840;
                }
                this.capduPutPIN[2] = -126;
            } else if ((byte)(this.tokenInfo.authType & 0xF0) == -128) {
                byte[] appRand = new byte[8];
                Random rnd = new Random();
                rnd.setSeed(System.currentTimeMillis());
                int idx = 0;
                while (true) {
                    if (idx >= 8) {
                        try {
                            outEncPin = this.mCryptoKFTC.EncryptPINPutpin(Pin);
                            break;
                        }
                        catch (HSMCryptException e) {
                            String emsg = e.getMessage();
                            if (emsg == null) {
                                emsg = "";
                            }
                            LibLog.e(TAG, "!!!! EncryptPINPutpin Exception: " + emsg);
                            return 3840;
                        }
                    }
                    appRand[idx] = (byte)rnd.nextInt(254);
                    ++idx;
                }
                this.capduPutPIN[2] = -120;
            }
            outEncPinLength = outEncPin.length;
            if (outEncPinLength < Pin.length) {
                return 3840;
            }
            byte[] capduPutEncPIN = new byte[this.capduPutPIN.length + outEncPinLength];
            this.capduPutPIN[4] = (byte)outEncPinLength;
            System.arraycopy(this.capduPutPIN, 0, capduPutEncPIN, 0, this.capduPutPIN.length);
            System.arraycopy(outEncPin, 0, capduPutEncPIN, this.capduPutPIN.length, outEncPinLength);
            iRet = this.tokenTransmit(capduPutEncPIN, 10000);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] == -112) {
                return 0;
            }
            if (this.RAPDU_SW12[0] == 105) {
                return 3846;
            }
            return 4036;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! PutPIN Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    public short GetCSN(boolean includeReverseCSN, byte[] outCSN) {
        block6: {
            short iRet = 3840;
            LibLog.i(TAG, "## TOKEN CONTROL: Get Token Info(for CSN)");
            iRet = this.tokenTransmit(CAPDU_GET_TOKEN_INFO);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] == -112) break block6;
            return 4036;
        }
        try {
            System.arraycopy(this.RAPDU_DATA, 80, outCSN, 0, 8);
            if (includeReverseCSN) {
                int i = 0;
                while (i < 8) {
                    outCSN[i + 8] = ~this.RAPDU_DATA[i];
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! GetCSN Exception");
            e.printStackTrace();
            return 3840;
        }
        return 0;
    }

    public short GetChallenge(byte inPurpose, int inRandomLength, byte[] outCardRandom) {
        block4: {
            short iRet = 3840;
            try {
                LibLog.i(TAG, "## TOKEN CONTROL: Get Challenge");
                this.capduGetChallenge[2] = inPurpose;
                this.capduGetChallenge[4] = (byte)inRandomLength;
                iRet = this.tokenTransmit(this.capduGetChallenge);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] == -112) break block4;
                return 4036;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! GetChallenge Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        System.arraycopy(this.RAPDU_DATA, 0, outCardRandom, 0, inRandomLength);
        return 0;
    }

    public short GetPublicKeyForEncrypt() {
        short iRet;
        block6: {
            iRet = 3840;
            if (this.tokenInfo.pubKeyForEnc == null) break block6;
            return 0;
        }
        try {
            iRet = this.tokenTransmit(CAPDU_GET_PUBLICKEY_FOR_ENC);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] == -112) {
                this.tokenInfo.pubKeyForEnc = new RSAPublicKey(this.RAPDU_DATA);
                return 0;
            }
            return 4036;
        }
        catch (HSMCryptException e) {
            LibLog.e(TAG, "!!!! \uacf5\uac1c\ud0a4 \ucc98\ub9ac \uc624\ub958(new RSAPublicKey)");
            return 3840;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! GetPublicKeyForEncrypt Exception");
            e.printStackTrace();
            return 3840;
        }
    }

    public short UpdateKeyLengthToKeyInfoFile(int inKeyIndex, byte inKeyLength) {
        short iRet;
        block5: {
            iRet = 3840;
            try {
                this.capduSelectFile[5] = -8;
                this.capduSelectFile[6] = (byte)(1 + 4 * inKeyIndex);
                iRet = this.tokenTransmit(this.capduSelectFile);
                if (iRet != 0) {
                    return iRet;
                }
                if (this.RAPDU_SW12[0] == -112) break block5;
                return 4036;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! UpdateKeyLengthToKeyInfoFile Exception");
                e.printStackTrace();
                return 3840;
            }
        }
        byte[] byArray = new byte[6];
        byArray[1] = -42;
        byArray[2] = 1;
        byArray[3] = 105;
        byArray[4] = 1;
        byte[] capduUpdateBinary = byArray;
        capduUpdateBinary[5] = inKeyLength;
        iRet = this.tokenTransmit(capduUpdateBinary);
        if (iRet != 0) {
            return iRet;
        }
        iRet = this.RAPDU_SW12[0] == 105 ? (short)3846 : 4036;
        return iRet;
    }

    public short GetKeyLengthFromKeyInfoFile(int inKeyIndex, byte[] outKeyLength) {
        short iRet;
        block7: {
            block6: {
                iRet = 3840;
                try {
                    this.capduSelectFile[5] = -8;
                    this.capduSelectFile[6] = (byte)(1 + 4 * inKeyIndex);
                    iRet = this.tokenTransmit(this.capduSelectFile);
                    if (iRet != 0) {
                        return iRet;
                    }
                    if (this.RAPDU_SW12[0] == -112) break block6;
                    return 4036;
                }
                catch (Exception e) {
                    LibLog.e(TAG, "!!!! GetKeyLengthFromKeyInfoFile Exception");
                    e.printStackTrace();
                    return 3840;
                }
            }
            this.capduReadBinary[2] = 1;
            this.capduReadBinary[3] = 105;
            this.capduReadBinary[4] = 1;
            iRet = this.tokenTransmit(this.capduReadBinary);
            if (iRet != 0) {
                return iRet;
            }
            if (this.RAPDU_SW12[0] == -112) break block7;
            return 4036;
        }
        outKeyLength[0] = this.RAPDU_DATA.length > 0 ? this.RAPDU_DATA[0] : 32;
        return iRet;
    }

    public short SendApdu(byte[] inApdu, byte[] outResponseData, int[] outDataLength, byte[] sw12, int timeout) {
        short iRet = 3840;
        try {
            sw12[0] = 0;
            sw12[1] = 0;
            outDataLength[0] = 0;
            iRet = this.tokenTransmit(inApdu, timeout);
            if (iRet == 0) {
                if (this.RAPDU_DATA != null && this.RAPDU_DATA.length > 0) {
                    System.arraycopy(this.RAPDU_DATA, 0, outResponseData, 0, this.RAPDU_DATA.length);
                    outDataLength[0] = this.RAPDU_DATA.length;
                }
                sw12[0] = this.RAPDU_SW12[0];
                sw12[1] = this.RAPDU_SW12[1];
            }
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! SendApdu Exception");
            e.printStackTrace();
            return 3840;
        }
        return iRet;
    }

    private short tokenTransmit(byte[] apdu) {
        short iRet = 3840;
        try {
            if (this.tokenDeviceType.equals((Object)TokenDeviceType.NFC)) {
                this.cardNFC.setTimeout(5000);
                iRet = this.nfcTransceive(apdu);
            }
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! tokenTransmit Exception");
            e.printStackTrace();
            return 3840;
        }
        return iRet;
    }

    private short tokenTransmit(byte[] apdu, int timeout) {
        short iRet = 3840;
        try {
            if (this.tokenDeviceType.equals((Object)TokenDeviceType.NFC)) {
                this.cardNFC.setTimeout(timeout);
                iRet = this.nfcTransceive(apdu);
            }
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! tokenTransmit(with timeout) Exception");
            e.printStackTrace();
            return 3840;
        }
        return iRet;
    }

    private short nfcTransceive(byte[] apdu) {
        byte[] tmpLongResponseData;
        byte[] responseData;
        int iRet;
        block21: {
            block20: {
                block19: {
                    iRet = 3840;
                    responseData = null;
                    tmpLongResponseData = new byte[9216];
                    LibLog.d(TAG, ">> CAPDU: " + this.mConverter.HexToStringForDisplay(apdu, 0, apdu.length));
                    this.RAPDU_DATA = null;
                    this.RAPDU_SW12[0] = 0;
                    this.RAPDU_SW12[1] = 0;
                    responseData = this.cardNFC.transceive(apdu);
                    if (responseData != null) break block19;
                    return 4035;
                }
                if (responseData.length >= 1) break block20;
                return 4035;
            }
            if (responseData.length != 1) break block21;
            this.RAPDU_SW12[0] = responseData[0];
            return 4035;
        }
        try {
            LibLog.d(TAG, "<< RAPDU: " + this.mConverter.HexToStringForDisplay(responseData, 0, responseData.length));
            this.RAPDU_SW12[0] = responseData[responseData.length - 2];
            this.RAPDU_SW12[1] = responseData[responseData.length - 1];
            if (this.RAPDU_SW12[0] == 97) {
                if (responseData.length > 2) {
                    System.arraycopy(responseData, 0, tmpLongResponseData, 0, responseData.length - 2);
                }
                int lastResponseDataLength = responseData.length - 2;
                this.RAPDU_DATA = null;
                do {
                    byte[] byArray = new byte[5];
                    byArray[1] = -64;
                    byArray[4] = this.RAPDU_SW12[1];
                    apdu = byArray;
                    LibLog.d(TAG, ">> CAPDU: " + this.mConverter.HexToStringForDisplay(apdu, 0, apdu.length));
                    responseData = this.cardNFC.transceive(apdu);
                    if (responseData == null) {
                        iRet = 4035;
                        break;
                    }
                    if (responseData.length < 1) {
                        iRet = 4035;
                        break;
                    }
                    if (responseData.length == 1) {
                        this.RAPDU_SW12[0] = responseData[0];
                        iRet = 4035;
                        break;
                    }
                    iRet = 0;
                    LibLog.d(TAG, "<< RAPDU: " + this.mConverter.HexToStringForDisplay(responseData, 0, responseData.length));
                    this.RAPDU_SW12[0] = responseData[responseData.length - 2];
                    this.RAPDU_SW12[1] = responseData[responseData.length - 1];
                    System.arraycopy(responseData, 0, tmpLongResponseData, lastResponseDataLength, responseData.length - 2);
                    lastResponseDataLength = lastResponseDataLength + responseData.length - 2;
                    if (lastResponseDataLength <= 8192) continue;
                    iRet = 4035;
                    break;
                } while (this.RAPDU_SW12[0] == 97);
                if (iRet == 0) {
                    this.RAPDU_DATA = new byte[lastResponseDataLength];
                    System.arraycopy(tmpLongResponseData, 0, this.RAPDU_DATA, 0, lastResponseDataLength);
                } else {
                    this.RAPDU_DATA = null;
                }
            } else if (responseData.length > 2) {
                this.RAPDU_DATA = new byte[responseData.length - 2];
                System.arraycopy(responseData, 0, this.RAPDU_DATA, 0, responseData.length - 2);
            } else {
                this.RAPDU_DATA = null;
            }
            if (this.RAPDU_DATA == null) {
                LibLog.d(TAG, "## DATA: none");
            } else {
                LibLog.d(TAG, "## DATA:" + this.mConverter.HexToStringForDisplay(this.RAPDU_DATA, 0, this.RAPDU_DATA.length));
            }
            LibLog.d(TAG, "## SW12: " + this.mConverter.HexToString(this.RAPDU_SW12, 0, this.RAPDU_SW12.length));
            responseData = null;
            tmpLongResponseData = null;
            return 0;
        }
        catch (IOException ioe) {
            LibLog.e(TAG, "!!!! NFC \ud1b5\uc2e0\uc911 \uc624\ub958(IOException) \ubc1c\uc0dd");
            ioe.printStackTrace();
            responseData = null;
            tmpLongResponseData = null;
            return 4034;
        }
        catch (Exception e) {
            LibLog.e(TAG, "!!!! NFC \ud1b5\uc2e0\uc911 \uc624\ub958(Exception) \ubc1c\uc0dd");
            e.printStackTrace();
            responseData = null;
            tmpLongResponseData = null;
            return 3840;
        }
    }

    public String getSW12() {
        block5: {
            block4: {
                try {
                    if (this.RAPDU_SW12 != null) break block4;
                    return "";
                }
                catch (Exception e) {
                    return "";
                }
            }
            if (this.RAPDU_SW12[0] != 0 && this.RAPDU_SW12[0] != -112) break block5;
            return "";
        }
        return "[SW12:" + this.mConverter.HexToString(this.RAPDU_SW12, 0, this.RAPDU_SW12.length).toUpperCase() + "]";
    }

    public class KFTCTokenInfo {
        public byte[] issuerCode = new byte[3];
        public byte tokenSpecVersion;
        public int maxCertificates;
        public byte tokenKeyFeature;
        public byte authType;
        public byte cryptoAlgorithm;
        public byte[] tokenLabel = new byte[32];
        public byte[] manufacturerID = new byte[32];
        public byte[] tokenModel = new byte[16];
        public byte[] tokenSerialNumber = new byte[8];
        public int maxPinLen;
        public int minPinLen;
        public byte[] hwVersion = new byte[2];
        public byte[] fwVersion = new byte[2];
        public byte[] createdKeyIndex = new byte[8];
        public RSAPublicKey pubKeyForEnc;

        public KFTCTokenInfo() {
            this.InitTokenInfo();
        }

        public void InitTokenInfo() {
            try {
                Arrays.fill(this.issuerCode, (byte)0);
                this.tokenSpecVersion = 0;
                this.maxCertificates = 2;
                this.tokenKeyFeature = 0;
                this.authType = 0;
                this.cryptoAlgorithm = 0;
                Arrays.fill(this.tokenLabel, (byte)0);
                Arrays.fill(this.manufacturerID, (byte)0);
                Arrays.fill(this.tokenModel, (byte)0);
                Arrays.fill(this.tokenSerialNumber, (byte)0);
                this.maxPinLen = 16;
                this.minPinLen = 6;
                Arrays.fill(this.hwVersion, (byte)0);
                Arrays.fill(this.fwVersion, (byte)0);
                Arrays.fill(this.createdKeyIndex, (byte)0);
                this.pubKeyForEnc = null;
            }
            catch (Exception e) {
                LibLog.e(TAG, "!!!! KFTCTokenInfo.InitTokenInfo Exception.");
                e.printStackTrace();
            }
        }
    }

    public static enum TokenDeviceType {
        NFC,
        MSD,
        BLE,
        ESE;

    }
}

