/*
 * Decompiled with CFR 0.152.
 */
package kr.or.kftc.mobiletoken_lib.device_control;

import android.nfc.tech.IsoDep;
import android.os.Bundle;
import java.util.Arrays;
import kr.or.kftc.crypto.HSMCrypt;
import kr.or.kftc.crypto.HSMCryptException;
import kr.or.kftc.crypto.RSAPublicKey;
import kr.or.kftc.mobiletoken_lib.util.DataConverter;
import kr.or.kftc.mobiletoken_lib.util.LibLog;
import kr.or.kftc.smartcard.SecurityToken;

public class TokenControl {
    private final String TAG = TokenControl.class.getSimpleName();
    public static final int PRIVATEKEY_SIZE = 642;
    public static final int PUBLICKEY_SIZE = 262;
    private static final String API_VERSION = "1.8";
    private SecurityToken mToken;
    private DataConverter mConverter = new DataConverter();

    public TokenControl(IsoDep isoDep) {
        LibLog.i(this.TAG, "##### NFC \ubcf4\uc548\ud1a0\ud070 \uc81c\uc5b4 \uac1d\uccb4 \uc0dd\uc131 \ubc0f \ucd08\uae30\ud654 #####");
        this.mToken = new SecurityToken(SecurityToken.TokenDeviceType.NFC);
        this.mToken.SetCard(isoDep);
    }

    public String GetVersion() {
        return API_VERSION;
    }

    public boolean Connect() {
        block3: {
            int iRet;
            block4: {
                LibLog.i(this.TAG, "##### \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0(Connect) #####");
                try {
                    this.mToken.tokenInfo.InitTokenInfo();
                    if (!this.mToken.ConnectCard()) break block3;
                    iRet = 3840;
                    iRet = this.mToken.SelectApplet();
                    if (iRet == 0) break block4;
                    LibLog.e(this.TAG, "!!!! NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0\ud6c4 \ubcf4\uc548\ud1a0\ud070 \uc560\ud50c\ub9bf \uc120\ud0dd\uc2dc \uc624\ub958 \ubc1c\uc0dd");
                    return false;
                }
                catch (Exception e) {
                    LibLog.e(this.TAG, "!!!! \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0 \ucc98\ub9ac\uc911 \uc624\ub958 \ubc1c\uc0dd");
                    e.printStackTrace();
                    return false;
                }
            }
            iRet = this.mToken.GetTokenInfo();
            if (iRet == 0) break block3;
            LibLog.e(this.TAG, "!!!! NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0\ud6c4 \ubcf4\uc548\ud1a0\ud070 \uae30\ubcf8\uc815\ubcf4 \uc870\ud68c\uc2dc \uc624\ub958 \ubc1c\uc0dd");
            return false;
        }
        return true;
    }

    public boolean Connect(Bundle responseBundle) {
        block3: {
            short iRet;
            block4: {
                LibLog.i(this.TAG, "##### \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0(Connect) #####");
                try {
                    responseBundle.putString("ERROR_CODE", "0000");
                    responseBundle.putString("ERROR_MESSAGE", "\uc5f0\uacb0\uc131\uacf5");
                    this.mToken.tokenInfo.InitTokenInfo();
                    if (!this.mToken.ConnectCard()) break block3;
                    iRet = 3840;
                    iRet = this.mToken.SelectApplet();
                    if (iRet == 0) break block4;
                    LibLog.e(this.TAG, "!!!! NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0\ud6c4 \ubcf4\uc548\ud1a0\ud070 \uc560\ud50c\ub9bf \uc120\ud0dd\uc2dc \uc624\ub958 \ubc1c\uc0dd");
                    responseBundle.putString("ERROR_CODE", String.format("%04x", iRet).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0\ud6c4 \ubcf4\uc548\ud1a0\ud070 \uc560\ud50c\ub9bf \uc120\ud0dd\uc2dc \uc624\ub958 \ubc1c\uc0dd");
                    this.getDetailErrorMessage(iRet, responseBundle);
                    return false;
                }
                catch (Exception e) {
                    LibLog.e(this.TAG, "!!!! \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0 \ucc98\ub9ac\uc911 \uc624\ub958 \ubc1c\uc0dd");
                    responseBundle.putString("ERROR_CODE", String.format("%04x", (short)4035).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "\ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0\uc911 \ud1b5\uc2e0\uc624\ub958 \ubc1c\uc0dd");
                    e.printStackTrace();
                    return false;
                }
            }
            iRet = this.mToken.GetTokenInfo();
            if (iRet == 0) break block3;
            LibLog.e(this.TAG, "!!!! NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0\ud6c4 \ubcf4\uc548\ud1a0\ud070 \uae30\ubcf8\uc815\ubcf4 \uc870\ud68c\uc2dc \uc624\ub958 \ubc1c\uc0dd");
            responseBundle.putString("ERROR_CODE", String.format("%04x", iRet).toUpperCase());
            responseBundle.putString("ERROR_MESSAGE", "NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0\ud6c4 \ubcf4\uc548\ud1a0\ud070 \uae30\ubcf8\uc815\ubcf4 \uc870\ud68c\uc2dc \uc624\ub958 \ubc1c\uc0dd");
            return false;
        }
        return true;
    }

    public boolean Disconnect() {
        LibLog.i(this.TAG, "##### \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0\ud574\uc81c(Disconnect) #####");
        try {
            this.mToken.DisconnectCard();
            this.mToken.tokenInfo.InitTokenInfo();
            return true;
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0\ud574\uc81c \ucc98\ub9ac\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
            return false;
        }
    }

    public void Transmit(Bundle requestBundle, Bundle responseBundle) {
        block24: {
            LibLog.i(this.TAG, "##### \ubcf4\uc548\ud1a0\ud070 \uba85\ub839 \uc218\ud589 \uc694\uccad(Transmit) #####");
            String mRequestAction = requestBundle.getString("REQUEST_ACTION");
            mRequestAction = mRequestAction == null ? "" : mRequestAction.toUpperCase();
            try {
                if (!this.mToken.isConnectedCard()) {
                    responseBundle.putString("RESPONSE_ACTION", mRequestAction);
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)4033).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "\ubcf4\uc548\ud1a0\ud070\uacfc \uc5f0\uacb0 \ud574\uc81c \uc0c1\ud0dc\uc784");
                    return;
                }
                if (mRequestAction.equals("")) {
                    responseBundle.putString("RESPONSE_ACTION", "");
                    responseBundle.putString("RESULT_CODE", "0E02");
                    responseBundle.putString("ERROR_MESSAGE", "\ubbf8\uc9c0\uc6d0 \uae30\ub2a5");
                    return;
                }
                LibLog.i(this.TAG, "##### \uc694\uccad \uba85\ub839: " + mRequestAction);
                responseBundle.putString("RESPONSE_ACTION", mRequestAction);
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3840).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958");
                if (mRequestAction.equals("GET_TOKEN_INFO")) {
                    this.getTokenInfo(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("GET_APPLET_CONTROL_INFO")) {
                    this.getAppletControlInfo(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("GET_KEY_PIN_STATUS")) {
                    this.getKeyPinStatus(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("VERIFY_PIN")) {
                    this.verifyPin(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("PUT_PIN")) {
                    this.putPin(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("GET_CHALLENGE")) {
                    this.getChallenge(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("MUTUAL_AUTHENTICATE")) {
                    this.mutualAuthenticate(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("GET_CERTIFICATE_LIST")) {
                    this.getCertificateList(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("GET_CERTIFICATE")) {
                    this.getCertificate(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("GET_CERTIFICATE_R")) {
                    this.getCertificateR(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("GET_KEY_LENGTH")) {
                    this.getKeyLength(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("GENERATE_SIGNATURE")) {
                    this.generateSignature(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("DECRYPT")) {
                    this.decrypt(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("GENERATE_KEY_PAIR")) {
                    this.generateKeyPair(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("STORE_PRIVATE_KEY")) {
                    this.storePrivateKey(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("STORE_PUBLIC_KEY")) {
                    this.storePublicKey(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("PUSH_CERTIFICATE")) {
                    this.pushCertificate(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("DELETE_CERTIFICATE")) {
                    this.deleteCertificate(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("PUT_CERTIFICATE_R")) {
                    this.putCertificateR(requestBundle, responseBundle);
                    break block24;
                }
                if (mRequestAction.equals("SEND_APDU")) {
                    this.sendAPDU(requestBundle, responseBundle);
                    break block24;
                }
                responseBundle.putString("RESPONSE_ACTION", mRequestAction);
                responseBundle.putString("RESULT_CODE", "0E02");
                responseBundle.putString("ERROR_MESSAGE", "\ubbf8\uc9c0\uc6d0 \uae30\ub2a5");
                return;
            }
            catch (Exception e) {
                LibLog.e(this.TAG, "!!!! \ubcf4\uc548\ud1a0\ud070 \uba85\ub839 \uc218\ud589\uc911 \uc624\ub958 \ubc1c\uc0dd");
                e.printStackTrace();
                responseBundle.putString("RESPONSE_ACTION", mRequestAction);
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3840).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958");
                return;
            }
        }
    }

    private void getDetailErrorMessage(short errCode, Bundle responseBundle) {
        try {
            String sw12 = this.mToken.getSW12();
            if (errCode == 4033) {
                responseBundle.putString("ERROR_MESSAGE", "\uc0ac\uc6a9 \uac00\ub2a5\ud55c \ubcf4\uc548\ud1a0\ud070\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc74c(NFC \ubcf4\uc548\ud1a0\ud070 \uc7ac\uc811\ucd09)" + sw12);
            } else if (errCode == 4034) {
                responseBundle.putString("ERROR_MESSAGE", "\ubcf4\uc548\ud1a0\ud070\uacfc NFC \ud1b5\uc2e0\ubb38\uc81c \ubc1c\uc0dd(NFC \ubcf4\uc548\ud1a0\ud070 \uc11c\ube44\uc2a4 \uc911\uc9c0\ub428)" + sw12);
            } else if (errCode == 4035) {
                responseBundle.putString("ERROR_MESSAGE", "\ubcf4\uc548\ud1a0\ud070\uacfc \ud1b5\uc2e0\ubb38\uc81c \ubc1c\uc0dd" + sw12);
            } else if (errCode == 4036) {
                responseBundle.putString("ERROR_MESSAGE", "\ubcf4\uc548\ud1a0\ud070 \ub0b4\ubd80\uba85\ub839 \uc218\ud589 \uc2e4\ud328" + sw12);
            } else if (errCode == 4037) {
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc74c" + sw12);
            } else if (errCode == 3841) {
                responseBundle.putString("ERROR_MESSAGE", "\ubbf8\uc9c0\uc6d0 \ubcf4\uc548\ud1a0\ud070" + sw12);
            } else if (errCode == 3843) {
                responseBundle.putString("ERROR_MESSAGE", "PIN \uc778\uc99d \uc2e4\ud328" + sw12);
            } else if (errCode == 3846) {
                responseBundle.putString("ERROR_MESSAGE", "Security \uc870\uac74(PIN \uc778\uc99d, \uc0c1\ud638\uc778\uc99d \ub4f1) \ubd88\ucda9\uc871" + sw12);
            } else if (errCode == 3845) {
                responseBundle.putString("ERROR_MESSAGE", "PIN \uc778\uc99d \uc624\ub958\ub85c \uc778\ud55c \ubcf4\uc548\ud1a0\ud070 \uc7a0\uae40" + sw12);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uc5d0\ub7ec \uba54\uc2dc\uc9c0 \ucc98\ub9ac\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void getTokenInfo(Bundle requestBundle, Bundle responseBundle) {
        try {
            responseBundle.putByteArray("LABEL", this.mToken.tokenInfo.tokenLabel);
            LibLog.d(this.TAG, "## LABEL:" + this.mConverter.HexToString(this.mToken.tokenInfo.tokenLabel, 0, this.mToken.tokenInfo.tokenLabel.length));
            responseBundle.putByteArray("MANUFACTURER_ID", this.mToken.tokenInfo.manufacturerID);
            LibLog.d(this.TAG, "## MANUFACTURER_ID:" + this.mConverter.HexToString(this.mToken.tokenInfo.manufacturerID, 0, this.mToken.tokenInfo.manufacturerID.length));
            responseBundle.putByteArray("MODEL", this.mToken.tokenInfo.tokenModel);
            LibLog.d(this.TAG, "## MODEL:" + this.mConverter.HexToString(this.mToken.tokenInfo.tokenModel, 0, this.mToken.tokenInfo.tokenModel.length));
            responseBundle.putByteArray("CSN", this.mToken.tokenInfo.tokenSerialNumber);
            LibLog.d(this.TAG, "## CSN:" + this.mConverter.HexToString(this.mToken.tokenInfo.tokenSerialNumber, 0, this.mToken.tokenInfo.tokenSerialNumber.length));
            responseBundle.putInt("MAX_PIN_LENGTH", this.mToken.tokenInfo.maxPinLen);
            LibLog.d(this.TAG, "## MAX_PIN_LENGTH:" + this.mToken.tokenInfo.maxPinLen);
            responseBundle.putInt("MIN_PIN_LENGTH", this.mToken.tokenInfo.minPinLen);
            LibLog.d(this.TAG, "## MIN_PIN_LENGTH:" + this.mToken.tokenInfo.minPinLen);
            responseBundle.putByteArray("HW_VER", this.mToken.tokenInfo.hwVersion);
            LibLog.d(this.TAG, "## HW_VER:" + this.mConverter.HexToString(this.mToken.tokenInfo.hwVersion, 0, this.mToken.tokenInfo.hwVersion.length));
            responseBundle.putByteArray("FW_VER", this.mToken.tokenInfo.fwVersion);
            LibLog.d(this.TAG, "## FW_VER:" + this.mConverter.HexToString(this.mToken.tokenInfo.fwVersion, 0, this.mToken.tokenInfo.fwVersion.length));
            responseBundle.putString("RESULT_CODE", "0000");
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \ubcf4\uc548\ud1a0\ud070 \uae30\ubcf8\uc815\ubcf4 \uc870\ud68c\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void getAppletControlInfo(Bundle requestBundle, Bundle responseBundle) {
        try {
            responseBundle.putByteArray("ISSUER_CODE", this.mToken.tokenInfo.issuerCode);
            LibLog.d(this.TAG, "## ISSUER_CODE:" + this.mConverter.HexToString(this.mToken.tokenInfo.issuerCode, 0, this.mToken.tokenInfo.issuerCode.length));
            responseBundle.putByte("VERSION", this.mToken.tokenInfo.tokenSpecVersion);
            LibLog.d(this.TAG, "## VERSION:" + this.mToken.tokenInfo.tokenSpecVersion);
            responseBundle.putInt("CERT_MAX_COUNT", this.mToken.tokenInfo.maxCertificates);
            LibLog.d(this.TAG, "## CERT_MAX_COUNT:" + this.mToken.tokenInfo.maxCertificates);
            responseBundle.putByte("SUPPORT_FUNCTION", this.mToken.tokenInfo.tokenKeyFeature);
            LibLog.d(this.TAG, "## SUPPORT_FUNCTION:" + String.format("%02x", this.mToken.tokenInfo.tokenKeyFeature));
            responseBundle.putByte("USER_AUTH_MODE", this.mToken.tokenInfo.authType);
            LibLog.d(this.TAG, "## USER_AUTH_MODE:" + String.format("%02x", this.mToken.tokenInfo.authType));
            responseBundle.putByte("CRYPTO_ALG", this.mToken.tokenInfo.cryptoAlgorithm);
            LibLog.d(this.TAG, "## CRYPTO_ALG:" + String.format("%02x", this.mToken.tokenInfo.cryptoAlgorithm));
            responseBundle.putString("RESULT_CODE", "0000");
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \ubcf4\uc548\ud1a0\ud070 \uc560\ud50c\ub9bf \uc81c\uc5b4\uc815\ubcf4 \uc870\ud68c\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void getKeyPinStatus(Bundle requestBundle, Bundle responseBundle) {
        try {
            short iRet = 3840;
            byte[] outKeyPinStatus = new byte[1];
            iRet = this.mToken.GetIssueKeyAndPinStatus(outKeyPinStatus);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\ubc1c\ud589\uae30\uad00 \ud0a4 \ubc0f PIN \uc0c1\ud0dc \uc870\ud68c \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            } else {
                LibLog.d(this.TAG, "## \ubc1c\ud589\uae30\uad00 \ud0a4 \ubc0f PIN \uc0c1\ud0dc \uc815\ubcf4:" + this.mConverter.HexToString(outKeyPinStatus, 0, outKeyPinStatus.length));
                responseBundle.putInt("ISSUER_KEY_STATUS", (outKeyPinStatus[0] & 0xFFFFFF80) / -128);
                responseBundle.putInt("PIN_INIT_STATUS", (outKeyPinStatus[0] & 0x10) / 16);
                responseBundle.putInt("PIN_VERIFY_STATUS", outKeyPinStatus[0] & 1);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \ubc1c\ud589\uae30\uad00 \ud0a4 \ubc0f PIN \uc0c1\ud0dc \uc870\ud68c\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void verifyPin(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("PIN")) {
                LibLog.e(this.TAG, "!!!! PIN \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "PIN \uc785\ub825 \uc624\ub958");
                return;
            }
            byte[] inPIN = requestBundle.getByteArray("PIN");
            LibLog.d(this.TAG, "## Pin Length: " + inPIN.length);
            if (inPIN.length < this.mToken.tokenInfo.minPinLen || inPIN.length > this.mToken.tokenInfo.maxPinLen) {
                LibLog.e(this.TAG, "!!!! PIN \uc785\ub825\ubc94\uc704 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "PIN \uae38\uc774 \uc785\ub825 \uc624\ub958(\ucd5c\uc18c 6\uc790 \uc774\uc0c1, \ucd5c\ub300 16\uc790 \uc774\ud558 \uc785\ub825");
                return;
            }
            short iRet = 3840;
            byte[] outRetryCount = new byte[1];
            iRet = this.mToken.VerifyPIN(inPIN, outRetryCount);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                LibLog.d(this.TAG, "## \ub0a8\uc740 \uc7ac\uc2dc\ub3c4 \ud69f\uc218:" + outRetryCount[0]);
                responseBundle.putInt("RETRY_COUNT", (int)outRetryCount[0]);
                responseBundle.putString("ERROR_MESSAGE", "PIN \uc778\uc99d \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! PIN \uc778\uc99d \ucc98\ub9ac\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void putPin(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("PIN")) {
                LibLog.e(this.TAG, "!!!! PIN \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "PIN \uc785\ub825 \uc624\ub958");
                return;
            }
            byte[] inPIN = requestBundle.getByteArray("PIN");
            if (inPIN.length < this.mToken.tokenInfo.minPinLen || inPIN.length > this.mToken.tokenInfo.maxPinLen) {
                LibLog.e(this.TAG, "!!!! PIN \uc785\ub825\ubc94\uc704 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "PIN \uae38\uc774 \uc785\ub825 \uc624\ub958(\ucd5c\uc18c 6\uc790 \uc774\uc0c1, \ucd5c\ub300 16\uc790 \uc774\ud558 \uc785\ub825");
                return;
            }
            short iRet = 3840;
            iRet = this.mToken.PutPIN(inPIN);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "PIN \uc800\uc7a5 \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! PIN \ubcc0\uacbd \ucc98\ub9ac\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void getChallenge(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("RANDOM_LENGTH")) {
                LibLog.e(this.TAG, "!!!! \ub09c\uc218 \uae38\uc774 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ub09c\uc218 \uae38\uc774 \uc785\ub825 \uc624\ub958");
                return;
            }
            if (!requestBundle.containsKey("RANDOM_PURPOSE")) {
                LibLog.e(this.TAG, "!!!! \ub09c\uc218 \uc0ac\uc6a9\uc6a9\ub3c4 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ub09c\uc218 \uc0ac\uc6a9\uc6a9\ub3c4 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inRandomLength = requestBundle.getInt("RANDOM_LENGTH");
            byte inPurpose = requestBundle.getByte("RANDOM_PURPOSE");
            if (inPurpose == 0) {
                if (inRandomLength < 1 || inRandomLength > 256) {
                    LibLog.e(this.TAG, "!!!! \ub09c\uc218 \uae38\uc774\uac12 \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "\ub09c\uc218 \uae38\uc774 \uc785\ub825 \uc624\ub958(\ub09c\uc218\uae38\uc774\ub294 1 ~ 256 \ubc94\uc704 \ub0b4\uc5d0\uc11c \uc0ac\uc6a9)");
                    return;
                }
            } else if (inPurpose == 1) {
                if (inRandomLength < 1 || inRandomLength > 32) {
                    LibLog.e(this.TAG, "!!!! \ub09c\uc218 \uae38\uc774\uac12 \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "\ub09c\uc218 \uae38\uc774 \uc785\ub825 \uc624\ub958(\ub09c\uc218\uae38\uc774\ub294 1 ~ 32 \ubc94\uc704 \ub0b4\uc5d0\uc11c \uc0ac\uc6a9)");
                    return;
                }
            } else {
                LibLog.e(this.TAG, "!!!! \ub09c\uc218 \uc0ac\uc6a9\uc6a9\ub3c4 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ub09c\uc218 \uc0ac\uc6a9\uc6a9\ub3c4 \uc785\ub825 \uc624\ub958");
                return;
            }
            short iRet = 3840;
            byte[] outRandom = new byte[inRandomLength];
            iRet = this.mToken.GetChallenge(inPurpose, inRandomLength, outRandom);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\ub09c\uc218 \uc0dd\uc131 \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            } else {
                responseBundle.putByteArray("RANDOM", outRandom);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \ub09c\uc218 \uc0dd\uc131\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void mutualAuthenticate(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("ISSUER_ENC_DATA")) {
                LibLog.e(this.TAG, "!!!! \ubc1c\ud589\uae30\uad00 \uc554\ud638\ud654 \ub370\uc774\ud130 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ubc1c\ud589\uae30\uad00 \uc554\ud638\ud654 \ub370\uc774\ud130 \uc785\ub825 \uc624\ub958");
                return;
            }
            byte[] inIssuerEncData = requestBundle.getByteArray("ISSUER_ENC_DATA");
            if (inIssuerEncData.length != 32) {
                LibLog.e(this.TAG, "!!!! \ubc1c\ud589\uae30\uad00 \uc554\ud638\ud654 \ub370\uc774\ud130 \uae38\uc774 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ubc1c\ud589\uae30\uad00 \uc554\ud638\ud654 \ub370\uc774\ud130 \uae38\uc774 \uc624\ub958");
                return;
            }
            short iRet = 3840;
            byte[] outTokenEncData = new byte[4];
            iRet = this.mToken.MutualAuthenticate(inIssuerEncData, outTokenEncData);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\uc0c1\ud638\uc778\uc99d \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            } else {
                responseBundle.putByteArray("TOKEN_ENC_DATA", outTokenEncData);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uc0c1\ud638\uc778\uc99d \ucc98\ub9ac\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void getCertificateList(Bundle requestBundle, Bundle responseBundle) {
        try {
            short iRet = 3840;
            byte[] outCertificateList = new byte[8];
            int[] outCertificateLength = new int[7];
            iRet = this.mToken.GetCertificateList(outCertificateList);
            if (iRet == 0) {
                int[] tmpCertificateLength = new int[1];
                int idx = 0;
                while (idx < 7) {
                    if (outCertificateList[1 + idx] != 0) {
                        iRet = this.mToken.GetCertificateSize(idx, tmpCertificateLength);
                        if (iRet != 0) break;
                        outCertificateLength[idx] = tmpCertificateLength[0];
                    }
                    ++idx;
                }
            }
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \ubaa9\ub85d \uc870\ud68c \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            } else {
                LibLog.d(this.TAG, "## \uc778\uc99d\uc11c \ubc1c\uae09\ubaa9\ub85d \uc815\ubcf4:" + this.mConverter.HexToString(outCertificateList, 0, outCertificateList.length));
                responseBundle.putInt("CERT_COUNT", (int)outCertificateList[0]);
                responseBundle.putByte("CERT1_TYPE", outCertificateList[1]);
                responseBundle.putByte("CERT2_TYPE", outCertificateList[2]);
                responseBundle.putByte("CERT3_TYPE", outCertificateList[3]);
                responseBundle.putByte("CERT4_TYPE", outCertificateList[4]);
                responseBundle.putByte("CERT5_TYPE", outCertificateList[5]);
                responseBundle.putByte("CERT6_TYPE", outCertificateList[6]);
                responseBundle.putByte("CERT7_TYPE", outCertificateList[7]);
                responseBundle.putInt("CERT1_LENGTH", outCertificateLength[0]);
                responseBundle.putInt("CERT2_LENGTH", outCertificateLength[1]);
                responseBundle.putInt("CERT3_LENGTH", outCertificateLength[2]);
                responseBundle.putInt("CERT4_LENGTH", outCertificateLength[3]);
                responseBundle.putInt("CERT5_LENGTH", outCertificateLength[4]);
                responseBundle.putInt("CERT6_LENGTH", outCertificateLength[5]);
                responseBundle.putInt("CERT7_LENGTH", outCertificateLength[6]);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \ubc1c\uae09\ubaa9\ub85d \uc815\ubcf4 \uc870\ud68c\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void getCertificate(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("CERTIFICATE_INDEX")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inCertificateIndex = requestBundle.getInt("CERTIFICATE_INDEX");
            if (inCertificateIndex < 1 || inCertificateIndex > this.mToken.tokenInfo.maxCertificates) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3844).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            short iRet = 3840;
            byte[] outCertificate = new byte[4096];
            int[] outCertificateLength = new int[1];
            if ((iRet = (short)this.mToken.GetCertificateSize(--inCertificateIndex, outCertificateLength)) == 0) {
                LibLog.d(this.TAG, "## \uc778\uc99d\uc11c \ud06c\uae30: " + outCertificateLength[0]);
                if (outCertificateLength[0] == 0) {
                    iRet = 4037;
                } else {
                    iRet = this.mToken.SelectCertificateFile(inCertificateIndex);
                    if (iRet == 0) {
                        iRet = this.mToken.GetCertificateData(outCertificateLength[0], outCertificate);
                    }
                }
            }
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc870\ud68c \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            } else {
                byte[] certificate = new byte[outCertificateLength[0]];
                System.arraycopy(outCertificate, 0, certificate, 0, outCertificateLength[0]);
                LibLog.d(this.TAG, "## \uc778\uc99d\uc11c \uc0ac\uc774\uc988:" + outCertificateLength[0]);
                responseBundle.putByteArray("CERTIFICATE", certificate);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc870\ud68c\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void getCertificateR(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("CERTIFICATE_INDEX")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inCertificateIndex = requestBundle.getInt("CERTIFICATE_INDEX");
            if (inCertificateIndex < 1 || inCertificateIndex > this.mToken.tokenInfo.maxCertificates) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3844).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            short iRet = 3840;
            byte[] outCertificateR = new byte[20];
            if ((iRet = (short)this.mToken.SelectCertificateFile(--inCertificateIndex)) == 0) {
                iRet = this.mToken.GetCertificateR(inCertificateIndex, outCertificateR);
            }
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c R\uac12 \uc870\ud68c \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            } else {
                LibLog.d(this.TAG, "## \uc778\uc99d\uc11c R\uac12:" + this.mConverter.HexToString(outCertificateR, 0, outCertificateR.length));
                responseBundle.putByteArray("CERTIFICATE_R", outCertificateR);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c R\uac12 \uc870\ud68c\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void getKeyLength(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("CERTIFICATE_INDEX")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inCertificateIndex = requestBundle.getInt("CERTIFICATE_INDEX");
            if (inCertificateIndex < 1 || inCertificateIndex > this.mToken.tokenInfo.maxCertificates) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3844).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            short iRet = 3840;
            byte[] outKeyLength = new byte[1];
            iRet = this.mToken.GetPublicKeyLength(--inCertificateIndex, outKeyLength);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uae38\uc774 \uc870\ud68c \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            } else {
                LibLog.d(this.TAG, "## \ud0a4 \uae38\uc774:" + this.mConverter.HexToString(outKeyLength, 0, outKeyLength.length));
                responseBundle.putByte("KEY_LENGTH", outKeyLength[0]);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \ud0a4 \uae38\uc774 \uc870\ud68c\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void generateKeyPair(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("KEY_TYPE_LENGTH")) {
                LibLog.e(this.TAG, "!!!! \ud0a4\uc885\ub958 \ubc0f \ud0a4\uae38\uc774 \ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4\uc885\ub958 \ubc0f \ud0a4\uae38\uc774 \ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                return;
            }
            byte inKeyTypeLength = requestBundle.getByte("KEY_TYPE_LENGTH");
            if (inKeyTypeLength != 1 && inKeyTypeLength != 2 && inKeyTypeLength != 17 && inKeyTypeLength != 18) {
                LibLog.e(this.TAG, "!!!! \ud0a4\uc885\ub958 \ubc0f \ud0a4\uae38\uc774 \ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4\uc885\ub958 \ubc0f \ud0a4\uae38\uc774 \ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                return;
            }
            if (!requestBundle.containsKey("PURPOSE")) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uc0dd\uc131 \uc6a9\ub3c4\ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uc0dd\uc131 \uc6a9\ub3c4\ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                return;
            }
            byte inPurpose = requestBundle.getByte("PURPOSE");
            if (inPurpose != 1 && inPurpose != 2) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uc0dd\uc131 \uc6a9\ub3c4\ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uc0dd\uc131 \uc6a9\ub3c4\ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                return;
            }
            short iRet = 3840;
            int keyIndex = this.GetNewKeyIndex(inPurpose);
            if (keyIndex == 0) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uc0dd\uc131 \uac00\ub2a5 \uac1c\uc218 \ucd08\uacfc");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3847).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uc0dd\uc131 \uac00\ub2a5 \uac1c\uc218 \ucd08\uacfc");
                return;
            }
            if (keyIndex == -1) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uc0dd\uc131 \uac00\ub2a5 \uc704\uce58 \uc870\ud68c \uc2e4\ud328");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)4036).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uc0dd\uc131 \uac00\ub2a5 \uc704\uce58 \uc870\ud68c \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
                return;
            }
            byte[] outModulus = new byte[(inKeyTypeLength & 0xF) * 128];
            byte[] outExponent = new byte[4];
            iRet = this.mToken.GenerateKeyPair(keyIndex, inKeyTypeLength, outModulus, outExponent);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uc30d \uc0dd\uc131 \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
                return;
            }
            this.mToken.tokenInfo.createdKeyIndex[0] = (byte)(this.mToken.tokenInfo.createdKeyIndex[0] + 1);
            this.mToken.tokenInfo.createdKeyIndex[keyIndex] = -1;
            LibLog.d(this.TAG, "## Modulus:" + this.mConverter.HexToString(outModulus, 0, outModulus.length));
            LibLog.d(this.TAG, "## Public exponent:" + this.mConverter.HexToString(outExponent, 0, outExponent.length));
            LibLog.d(this.TAG, "## \uacf5\uac1c\ud0a4 \uc704\uce58\ubc88\ud638:" + keyIndex);
            responseBundle.putByteArray("MODULUS", outModulus);
            responseBundle.putByteArray("EXPONENT", outExponent);
            responseBundle.putInt("KEY_INDEX", keyIndex);
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \ud0a4 \uc30d \uc0dd\uc131\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void storePrivateKey(Bundle requestBundle, Bundle responseBundle) {
        try {
            HSMCrypt mCryptoSymm;
            byte[] symmetricKey;
            if (!requestBundle.containsKey("KEY_TYPE_LENGTH")) {
                LibLog.e(this.TAG, "!!!! \ud0a4\uc885\ub958 \ubc0f \ud0a4\uae38\uc774 \ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4\uc885\ub958 \ubc0f \ud0a4\uae38\uc774 \ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                return;
            }
            byte inKeyTypeLength = requestBundle.getByte("KEY_TYPE_LENGTH");
            if (inKeyTypeLength != 1 && inKeyTypeLength != 2 && inKeyTypeLength != 17 && inKeyTypeLength != 18) {
                LibLog.e(this.TAG, "!!!! \ud0a4\uc885\ub958 \ubc0f \ud0a4\uae38\uc774 \ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4\uc885\ub958 \ubc0f \ud0a4\uae38\uc774 \ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                return;
            }
            int crtLength = (inKeyTypeLength & 0xF) * 64;
            byte[] inModulus = null;
            byte[] inPrivateExponent = null;
            byte[] inPrime1 = null;
            byte[] inPrime2 = null;
            byte[] inExponent1 = null;
            byte[] inExponent2 = null;
            byte[] inCoefficient = null;
            if (inKeyTypeLength == 1 || inKeyTypeLength == 2) {
                if (!requestBundle.containsKey("MODULUS")) {
                    LibLog.e(this.TAG, "!!!! Modulus \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Modulus \uc785\ub825 \uc624\ub958");
                    return;
                }
                inModulus = requestBundle.getByteArray("MODULUS");
                LibLog.e(this.TAG, this.mConverter.HexToString(inModulus, 0, inModulus.length));
                if (inModulus.length != 128 && inModulus.length != 256) {
                    LibLog.e(this.TAG, "!!!! Modulus \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Modulus \uc785\ub825 \uc624\ub958");
                    return;
                }
                if (!requestBundle.containsKey("PRIVATE_EXPONENT")) {
                    LibLog.e(this.TAG, "!!!! Private exponent \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Private exponent \uc785\ub825 \uc624\ub958");
                    return;
                }
                inPrivateExponent = requestBundle.getByteArray("PRIVATE_EXPONENT");
                LibLog.e(this.TAG, this.mConverter.HexToString(inPrivateExponent, 0, inPrivateExponent.length));
                if (inPrivateExponent.length != 128 && inPrivateExponent.length != 256) {
                    LibLog.e(this.TAG, "!!!! Private exponent \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Private exponent \uc785\ub825 \uc624\ub958");
                    return;
                }
            } else if (inKeyTypeLength == 17 || inKeyTypeLength == 18) {
                if (!requestBundle.containsKey("CRT_PRIME1")) {
                    LibLog.e(this.TAG, "!!!! Prime-1 \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Prime-1 \uc785\ub825 \uc624\ub958");
                    return;
                }
                inPrime1 = requestBundle.getByteArray("CRT_PRIME1");
                LibLog.e(this.TAG, "!!! inPrime1" + this.mConverter.HexToString(inPrime1, 0, inPrime1.length));
                if (inPrime1.length != 64 && inPrime1.length != 128) {
                    LibLog.e(this.TAG, "!!!! Prime-1 \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Prime-1 \uc785\ub825 \uc624\ub958");
                    return;
                }
                if (!requestBundle.containsKey("CRT_PRIME2")) {
                    LibLog.e(this.TAG, "!!!! Prime-2 \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Prime-2 \uc785\ub825 \uc624\ub958");
                    return;
                }
                inPrime2 = requestBundle.getByteArray("CRT_PRIME2");
                LibLog.e(this.TAG, "!!! inPrime2" + this.mConverter.HexToString(inPrime2, 0, inPrime2.length));
                if (inPrime2.length != 64 && inPrime2.length != 128) {
                    LibLog.e(this.TAG, "!!!! Prime-2 \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Prime-2 \uc785\ub825 \uc624\ub958");
                    return;
                }
                if (!requestBundle.containsKey("CRT_EXPONENT1")) {
                    LibLog.e(this.TAG, "!!!! Exponent-1 \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Exponent-1 \uc785\ub825 \uc624\ub958");
                    return;
                }
                inExponent1 = requestBundle.getByteArray("CRT_EXPONENT1");
                LibLog.e(this.TAG, "!!! inExponent1" + this.mConverter.HexToString(inExponent1, 0, inExponent1.length));
                if (inExponent1.length != 64 && inExponent1.length != 128) {
                    LibLog.e(this.TAG, "!!!! Exponent-1 \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Exponent-1 \uc785\ub825 \uc624\ub958");
                    return;
                }
                if (!requestBundle.containsKey("CRT_EXPONENT2")) {
                    LibLog.e(this.TAG, "!!!! Exponent-2 \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Exponent-2 \uc785\ub825 \uc624\ub958");
                    return;
                }
                inExponent2 = requestBundle.getByteArray("CRT_EXPONENT2");
                LibLog.e(this.TAG, "!!! inExponent2" + this.mConverter.HexToString(inExponent2, 0, inExponent2.length));
                if (inExponent2.length != 64 && inExponent2.length != 128) {
                    LibLog.e(this.TAG, "!!!! Exponent-2 \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Exponent-2 \uc785\ub825 \uc624\ub958");
                    return;
                }
                if (!requestBundle.containsKey("CRT_COEFFICIENT")) {
                    LibLog.e(this.TAG, "!!!! Coefficient \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Coefficient \uc785\ub825 \uc624\ub958");
                    return;
                }
                inCoefficient = requestBundle.getByteArray("CRT_COEFFICIENT");
                LibLog.e(this.TAG, "!!! inCoefficient" + this.mConverter.HexToString(inCoefficient, 0, inCoefficient.length));
                if (inCoefficient.length != 64 && inCoefficient.length != 128) {
                    LibLog.e(this.TAG, "!!!! Coefficient \uc785\ub825 \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "Coefficient \uc785\ub825 \uc624\ub958");
                    return;
                }
            } else {
                LibLog.e(this.TAG, "!!!! \ud0a4\uc885\ub958 \ubc0f \ud0a4\uae38\uc774 \ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4\uc885\ub958 \ubc0f \ud0a4\uae38\uc774 \ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                return;
            }
            short iRet = 3840;
            int tmpKeyindex = this.GetNewKeyIndex((byte)2);
            if (tmpKeyindex == 0) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uc800\uc7a5 \uac00\ub2a5 \uac1c\uc218 \ucd08\uacfc");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3847).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uc800\uc7a5 \uac00\ub2a5 \uac1c\uc218 \ucd08\uacfc");
                return;
            }
            if (tmpKeyindex == -1) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uc800\uc7a5 \uc704\uce58 \uc870\ud68c \uc2e4\ud328");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)4036).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uc800\uc7a5 \uc704\uce58 \uc870\ud68c \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
                return;
            }
            if ((byte)(this.mToken.tokenInfo.authType & 0xF0) == 32) {
                iRet = this.mToken.GetPublicKeyForEncrypt();
                if (iRet != 0) {
                    LibLog.e(this.TAG, "!!!! \ub300\uce6d\ud0a4 \uc554\ud638\ud654\ub97c \uc704\ud55c \uacf5\uac1c\ud0a4 \uc870\ud68c \uc2e4\ud328");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "\ub300\uce6d\ud0a4 \uc554\ud638\ud654\ub97c \uc704\ud55c \uacf5\uac1c\ud0a4 \uc870\ud68c \uc2e4\ud328" + this.mToken.getSW12());
                    this.getDetailErrorMessage(iRet, responseBundle);
                    return;
                }
                HSMCrypt mCryptoRSA = LibLog.isDebugMode() ? new HSMCrypt(-128, "MTKCrypto") : new HSMCrypt(-128);
                RSAPublicKey tmpPubKey = this.mToken.tokenInfo.pubKeyForEnc;
                symmetricKey = new byte[16];
                byte[] encSymmetricKey = new byte[128];
                try {
                    mCryptoRSA.generateRandom(symmetricKey, 0, symmetricKey.length);
                    encSymmetricKey = mCryptoRSA.EncryptSymmKey(symmetricKey, tmpPubKey);
                }
                catch (HSMCryptException e) {
                    LibLog.e(this.TAG, "!!!! \ub300\uce6d\ud0a4 \uc554\ud638\ud654\uc2dc \uc624\ub958 \ubc1c\uc0dd");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3840).toUpperCase());
                    String emsg = e.getMessage();
                    if (emsg == null) {
                        emsg = "";
                    }
                    responseBundle.putString("ERROR_MESSAGE", emsg);
                    return;
                }
                byte inP2 = -120;
                iRet = this.mToken.InitializeCrypto((byte)8, inP2);
                if (iRet != 0) {
                    LibLog.e(this.TAG, "!!!! \uc554\ud638\ud654\ub41c \ub300\uce6d\ud0a4 \uc784\uc2dc \uc800\uc7a5 \ucd08\uae30\ud654 \uc624\ub958 \ubc1c\uc0dd(InitializeCrypto)");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "\uc554\ud638\ud654\ub41c \ub300\uce6d\ud0a4 \uc784\uc2dc \uc800\uc7a5 \ucd08\uae30\ud654 \uc2e4\ud328" + this.mToken.getSW12());
                    this.getDetailErrorMessage(iRet, responseBundle);
                    return;
                }
                iRet = this.mToken.PerformCrypto(encSymmetricKey, null, encSymmetricKey.length);
                if (iRet != 0) {
                    LibLog.e(this.TAG, "!!!! \uc554\ud638\ud654\ub41c \ub300\uce6d\ud0a4 \uc784\uc2dc \uc800\uc7a5 \uc218\ud589 \uc624\ub958 \ubc1c\uc0dd(PerformCrypto)");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "\uc554\ud638\ud654\ub41c \ub300\uce6d\ud0a4 \uc784\uc2dc \uc800\uc7a5 \uc218\ud589 \uc2e4\ud328" + this.mToken.getSW12());
                    this.getDetailErrorMessage(iRet, responseBundle);
                    return;
                }
            } else {
                symmetricKey = this.mToken.getSessionKey();
                if (symmetricKey == null) {
                    LibLog.e(this.TAG, "!!!! \uac1c\uc778\ud0a4 \uc554\ud638\ud654\ub97c \uc704\ud55c \uc138\uc158\ud0a4 \ucde8\ub4dd \uc2e4\ud328");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3840));
                    responseBundle.putString("ERROR_MESSAGE", "\uac1c\uc778\ud0a4 \uc554\ud638\ud654\ub97c \uc704\ud55c \uc138\uc158\ud0a4 \ucde8\ub4dd \uc2e4\ud328");
                    return;
                }
                LibLog.d(this.TAG, "## sessionkey: " + this.mConverter.HexToString(symmetricKey, 0, symmetricKey.length));
                if (symmetricKey.length % 8 != 0) {
                    LibLog.e(this.TAG, "!!!! \uac1c\uc778\ud0a4 \uc554\ud638\ud654\ub97c \uc704\ud55c \uc138\uc158\ud0a4 \ucde8\ub4dd \uc624\ub958");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3840));
                    responseBundle.putString("ERROR_MESSAGE", "\uac1c\uc778\ud0a4 \uc554\ud638\ud654\ub97c \uc704\ud55c \uc138\uc158\ud0a4 \ucde8\ub4dd \uc624\ub958");
                    return;
                }
            }
            byte[] inPrivatekey = new byte[642];
            if (inKeyTypeLength == 1 || inKeyTypeLength == 2) {
                inPrivatekey[0] = 2;
                inPrivatekey[1] = (byte)(crtLength / 2);
                System.arraycopy(inModulus, 0, inPrivatekey, 2, inModulus.length);
                System.arraycopy(inPrivateExponent, 0, inPrivatekey, 2 + inModulus.length, inPrivateExponent.length);
            } else {
                inPrivatekey[0] = 3;
                inPrivatekey[1] = (byte)(crtLength / 2);
                System.arraycopy(inPrime1, 0, inPrivatekey, 2, crtLength);
                System.arraycopy(inPrime2, 0, inPrivatekey, 2 + crtLength, crtLength);
                System.arraycopy(inExponent1, 0, inPrivatekey, 2 + crtLength * 2, crtLength);
                System.arraycopy(inExponent2, 0, inPrivatekey, 2 + crtLength * 3, crtLength);
                System.arraycopy(inCoefficient, 0, inPrivatekey, 2 + crtLength * 4, crtLength);
            }
            byte[] inPrivateKeyBlock = new byte[230];
            byte[] encPrivateKey = null;
            int inPrivateKeyLength = 230;
            int offset = 0;
            byte tmpP1 = 0;
            byte tmpP2 = 0;
            byte tmpIVLen = 0;
            try {
                if (this.mToken.tokenInfo.cryptoAlgorithm == 32) {
                    tmpP1 = 41;
                    tmpIVLen = 16;
                    mCryptoSymm = LibLog.isDebugMode() ? new HSMCrypt(32, "MTKCrypto") : new HSMCrypt(32);
                } else if (this.mToken.tokenInfo.cryptoAlgorithm == 64) {
                    tmpP1 = 73;
                    tmpIVLen = 16;
                    mCryptoSymm = LibLog.isDebugMode() ? new HSMCrypt(64, "MTKCrypto") : new HSMCrypt(64);
                } else {
                    tmpP1 = 25;
                    tmpIVLen = 8;
                    mCryptoSymm = LibLog.isDebugMode() ? new HSMCrypt(16, "MTKCrypto") : new HSMCrypt(16);
                }
            }
            catch (HSMCryptException e) {
                LibLog.e(this.TAG, "!!!! \uc554\ud638\ud654 \uc54c\uace0\ub9ac\uc998 \ucd08\uae30\ud654 \uc624\ub958 \ubc1c\uc0dd(new HSMCrypt)");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3840).toUpperCase());
                String emsg = e.getMessage();
                if (emsg == null) {
                    emsg = "";
                }
                responseBundle.putString("ERROR_MESSAGE", emsg);
                return;
            }
            do {
                if (offset + 230 > 642) {
                    inPrivateKeyLength = 642 - offset;
                    inPrivateKeyBlock = new byte[inPrivateKeyLength];
                    System.arraycopy(inPrivatekey, offset, inPrivateKeyBlock, 0, inPrivateKeyLength);
                } else {
                    inPrivateKeyLength = 230;
                    inPrivateKeyBlock = new byte[inPrivateKeyLength];
                    System.arraycopy(inPrivatekey, offset, inPrivateKeyBlock, 0, inPrivateKeyLength);
                }
                iRet = 3840;
                tmpP2 = (byte)(this.mToken.tokenInfo.authType & 0xF0) == -128 ? (byte)(144 + tmpKeyindex) : (byte)(128 + tmpKeyindex);
                iRet = this.mToken.InitializeCrypto(tmpP1, tmpP2, tmpIVLen);
                if (iRet != 0) {
                    LibLog.e(this.TAG, "!!!! \uac1c\uc778\ud0a4 \ubcf5\ud638\ud654\ub97c \uc704\ud55c \ucd08\uae30\ud654 \uc624\ub958 \ubc1c\uc0dd(InitializeCrypto)");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "\uac1c\uc778\ud0a4 \ubcf5\ud638\ud654\ub97c \uc704\ud55c \ucd08\uae30\ud654 \uc2e4\ud328" + this.mToken.getSW12());
                    this.getDetailErrorMessage(iRet, responseBundle);
                    return;
                }
                try {
                    encPrivateKey = mCryptoSymm.EncryptPrivateKey(1, symmetricKey, inPrivateKeyBlock);
                }
                catch (HSMCryptException e) {
                    LibLog.e(this.TAG, "!!!! \uac1c\uc778\ud0a4 \uc554\ud638\ud654\uc2dc \uc624\ub958 \ubc1c\uc0dd(EncryptPrivateKey)");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3840).toUpperCase());
                    String emsg = e.getMessage();
                    if (emsg == null) {
                        emsg = "";
                    }
                    responseBundle.putString("ERROR_MESSAGE", emsg);
                    return;
                }
            } while ((iRet = this.mToken.StorePrivateKey(offset, encPrivateKey, encPrivateKey.length)) == 0 && (offset += 230) <= 642);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\uac1c\uc778\ud0a4 \uc8fc\uc785 \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
                return;
            }
            this.mToken.tokenInfo.createdKeyIndex[0] = (byte)(this.mToken.tokenInfo.createdKeyIndex[0] + 1);
            this.mToken.tokenInfo.createdKeyIndex[tmpKeyindex] = -1;
            LibLog.d(this.TAG, "## \uc784\uc2dc\uad00\ub9ac \uc778\uc99d\uc11c\ubaa9\ub85d\uc815\ubcf4:" + this.mConverter.HexToString(this.mToken.tokenInfo.createdKeyIndex, 0, this.mToken.tokenInfo.createdKeyIndex.length));
            LibLog.d(this.TAG, "## \uc800\uc7a5\ub41c \ud0a4 \uc704\uce58\ubc88\ud638:" + tmpKeyindex);
            responseBundle.putInt("KEY_INDEX", tmpKeyindex);
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uac1c\uc778\ud0a4 \uc8fc\uc785\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void storePublicKey(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("KEY_INDEX")) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inKeyIndex = requestBundle.getInt("KEY_INDEX");
            if (inKeyIndex < 1 || inKeyIndex > this.mToken.tokenInfo.maxCertificates) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958: " + inKeyIndex);
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3844).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            --inKeyIndex;
            if (!requestBundle.containsKey("KEY_LENGTH")) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uae38\uc774 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uae38\uc774 \uc785\ub825 \uc624\ub958");
                return;
            }
            byte inKeyLength = requestBundle.getByte("KEY_LENGTH");
            if (inKeyLength != 32 && inKeyLength != 64) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uae38\uc774 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uae38\uc774 \uc785\ub825 \uc624\ub958");
                return;
            }
            if (!requestBundle.containsKey("MODULUS")) {
                LibLog.e(this.TAG, "!!!! Modulus \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "Modulus \uc785\ub825 \uc624\ub958");
                return;
            }
            byte[] inModulus = requestBundle.getByteArray("MODULUS");
            if (inModulus.length != inKeyLength * 4) {
                LibLog.e(this.TAG, "!!!! Modulus \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "Modulus \uc785\ub825 \uc624\ub958");
                return;
            }
            if (!requestBundle.containsKey("PUBLIC_EXPONENT")) {
                LibLog.e(this.TAG, "!!!! Public exponent \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "Public exponent \uc785\ub825 \uc624\ub958");
                return;
            }
            byte[] inPublicExponent = requestBundle.getByteArray("PUBLIC_EXPONENT");
            if (inPublicExponent.length != 4) {
                LibLog.e(this.TAG, "!!!! Public exponent \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "Public exponent \uc785\ub825 \uc624\ub958");
                return;
            }
            short iRet = 3840;
            byte[] inPublicKey = new byte[262];
            inPublicKey[0] = 1;
            inPublicKey[1] = inKeyLength;
            System.arraycopy(inModulus, 0, inPublicKey, 2, inModulus.length);
            System.arraycopy(inPublicExponent, 0, inPublicKey, 2 + inModulus.length, inPublicExponent.length);
            iRet = this.mToken.PutPublicKey(inKeyIndex, inPublicKey);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet == 0) {
                String tmpModel = "";
                tmpModel = this.mToken.tokenInfo.tokenModel[0] != 0 ? this.mConverter.HexToString(this.mToken.tokenInfo.tokenModel, 0, this.mToken.tokenInfo.tokenModel.length).toUpperCase() : "00";
                boolean bTargetModel = tmpModel.equals("544D4E34303732202020202020202020");
                if (bTargetModel && this.mToken.tokenInfo.fwVersion[0] == 1 && this.mToken.tokenInfo.fwVersion[1] == 0 || bTargetModel && this.mToken.tokenInfo.fwVersion[0] == 0 && this.mToken.tokenInfo.fwVersion[1] == 1) {
                    LibLog.i(this.TAG, "** 0100");
                    iRet = this.mToken.UpdateKeyLengthToKeyInfoFile(inKeyIndex, inKeyLength);
                }
            }
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\uacf5\uac1c\ud0a4 \uc8fc\uc785 \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
                return;
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uacf5\uac1c\ud0a4 \uc8fc\uc785\uc911 \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void pushCertificate(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("CERTIFICATE_INDEX")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inCertificateIndex = requestBundle.getInt("CERTIFICATE_INDEX");
            if (inCertificateIndex < 1 || inCertificateIndex > this.mToken.tokenInfo.maxCertificates) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3844).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            --inCertificateIndex;
            if (!requestBundle.containsKey("CERTIFICATE_TYPE")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc885\ub958\ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc778\uc99d\uc11c \uc885\ub958\ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                return;
            }
            byte inCertificateType = requestBundle.getByte("CERTIFICATE_TYPE");
            if (inCertificateType == 0) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc885\ub958\ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc885\ub958\ucf54\ub4dc \uc785\ub825 \uc624\ub958");
                return;
            }
            byte[] inCertificateR = null;
            if (requestBundle.containsKey("CERTIFICATE_R") && (inCertificateR = requestBundle.getByteArray("CERTIFICATE_R")).length != 20) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c R\uac12 \uae38\uc774 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c R\uac12 \uae38\uc774 \uc624\ub958(\uc778\uc99d\uc11c R\uac12\uc758 \uae38\uc774 = 20bytes)");
                return;
            }
            if (!requestBundle.containsKey("CERTIFICATE_LENGTH")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uae38\uc774 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uae38\uc774 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inCertificateLength = requestBundle.getInt("CERTIFICATE_LENGTH");
            if (inCertificateLength == 0) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uae38\uc774 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uae38\uc774 \uc785\ub825 \uc624\ub958");
                return;
            }
            if (!requestBundle.containsKey("CERTIFICATE")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \ub370\uc774\ud130 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \ub370\uc774\ud130 \uc785\ub825 \uc624\ub958");
                return;
            }
            byte[] inCertificate = requestBundle.getByteArray("CERTIFICATE");
            if (inCertificate.length == 0) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \ub370\uc774\ud130 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \ub370\uc774\ud130 \uc785\ub825 \uc624\ub958");
                return;
            }
            short iRet = 3840;
            iRet = this.mToken.PutCertificate(inCertificateIndex, inCertificate, inCertificateLength);
            if (iRet != 0) {
                responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \ub370\uc774\ud130 \uc800\uc7a5 \uc2e4\ud328" + this.mToken.getSW12());
                return;
            }
            if (inCertificateR != null && (iRet = (short)this.mToken.PutCertificateR(inCertificateIndex, inCertificateR)) != 0) {
                responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c R\uac12 \uc800\uc7a5 \uc2e4\ud328" + this.mToken.getSW12());
                return;
            }
            iRet = this.mToken.PutCertificateSize(inCertificateIndex, inCertificateLength);
            if (iRet != 0) {
                responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uae38\uc774 \uc800\uc7a5 \uc2e4\ud328" + this.mToken.getSW12());
                return;
            }
            byte[] certificateList = new byte[8];
            iRet = this.mToken.GetCertificateList(certificateList);
            if (iRet == 0) {
                LibLog.d(this.TAG, "!#### inCertificateIndex: " + inCertificateIndex);
                LibLog.d(this.TAG, "!#### certificateList: " + this.mConverter.HexToString(certificateList, 0, certificateList.length));
                certificateList[0] = (byte)(certificateList[0] + 1);
                certificateList[inCertificateIndex + 1] = inCertificateType;
                iRet = this.mToken.UpdateCertificateList(certificateList);
            }
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet == 0) {
                this.mToken.tokenInfo.createdKeyIndex[0] = (byte)(this.mToken.tokenInfo.createdKeyIndex[0] - 1);
                this.mToken.tokenInfo.createdKeyIndex[inCertificateIndex + 1] = 0;
            } else {
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \ub4f1\ub85d \uc815\ubcf4(\uc778\uc99d\uc11c \uc800\uc7a5\uac1c\uc218\uc640 \uc778\uc99d\uc11c\uc885\ub958) \uc800\uc7a5 \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc911 Exception \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void generateSignature(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("CERTIFICATE_INDEX")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inCertificateIndex = requestBundle.getInt("CERTIFICATE_INDEX");
            if (inCertificateIndex < 1 || inCertificateIndex > this.mToken.tokenInfo.maxCertificates) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3844).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            --inCertificateIndex;
            if (!requestBundle.containsKey("TO_BE_SIGNED_DATA")) {
                LibLog.e(this.TAG, "!!!! \uc11c\uba85\ud560 \ub370\uc774\ud130 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc11c\uba85\ud560 \ub370\uc774\ud130 \uc785\ub825 \uc624\ub958");
                return;
            }
            byte[] inDataToBeSigned = requestBundle.getByteArray("TO_BE_SIGNED_DATA");
            if (inDataToBeSigned.length == 0) {
                LibLog.e(this.TAG, "!!!! \uc11c\uba85\ud560 \ub370\uc774\ud130 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc11c\uba85\ud560 \ub370\uc774\ud130 \uc785\ub825 \uc624\ub958");
                return;
            }
            if (!requestBundle.containsKey("KEY_LENGTH")) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uae38\uc774 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uae38\uc774 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inKeyLength = requestBundle.getByte("KEY_LENGTH") * 4;
            if (inKeyLength != 128 && inKeyLength != 256) {
                LibLog.e(this.TAG, "!!!! \ud0a4 \uae38\uc774 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4 \uae38\uc774 \uc785\ub825 \uc624\ub958");
                return;
            }
            if (!requestBundle.containsKey("MECHANISM")) {
                LibLog.e(this.TAG, "!!!! \uba54\ucee4\ub2c8\uc998 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uba54\ucee4\ub2c8\uc998 \uc785\ub825 \uc624\ub958");
                return;
            }
            byte inMechanism = requestBundle.getByte("MECHANISM");
            if (inMechanism != 1) {
                LibLog.e(this.TAG, "!!!! \ubbf8\uc9c0\uc6d0 \uba54\ucee4\ub2c8\uc998 \ucf54\ub4dc \uc0ac\uc6a9");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ubbf8\uc9c0\uc6d0 \uba54\ucee4\ub2c8\uc998 \ucf54\ub4dc \uc0ac\uc6a9");
                return;
            }
            HSMCrypt mCryptoRSA = LibLog.isDebugMode() ? new HSMCrypt(-128, "MTKCrypto") : new HSMCrypt(-128);
            short iRet = 3840;
            byte[] outSignature = new byte[inKeyLength];
            byte[] inPaddingDataToBeSigned = null;
            try {
                inPaddingDataToBeSigned = mCryptoRSA.RSAPaddingForSign(inMechanism, inKeyLength, inDataToBeSigned);
            }
            catch (HSMCryptException e) {
                LibLog.e(this.TAG, "!!!! \uc804\uc790\uc11c\uba85 \uc6d0\ubb38 \ud328\ub529 \ucc98\ub9ac\uc911 \uc624\ub958(RSAPaddingForSign)");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3840).toUpperCase());
                String emsg = e.getMessage();
                if (emsg == null) {
                    emsg = "";
                }
                responseBundle.putString("ERROR_MESSAGE", emsg);
                return;
            }
            byte inP2 = (byte)(inCertificateIndex + 1 << 4);
            iRet = this.mToken.InitializeCrypto((byte)8, inP2);
            if (iRet == 0) {
                iRet = this.mToken.GenerateSignature(inPaddingDataToBeSigned, outSignature, inKeyLength);
            }
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\uc804\uc790\uc11c\uba85 \uc0dd\uc131 \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            } else {
                LibLog.d(this.TAG, "## \uc804\uc790\uc11c\uba85 \uc0ac\uc774\uc988:" + inKeyLength);
                LibLog.d(this.TAG, "## \uc804\uc790\uc11c\uba85 \ub370\uc774\ud0c0:" + this.mConverter.HexToString(outSignature, 0, outSignature.length));
                responseBundle.putByteArray("SIGNATURE", outSignature);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uc804\uc790\uc11c\uba85 \uc0dd\uc131\uc911 Exception \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void decrypt(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("CERTIFICATE_INDEX")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inCertificateIndex = requestBundle.getInt("CERTIFICATE_INDEX");
            if (inCertificateIndex < 1 || inCertificateIndex > this.mToken.tokenInfo.maxCertificates) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3844).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            --inCertificateIndex;
            if (!requestBundle.containsKey("ENC_DATA")) {
                LibLog.e(this.TAG, "!!!! \uc554\ud638\ubb38 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc554\ud638\ubb38 \uc785\ub825 \uc624\ub958");
                return;
            }
            byte[] inEncryptedData = requestBundle.getByteArray("ENC_DATA");
            if (inEncryptedData.length == 0) {
                LibLog.e(this.TAG, "!!!! \uc554\ud638\ubb38 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc554\ud638\ubb38 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inKeyLength = inEncryptedData.length;
            if (inKeyLength != 128 && inKeyLength != 256) {
                LibLog.e(this.TAG, "!!!! \uc554\ud638\ubb38 \uae38\uc774 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc554\ud638\ubb38 \uae38\uc774 \uc624\ub958(\uc785\ub825\ub41c \uc554\ubaa8\ubb38\uc758 \uae38\uc774=" + String.format("%d", inKeyLength) + ")");
                return;
            }
            if (!requestBundle.containsKey("MECHANISM")) {
                LibLog.e(this.TAG, "!!!! \uba54\ucee4\ub2c8\uc998 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uba54\ucee4\ub2c8\uc998 \uc785\ub825 \uc624\ub958");
                return;
            }
            byte inMechanism = requestBundle.getByte("MECHANISM");
            if (inMechanism != 1) {
                LibLog.e(this.TAG, "!!!! \ubbf8\uc9c0\uc6d0 \uba54\ucee4\ub2c8\uc998 \ucf54\ub4dc \uc0ac\uc6a9");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\ubbf8\uc9c0\uc6d0 \uba54\ucee4\ub2c8\uc998 \ucf54\ub4dc \uc0ac\uc6a9");
                return;
            }
            short iRet = 3840;
            byte[] outDecryptedData = new byte[inKeyLength];
            byte inP2 = (byte)(inCertificateIndex + 1 << 4);
            iRet = this.mToken.InitializeCrypto((byte)8, inP2);
            if (iRet == 0) {
                iRet = this.mToken.Decrypt(inEncryptedData, outDecryptedData, inKeyLength);
            }
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\ubcf5\ud638\ud654 \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            } else {
                HSMCrypt mCryptoRSA = LibLog.isDebugMode() ? new HSMCrypt(-128, "MTKCrypto") : new HSMCrypt(-128);
                try {
                    byte[] inUnpaddingData = mCryptoRSA.RSAUnpaddingForDecrypt(inMechanism, inKeyLength, outDecryptedData);
                    LibLog.d(this.TAG, "## \ud3c9\ubb38 \ud06c\uae30:" + inUnpaddingData.length);
                    LibLog.d(this.TAG, "## \ud3c9\ubb38:" + this.mConverter.HexToString(inUnpaddingData, 0, inUnpaddingData.length));
                    responseBundle.putByteArray("DEC_DATA", inUnpaddingData);
                }
                catch (HSMCryptException e) {
                    LibLog.e(this.TAG, "!!!! \ubcf5\ud638\ud654\ub41c \ub370\uc774\ud130\uc758 \uc5b8\ud328\ub529\uc2dc \uc624\ub958 \ubc1c\uc0dd(RSAUnpaddingForDecrypt)");
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3840).toUpperCase());
                    String emsg = e.getMessage();
                    if (emsg == null) {
                        emsg = "";
                    }
                    responseBundle.putString("ERROR_MESSAGE", emsg);
                }
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \ubcf5\ud638\ud654 \uc218\ud589\uc911 Exception \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void deleteCertificate(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("CERTIFICATE_INDEX")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inCertificateIndex = requestBundle.getInt("CERTIFICATE_INDEX");
            if (inCertificateIndex < 1 || inCertificateIndex > this.mToken.tokenInfo.maxCertificates) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3844).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            --inCertificateIndex;
            short iRet = 3840;
            byte[] certificateList = new byte[8];
            iRet = this.mToken.GetCertificateList(certificateList);
            if (iRet == 0) {
                if (certificateList[inCertificateIndex + 1] == 0) {
                    responseBundle.putString("RESULT_CODE", String.format("%04x", (short)4037).toUpperCase());
                    responseBundle.putString("ERROR_MESSAGE", "\ud574\ub2f9 \uc704\uce58\uc5d0 \ubc1c\uae09\ub41c \uc778\uc99d\uc11c\uac00 \uc5c6\uc74c");
                    return;
                }
                certificateList[0] = (byte)(certificateList[0] - 1);
                certificateList[inCertificateIndex + 1] = 0;
                iRet = this.mToken.UpdateCertificateList(certificateList);
            }
            if (iRet != 0) {
                responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \ub4f1\ub85d \uc815\ubcf4 \ubcc0\uacbd \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
                return;
            }
            iRet = this.mToken.PutCertificateSize(inCertificateIndex, 0);
            if (iRet != 0) {
                responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uae38\uc774 \uc815\ubcf4 \uc0ad\uc81c \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
                return;
            }
            byte[] certificateR = new byte[20];
            Arrays.fill(certificateR, (byte)0);
            iRet = this.mToken.PutCertificateR(inCertificateIndex, certificateR);
            if (iRet != 0) {
                responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c R\uac12 \uc0ad\uc81c \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
                return;
            }
            iRet = this.mToken.ClearKeyAndCertificate(inCertificateIndex);
            if (iRet != 0) {
                responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uacf5\uac1c\ud0a4,\uac1c\uc778\ud0a4,\uc778\uc99d\uc11c \ud30c\uc77c \uc0ad\uc81c \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
                return;
            }
            iRet = this.mToken.ClearKeyInfo(inCertificateIndex);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\ud0a4\uc815\ubcf4 \ud30c\uc77c \uc0ad\uc81c \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
                return;
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc0ad\uc81c \ucc98\ub9ac\uc911 Exception \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    private void putCertificateR(Bundle requestBundle, Bundle responseBundle) {
        try {
            if (!requestBundle.containsKey("CERTIFICATE_INDEX")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            int inCertificateIndex = requestBundle.getInt("CERTIFICATE_INDEX");
            if (inCertificateIndex < 1 || inCertificateIndex > this.mToken.tokenInfo.maxCertificates) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3844).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c \uc800\uc7a5\uc704\uce58\ubc88\ud638 \uc785\ub825 \uc624\ub958");
                return;
            }
            --inCertificateIndex;
            if (!requestBundle.containsKey("CERTIFICATE_R")) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c R\uac12 \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c R\uac12 \uc785\ub825 \uc624\ub958");
                return;
            }
            byte[] inCertificateR = requestBundle.getByteArray("CERTIFICATE_R");
            if (inCertificateR.length != 20) {
                LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c R\uac12 \uae38\uc774 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c R\uac12 \uae38\uc774 \uc624\ub958");
                return;
            }
            short iRet = 3840;
            iRet = this.mToken.PutCertificateR(inCertificateIndex, inCertificateR);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "\uc778\uc99d\uc11c R\uac12 \uc800\uc7a5 \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uc778\uc99d\uc11c R\uac12 \uc800\uc7a5\uc911 Exception \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int GetNewKeyIndex(byte inPurpose) {
        int keyIndex = 0;
        try {
            byte[] outCertificateList = new byte[8];
            short iRet = this.mToken.GetCertificateList(outCertificateList);
            if (iRet == 0) {
                LibLog.d(this.TAG, "## \uc778\uc99d\uc11c \ubc1c\uae09 \uac1c\uc218 : " + outCertificateList[0]);
                LibLog.d(this.TAG, "## \ud0a4\uc30d \uc0dd\uc131 \uac1c\uc218 : " + this.mToken.tokenInfo.createdKeyIndex[0]);
                LibLog.d(this.TAG, "## \ub0a8\uc740 \uac1c\uc218 : " + (this.mToken.tokenInfo.maxCertificates - this.mToken.tokenInfo.createdKeyIndex[0] - outCertificateList[0]));
                if (inPurpose == 1 ? this.mToken.tokenInfo.maxCertificates - this.mToken.tokenInfo.createdKeyIndex[0] - outCertificateList[0] < 2 : this.mToken.tokenInfo.maxCertificates - this.mToken.tokenInfo.createdKeyIndex[0] - outCertificateList[0] < 1) {
                    return 0;
                }
                int i = 1;
                while (i < this.mToken.tokenInfo.maxCertificates + 1) {
                    if (outCertificateList[i] == 0 && this.mToken.tokenInfo.createdKeyIndex[i] == 0) {
                        keyIndex = i;
                        break;
                    }
                    ++i;
                }
            } else {
                keyIndex = -1;
            }
            LibLog.d(this.TAG, "## \uc0c8\ub85c\uc6b4 \uc778\uc99d\uc11c/\ud0a4 \uc800\uc7a5\uc704\uce58 : " + keyIndex);
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! \uc0c8\ub85c\uc6b4 \uc778\uc99d\uc11c/\ud0a4 \uc800\uc7a5\uc704\uce58 \ud655\uc778\uc911 Exception \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
            return -1;
        }
        return keyIndex;
    }

    private void sendAPDU(Bundle requestBundle, Bundle responseBundle) {
        try {
            byte[] apdu;
            if (!requestBundle.containsKey("APDU")) {
                LibLog.e(this.TAG, "!!!! APDU \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "APDU \uc785\ub825 \uc624\ub958");
                return;
            }
            byte[] tmpApdu = requestBundle.getByteArray("APDU");
            if (tmpApdu.length < 4) {
                LibLog.e(this.TAG, "!!!! APDU \uc785\ub825 \uc624\ub958");
                responseBundle.putString("RESULT_CODE", String.format("%04x", (short)3842).toUpperCase());
                responseBundle.putString("ERROR_MESSAGE", "APDU \uc785\ub825 \uc624\ub958");
                return;
            }
            if (tmpApdu.length == 4) {
                byte[] byArray = new byte[5];
                byArray[0] = tmpApdu[0];
                byArray[1] = tmpApdu[1];
                byArray[2] = tmpApdu[2];
                byArray[3] = tmpApdu[3];
                apdu = byArray;
            } else {
                apdu = tmpApdu;
            }
            int transmitTimeout = 5000;
            if (requestBundle.containsKey("TIMEOUT")) {
                transmitTimeout = requestBundle.getInt("TIMEOUT");
            }
            short iRet = 3840;
            byte[] outData = new byte[4096];
            int[] outDataLength = new int[1];
            byte[] sw12 = new byte[2];
            iRet = this.mToken.SendApdu(apdu, outData, outDataLength, sw12, transmitTimeout);
            responseBundle.putString("RESULT_CODE", String.format("%04x", iRet).toUpperCase());
            if (iRet != 0) {
                responseBundle.putString("ERROR_MESSAGE", "APDU \uc804\uc1a1 \uc2e4\ud328" + this.mToken.getSW12());
                this.getDetailErrorMessage(iRet, responseBundle);
            } else {
                byte[] responseData = new byte[outDataLength[0]];
                System.arraycopy(outData, 0, responseData, 0, outDataLength[0]);
                LibLog.d(this.TAG, "## \uc751\ub2f5 \ub370\uc774\ud0c0:" + this.mConverter.HexToString(responseData, 0, responseData.length));
                LibLog.d(this.TAG, "## \uc751\ub2f5\ucf54\ub4dc(SW12):" + this.mConverter.HexToString(sw12, 0, sw12.length));
                responseBundle.putByteArray("RESPONSE_DATA", responseData);
                responseBundle.putByteArray("SW12", sw12);
            }
        }
        catch (Exception e) {
            LibLog.e(this.TAG, "!!!! APDU \ucc98\ub9ac\uc911 Exception \uc624\ub958 \ubc1c\uc0dd");
            e.printStackTrace();
        }
    }

    public void SetDebug(boolean mode) {
        LibLog.setDebugMode(mode);
    }
}

