/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem;

import android.content.Context;
import android.os.Handler;
import com.skp.smarttouch.sem.GlobalRepository;
import com.skp.smarttouch.sem.NOPObserver;
import com.skp.smarttouch.sem.SEMConstants;
import com.skp.smarttouch.sem.SEManagerConnection;
import com.skp.smarttouch.sem.tools.dao.TagInfo;
import com.skp.smarttouch.sem.tools.smartcard.AbstractSmartcard;
import kr.co.skplanet.utils.BinaryUtil;
import kr.co.skplanet.utils.LOG;
import kr.co.skplanet.utils.Util;

public abstract class AbstractSEM
implements NOPObserver,
SEMConstants {
    protected Context m_oContext = null;
    protected GlobalRepository m_oGlobalRepository = null;
    protected AbstractSmartcard m_oSmartcard = null;
    protected SEManagerConnection m_onSEManagerConnection = null;
    protected String m_strAppKey = null;
    protected String m_strNopKey = null;
    private String a = null;
    private String b = null;
    protected Handler m_oHandler = new Handler(){};
    private int c = 0;

    protected AbstractSEM(Context context, String compId) {
        this.m_oContext = context;
        this.c = 0;
        this.a = compId;
        this.m_oGlobalRepository = GlobalRepository.getInstance(context);
    }

    public void initialize(String appKey, String stId, SEManagerConnection connection) {
        LOG.info(">> initialize()");
        LOG.info("++ appKey : [%s]", appKey);
        LOG.info("++ stId : [%s]", stId);
        LOG.info("++ connection : [%s]", connection);
        try {
            LOG.setLogTag("SecureElementManager");
            LOG.setReleaseMode(true);
            if (stId == null || stId.length() < 1) {
                throw new IllegalArgumentException("***** nopKey is invalid !!");
            }
            this.m_strAppKey = appKey;
            this.m_strNopKey = stId;
            this.c = 0;
            this.m_onSEManagerConnection = connection;
            if (this.m_oGlobalRepository == null) {
                this.m_oGlobalRepository = GlobalRepository.getInstance(this.m_oContext);
            }
            this.m_oGlobalRepository.requestRightCheck(this, this.m_strNopKey, connection);
        }
        catch (IllegalArgumentException e) {
            LOG.error(e);
            this.c = stId == null ? -2 : -99;
            connection.onServiceDisconnected(this.getCompID(), this.c);
        }
        catch (Exception e) {
            LOG.error(e);
            this.c = -99;
            connection.onServiceDisconnected(this.getCompID(), this.c);
        }
    }

    public void finalize() {
        LOG.info(">> finalize()");
        this.c = 0;
        try {
            this.m_onSEManagerConnection.onServiceDisconnected(this.getCompID(), this.c);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        if (this.m_oGlobalRepository != null) {
            try {
                this.m_oGlobalRepository.finalize(this);
                this.m_oGlobalRepository = null;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    public String getCompID() {
        LOG.info(">> getCompID()");
        return this.a;
    }

    public int getState() {
        LOG.info(">> getState()");
        return this.c;
    }

    protected void setState(int state) {
        LOG.info(">> setState : " + state);
        this.c = state;
    }

    @Override
    public void update(int state) {
        LOG.info(">> update()");
        LOG.info("++ state : [%s]", state);
        this.c = state;
        if (this.m_oSmartcard == null) {
            this.m_oSmartcard = this.m_oGlobalRepository.getISmartcard();
        }
        if (this.m_onSEManagerConnection == null) {
            return;
        }
        this.m_oHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AbstractSEM.this.c == 50) {
                    AbstractSEM.this.m_onSEManagerConnection.onServiceConnected(AbstractSEM.this.getCompID());
                } else {
                    AbstractSEM.this.m_onSEManagerConnection.onServiceDisconnected(AbstractSEM.this.getCompID(), AbstractSEM.this.c);
                }
            }
        });
    }

    protected String generateIccid() {
        LOG.info(">> generateIccid()");
        LOG.info("++ iccid(Stroed) : [%s]", this.b);
        if (this.b != null) {
            return this.b;
        }
        try {
            try {
                int j;
                if (this.m_oSmartcard.connect() <= 0) {
                    throw new Exception("[connect] failed");
                }
                byte[] baRPDU = null;
                byte[] baICCID = null;
                baRPDU = this.m_oSmartcard.transmit(BinaryUtil.parseHexString("00A4000C022FE2"));
                LOG.info("++ baRPDU : [%s]", BinaryUtil.toHexString(baRPDU));
                if (!this.m_oSmartcard.isResponseSuccess(baRPDU)) {
                    throw new Exception("***** File select failed");
                }
                baRPDU = this.m_oSmartcard.transmit(BinaryUtil.parseHexString("00B000000A"));
                LOG.info("++ baRPDU : [%s]", BinaryUtil.toHexString(baRPDU));
                if (!this.m_oSmartcard.isResponseSuccess(baRPDU)) {
                    throw new Exception("***** ICCID read faild");
                }
                baICCID = new byte[baRPDU.length - 2];
                System.arraycopy(baRPDU, 0, baICCID, 0, baICCID.length);
                String tmpIccid = BinaryUtil.toHexString(baICCID);
                int nByteCount = tmpIccid.length() / 2;
                String[][] tempHexString = new String[nByteCount][2];
                int nCount = 0;
                int i = 0;
                while (i < nByteCount) {
                    j = 0;
                    while (j < 2) {
                        tempHexString[i][j] = String.format("%c", Character.valueOf(tmpIccid.charAt(nCount)));
                        ++nCount;
                        ++j;
                    }
                    ++i;
                }
                this.b = "";
                i = 0;
                while (i < nByteCount) {
                    j = 1;
                    while (j >= 0) {
                        this.b = String.valueOf(this.b) + tempHexString[i][j];
                        --j;
                    }
                    ++i;
                }
                LOG.info("++ tmpIccid : [%s]", tmpIccid);
                LOG.info("++ iccid : [%s]", this.b);
            }
            catch (Exception e) {
                LOG.error(e);
                if (this.m_oSmartcard != null) {
                    this.m_oSmartcard.disconnect();
                }
            }
        }
        finally {
            if (this.m_oSmartcard != null) {
                this.m_oSmartcard.disconnect();
            }
        }
        return this.b;
    }

    protected TagInfo getTagInfo(byte[] data, int offset) {
        LOG.info(">> getTagInfo()");
        LOG.debug("offset[" + offset + "]");
        byte tag1byte = data[offset];
        LOG.debug("tag1byte[" + BinaryUtil.toHexString(tag1byte) + "]");
        byte[] tag2byte = new byte[2];
        int dataLen = 0;
        byte[] body = null;
        TagInfo ti = new TagInfo();
        if ((tag1byte & 0x20) == 32) {
            ti.setHasTag(true);
        } else {
            ti.setHasTag(false);
        }
        if ((tag1byte & 0x1F) == 31) {
            System.arraycopy(data, offset, tag2byte, 0, tag2byte.length);
            offset += tag2byte.length;
            ti.setTag2Byte(tag2byte);
        } else {
            ++offset;
            ti.setTag1Byte(tag1byte);
        }
        byte temp = data[offset];
        if ((temp & 0x80) == 128) {
            ++offset;
            ti.setSkipLen(true);
        } else {
            ti.setSkipLen(false);
        }
        dataLen = Util.BytesToInt(data, offset, 1);
        LOG.debug("dataLen[" + dataLen + "]");
        body = new byte[dataLen];
        System.arraycopy(data, ++offset, body, 0, dataLen);
        Util.DumpPacket("getTagInfo", body, dataLen);
        ti.setLen(dataLen);
        ti.setBody(body);
        LOG.debug("getTagInfo");
        return ti;
    }
}

