/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.applet;

import android.content.Context;
import com.skp.smarttouch.sem.AbstractSEM;
import com.skp.smarttouch.sem.SEMConstants;
import com.skp.smarttouch.sem.tools.common.STIllegarStateException;
import com.skp.smarttouch.sem.tools.network.WorkerPoolExecutor;
import kr.co.skplanet.utils.LOG;

public class SEIO
extends AbstractSEM
implements SEMConstants {
    public static final String COMPONENT_ID = "APPLET_SEIO";
    private static SEIO a = null;

    private SEIO(Context context, String compId) {
        super(context, compId);
        LOG.info(">> SEIO()");
        LOG.info("++ context : [%s]", context);
        LOG.info("++ compId : [%s]", compId);
    }

    public static SEIO getInstance(Context context) {
        if (a == null) {
            a = new SEIO(context, COMPONENT_ID);
        }
        return a;
    }

    @Override
    public void finalize() {
        LOG.info(">> finalize()");
        if (this.m_oSmartcard != null) {
            this.m_oSmartcard.disconnect();
        }
        super.finalize();
    }

    public int getChannel() {
        int nChannel = -1;
        try {
            this.a();
            nChannel = this.m_oSmartcard.getChannel();
        }
        catch (Exception e) {
            LOG.error(e);
            nChannel = -1;
        }
        return nChannel;
    }

    public int getATR(byte[] rpdu) {
        int nResult = -1;
        try {
            this.a();
            WorkerPoolExecutor workExcutor = WorkerPoolExecutor.getInstance();
            if (workExcutor.isWorking()) {
                throw new Exception("***** smartcard is working");
            }
            byte[] response = this.m_oSmartcard.getATR();
            nResult = response.length;
            System.arraycopy(response, 0, rpdu, 0, nResult);
        }
        catch (Exception e) {
            LOG.error(e);
            nResult = -1;
        }
        return nResult;
    }

    public int connect() {
        int nRet = -1;
        try {
            this.a();
            nRet = this.m_oSmartcard.getChannel();
            if (nRet < 0) {
                nRet = this.m_oSmartcard.connect();
            }
        }
        catch (Exception e) {
            LOG.error(e);
            nRet = -1;
        }
        return nRet;
    }

    public int disconnect() {
        int nRet = -1;
        try {
            this.a();
            nRet = this.m_oSmartcard.disconnect();
        }
        catch (Exception e) {
            LOG.error(e);
            nRet = -1;
        }
        return nRet;
    }

    public int transmit(byte[] apdu, byte[] rpdu) {
        int nLen = -1;
        try {
            this.a();
            WorkerPoolExecutor workExcutor = WorkerPoolExecutor.getInstance();
            if (workExcutor.isWorking()) {
                throw new Exception("***** smartcard is working");
            }
            if (apdu == null || apdu.length < 4) {
                throw new IllegalArgumentException("***** apdu is empty");
            }
            if (rpdu == null || rpdu.length < 1) {
                throw new IllegalArgumentException("***** rpdu is not alloc");
            }
            byte[] response = this.m_oSmartcard.transmit(apdu);
            nLen = response.length;
            System.arraycopy(response, 0, rpdu, 0, nLen);
        }
        catch (Exception e) {
            LOG.error(e);
            nLen = -1;
        }
        return nLen;
    }

    private void a() throws Exception {
        LOG.info(">> beforeExecute()");
        if (a == null) {
            throw new STIllegarStateException("***** instance is invalidate !!");
        }
        if (this.getState() != 50) {
            throw new STIllegarStateException("***** component state is not connected !!");
        }
        if (this.m_oGlobalRepository == null) {
            throw new STIllegarStateException("***** component state is not connected !!");
        }
        this.m_oSmartcard = this.m_oGlobalRepository.getISmartcard();
        if (this.m_oSmartcard == null) {
            throw new STIllegarStateException("***** smartcard is not available !!");
        }
        this.m_oGlobalRepository.checkPermissionComponents(this.getCompID());
    }
}

