/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.core.CoreWrapper;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.crypto.PKCS11Password;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;

public class CopyCertificate
extends Activity {
    private int mSrcMediaID;
    private int mDstMediaID;
    private String mPass_word;
    private String mNew_Pass_word;
    private String mNew_Pass_wordConfirm;
    private XDetailData mSelectedData;
    public static final int mCopyCertificateID = 110000;
    public static final String mSrcMediaIDKey = "copy_cert_src_media_id_key";
    public static final String mDstMediaIDKey = "copy_cert_dst_media_id_key";
    public static final String mSelectedCertDataKey = "copy_cert_selected_cert_data_key";
    private XCoreUtil mCoreUtil = new XCoreUtil();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_cert_copy);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), 0);
        this.mSrcMediaID = this.getIntent().getIntExtra(mSrcMediaIDKey, -1);
        this.mDstMediaID = this.getIntent().getIntExtra(mDstMediaIDKey, -1);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)XUtil.getCNFromRDN((String)this.mSelectedData.getValue(7)));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(4) + " : " + XUtil.getCNFromRDN((String)this.mSelectedData.getValue(4))));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(6) + " : " + this.mSelectedData.getValue(6)));
        if (this.mDstMediaID == 101) {
            this.findViewById(R.id.password_input_view).setVisibility(8);
        } else {
            this.findViewById(R.id.new_password_input_view).setVisibility(8);
        }
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CopyCertificate.this.onOKButtonClick(v);
            }
        });
        this.showMessage();
    }

    private void startPKCS11PasswordActivity() {
        this.startActivityForResult(new Intent((Context)this, PKCS11Password.class), 90000);
    }

    private void onOKButtonClick(View v) {
        this.mCoreUtil.resetError();
        if (this.mDstMediaID == 401) {
            TextView aPasswordTextView = (TextView)this.findViewById(R.id.password_edittext);
            this.mPass_word = aPasswordTextView.getText().toString();
        } else {
            XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
            TextView aNewPasswordTextView = (TextView)this.findViewById(R.id.new_password_edittext);
            TextView aNewPasswordConfirmTextView = (TextView)this.findViewById(R.id.new_password_confirm_edittext);
            this.mNew_Pass_word = aNewPasswordTextView.getText().toString();
            this.mNew_Pass_wordConfirm = aNewPasswordConfirmTextView.getText().toString();
            if (this.mNew_Pass_word.length() == 0) {
                aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
                return;
            }
            if (!this.mNew_Pass_word.equals(this.mNew_Pass_wordConfirm)) {
                aTopView.setDescription(this.getString(R.string.incorrect_confirm_password));
                return;
            }
        }
        this.startPKCS11PasswordActivity();
    }

    private void showMessage() {
        String message = this.mSrcMediaID == 401 ? this.getString(R.string.cert_copy_to_sdcard) : this.getString(R.string.cert_copy_to_pkcs11);
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)message).setPositiveButton((CharSequence)"\ud655\uc778", null).show();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 90000) {
            if (resultCode == 0) {
                this.setResult(0);
                this.finish();
            } else if (resultCode == 100) {
                this.setResult(resultCode);
                this.finish();
            } else {
                boolean result = false;
                if (this.mDstMediaID == 401) {
                    CoreWrapper.saveCert((String)this.mSelectedData.getValue(7), (byte[])this.mPass_word.getBytes(), (int)this.mSrcMediaID, (int)3, (int)14, (int)this.mDstMediaID);
                } else {
                    CoreWrapper.saveCert((String)this.mSelectedData.getValue(7), (byte[])this.mNew_Pass_word.getBytes(), (int)this.mSrcMediaID, (int)3, (int)14, (int)this.mDstMediaID);
                }
                if (!result) {
                    this.setResult(-1);
                    CertMgr.getInstance().getMediaList(this.mDstMediaID / 100 * 100, 0, 1);
                    this.finish();
                } else {
                    this.setResult(2);
                    this.finish();
                }
            }
        }
    }
}

