/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.lumensoft.ks.KSException;
import com.lumensoft.ks.KSHsaNet;
import com.softforum.sample.R;
import com.softforum.xecure.XApplication;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.util.XSLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class XecureSmartCertMgrCopy
extends Activity {
    public static final int mXecureSmartCertMgrCopyID = 72500;
    public static final String mVidKey = "vid_key";
    private ProgressDialog mProgressBarDialog;
    private ProgressBar mProgressBar;
    private int mProgressStatus = 0;
    private KSHsaNet mHsa = null;
    private String mCnum = null;
    private TextView mTextview;
    private Handler mHandler;
    private RestTimeCountDownTimer mRestTimeCountDownTimer;
    private long mTotalTime = 180000L;
    private long mCountDownInterval = 1000L;
    private boolean mCancelFlag = false;
    private boolean mCompleteGetCNum = false;
    private int mGetCNumResult = 0;
    private int mGetCertificateResult = 0;
    private Thread mCopyThread;
    private int mResultForImportCertOK = 2;
    private int mResultForImportCertFail = 3;
    private int mResultForImportCertCancel = 4;
    private int mResultForImportCertCopyFail = 5;
    private int mResultForImportCertCreateCNumOK = 6;
    private int mResultForImportCertCreateCNumFail = 7;
    private int mResultForImportCertWrongVID = 8;
    private int mResultForImportCertNotExistSDCard = 9;
    private int mResultForImportCertConnectionDone = 10;
    private int mResultForImportCertNetworkError = 11;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_cert_mgr_copy);
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartCertMgrCopy.this.onOKButtonClick(v);
            }
        });
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                Intent aIntent = XecureSmartCertMgrCopy.this.getIntent();
                if (msg.what == XecureSmartCertMgrCopy.this.mResultForImportCertOK) {
                    aIntent.putExtra("xecure_smart_result_key", 2);
                    XecureSmartCertMgrCopy.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopy.this.mProgressBarDialog != null) {
                        XecureSmartCertMgrCopy.this.mProgressBarDialog.dismiss();
                    }
                    XecureSmartCertMgrCopy.this.finish();
                } else if (msg.what == XecureSmartCertMgrCopy.this.mResultForImportCertFail) {
                    aIntent.putExtra("xecure_smart_result_key", 3);
                    XecureSmartCertMgrCopy.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopy.this.mProgressBarDialog != null) {
                        XecureSmartCertMgrCopy.this.mProgressBarDialog.dismiss();
                    }
                    XecureSmartCertMgrCopy.this.finish();
                } else if (msg.what == XecureSmartCertMgrCopy.this.mResultForImportCertCancel) {
                    aIntent.putExtra("xecure_smart_result_key", 4);
                    XecureSmartCertMgrCopy.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopy.this.mProgressBarDialog != null) {
                        XecureSmartCertMgrCopy.this.mProgressBarDialog.dismiss();
                    }
                    XecureSmartCertMgrCopy.this.finish();
                } else if (msg.what == XecureSmartCertMgrCopy.this.mResultForImportCertCopyFail) {
                    aIntent.putExtra("xecure_smart_result_key", 5);
                    XecureSmartCertMgrCopy.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopy.this.mProgressBarDialog != null) {
                        XecureSmartCertMgrCopy.this.mProgressBarDialog.dismiss();
                    }
                    XecureSmartCertMgrCopy.this.finish();
                } else if (msg.what == XecureSmartCertMgrCopy.this.mResultForImportCertCreateCNumOK) {
                    XecureSmartCertMgrCopy.this.mTextview = (TextView)XecureSmartCertMgrCopy.this.findViewById(R.id.cnum);
                    XecureSmartCertMgrCopy.this.mTextview.setText((CharSequence)("\uc778\uc99d\ubc88\ud638 : " + XecureSmartCertMgrCopy.this.mCnum));
                    if (XecureSmartCertMgrCopy.this.mProgressBarDialog != null) {
                        XecureSmartCertMgrCopy.this.mProgressBarDialog.dismiss();
                    }
                } else if (msg.what == XecureSmartCertMgrCopy.this.mResultForImportCertCreateCNumFail) {
                    aIntent.putExtra("xecure_smart_result_key", 8);
                    XecureSmartCertMgrCopy.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopy.this.mProgressBarDialog != null) {
                        XecureSmartCertMgrCopy.this.mProgressBarDialog.dismiss();
                    }
                    XecureSmartCertMgrCopy.this.finish();
                } else if (msg.what == XecureSmartCertMgrCopy.this.mResultForImportCertWrongVID) {
                    aIntent.putExtra("xecure_smart_result_key", 10);
                    XecureSmartCertMgrCopy.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopy.this.mProgressBarDialog != null) {
                        XecureSmartCertMgrCopy.this.mProgressBarDialog.dismiss();
                    }
                    XecureSmartCertMgrCopy.this.finish();
                } else if (msg.what == XecureSmartCertMgrCopy.this.mResultForImportCertNotExistSDCard) {
                    aIntent.putExtra("xecure_smart_result_key", 6);
                    XecureSmartCertMgrCopy.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopy.this.mProgressBarDialog != null) {
                        XecureSmartCertMgrCopy.this.mProgressBarDialog.dismiss();
                    }
                    XecureSmartCertMgrCopy.this.finish();
                } else if (msg.what == XecureSmartCertMgrCopy.this.mResultForImportCertConnectionDone) {
                    aIntent.putExtra("xecure_smart_result_key", 9);
                    XecureSmartCertMgrCopy.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopy.this.mProgressBarDialog != null) {
                        XecureSmartCertMgrCopy.this.mProgressBarDialog.dismiss();
                    }
                    XecureSmartCertMgrCopy.this.finish();
                } else if (msg.what == XecureSmartCertMgrCopy.this.mResultForImportCertNetworkError) {
                    aIntent.putExtra("xecure_smart_result_key", 11);
                    XecureSmartCertMgrCopy.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopy.this.mProgressBarDialog != null) {
                        XecureSmartCertMgrCopy.this.mProgressBarDialog.dismiss();
                    }
                    XecureSmartCertMgrCopy.this.finish();
                }
            }
        };
        this.getCNum();
    }

    public void finish() {
        super.finish();
        if (this.mHsa != null) {
            this.mHsa.close();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (this.mHsa != null) {
            this.mHsa.close();
        }
        if (this.mCopyThread != null && this.mCopyThread.isAlive()) {
            this.mCancelFlag = true;
            this.mRestTimeCountDownTimer.cancel();
            this.mCopyThread.interrupt();
        }
    }

    private void onOKButtonClick(View v) {
        if (this.mCompleteGetCNum) {
            View aView = this.findViewById(R.id.rest_time_layout);
            aView.setVisibility(0);
            Button aButton = (Button)this.findViewById(R.id.top_right_button);
            aButton.setVisibility(4);
            this.mRestTimeCountDownTimer = new RestTimeCountDownTimer(this.mTotalTime, this.mCountDownInterval);
            this.mProgressBar = (ProgressBar)this.findViewById(R.id.rest_time_progressbar);
            this.mProgressBar.setMax((int)(this.mTotalTime / 1000L));
            this.mCopyThread = new Thread(new CopyRunnable());
            this.mCopyThread.start();
        } else {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(this.mResultForImportCertCreateCNumFail));
        }
    }

    private void getCNum() {
        final Thread GetCNNumThread = new Thread(new GetCNNumRunnable());
        this.mProgressBarDialog = new ProgressDialog((Context)this);
        this.mProgressBarDialog.setTitle((CharSequence)this.getString(R.string.xecure_smart_cert_mgr_copy_copying));
        this.mProgressBarDialog.setMessage((CharSequence)"\uc778\uc99d\ubc88\ud638\ub97c \uac00\uc838\uc624\ub294 \uc911\uc785\ub2c8\ub2e4.");
        this.mProgressBarDialog.setIndeterminate(true);
        this.mProgressBarDialog.setCancelable(true);
        this.mProgressBarDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (XecureSmartCertMgrCopy.this.mCnum != null) {
                    XecureSmartCertMgrCopy.this.mHsa.close();
                }
                if (GetCNNumThread.isAlive() && !XecureSmartCertMgrCopy.this.mCompleteGetCNum) {
                    XecureSmartCertMgrCopy.this.mCancelFlag = true;
                    GetCNNumThread.interrupt();
                }
            }
        });
        this.mProgressBarDialog.show();
        GetCNNumThread.start();
    }

    private class RestTimeCountDownTimer
    extends CountDownTimer {
        public RestTimeCountDownTimer(long aStartTime, long aInterval) {
            super(aStartTime, aInterval);
        }

        public void onFinish() {
            XecureSmartCertMgrCopy.this.mHandler.sendMessage(XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertConnectionDone));
        }

        public void onTick(long aCurrentSecond) {
            TextView aTextView = (TextView)XecureSmartCertMgrCopy.this.findViewById(R.id.rest_time_text);
            String aRestTime = aTextView.getText().toString();
            int aSecond = (int)(aCurrentSecond / 1000L);
            int aMinute = aSecond / 60;
            aSecond %= 60;
            aRestTime = "\uc778\uc99d\uc11c\ub97c \uac00\uc838\uc624\uace0 \uc788\ub294 \uc911\uc785\ub2c8\ub2e4.\n";
            aRestTime = aRestTime + "\ub0a8\uc740 \uc2dc\uac04 : ";
            if (aMinute != 0) {
                aRestTime = aRestTime + aMinute + "\ubd84 ";
                aRestTime = aSecond < 10 ? aRestTime + "0" + aSecond + "\ucd08" : aRestTime + aSecond + "\ucd08";
            } else {
                aRestTime = aSecond < 10 ? aRestTime + "0" + aSecond + "\ucd08" : aRestTime + aSecond + "\ucd08";
            }
            aTextView.setText((CharSequence)aRestTime);
            XecureSmartCertMgrCopy.this.mProgressStatus++;
            XecureSmartCertMgrCopy.this.mProgressBar.setProgress(XecureSmartCertMgrCopy.this.mProgressStatus);
        }
    }

    private class CopyRunnable
    implements Runnable {
        private CopyRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            XecureSmartCertMgrCopy.this.mRestTimeCountDownTimer.start();
            File aTempDir = null;
            File aTempUserCert = null;
            File aTempUserKey = null;
            FileOutputStream aCert = null;
            FileOutputStream aKey = null;
            String aCertPath = null;
            String aKeyPath = null;
            String aSofoPath = null;
            Message aMsg = null;
            aSofoPath = XApplication.getContext().getFilesDir() + "/temp";
            aCertPath = aSofoPath + "/SignCert.der";
            aKeyPath = aSofoPath + "/SignPri.key";
            XecureSmartCertMgrCopy.this.mGetCertificateResult = XecureSmartCertMgrCopy.this.mHsa.getCertificateSofo();
            if (!XecureSmartCertMgrCopy.this.mCancelFlag) {
                if (XecureSmartCertMgrCopy.this.mGetCertificateResult == 0) {
                    try {
                        byte[] userCert = XecureSmartCertMgrCopy.this.mHsa.getHsaCert();
                        byte[] userKey = XecureSmartCertMgrCopy.this.mHsa.getHsaKey();
                        int aResult = 0;
                        aTempDir = new File(aSofoPath);
                        if (!aTempDir.exists()) {
                            boolean aMkdirResult = false;
                            aMkdirResult = aTempDir.mkdir();
                            XSLog.d((String)(this.getClass().getName() + "::Make directory result : " + aMkdirResult));
                            if (!aMkdirResult) {
                                aMsg = XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertCopyFail);
                                return;
                            }
                        }
                        aTempUserCert = new File(aSofoPath, "SignCert.der");
                        aTempUserKey = new File(aSofoPath, "SignPri.key");
                        aCert = new FileOutputStream(aTempUserCert);
                        aKey = new FileOutputStream(aTempUserKey);
                        aCert.write(userCert);
                        aKey.write(userKey);
                        aResult = CertMgr.getInstance().importCertificateWithDer(101, null, aCertPath, aKeyPath, null, null, 1);
                        XSLog.d((String)(this.getClass().getName() + "::importCert result : " + aResult));
                        aMsg = aResult == 0 ? XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertOK) : XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertFail);
                        aTempUserCert.delete();
                        aTempUserKey.delete();
                        aTempDir.delete();
                    }
                    catch (IOException e) {
                        XSLog.e((String)"Could not write file");
                        aMsg = XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertCopyFail);
                    }
                    finally {
                        try {
                            if (aCert != null) {
                                aCert.close();
                            }
                            if (aKey != null) {
                                aKey.close();
                            }
                        }
                        catch (IOException e) {
                            XSLog.e((String)"Fail to close FileOutputStream.");
                            aMsg = XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertCopyFail);
                        }
                    }
                } else {
                    aMsg = XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertCopyFail);
                }
                XecureSmartCertMgrCopy.this.mHandler.sendMessage(aMsg);
            }
        }
    }

    private class GetCNNumRunnable
    implements Runnable {
        private GetCNNumRunnable() {
        }

        @Override
        public void run() {
            String aVid = null;
            Intent aIntent = XecureSmartCertMgrCopy.this.getIntent();
            aVid = aIntent.getStringExtra(XecureSmartCertMgrCopy.mVidKey);
            XecureSmartCertMgrCopy.this.mHsa = new KSHsaNet("211.32.131.182", 9500, "211.32.131.182", 9500, aVid);
            XecureSmartCertMgrCopy.this.mGetCNumResult = XecureSmartCertMgrCopy.this.mHsa.putIdv();
            XSLog.d((String)(this.getClass().getName() + "::putIDV return value : " + XecureSmartCertMgrCopy.this.mGetCNumResult));
            if (!XecureSmartCertMgrCopy.this.mCancelFlag) {
                if (XecureSmartCertMgrCopy.this.mGetCNumResult == 0) {
                    try {
                        XecureSmartCertMgrCopy.this.mCnum = XecureSmartCertMgrCopy.this.mHsa.getCnum();
                        XecureSmartCertMgrCopy.this.mHandler.sendMessage(XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertCreateCNumOK));
                        XecureSmartCertMgrCopy.this.mCompleteGetCNum = true;
                    }
                    catch (KSException e) {
                        XSLog.e((String)("KSException Error : " + e.getMessage()));
                        XecureSmartCertMgrCopy.this.mHandler.sendMessage(XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertCreateCNumFail));
                    }
                } else if (XecureSmartCertMgrCopy.this.mGetCNumResult == -211) {
                    XecureSmartCertMgrCopy.this.mHandler.sendMessage(XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertWrongVID));
                } else if (XecureSmartCertMgrCopy.this.mGetCNumResult == -209) {
                    XecureSmartCertMgrCopy.this.mHandler.sendMessage(XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertConnectionDone));
                } else {
                    XecureSmartCertMgrCopy.this.mHandler.sendMessage(XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertNetworkError));
                }
            } else {
                XecureSmartCertMgrCopy.this.mHandler.sendMessage(XecureSmartCertMgrCopy.this.mHandler.obtainMessage(XecureSmartCertMgrCopy.this.mResultForImportCertCancel));
            }
        }
    }
}

