/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.transkey;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.consortium.smartusim.SmartUsim;
import com.consortium.smartusim.SmartUsimResultCode;
import com.softforum.sample.R;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.transkey.TransKeyResultInterface;
import com.softforum.xecure.ui.transkey.TransKeyUtil;
import com.softforum.xecure.usim.SmartUsimParcelable;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;

public class UsimCertDeleteWithTranskey
extends Activity
implements TransKeyResultInterface {
    public static final int mXecureSmartDeleteCertoUsimID = 140000;
    private SmartUsim mSmartUsim = null;
    private int mCertPosition = -1;
    XTopView mTopView = null;
    private byte[] mSmartPassword = null;
    public static final String mParsedXDetailDataKey = "parsed_xdetail_data_key";
    private XDetailData mSelectedData;
    private int mDetailDataCertSubjectKey = 2;
    private int mDetailDataCertIssuerKey = 6;
    private int mDetailDataCertToKey = 5;
    private TransKeyUtil mTransKeyUtil = new TransKeyUtil();
    private final int[] mTransKeyTextIds = new int[]{R.id.smart_password_edittext};
    private final int[] mTransKeyTextStrings = new int[]{R.string.smart_password};
    private final int[] mTransKeyMaxLength = new int[]{150};

    protected void onCreate(Bundle pSavedInstanceState) {
        super.onCreate(pSavedInstanceState);
        this.setContentView(R.layout.usim_cert_delete);
        Intent aIntent = null;
        SmartUsimParcelable aSmartUsimParcelable = null;
        aIntent = this.getIntent();
        aSmartUsimParcelable = (SmartUsimParcelable)aIntent.getParcelableExtra("SmartUsim");
        this.mSmartUsim = aSmartUsimParcelable.getSmartUsim();
        this.mCertPosition = aIntent.getIntExtra("Position", 0);
        String[] aStringArrayExtra = this.getIntent().getStringArrayExtra(mParsedXDetailDataKey);
        this.mSelectedData = new XDetailData(aStringArrayExtra, 4);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)this.mSelectedData.getValue(this.mDetailDataCertSubjectKey));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertIssuerKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertIssuerKey)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertToKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertToKey)));
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UsimCertDeleteWithTranskey.this.onOKButtonClick(v);
            }
        });
        this.mTransKeyUtil.setMTransKey(this, this.mTransKeyTextIds, this.mTransKeyTextStrings, this.mTransKeyMaxLength, null);
    }

    private void onOKButtonClick(View v) {
        this.mTopView = (XTopView)this.findViewById(R.id.top_view);
        EditText aSmartPasswordEditText = (EditText)this.findViewById(R.id.smart_password_edittext);
        if (this.mSmartPassword == null || this.mSmartPassword.length == 0) {
            this.mTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        Intent aIntent = new Intent();
        SmartUsimResultCode delResult = this.mSmartUsim.deleteCertUsim(this.mCertPosition, this.mSmartPassword);
        if (delResult.getResultCode() != 0) {
            if (delResult.getResultCode() == 5001) {
                this.mTopView.setDescription(this.getString(R.string.message_password_pin_incorrect));
                this.mSmartPassword = null;
                aSmartPasswordEditText.setText((CharSequence)"");
                return;
            }
            if (delResult.getResultCode() == 5002) {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 4);
                this.setResult(-1, aIntent);
                this.finish();
            } else if (delResult.getResultCode() == 5003) {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 5);
                this.setResult(-1, aIntent);
                this.finish();
            } else {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 9);
                this.setResult(-1, aIntent);
                this.finish();
            }
        } else {
            aIntent.putExtra("xecure_smart_cert_mgr_result_key", 8);
            this.setResult(-1, aIntent);
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mTransKeyUtil.transKeyActivityResult(this, requestCode, resultCode, data, this.mTransKeyTextIds);
    }

    public void onBackPressed() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mSmartPassword});
        super.onBackPressed();
    }

    @Override
    public void setTransKeyResult(int index, byte[] result) {
        switch (index) {
            case 0: {
                if (result == null) break;
                this.mSmartPassword = (byte[])result.clone();
            }
        }
    }

    @Override
    public void setTransKeyResult(int pIndex, String pEncryptedData) {
        switch (pIndex) {
            case 0: {
                if (this.mTransKeyUtil.getDecryptCipherData() == null) break;
                this.mSmartPassword = (byte[])this.mTransKeyUtil.getDecryptCipherData().clone();
            }
        }
    }

    @Override
    public void doNext() {
        boolean aExistResult = false;
        aExistResult = this.mTransKeyUtil.isResultsNotEmpty(new byte[][]{this.mSmartPassword});
        if (aExistResult) {
            this.onOKButtonClick(null);
        }
        XUtil.resetByteArray((byte[][])new byte[][]{this.mSmartPassword});
    }
}

