/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.util;

import android.content.Context;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.softforum.sample.R;
import java.util.HashMap;
import java.util.List;

public class ImageTextSpinnerAdapter
implements ListAdapter,
SpinnerAdapter {
    private Context mContext;
    private List<HashMap<String, Object>> mItemLists;
    private final DataSetObservable observers = new DataSetObservable();
    private int mSelectedIndex = 0;

    public ImageTextSpinnerAdapter(Context context, List<HashMap<String, Object>> objects) {
        this.mContext = context;
        this.mItemLists = objects;
    }

    public int getCount() {
        return this.mItemLists.size();
    }

    public HashMap<String, Object> getItem(int position) {
        return this.mItemLists.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        LinearLayout aLayout;
        if (convertView == null) {
            LayoutInflater aLayoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            aLayout = (LinearLayout)aLayoutInflater.inflate(R.layout.image_text_spinner_item, parent, false);
        } else {
            aLayout = (LinearLayout)convertView;
        }
        ImageView aImage = (ImageView)aLayout.getChildAt(0);
        aImage.setImageResource(((Integer)((HashMap)this.getItem(position)).get("image")).intValue());
        TextView aText = (TextView)aLayout.getChildAt(1);
        aText.setText((CharSequence)((HashMap)this.getItem(position)).get("text").toString());
        Spinner aSpinner = (Spinner)parent;
        this.mSelectedIndex = aSpinner.getSelectedItemPosition();
        return aLayout;
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        LinearLayout aLayout;
        if (convertView == null) {
            LayoutInflater aLayoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            aLayout = (LinearLayout)aLayoutInflater.inflate(R.layout.image_text_spinner_dropdown_item, parent, false);
        } else {
            aLayout = (LinearLayout)convertView;
        }
        ImageView aImage = (ImageView)aLayout.getChildAt(0);
        aImage.setImageResource(((Integer)((HashMap)this.getItem(position)).get("image")).intValue());
        CheckedTextView aText = (CheckedTextView)aLayout.getChildAt(1);
        aText.setText((CharSequence)((HashMap)this.getItem(position)).get("text").toString());
        if (position == this.mSelectedIndex) {
            aText.setChecked(true);
        } else {
            aText.setChecked(false);
        }
        return aLayout;
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean isEnabled(int position) {
        return true;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public int getViewTypeCount() {
        return 1;
    }

    public boolean hasStableIds() {
        return false;
    }

    public boolean isEmpty() {
        return 0 == this.getCount();
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.observers.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.observers.unregisterObserver((Object)observer);
    }
}

