/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class Network {
    public static final int TIMEOUT = 300000;
    public Socket cs = null;
    public DataOutputStream outBound = null;
    public DataInputStream inBound = null;
    public byte type;

    public void netOpen(String serverIP, int serverPort) throws Exception {
        try {
            InetAddress serverAddr = InetAddress.getByName(serverIP);
            this.cs = new Socket(serverAddr, serverPort);
            this.outBound = new DataOutputStream(this.cs.getOutputStream());
            this.inBound = new DataInputStream(this.cs.getInputStream());
        }
        catch (IOException e) {
            throw new Exception("netOpen error");
        }
    }

    public void netClose() throws IOException {
        try {
            if (this.inBound != null) {
                this.inBound.close();
            }
            if (this.outBound != null) {
                this.outBound.close();
            }
            if (this.cs != null) {
                this.cs.close();
            }
        }
        catch (IOException e) {
            throw new IOException("netClose error : " + e.getMessage());
        }
    }

    public byte[] readToken() throws Exception {
        byte[] head = new byte[3];
        try {
            this.inBound.readFully(head);
            this.type = head[0];
            int len = (head[1] & 0xFF) * 256;
            if ((len += head[2] & 0xFF) <= 0 || len > 65536) {
                throw new Exception("Invalid data length : " + len);
            }
            byte[] token = new byte[len];
            this.inBound.readFully(token);
            return token;
        }
        catch (IOException e) {
            throw new Exception("readToken error ");
        }
    }

    public void writeToken(byte[] token, byte sendType) throws Exception {
        try {
            byte[] sendData = new byte[token.length + 3];
            sendData[0] = sendType;
            sendData[1] = (byte)(token.length >> 8 & 0xFF);
            sendData[2] = (byte)(token.length & 0xFF);
            System.arraycopy(token, 0, sendData, 3, token.length);
            this.outBound.write(sendData);
        }
        catch (IOException e) {
            throw new Exception("writeToken error ");
        }
    }
}

