/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecurekeypad;

import com.softforum.xecurekeypad.XKCoreWrapper;
import com.softforum.xecurekeypad.XKEditText;
import com.softforum.xecurekeypad.XKKeyButton;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;

public class XKKeypadInterface {
    private XKCoreWrapper mXKCoreWrapper = null;
    private XKEditText mXKEditText = null;
    private Random mRandom = null;

    public XKKeypadInterface(XKEditText aXKEditText, XKCoreWrapper aXKCoreWrapper) {
        this.mXKEditText = aXKEditText;
        this.mXKCoreWrapper = aXKCoreWrapper;
    }

    public void initRandom() {
        this.mRandom = new Random(System.currentTimeMillis());
    }

    public int getRandom(int aStartNumber, int aEndNumber) {
        int aRandomNumber = 0;
        aRandomNumber = this.mRandom.nextInt(aEndNumber - aStartNumber + 1) + aStartNumber;
        return aRandomNumber;
    }

    public int getIndex(int[] aIndexArray, int aIndexArrayLength) {
        int aResult = 0;
        int aIndexCount = 0;
        String aIndex = "";
        StringTokenizer aIndexTokenizer = null;
        aIndex = this.mXKCoreWrapper.getIndex();
        try {
            aIndexTokenizer = new StringTokenizer(aIndex, ",");
            aIndexCount = 0;
            while (aIndexCount < aIndexArrayLength) {
                aIndexArray[aIndexCount] = Integer.parseInt(aIndexTokenizer.nextToken());
                ++aIndexCount;
            }
        }
        catch (NullPointerException aException) {
            aResult = -1;
        }
        catch (NoSuchElementException aException) {
            aResult = -1;
        }
        return aResult;
    }

    public int getIndexText(String[] aIndexTextArray, int aIndexTextArrayLength, int aKeypadType) {
        int aResult = 0;
        int aIndexCount = 0;
        String aIndexText = "";
        StringTokenizer aIndexTextTokenizer = null;
        aIndexText = this.mXKCoreWrapper.getIndexText(aKeypadType);
        try {
            aIndexTextTokenizer = new StringTokenizer(aIndexText, "\t\n");
            aIndexCount = 0;
            while (aIndexCount < aIndexTextArrayLength) {
                aIndexTextArray[aIndexCount] = aIndexTextTokenizer.nextToken();
                ++aIndexCount;
            }
        }
        catch (NullPointerException aException) {
            aResult = -1;
        }
        catch (NoSuchElementException aException) {
            aResult = -1;
        }
        return aResult;
    }

    public int makeIndex(int[] aIndexArray, int aIndexArrayLength, int aKeypadType) {
        int aResult = 0;
        int aIndexCount = 0;
        String aIndex = "";
        StringTokenizer aIndexTokenizer = null;
        this.mXKCoreWrapper.clearIndex();
        aIndex = this.mXKCoreWrapper.makeIndex(aKeypadType);
        try {
            aIndexTokenizer = new StringTokenizer(aIndex, ",");
            aIndexCount = 0;
            while (aIndexCount < aIndexArrayLength) {
                aIndexArray[aIndexCount] = Integer.parseInt(aIndexTokenizer.nextToken());
                ++aIndexCount;
            }
        }
        catch (NullPointerException aException) {
            aResult = -1;
        }
        catch (NoSuchElementException aException) {
            aResult = -1;
        }
        return aResult;
    }

    public int getIndexE2E(int[] aIndexArray, int aIndexArrayLength) {
        int aResult = 0;
        int aIndexCount = 0;
        String aIndex = "";
        StringTokenizer aIndexTokenizer = null;
        aIndex = this.mXKCoreWrapper.getIndexE2E();
        try {
            aIndexTokenizer = new StringTokenizer(aIndex, ",");
            aIndexCount = 0;
            while (aIndexCount < aIndexArrayLength) {
                aIndexArray[aIndexCount] = Integer.parseInt(aIndexTokenizer.nextToken());
                ++aIndexCount;
            }
        }
        catch (NullPointerException aException) {
            aResult = -1;
        }
        catch (NoSuchElementException aException) {
            aResult = -1;
        }
        return aResult;
    }

    public int makeIndexE2E(int[] aIndexArray, int aIndexArrayLength, int aKeypadType, String aURL) {
        int aResult = 0;
        int aIndexCount = 0;
        String aIndex = "";
        StringTokenizer aIndexTokenizer = null;
        this.mXKCoreWrapper.clearIndex();
        aIndex = this.mXKCoreWrapper.makeIndexE2E(aKeypadType, aURL);
        try {
            aIndexTokenizer = new StringTokenizer(aIndex, ",");
            aIndexCount = 0;
            while (aIndexCount < aIndexArrayLength) {
                aIndexArray[aIndexCount] = Integer.parseInt(aIndexTokenizer.nextToken());
                ++aIndexCount;
            }
        }
        catch (NullPointerException aException) {
            aResult = -1;
        }
        catch (NoSuchElementException aException) {
            aResult = -1;
        }
        return aResult;
    }

    public int getIndexData(XKKeyButton aXKKeyButton) {
        String aIndex = null;
        aIndex = String.valueOf(aXKKeyButton.getIndex());
        this.mXKCoreWrapper.putIndex(aIndex);
        this.setParentEditText();
        return aXKKeyButton.getIndex();
    }

    public void deleteIndex() {
        this.mXKCoreWrapper.deleteIndex();
        this.setParentEditText();
    }

    public void clearIndex() {
        this.mXKCoreWrapper.clearIndex();
        this.setParentEditText();
    }

    public void setParentEditText() {
        int aIndexCount = 0;
        String aText = "";
        aIndexCount = this.mXKCoreWrapper.getIndexCount();
        aText = aIndexCount == 0 ? "" : String.format("%" + aIndexCount + "s", "").replace(' ', '*');
        this.mXKEditText.setText(aText);
        this.mXKEditText.setSelection(aIndexCount);
    }
}

