/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.telco;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.skp.smarttouch.sem.tools.network.ota.OTAManager;
import com.skp.smarttouch.sem.tools.network.sems.SEMSManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import kr.co.skplanet.utils.LOG;

public class SEUtility {
    private static final String a = "application/vnd.android.package-archive";
    private static final String b = "SEIOAgent.apk";
    private static final String c = "com.skp.seio";
    private static final String d = "0000397902";
    public static final byte INSTALL_FROM_ASSET = 48;
    public static final byte INSTALL_FROM_TSTORE = 49;
    public static final byte INSTALL_FROM_GOOGLE = 50;
    private static final String e = "PRODUCT_VIEW/%s/0";
    private static final String f = "com.skt.skaf.A000Z00040";
    private static final String g = "A000Z00040";
    private static final String h = "market://details?id=";

    public static boolean setServerType(Context context, boolean isStaging) {
        LOG.info(">> setServerType()");
        LOG.info("++ isStaging : [%s]", isStaging);
        boolean bRet = true;
        try {
            if (context == null) {
                throw new IllegalArgumentException("***** invalid context");
            }
            SEMSManager.getInstance(context).setStagingYn(isStaging ? "Y" : "N");
            OTAManager.getInstance(context).setStagingYn(isStaging ? "Y" : "N");
        }
        catch (Exception e) {
            LOG.error(e);
            bRet = false;
        }
        return bRet;
    }

    public static boolean installSEIOAgent(Context objContext, int nMajor, int nMinor) {
        try {
            boolean isUpgrade = SEUtility.a(objContext, c, nMajor, nMinor);
            if (isUpgrade) {
                return SEUtility.installAssetsAPK(objContext, b);
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return false;
    }

    public static boolean installSEIOAgentByStore(Context objContext, int nMajor, int nMinor) {
        boolean result;
        block6: {
            result = false;
            try {
                boolean isUpgrade = SEUtility.a(objContext, c, nMajor, nMinor);
                if (!isUpgrade) break block6;
                try {
                    result = SEUtility.a(objContext, d);
                }
                catch (ActivityNotFoundException e) {
                    LOG.error((Exception)((Object)e));
                    if (!result) {
                        result = SEUtility.b(objContext, c);
                    }
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return result;
    }

    public static boolean installAssetsAPK(Context objContext, String strAPKName) throws IOException {
        InputStream is = objContext.getAssets().open(strAPKName);
        if (is == null) {
            return false;
        }
        File objFile = SEUtility.a(objContext, is, strAPKName);
        if (objFile == null) {
            return false;
        }
        return SEUtility.executeInstall(objContext, objFile);
    }

    public static boolean executeInstall(Context objContext, File objFile) {
        if (objContext == null || objFile == null) {
            return false;
        }
        Intent installIntent = new Intent("android.intent.action.VIEW");
        installIntent.addFlags(0x10000000);
        installIntent.addCategory("android.intent.category.DEFAULT");
        installIntent.setDataAndType(Uri.fromFile((File)objFile), a);
        try {
            objContext.startActivity(installIntent);
            return true;
        }
        catch (ActivityNotFoundException anfe) {
            LOG.error((Exception)((Object)anfe));
            return false;
        }
    }

    private static boolean a(Context objContext) {
        PackageManager pm = objContext.getPackageManager();
        List appList = pm.getInstalledApplications(0);
        ApplicationInfo app = null;
        int nSize = appList.size();
        int i = 0;
        while (i < nSize) {
            app = (ApplicationInfo)appList.get(i);
            if (app.packageName.indexOf(f) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String a(String strPID, String strType) {
        String strUrl = String.format(e, strPID);
        if (strType != null) {
            strUrl = String.valueOf(strUrl) + "/" + strType;
        }
        LOG.debug("-- return() strUrl : " + strUrl);
        return strUrl;
    }

    private static boolean a(Context objContext, String strPID) throws Exception {
        String strUrl = SEUtility.a(strPID, "PAYMENT");
        if (!SEUtility.a(objContext)) {
            throw new ActivityNotFoundException("T store is not intalled");
        }
        PackageManager pm = objContext.getPackageManager();
        Intent intent = pm.getLaunchIntentForPackage(f);
        if (intent == null) {
            throw new ActivityNotFoundException("T store is not intalled");
        }
        intent.addFlags(0x30000000);
        intent.setClassName(f, "com.skt.skaf.A000Z00040.A000Z00040");
        intent.setAction("COLLAB_ACTION");
        intent.putExtra("com.skt.skaf.COL.URI", strUrl.getBytes());
        intent.putExtra("com.skt.skaf.COL.REQUESTER", g);
        objContext.startActivity(intent);
        return true;
    }

    private static boolean b(Context objContext, String strPackageName) {
        boolean result = false;
        String strUrl = h + strPackageName;
        if (strUrl == null || strUrl.length() <= 0) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)strUrl));
        intent.addFlags(0x10000000);
        objContext.startActivity(intent);
        return result;
    }

    public static boolean isInstalledSeioAgent(Context objContext) {
        String strInstallVersionName = SEUtility.c(objContext, c);
        if (strInstallVersionName == null || strInstallVersionName.trim().length() <= 0) {
            LOG.info("-- return strInstallVersionName is [%s]..!!", strInstallVersionName);
            return false;
        }
        return true;
    }

    public static String getPackageName(Context objContext) {
        String strResult = null;
        try {
            if (objContext == null) {
                throw new IllegalArgumentException("***** context is null");
            }
            PackageManager pm = objContext.getPackageManager();
            PackageInfo info = pm.getPackageInfo(objContext.getPackageName(), 0);
            strResult = info.packageName;
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return strResult;
    }

    private static File a(Context objContext, InputStream objInputStream, String strOutputFileName) throws IOException {
        if (objContext == null || objInputStream == null || strOutputFileName == null || strOutputFileName.trim().length() == 0) {
            return null;
        }
        FileOutputStream fos = objContext.openFileOutput(strOutputFileName, 3);
        byte[] buffer = new byte[1024];
        int byteRead = 0;
        while ((byteRead = objInputStream.read(buffer)) != -1) {
            fos.write(buffer, 0, byteRead);
        }
        fos.close();
        return objContext.getFileStreamPath(strOutputFileName);
    }

    public static boolean isNeedUpgradeSEIOAgent(Context objContext, int nMajor, int nMinor) {
        boolean isUpgrade = false;
        try {
            isUpgrade = SEUtility.a(objContext, c, nMajor, nMinor);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return isUpgrade;
    }

    private static boolean a(Context objContext, String strPackageName, int nMajor, int nMinor) throws Exception {
        int nSize;
        if (objContext == null || strPackageName == null || strPackageName.trim().length() <= 0) {
            throw new IllegalArgumentException();
        }
        String strInstallVersionName = SEUtility.c(objContext, strPackageName);
        if (strInstallVersionName == null || strInstallVersionName.trim().length() <= 0) {
            LOG.info("-- return strInstallVersionName is [%s]..!!", strInstallVersionName);
            return true;
        }
        String[] astrInstallVersion = strInstallVersionName.split("\\.");
        int n = nSize = astrInstallVersion.length > 2 ? 2 : astrInstallVersion.length;
        if (nSize == 0) {
            LOG.info("-- return nSize is 0..!!");
            return true;
        }
        int nInstallMajor = SEUtility.a(astrInstallVersion[0], 0);
        if (nInstallMajor < nMajor) {
            LOG.info("-- return MAJOR_VERSION..!!");
            return true;
        }
        int nInstallMinor = SEUtility.a(astrInstallVersion[1], 0);
        if (nInstallMinor < nMinor) {
            LOG.info("-- return MINOR_VERSION..!!");
            return true;
        }
        return false;
    }

    private static String c(Context objContext, String strPackageName) {
        String strRetVal = "";
        try {
            PackageInfo i = objContext.getPackageManager().getPackageInfo(strPackageName, 0);
            strRetVal = i.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return "";
        }
        catch (Exception e) {
            return "";
        }
        LOG.debug("-- return() strRetVal : " + strRetVal);
        return strRetVal;
    }

    private static int a(String strString, int nDefault) {
        int nParseData = nDefault;
        try {
            nParseData = Integer.parseInt(strString);
        }
        catch (Exception e) {
            nParseData = nDefault;
        }
        return nParseData;
    }
}

