/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.keypad;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.Toast;
import com.softforum.sample.R;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.ImageTextSpinnerAdapter;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecurekeypad.XKConstants;
import com.softforum.xecurekeypad.XKEditText;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;

public class RequestCertificateWithXK
extends Activity {
    public static final int mRequestCertificateWindowID = 77000;
    public static final String mMediaIDKey = "request_cert_window_mediaid_key";
    public static final String m_P_assW_ordKey = "request_cert_window_password_key";
    public static final String mRandomValueKey = "request_cert_window_password_key";
    public static final String mE_ncryptedDataKey = "request_cert_window_e_ncrypted_data_key";
    private static final int MEDIA_SDCARD = 0;
    private static final int MEDIA_PKCS11 = 1;
    private int mMediaID = 1401;
    private byte[] m_P_assW_ord = null;
    private byte[] m_P_assW_ordConfirm = null;
    private XKEditText m_P_assW_ordTextView = null;
    private XKEditText m_P_assW_ordConfirmTextView = null;
    private String mEncryptedData = null;
    private String mConfirmEncryptedData = null;
    private byte[] mRandomValue = new byte[20];
    private BlockerActivityResult mBlockerParam;
    private final int mResultForNotExistPassword = 10;
    private final int mResultForNotCorrectPassword = 11;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.request_certificate_window_xk);
        Intent receivedIntent = this.getIntent();
        this.mMediaID = receivedIntent.getIntExtra(mMediaIDKey, -1);
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        Spinner aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
        aSelectStorage.setVisibility(4);
        aSelectStorage.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(this.mRandomValue);
        }
        this.setKeyPad();
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RequestCertificateWithXK.this.onOKButtonClick(v);
            }
        });
    }

    private void setSpinner() {
        Spinner aSelectStorage = null;
        ImageTextSpinnerAdapter aSpinnerAdapter = null;
        HashMap<String, Object> aItem = null;
        ArrayList<HashMap<String, Object>> aItemList = null;
        aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
        aItemList = new ArrayList<HashMap<String, Object>>();
        aItem = new HashMap<String, Object>();
        aItem.put("image", R.drawable.sdcard);
        aItem.put("text", "SDCard");
        aItemList.add(aItem);
        aItem = new HashMap();
        aItem.put("image", R.drawable.pkcs11);
        aItem.put("text", "\ubcf4\uc548\ud1a0\ud070");
        aItemList.add(aItem);
        aSpinnerAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
        aSelectStorage.setAdapter((SpinnerAdapter)aSpinnerAdapter);
        aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                switch (position) {
                    case 0: {
                        RequestCertificateWithXK.this.mMediaID = 101;
                        RequestCertificateWithXK.this.findViewById(R.id.password_input_view).setVisibility(0);
                        break;
                    }
                    case 1: {
                        RequestCertificateWithXK.this.mMediaID = 1401;
                        RequestCertificateWithXK.this.findViewById(R.id.password_input_view).setVisibility(8);
                    }
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
        aSelectStorage.setSelection(0);
    }

    private void setKeyPad() {
        int aKeypadType = 0;
        int aKeypadViewType = 0;
        this.m_P_assW_ordTextView = (XKEditText)this.findViewById(R.id.password_edittext);
        this.m_P_assW_ordConfirmTextView = (XKEditText)this.findViewById(R.id.password_confirm_edittext);
        if (EnvironmentConfig.mXecureKeypadFullViewUsage) {
            aKeypadViewType = 1;
            this.m_P_assW_ordTextView.setSubTitle("\ube44\ubc00\ubc88\ud638");
            this.m_P_assW_ordConfirmTextView.setSubTitle("\ube44\ubc00\ubc88\ud638 \ud655\uc778");
        } else if (EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aKeypadViewType = 0;
            this.m_P_assW_ordTextView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
            this.m_P_assW_ordConfirmTextView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
        }
        if (aKeypadViewType == 1) {
            this.m_P_assW_ordTextView.setUseInputButton(true);
            this.m_P_assW_ordConfirmTextView.setUseInputButton(true);
            this.m_P_assW_ordTextView.setSubTitle(this.getString(R.string.password));
            this.m_P_assW_ordConfirmTextView.setSubTitle(this.getString(R.string.password_confirm));
        }
        aKeypadType = 1;
        this.m_P_assW_ordTextView.setXKViewType(aKeypadViewType);
        this.m_P_assW_ordTextView.setXKKeypadType(aKeypadType);
        this.m_P_assW_ordConfirmTextView.setXKViewType(aKeypadViewType);
        this.m_P_assW_ordConfirmTextView.setXKKeypadType(aKeypadType);
    }

    private int checkInputPasswordWithEncryption() {
        int aResult = -1;
        int aConfirmResult = 0;
        if (this.mEncryptedData == null || this.mEncryptedData.length() == 0) {
            return 10;
        }
        aResult = XUtil.checkPassword((String)this.mEncryptedData, (byte[])this.mRandomValue, (int)2);
        if (aResult != 0) {
            return aResult;
        }
        if (this.mConfirmEncryptedData == null || this.mConfirmEncryptedData.length() == 0) {
            aConfirmResult = -1;
        } else if (!this.mEncryptedData.equals(this.mConfirmEncryptedData)) {
            aConfirmResult = -1;
        }
        if (aConfirmResult != 0) {
            return 11;
        }
        return aResult;
    }

    private int checkInputPassword() {
        int aResult = -1;
        int aConfirmResult = 0;
        int aIndex = 0;
        if (this.m_P_assW_ord == null || this.m_P_assW_ord.length == 0) {
            return 10;
        }
        aResult = XUtil.newCheckPasswordFormat((byte[])this.m_P_assW_ord);
        if (aResult != 0) {
            return aResult;
        }
        if (this.m_P_assW_ordConfirm == null || this.m_P_assW_ordConfirm.length == 0) {
            aConfirmResult = -1;
        } else if (this.m_P_assW_ord.length == this.m_P_assW_ordConfirm.length) {
            for (aIndex = 0; aIndex < this.m_P_assW_ord.length; ++aIndex) {
                if (this.m_P_assW_ord[aIndex] == this.m_P_assW_ordConfirm[aIndex]) continue;
                aConfirmResult = -1;
                break;
            }
        } else {
            aConfirmResult = -1;
        }
        if (aConfirmResult != 0) {
            return 11;
        }
        return aResult;
    }

    private void onOKButtonClick(View v) {
        int aResult = -1;
        Intent aIntent = new Intent();
        XTopView aTopView = null;
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            this.mEncryptedData = this.m_P_assW_ordTextView.getEncryptedData(this.mRandomValue);
            this.mConfirmEncryptedData = this.m_P_assW_ordConfirmTextView.getEncryptedData(this.mRandomValue);
        } else {
            this.m_P_assW_ord = this.m_P_assW_ordTextView.getData().getBytes();
            this.m_P_assW_ordConfirm = this.m_P_assW_ordConfirmTextView.getData().getBytes();
        }
        aResult = EnvironmentConfig.mXecureKeypadEncryptionUsage ? this.checkInputPasswordWithEncryption() : this.checkInputPassword();
        switch (aResult) {
            case 10: {
                aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
                return;
            }
            case 11: {
                aTopView.setDescription(this.getString(R.string.incorrect_confirm_password));
                return;
            }
            case 1: {
                aTopView.setDescription(this.getString(R.string.password_length_error));
                return;
            }
            case 2: {
                aTopView.setDescription(this.getString(R.string.password_syntax_error));
                return;
            }
            case 3: {
                aTopView.setDescription(this.getString(R.string.newpassword_length_error));
                return;
            }
            case 4: {
                aTopView.setDescription(this.getString(R.string.newpassword_syntax_error));
                return;
            }
            case 5: {
                aTopView.setDescription(this.getString(R.string.newpassword_invalid_error));
                return;
            }
        }
        aIntent.putExtra(mMediaIDKey, this.mMediaID);
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            aIntent.putExtra("request_cert_window_password_key", this.mRandomValue);
            aIntent.putExtra(mE_ncryptedDataKey, this.mEncryptedData);
        } else {
            aIntent.putExtra("request_cert_window_password_key", this.m_P_assW_ord);
        }
        this.mBlockerParam.setBlockerResult(-1, aIntent);
        this.finish();
    }

    public void finish() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ordConfirm});
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }

    public void onBackPressed() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord, this.m_P_assW_ordConfirm, this.mRandomValue});
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if ((requestCode != XKConstants.XKKeypadRequestCode || resultCode != 0) && requestCode == XKConstants.XKKeypadRequestCode && resultCode == 200000) {
            Toast.makeText((Context)this, (CharSequence)"\uc778\ub371\uc2a4 \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.", (int)0).show();
        }
    }
}

