/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.keypad;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.softforum.sample.R;
import com.softforum.xecure.certshare.ExportCertWithCertShare;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecure.yessign.ConnectToYessignApp;
import com.softforum.xecure.yessign.ExportCertificateToYessign;
import com.softforum.xecurekeypad.XKConstants;
import com.softforum.xecurekeypad.XKEditText;
import java.security.SecureRandom;

public class SignCertPasswordWindowWithXK
extends Activity {
    public static final int mSignCertPasswordWindowID = 70510;
    public static final int mExportCertWindowID = 72800;
    public static final String mMediaIDKey = "sign_cert_password_media_id_key";
    public static final String mSelectedCertDataKey = "sign_cert_password_selected_cert_data_key";
    public static final String m_P_assW_ordKey = "sign_cert_password_password_key";
    public static final String mOldP_assw_ordKey = "old_cert_password_password_key";
    public static final String mRandomValueKey = "sign_cert_password_random_value_key";
    public static final String mE_ncryptedDataKey = "sign_cert_password_e_ncrypted_data_key";
    public static final String mNewE_ncryptedDataKey = "sign_cert_password_new_e_ncrypted_data_key";
    public static final String mCallModeKey = "call_mode_key";
    public static final String mCallModeSign = "call_mode_sign";
    public static final String mCallModeExportCertificate = "call_mode_export_certificate";
    public static final String mCallModeExportCertificateEX = "call_mode_export_certificate_ex";
    public static final String mCallModeExportCertificateByCertShare = "call_mode_export_certificate_certshare";
    public static final int RESULT_PASSWD_FAIL = 2;
    public static final int RESULT_VERIFY_PASSWORD_OK = 3;
    public static final int RESULT_EXPORT_CERTIFICATE_OK = 4;
    private int mMediaID;
    private XDetailData mSelectedData;
    private byte[] m_P_assW_ord = null;
    private int m_P_assW_ordTryCount;
    private String mCallMode = null;
    private XCoreUtil mCoreUtil = new XCoreUtil();
    private XKEditText m_P_assW_ordTextView = null;
    private String mEncryptedData = null;
    private byte[] mRandomValue = new byte[20];

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_sign_cert_password_window_xk);
        this.m_P_assW_ordTryCount = 0;
        this.mMediaID = this.getIntent().getIntExtra(mMediaIDKey, -1);
        this.mCallMode = this.getIntent().getStringExtra(mCallModeKey);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), 3);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)XUtil.getCNFromRDN((String)this.mSelectedData.getValue(2)));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(3) + " : " + this.mSelectedData.getValue(3)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(4) + " : " + this.mSelectedData.getValue(4)));
        this.setKeyPad();
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SignCertPasswordWindowWithXK.this.onOKButtonClick(v);
            }
        });
    }

    private void setKeyPad() {
        int aKeypadType = 0;
        int aKeypadViewType = 0;
        this.m_P_assW_ordTextView = (XKEditText)this.findViewById(R.id.password_edittext);
        if (EnvironmentConfig.mXecureKeypadFullViewUsage) {
            aKeypadViewType = 1;
            this.m_P_assW_ordTextView.setSubTitle("\ube44\ubc00\ubc88\ud638");
        } else if (EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aKeypadViewType = 0;
            this.m_P_assW_ordTextView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
        }
        aKeypadType = 1;
        this.m_P_assW_ordTextView.setXKViewType(aKeypadViewType);
        this.m_P_assW_ordTextView.setXKKeypadType(aKeypadType);
        if (aKeypadViewType == 1) {
            this.m_P_assW_ordTextView.setUseInputButton(true);
            this.m_P_assW_ordTextView.setSubTitle(this.getString(R.string.password));
        }
    }

    private void onOKButtonClick(View v) {
        Intent aIntent;
        int aErrorCode = 0;
        CertMgr aCertMgr = null;
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        int aVerifyResult = 0;
        this.mCoreUtil.resetError();
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage && !this.mCallMode.equals(mCallModeExportCertificateByCertShare)) {
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(this.mRandomValue);
            this.mEncryptedData = this.m_P_assW_ordTextView.getEncryptedData(this.mRandomValue);
        } else {
            this.m_P_assW_ord = this.m_P_assW_ordTextView.getData().getBytes();
        }
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage && !this.mCallMode.equals(mCallModeExportCertificateByCertShare)) {
            if (this.mEncryptedData == null || this.mEncryptedData.length() == 0) {
                aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
                return;
            }
        } else if (this.m_P_assW_ord == null || this.m_P_assW_ord.length == 0) {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        aCertMgr = CertMgr.getInstance();
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage && !this.mCallMode.equals(mCallModeExportCertificateByCertShare)) {
            if (this.mEncryptedData != null || this.mEncryptedData.length() != 0) {
                aVerifyResult = aCertMgr.verifyPassword(this.mMediaID, this.mSelectedData.getValue(2), this.mRandomValue, this.mEncryptedData);
            }
        } else {
            aVerifyResult = aCertMgr.verifyPassword(this.mMediaID, 14, this.mSelectedData.getValue(2), this.m_P_assW_ord);
        }
        if (aVerifyResult != 0 && (aErrorCode = this.mCoreUtil.lastErrCode()) != 22000015) {
            aTopView.setDescription(this.mCoreUtil.lastErrMsg());
            if (++this.m_P_assW_ordTryCount >= 3) {
                this.setResult(2);
                this.finish();
            }
            return;
        }
        if (this.mCallMode.equals(mCallModeExportCertificate)) {
            aIntent = null;
            aIntent = new Intent((Context)this, ConnectToYessignApp.class);
            if (this.mCallMode.equals(mCallModeExportCertificate)) {
                aIntent.putExtra("ChoiceAction", 0);
            }
            if (this.mCallMode.equals(mCallModeExportCertificateEX)) {
                aIntent.putExtra("ChoiceAction", 2);
            }
            aIntent.putExtra("export_cert_media_id_key", this.mMediaID);
            aIntent.putExtra("export_cert_selected_cert_data_key", this.mSelectedData.getValueArray());
            this.startActivityForResult(aIntent, 72900);
        } else if (this.mCallMode.equals(mCallModeExportCertificateEX)) {
            ExportCertificateToYessign.setCertificate(this.mSelectedData, this.mMediaID);
            this.setResult(3);
            this.finish();
        } else if (this.mCallMode.equals(mCallModeExportCertificateByCertShare)) {
            aIntent = null;
            aIntent = new Intent((Context)this, ExportCertWithCertShare.class);
            aIntent.putExtra("export_cert_media_id_key", this.mMediaID);
            aIntent.putExtra("export_cert_selected_cert_data_key", this.mSelectedData.getValueArray());
            aIntent.putExtra("export_cert_selected_cert_password_key", this.m_P_assW_ord);
            aIntent.addFlags(0x2000000);
            this.startActivity(aIntent);
            XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord});
            this.finish();
        } else {
            aIntent = new Intent();
            if (EnvironmentConfig.mXecureKeypadEncryptionUsage && !this.mCallMode.equals(mCallModeExportCertificateByCertShare)) {
                aIntent.putExtra(mRandomValueKey, this.mRandomValue);
                aIntent.putExtra(mE_ncryptedDataKey, this.mEncryptedData);
            } else {
                aIntent.putExtra(m_P_assW_ordKey, this.m_P_assW_ord);
            }
            this.setResult(-1, aIntent);
            this.finish();
        }
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord, this.mRandomValue});
    }

    public void onBackPressed() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord, this.mRandomValue});
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == 4) {
            this.setResult(-1);
            this.finish();
        } else if (resultCode == 6) {
            this.setResult(6);
            this.finish();
        } else if (resultCode == 200000) {
            Toast.makeText((Context)this, (CharSequence)"\uc778\ub371\uc2a4 \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.", (int)0).show();
        } else if (resultCode == 0 && requestCode != XKConstants.XKKeypadRequestCode) {
            this.setResult(0);
            this.finish();
        }
    }
}

