/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.keypad;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.consortium.smartusim.SmartUsim;
import com.consortium.smartusim.SmartUsimResultCode;
import com.softforum.sample.R;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.usim.SmartUsimParcelable;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecurekeypad.XKConstants;
import com.softforum.xecurekeypad.XKEditText;

public class UsimCertVerifyOwnerWithXK
extends Activity {
    public static final int mXecureSmartVerifyOwnerCertoUsimID = 150000;
    public static final String mParsedXDetailDataKey = "parsed_xdetail_data_key";
    private SmartUsim mSmartUsim = null;
    private int mCertPosition = -1;
    private byte[] mSmartPassword = null;
    private byte[] mVid = null;
    private XDetailData mSelectedData = null;
    private XKEditText m_P_assW_ordTextView = null;
    private XKEditText mVidNumberView = null;

    protected void onCreate(Bundle pSavedInstanceState) {
        super.onCreate(pSavedInstanceState);
        this.setContentView(R.layout.usim_cert_verify_vid_xk);
        Intent aIntent = null;
        SmartUsimParcelable aSmartUsimParcelable = null;
        aIntent = this.getIntent();
        aSmartUsimParcelable = (SmartUsimParcelable)aIntent.getParcelableExtra("SmartUsim");
        this.mSmartUsim = aSmartUsimParcelable.getSmartUsim();
        this.mCertPosition = aIntent.getIntExtra("Position", 0);
        String[] aStringArrayExtra = this.getIntent().getStringArrayExtra(mParsedXDetailDataKey);
        this.mSelectedData = new XDetailData(aStringArrayExtra, 4);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)XUtil.getCNFromRDN((String)this.mSelectedData.getValue(2)));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(6) + " : " + this.mSelectedData.getValue(6)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(5) + " : " + this.mSelectedData.getValue(5)));
        this.setKeyPad();
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UsimCertVerifyOwnerWithXK.this.onOKButtonClick(v);
            }
        });
    }

    private void setKeyPad() {
        int aInputPasswordKeypadType = 0;
        int aInputVidKeypadType = 0;
        int aKeypadViewType = 0;
        this.m_P_assW_ordTextView = (XKEditText)this.findViewById(R.id.smart_password_edittext);
        this.mVidNumberView = (XKEditText)this.findViewById(R.id.vid_edittext);
        if (EnvironmentConfig.mXecureKeypadFullViewUsage) {
            aKeypadViewType = 1;
            this.m_P_assW_ordTextView.setSubTitle("\ube44\ubc00\ubc88\ud638");
            this.mVidNumberView.setSubTitle("\uc8fc\ubbfc\ub4f1\ub85d\ubc88\ud638");
        } else if (EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aKeypadViewType = 0;
            this.m_P_assW_ordTextView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
            this.mVidNumberView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
        }
        aInputPasswordKeypadType = 1;
        aInputVidKeypadType = 0;
        this.m_P_assW_ordTextView.setXKViewType(aKeypadViewType);
        this.m_P_assW_ordTextView.setXKKeypadType(aInputPasswordKeypadType);
        this.mVidNumberView.setXKViewType(aKeypadViewType);
        this.mVidNumberView.setXKKeypadType(aInputVidKeypadType);
        if (aKeypadViewType == 1) {
            this.m_P_assW_ordTextView.setUseInputButton(true);
            this.mVidNumberView.setUseInputButton(true);
            this.m_P_assW_ordTextView.setSubTitle(this.getString(R.string.password));
            this.mVidNumberView.setSubTitle(this.getString(R.string.identification_number));
        }
        this.mVidNumberView.setXKKeypadMaxLength(13);
    }

    private void onOKButtonClick(View v) {
        boolean aVerfiyOwner = false;
        XTopView aTopView = null;
        Intent aIntent = null;
        SmartUsimResultCode aResultCode = null;
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        this.mSmartPassword = this.m_P_assW_ordTextView.getData().getBytes();
        this.mVid = this.mVidNumberView.getData().getBytes();
        aIntent = new Intent();
        if (this.mSmartPassword == null || this.mSmartPassword.length == 0 || this.mVid == null || this.mVid.length == 0) {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        aVerfiyOwner = this.mSmartUsim.verifyVID(this.mCertPosition, this.mSmartPassword, this.mVid);
        if (aVerfiyOwner) {
            aIntent.putExtra("xecure_smart_cert_mgr_result_key", 10);
        } else {
            aResultCode = this.mSmartUsim.getLastError();
            if (aResultCode.getResultCode() == 7011) {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 11);
            } else {
                if (aResultCode.getResultCode() == 5001) {
                    aTopView.setDescription(this.getString(R.string.message_password_pin_incorrect));
                    return;
                }
                if (aResultCode.getResultCode() == 5002) {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 4);
                } else if (aResultCode.getResultCode() == 5003) {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 5);
                } else {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 11);
                }
            }
        }
        this.setResult(-1, aIntent);
        this.finish();
    }

    public void finish() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mSmartPassword, this.mVid});
        super.finish();
    }

    public void onBackPressed() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mSmartPassword, this.mVid});
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if ((requestCode != XKConstants.XKKeypadRequestCode || resultCode != 0) && requestCode == XKConstants.XKKeypadRequestCode && resultCode == 200000) {
            Toast.makeText((Context)this, (CharSequence)"\uc778\ub371\uc2a4 \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.", (int)0).show();
        }
    }
}

