/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.keypad;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.consortium.smartusim.SmartUsim;
import com.consortium.smartusim.SmartUsimResultCode;
import com.softforum.sample.R;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.usim.SmartUsimParcelable;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecurekeypad.XKConstants;
import com.softforum.xecurekeypad.XKEditText;

public class UsimSignCertPasswordWindowWithXK
extends Activity {
    public static final int mSignCertPasswordWindowUsimID = 160000;
    private SmartUsim mSmartUsim = null;
    private int mCertPosition = -1;
    private byte[] mSmartPassword = null;
    private int m_P_assW_ordTryCount = 0;
    public static final int RESULT_PASSWD_FAIL = 3;
    private String mPlainText = null;
    public static final String mParsedXDetailDataKey = "parsed_xdetail_data_key";
    private XDetailData mSelectedData = null;
    private byte[] mUsimCertSignResult = null;
    private String mUsimCertSignResultString = null;
    public static final String mUsimCertSignResultKey = "sign_usim_cert_result";
    private XKEditText mSmartPasswordTextView = null;

    protected void onCreate(Bundle pSavedInstanceState) {
        super.onCreate(pSavedInstanceState);
        this.setContentView(R.layout.usim_sign_cert_password_window_xk);
        Intent aIntent = null;
        SmartUsimParcelable aSmartUsimParcelable = null;
        aIntent = this.getIntent();
        aSmartUsimParcelable = (SmartUsimParcelable)aIntent.getParcelableExtra("SmartUsim");
        this.mSmartUsim = aSmartUsimParcelable.getSmartUsim();
        this.mCertPosition = aIntent.getIntExtra("Position", 0);
        this.mPlainText = aIntent.getStringExtra("sign_plain_text_data");
        String[] aStringArrayExtra = this.getIntent().getStringArrayExtra(mParsedXDetailDataKey);
        this.mSelectedData = new XDetailData(aStringArrayExtra, 4);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)XUtil.getCNFromRDN((String)this.mSelectedData.getValue(2)));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(6) + " : " + this.mSelectedData.getValue(6)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(5) + " : " + this.mSelectedData.getValue(5)));
        this.setKeyPad();
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UsimSignCertPasswordWindowWithXK.this.onOKButtonClick(v);
            }
        });
    }

    private void setKeyPad() {
        int aKeypadType = 0;
        int aKeypadViewType = 0;
        this.mSmartPasswordTextView = (XKEditText)this.findViewById(R.id.smart_password_edittext);
        if (EnvironmentConfig.mXecureKeypadFullViewUsage) {
            aKeypadViewType = 1;
            this.mSmartPasswordTextView.setSubTitle("\uc2a4\ub9c8\ud2b8\uc778\uc99d \ube44\ubc00\ubc88\ud638");
        } else if (EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aKeypadViewType = 0;
            this.mSmartPasswordTextView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
        }
        if (aKeypadViewType == 1) {
            this.mSmartPasswordTextView.setUseInputButton(true);
            this.mSmartPasswordTextView.setSubTitle(this.getString(R.string.smart_password));
        }
        aKeypadType = 1;
        this.mSmartPasswordTextView.setXKViewType(aKeypadViewType);
        this.mSmartPasswordTextView.setXKKeypadType(aKeypadType);
    }

    private void onOKButtonClick(View v) {
        XTopView aTopView = null;
        Intent aIntent = null;
        SmartUsimResultCode aResultCode = null;
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        this.mSmartPassword = this.mSmartPasswordTextView.getData().getBytes();
        if (this.mSmartPassword == null || this.mSmartPassword.length == 0) {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        this.mUsimCertSignResult = this.mSmartUsim.sign(this.mCertPosition, this.mSmartPassword, 2, this.mPlainText.getBytes(), null);
        if (this.mUsimCertSignResult != null) {
            this.mUsimCertSignResultString = XUtil.asHex((byte[])this.mUsimCertSignResult);
        }
        if (this.mUsimCertSignResult == null || this.mUsimCertSignResult.length < 1) {
            aResultCode = this.mSmartUsim.getLastError();
            if (aResultCode.getResultCode() != 0) {
                aTopView.setDescription(this.getString(R.string.message_password_pin_incorrect));
                if (++this.m_P_assW_ordTryCount >= 3) {
                    this.setResult(3);
                    this.endUnBind();
                    this.finish();
                }
                return;
            }
        } else {
            aIntent = new Intent();
            aIntent.putExtra(mUsimCertSignResultKey, this.mUsimCertSignResultString);
            this.setResult(-1, aIntent);
            this.endUnBind();
            this.finish();
        }
    }

    private void endUnBind() {
        this.mSmartUsim.unbindService();
    }

    public void finish() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mSmartPassword});
        super.finish();
    }

    public void onBackPressed() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mSmartPassword});
        this.endUnBind();
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if ((requestCode != XKConstants.XKKeypadRequestCode || resultCode != 0) && requestCode == XKConstants.XKKeypadRequestCode && resultCode == 200000) {
            Toast.makeText((Context)this, (CharSequence)"\uc778\ub371\uc2a4 \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.", (int)0).show();
        }
    }
}

