/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.keypad;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import com.softforum.sample.R;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.crypto.XecureSmartInputVID;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecurekeypad.XKConstants;
import com.softforum.xecurekeypad.XKEditText;
import java.security.SecureRandom;

public class XecureSmartInputVIDWithXK
extends Activity {
    public static final int mXecureSmartInputVidID = 80000;
    public static final String mXecureSmartInputVidKey = "xecure_smart_input_vid_key";
    private BlockerActivityResult mBlockerParam = null;
    private byte[] mVid = null;
    private XKEditText mVidTextView = null;
    private String mEncryptedData = null;
    private byte[] mRandomValue = new byte[20];

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_input_vid_xk);
        Intent aReceivedIntent = this.getIntent();
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)aReceivedIntent);
        this.setKeyPad();
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(this.mRandomValue);
        }
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartInputVIDWithXK.this.onOKButtonClick(v);
            }
        });
    }

    private void setKeyPad() {
        int aKeypadType = 0;
        int aKeypadViewType = 0;
        this.mVidTextView = (XKEditText)this.findViewById(R.id.vid_edittext);
        if (EnvironmentConfig.mXecureKeypadFullViewUsage) {
            aKeypadViewType = 1;
            this.mVidTextView.setSubTitle("\uc2e0\uc6d0\ud655\uc778\ubc88\ud638");
        } else if (EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aKeypadViewType = 0;
            this.mVidTextView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
        }
        if (aKeypadViewType == 1) {
            this.mVidTextView.setUseInputButton(true);
            this.mVidTextView.setSubTitle(this.getString(R.string.identification_number));
        }
        aKeypadType = 0;
        this.mVidTextView.setXKViewType(aKeypadViewType);
        this.mVidTextView.setXKKeypadType(aKeypadType);
        this.mVidTextView.setXKKeypadMaxLength(13);
    }

    private void onOKButtonClick(View v) {
        XTopView aTopView = null;
        Intent aIntent = new Intent();
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            this.mEncryptedData = this.mVidTextView.getEncryptedData(this.mRandomValue);
        } else {
            this.mVid = this.mVidTextView.getData().getBytes();
        }
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            if (this.mEncryptedData == null || this.mEncryptedData.length() == 0) {
                aTopView.setDescription(this.getString(R.string.xecure_smart_cert_mgr_copy_wrong_vid));
                return;
            }
        } else if (this.mVid == null || this.mVid.length == 0) {
            aTopView.setDescription(this.getString(R.string.xecure_smart_cert_mgr_copy_wrong_vid));
            return;
        }
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            aIntent.putExtra("random_value_key", this.mRandomValue);
            aIntent.putExtra("e_ncrypted_data_key", this.mEncryptedData);
        } else {
            aIntent.putExtra("vid_key", this.mVid);
        }
        this.mBlockerParam.setBlockerResult(-1, aIntent);
        this.finish();
    }

    public void onBackPressed() {
        super.onBackPressed();
        XUtil.resetByteArray((byte[][])new byte[][]{this.mVid, this.mRandomValue});
        Intent aIntent = new Intent((Context)this, XecureSmartInputVID.class);
        aIntent.putExtra("vid_key", "");
        this.mBlockerParam.setBlockerResult(0, aIntent);
        this.finish();
    }

    public void finish() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mVid});
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if ((requestCode != XKConstants.XKKeypadRequestCode || resultCode != 0) && requestCode == XKConstants.XKKeypadRequestCode && resultCode == 200000) {
            Toast.makeText((Context)this, (CharSequence)"\uc778\ub371\uc2a4 \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.", (int)0).show();
        }
    }
}

