/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.IsoDep;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.crypto.ICCardMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XSLog;
import kr.or.kftc.mobiletoken_lib.device_control.TokenControl;
import kr.or.kftc.smartcard.SecurityToken;

public class CopyCertToICCard
extends Activity {
    private int m_P_assW_ordTryCount;
    public static final int mXecureSmartCopyCertoICCardID = 170000;
    public static final String mSelectedCertDataKey = "sign_cert_password_selected_cert_data_key";
    public static final int RESULT_PASSWD_FAIL = 2;
    public static final String mParsedXDetailDataKey = "parsed_xdetail_data_key";
    public static final String mSrcMediaIDKey = "copy_cert_src_media_id_key";
    private int mSrcMediaID;
    private XDetailData mSelectedData;
    private String m_P_assW_ord = null;
    private String mPin = null;
    private int mDetailDataType = 0;
    private int mDetailDataCertSubjectKey = 7;
    private int mDetailDataCertIssuerKey = 4;
    private int mDetailDataCertToKey = 6;
    static final String TAG = SecurityToken.class.getSimpleName();
    private IsoDep isoDep;
    private NfcAdapter mNfcAdapter;
    private TokenControl mToken;
    private String aResult = null;
    private static boolean mVerify = false;
    private XCoreUtil mCoreUtil = new XCoreUtil();
    private ProgressDialog mProgressDialog = null;
    private String mProgressDialogMessage = "";
    private Handler mViewControlHandler = null;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.iccard_input_password);
        this.mViewControlHandler = new Handler();
        this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)this);
        this.m_P_assW_ordTryCount = 0;
        this.mSrcMediaID = this.getIntent().getIntExtra(mSrcMediaIDKey, 1);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), this.mDetailDataType);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)this.mSelectedData.getValue(this.mDetailDataCertSubjectKey));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertIssuerKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertIssuerKey)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertToKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertToKey)));
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CopyCertToICCard.this.onOKButtonClick(v);
            }
        });
    }

    private void onOKButtonClick(View v) {
        EditText aPasswordEditText = (EditText)this.findViewById(R.id.password_edittext);
        EditText aPinEditText = (EditText)this.findViewById(R.id.iccard_pin_edittext);
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        this.mCoreUtil.resetError();
        this.m_P_assW_ord = aPasswordEditText.getText().toString();
        this.mPin = aPinEditText.getText().toString();
        if (this.m_P_assW_ord.length() == 0) {
            aTopView.setDescription("\uc778\uc99d\uc11c \ud328\uc2a4\uc6cc\ub4dc\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694.");
            return;
        }
        if (this.mPin.length() == 0) {
            aTopView.setDescription("ICCard PIN\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694");
            return;
        }
        CertMgr aCertMgr = CertMgr.getInstance();
        if (aCertMgr.verifyPassword(this.mSrcMediaID, 14, this.mSelectedData.getValue(this.mDetailDataCertSubjectKey), this.m_P_assW_ord) != 0) {
            aTopView.setDescription(this.mCoreUtil.lastErrMsg());
            this.m_P_assW_ord = "";
            aPasswordEditText.setText((CharSequence)"");
            if (++this.m_P_assW_ordTryCount >= 3) {
                this.setResult(2);
                this.finish();
            }
        } else {
            mVerify = true;
            this.mProgressDialogMessage = "IC\uce74\ub4dc\ub85c \uc778\uc99d\uc11c \ubcf5\uc0ac\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4. \uc2a4\ub9c8\ud2b8\ud3f0\uc5d0 \ubcf4\uc548\ud1a0\ud070\uc744 \ud130\uce58\ud558\uc138\uc694.";
            this.ShowProgressDialog(this.mProgressDialogMessage);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mNfcAdapter.isEnabled()) {
            if (this.mNfcAdapter != null && this.mNfcAdapter.isEnabled()) {
                String[][] techList = new String[][]{{IsoDep.class.getName()}};
                PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent((Context)this, ((Object)((Object)this)).getClass()).addFlags(0x20000000), (int)0);
                this.mNfcAdapter.enableForegroundDispatch((Activity)this, pendingIntent, null, techList);
            }
        } else if (Build.VERSION.SDK_INT > 16) {
            this.startActivity(new Intent("android.settings.NFC_SETTINGS"));
        } else {
            this.startActivity(new Intent("android.settings.WIRELESS_SETTINGS"));
        }
    }

    protected void onNewIntent(Intent intent) {
        block6: {
            if (mVerify) {
                super.onNewIntent(intent);
                try {
                    Tag mTag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
                    ICCardMgr aICCardMgr = new ICCardMgr();
                    if (mTag == null) break block6;
                    this.isoDep = IsoDep.get((Tag)mTag);
                    this.mToken = new TokenControl(this.isoDep);
                    if (this.mToken == null) {
                        return;
                    }
                    if (this.mToken.Connect()) {
                        Toast.makeText((Context)this, (CharSequence)"NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0 \uc131\uacf5", (int)0).show();
                        byte aPriKeyLength = 18;
                        byte aPubKeyLength = 64;
                        byte aSaveCertType = 1;
                        this.aResult = aICCardMgr.copyCertToICCard(this.isoDep, this.mPin.getBytes(), this.mSelectedData, this.m_P_assW_ord.getBytes(), this.mSrcMediaID, aPriKeyLength, aPubKeyLength, aSaveCertType, "121.131.155.125", 39002);
                        this.m_P_assW_ord = null;
                        this.ShowAlertDialog(this.aResult);
                        break block6;
                    }
                    Toast.makeText((Context)this, (CharSequence)"NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0 \uc2e4\ud328", (int)1).show();
                }
                catch (Exception e) {
                    XSLog.i((String)"[Fail to connect ICCard.]");
                }
            } else {
                Toast.makeText((Context)this, (CharSequence)"\uba3c\uc800 \uc778\uc99d\uc11c \ud328\uc2a4\uc6cc\ub4dc\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694.", (int)1).show();
            }
        }
    }

    public void onBackPressed() {
        if (this.mToken != null) {
            this.mToken.Disconnect();
        }
        this.finish();
    }

    protected void onPause() {
        super.onPause();
        if (this.mNfcAdapter != null && this.mNfcAdapter.isEnabled()) {
            this.mNfcAdapter.disableForegroundDispatch((Activity)this);
        }
    }

    private void ShowProgressDialog(String pProgressDialogMessage) {
        if (this.mProgressDialog == null) {
            this.mProgressDialog = ProgressDialog.show((Context)this, (CharSequence)"Waiting", (CharSequence)pProgressDialogMessage, (boolean)true, (boolean)false);
            this.mProgressDialog.setCanceledOnTouchOutside(false);
        }
    }

    private void ShowAlertDialog(final String pAlertMessage) {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
        this.mProgressDialog = null;
        this.mViewControlHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    new AlertDialog.Builder((Context)CopyCertToICCard.this).setCancelable(false).setMessage((CharSequence)pAlertMessage).setPositiveButton((CharSequence)"\ud655\uc778", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            Intent aIntent = null;
                            aIntent = new Intent();
                            if (pAlertMessage.startsWith("0000")) {
                                CopyCertToICCard.this.setResult(-1, aIntent);
                            } else {
                                CopyCertToICCard.this.setResult(2, aIntent);
                            }
                            CopyCertToICCard.this.mToken.Disconnect();
                            CopyCertToICCard.this.mToken = null;
                            CopyCertToICCard.this.finish();
                        }
                    }).show();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

